/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.listener;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.mbassy.listener.Enveloped;
import org.mbassy.listener.IMessageFilter;
import org.mbassy.listener.Listener;
import org.mbassy.listener.Mode;

public class MessageHandlerMetadata {
    private Method handler;
    private IMessageFilter[] filter;
    private Listener listenerConfig;
    private boolean isAsynchronous = false;
    private Enveloped envelope = null;
    private List<Class<?>> handledMessages = new LinkedList();

    public MessageHandlerMetadata(Method handler, IMessageFilter[] filter, Listener listenerConfig) {
        this.handler = handler;
        this.filter = filter;
        this.listenerConfig = listenerConfig;
        this.isAsynchronous = listenerConfig.dispatch().equals((Object)Mode.Asynchronous);
        this.envelope = handler.getAnnotation(Enveloped.class);
        if (this.envelope != null) {
            for (Class messageType : this.envelope.messages()) {
                this.handledMessages.add(messageType);
            }
        } else {
            this.handledMessages.add(handler.getParameterTypes()[0]);
        }
        this.handler.setAccessible(true);
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public boolean isFiltered() {
        return this.filter != null && this.filter.length > 0;
    }

    public int getPriority() {
        return this.listenerConfig.priority();
    }

    public Method getHandler() {
        return this.handler;
    }

    public IMessageFilter[] getFilter() {
        return this.filter;
    }

    public List<Class<?>> getHandledMessages() {
        return this.handledMessages;
    }

    public boolean isEnveloped() {
        return this.envelope != null;
    }
}

