/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.subscription;

import java.util.Comparator;
import java.util.UUID;
import org.mbassy.common.ConcurrentSet;
import org.mbassy.dispatch.IMessageDispatcher;
import org.mbassy.dispatch.MessagingContext;

public class Subscription {
    private UUID id = UUID.randomUUID();
    protected ConcurrentSet<Object> listeners = new ConcurrentSet();
    private IMessageDispatcher dispatcher;
    private MessagingContext context;
    public static final Comparator<Subscription> SubscriptionByPriorityDesc = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription o1, Subscription o2) {
            int result = o1.getPriority() - o2.getPriority();
            return result == 0 ? o1.id.compareTo(o2.id) : result;
        }
    };

    public Subscription(MessagingContext context, IMessageDispatcher dispatcher) {
        this.context = context;
        this.dispatcher = dispatcher;
    }

    public void publish(Object message) {
        this.dispatcher.dispatch(message, this.listeners);
    }

    public MessagingContext getContext() {
        return this.context;
    }

    public int getPriority() {
        return this.context.getHandlerMetadata().getPriority();
    }

    public void subscribe(Object o) {
        this.listeners.add(o);
    }

    public boolean unsubscribe(Object existingListener) {
        return this.listeners.remove(existingListener);
    }

    public int size() {
        return this.listeners.size();
    }
}

