/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.subscription;

import org.mbassy.IMessageBus;
import org.mbassy.dispatch.AsynchronousHandlerInvocation;
import org.mbassy.dispatch.FilteredMessageDispatcher;
import org.mbassy.dispatch.IHandlerInvocation;
import org.mbassy.dispatch.IMessageDispatcher;
import org.mbassy.dispatch.MessageDispatcher;
import org.mbassy.dispatch.MessagingContext;
import org.mbassy.dispatch.ReflectiveHandlerInvocation;
import org.mbassy.listener.MessageHandlerMetadata;
import org.mbassy.subscription.Subscription;

public class SubscriptionFactory {
    private IMessageBus owner;

    public SubscriptionFactory(IMessageBus owner) {
        this.owner = owner;
    }

    public Subscription createSubscription(MessageHandlerMetadata messageHandlerMetadata) {
        MessagingContext context = new MessagingContext(this.owner, messageHandlerMetadata);
        IHandlerInvocation invocation = this.buildInvocationForHandler(context);
        IMessageDispatcher dispatcher = this.buildDispatcher(context, invocation);
        return new Subscription(context, dispatcher);
    }

    protected IHandlerInvocation buildInvocationForHandler(MessagingContext context) {
        IHandlerInvocation invocation = new ReflectiveHandlerInvocation(context);
        if (context.getHandlerMetadata().isAsynchronous()) {
            invocation = new AsynchronousHandlerInvocation(invocation);
        }
        return invocation;
    }

    protected IMessageDispatcher buildDispatcher(MessagingContext context, IHandlerInvocation invocation) {
        IMessageDispatcher dispatcher = new MessageDispatcher(context, invocation);
        if (context.getHandlerMetadata().isFiltered()) {
            dispatcher = new FilteredMessageDispatcher(dispatcher);
        }
        return dispatcher;
    }
}

