/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.common;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.mbassy.common.IPredicate;

public class ReflectionUtils {
    public static List<Method> getMethods(IPredicate<Method> condition, Class<?> target) {
        LinkedList<Method> methods = new LinkedList<Method>();
        try {
            for (Method method : target.getDeclaredMethods()) {
                if (!condition.apply(method)) continue;
                methods.add(method);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!target.equals(Object.class)) {
            methods.addAll(ReflectionUtils.getMethods(condition, target.getSuperclass()));
        }
        return methods;
    }

    public static List<Field> getFields(IPredicate<Field> condition, Class<?> target) {
        LinkedList<Field> methods = new LinkedList<Field>();
        try {
            for (Field method : target.getDeclaredFields()) {
                if (!condition.apply(method)) continue;
                methods.add(method);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!target.equals(Object.class)) {
            methods.addAll(ReflectionUtils.getFields(condition, target.getSuperclass()));
        }
        return methods;
    }

    public static Object callMethod(Object o, String methodName, Object ... args) {
        if (o == null || methodName == null) {
            return null;
        }
        Object res = null;
        try {
            Method m = o.getClass().getMethod(methodName, new Class[0]);
            res = m.invoke(o, args);
        }
        catch (Exception e) {
            // empty catch block
        }
        return res;
    }
}

