/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.listener;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.mbassy.listener.Filter;
import org.mbassy.listener.Listener;
import org.mbassy.listener.MessageFilter;
import org.mbassy.listener.MessageHandlerMetadata;

public class MetadataReader {
    private final Map<Class<? extends MessageFilter>, MessageFilter> filterCache = new HashMap<Class<? extends MessageFilter>, MessageFilter>();

    private MessageFilter[] getFilter(Listener subscription) throws Exception {
        if (subscription.filters().length == 0) {
            return null;
        }
        MessageFilter[] filters = new MessageFilter[subscription.filters().length];
        int i = 0;
        for (Filter filterDef : subscription.filters()) {
            MessageFilter filter = this.filterCache.get(filterDef.value());
            if (filter == null) {
                filter = filterDef.value().newInstance();
                this.filterCache.put(filterDef.value(), filter);
            }
            filters[i] = filter;
            ++i;
        }
        return filters;
    }

    public MessageHandlerMetadata getHandlerMetadata(Method messageHandler) throws Exception {
        Listener config = messageHandler.getAnnotation(Listener.class);
        MessageFilter[] filter = this.getFilter(config);
        return new MessageHandlerMetadata(messageHandler, filter, config);
    }
}

