mod general_category {
    pure fn Cc(c: char) -> bool {
        ret alt c {
              '\x00' to '\x1f'
            | '\x7f' to '\x9f'
              { true }
            _ { false }
        };
    }

    pure fn Cf(c: char) -> bool {
        ret alt c {
              '\xad'
            | '\u0600' to '\u0603'
            | '\u06dd'
            | '\u070f'
            | '\u17b4' to '\u17b5'
            | '\u200b' to '\u200f'
            | '\u202a' to '\u202e'
            | '\u2060' to '\u206f'
            | '\ufeff'
            | '\ufff9' to '\ufffb'
            | '\U000110bd'
            | '\U0001d173' to '\U0001d17a'
            | '\U000e0001' to '\U000e007f'
              { true }
            _ { false }
        };
    }

    pure fn Co(c: char) -> bool {
        ret alt c {
              '\ue000' to '\uf8ff'
              { true }
            _ { false }
        };
    }

    pure fn Cs(c: char) -> bool {
        ret alt c {
              '\ud800' to '\udfff'
              { true }
            _ { false }
        };
    }

    pure fn Ll(c: char) -> bool {
        ret alt c {
              '\x61' to '\x7a'
            | '\xaa'
            | '\xb5'
            | '\xba'
            | '\xdf' to '\xf6'
            | '\xf8' to '\xff'
            | '\u0101'
            | '\u0103'
            | '\u0105'
            | '\u0107'
            | '\u0109'
            | '\u010b'
            | '\u010d'
            | '\u010f'
            | '\u0111'
            | '\u0113'
            | '\u0115'
            | '\u0117'
            | '\u0119'
            | '\u011b'
            | '\u011d'
            | '\u011f'
            | '\u0121'
            | '\u0123'
            | '\u0125'
            | '\u0127'
            | '\u0129'
            | '\u012b'
            | '\u012d'
            | '\u012f'
            | '\u0131'
            | '\u0133'
            | '\u0135'
            | '\u0137' to '\u0138'
            | '\u013a'
            | '\u013c'
            | '\u013e'
            | '\u0140'
            | '\u0142'
            | '\u0144'
            | '\u0146'
            | '\u0148' to '\u0149'
            | '\u014b'
            | '\u014d'
            | '\u014f'
            | '\u0151'
            | '\u0153'
            | '\u0155'
            | '\u0157'
            | '\u0159'
            | '\u015b'
            | '\u015d'
            | '\u015f'
            | '\u0161'
            | '\u0163'
            | '\u0165'
            | '\u0167'
            | '\u0169'
            | '\u016b'
            | '\u016d'
            | '\u016f'
            | '\u0171'
            | '\u0173'
            | '\u0175'
            | '\u0177'
            | '\u017a'
            | '\u017c'
            | '\u017e' to '\u0180'
            | '\u0183'
            | '\u0185'
            | '\u0188'
            | '\u018c' to '\u018d'
            | '\u0192'
            | '\u0195'
            | '\u0199' to '\u019b'
            | '\u019e'
            | '\u01a1'
            | '\u01a3'
            | '\u01a5'
            | '\u01a8'
            | '\u01aa' to '\u01ab'
            | '\u01ad'
            | '\u01b0'
            | '\u01b4'
            | '\u01b6'
            | '\u01b9' to '\u01ba'
            | '\u01bd' to '\u01bf'
            | '\u01c6'
            | '\u01c9'
            | '\u01cc'
            | '\u01ce'
            | '\u01d0'
            | '\u01d2'
            | '\u01d4'
            | '\u01d6'
            | '\u01d8'
            | '\u01da'
            | '\u01dc' to '\u01dd'
            | '\u01df'
            | '\u01e1'
            | '\u01e3'
            | '\u01e5'
            | '\u01e7'
            | '\u01e9'
            | '\u01eb'
            | '\u01ed'
            | '\u01ef' to '\u01f0'
            | '\u01f3'
            | '\u01f5'
            | '\u01f9'
            | '\u01fb'
            | '\u01fd'
            | '\u01ff'
            | '\u0201'
            | '\u0203'
            | '\u0205'
            | '\u0207'
            | '\u0209'
            | '\u020b'
            | '\u020d'
            | '\u020f'
            | '\u0211'
            | '\u0213'
            | '\u0215'
            | '\u0217'
            | '\u0219'
            | '\u021b'
            | '\u021d'
            | '\u021f'
            | '\u0221'
            | '\u0223'
            | '\u0225'
            | '\u0227'
            | '\u0229'
            | '\u022b'
            | '\u022d'
            | '\u022f'
            | '\u0231'
            | '\u0233' to '\u0239'
            | '\u023c'
            | '\u023f' to '\u0240'
            | '\u0242'
            | '\u0247'
            | '\u0249'
            | '\u024b'
            | '\u024d'
            | '\u024f' to '\u0293'
            | '\u0295' to '\u02af'
            | '\u0371'
            | '\u0373'
            | '\u0377'
            | '\u037b' to '\u037d'
            | '\u0390'
            | '\u03ac' to '\u03ce'
            | '\u03d0' to '\u03d1'
            | '\u03d5' to '\u03d7'
            | '\u03d9'
            | '\u03db'
            | '\u03dd'
            | '\u03df'
            | '\u03e1'
            | '\u03e3'
            | '\u03e5'
            | '\u03e7'
            | '\u03e9'
            | '\u03eb'
            | '\u03ed'
            | '\u03ef' to '\u03f3'
            | '\u03f5'
            | '\u03f8'
            | '\u03fb' to '\u03fc'
            | '\u0430' to '\u045f'
            | '\u0461'
            | '\u0463'
            | '\u0465'
            | '\u0467'
            | '\u0469'
            | '\u046b'
            | '\u046d'
            | '\u046f'
            | '\u0471'
            | '\u0473'
            | '\u0475'
            | '\u0477'
            | '\u0479'
            | '\u047b'
            | '\u047d'
            | '\u047f'
            | '\u0481'
            | '\u048b'
            | '\u048d'
            | '\u048f'
            | '\u0491'
            | '\u0493'
            | '\u0495'
            | '\u0497'
            | '\u0499'
            | '\u049b'
            | '\u049d'
            | '\u049f'
            | '\u04a1'
            | '\u04a3'
            | '\u04a5'
            | '\u04a7'
            | '\u04a9'
            | '\u04ab'
            | '\u04ad'
            | '\u04af'
            | '\u04b1'
            | '\u04b3'
            | '\u04b5'
            | '\u04b7'
            | '\u04b9'
            | '\u04bb'
            | '\u04bd'
            | '\u04bf'
            | '\u04c2'
            | '\u04c4'
            | '\u04c6'
            | '\u04c8'
            | '\u04ca'
            | '\u04cc'
            | '\u04ce' to '\u04cf'
            | '\u04d1'
            | '\u04d3'
            | '\u04d5'
            | '\u04d7'
            | '\u04d9'
            | '\u04db'
            | '\u04dd'
            | '\u04df'
            | '\u04e1'
            | '\u04e3'
            | '\u04e5'
            | '\u04e7'
            | '\u04e9'
            | '\u04eb'
            | '\u04ed'
            | '\u04ef'
            | '\u04f1'
            | '\u04f3'
            | '\u04f5'
            | '\u04f7'
            | '\u04f9'
            | '\u04fb'
            | '\u04fd'
            | '\u04ff'
            | '\u0501'
            | '\u0503'
            | '\u0505'
            | '\u0507'
            | '\u0509'
            | '\u050b'
            | '\u050d'
            | '\u050f'
            | '\u0511'
            | '\u0513'
            | '\u0515'
            | '\u0517'
            | '\u0519'
            | '\u051b'
            | '\u051d'
            | '\u051f'
            | '\u0521'
            | '\u0523'
            | '\u0525'
            | '\u0527'
            | '\u0561' to '\u0587'
            | '\u1d00' to '\u1d2b'
            | '\u1d62' to '\u1d77'
            | '\u1d79' to '\u1d9a'
            | '\u1e01'
            | '\u1e03'
            | '\u1e05'
            | '\u1e07'
            | '\u1e09'
            | '\u1e0b'
            | '\u1e0d'
            | '\u1e0f'
            | '\u1e11'
            | '\u1e13'
            | '\u1e15'
            | '\u1e17'
            | '\u1e19'
            | '\u1e1b'
            | '\u1e1d'
            | '\u1e1f'
            | '\u1e21'
            | '\u1e23'
            | '\u1e25'
            | '\u1e27'
            | '\u1e29'
            | '\u1e2b'
            | '\u1e2d'
            | '\u1e2f'
            | '\u1e31'
            | '\u1e33'
            | '\u1e35'
            | '\u1e37'
            | '\u1e39'
            | '\u1e3b'
            | '\u1e3d'
            | '\u1e3f'
            | '\u1e41'
            | '\u1e43'
            | '\u1e45'
            | '\u1e47'
            | '\u1e49'
            | '\u1e4b'
            | '\u1e4d'
            | '\u1e4f'
            | '\u1e51'
            | '\u1e53'
            | '\u1e55'
            | '\u1e57'
            | '\u1e59'
            | '\u1e5b'
            | '\u1e5d'
            | '\u1e5f'
            | '\u1e61'
            | '\u1e63'
            | '\u1e65'
            | '\u1e67'
            | '\u1e69'
            | '\u1e6b'
            | '\u1e6d'
            | '\u1e6f'
            | '\u1e71'
            | '\u1e73'
            | '\u1e75'
            | '\u1e77'
            | '\u1e79'
            | '\u1e7b'
            | '\u1e7d'
            | '\u1e7f'
            | '\u1e81'
            | '\u1e83'
            | '\u1e85'
            | '\u1e87'
            | '\u1e89'
            | '\u1e8b'
            | '\u1e8d'
            | '\u1e8f'
            | '\u1e91'
            | '\u1e93'
            | '\u1e95' to '\u1e9d'
            | '\u1e9f'
            | '\u1ea1'
            | '\u1ea3'
            | '\u1ea5'
            | '\u1ea7'
            | '\u1ea9'
            | '\u1eab'
            | '\u1ead'
            | '\u1eaf'
            | '\u1eb1'
            | '\u1eb3'
            | '\u1eb5'
            | '\u1eb7'
            | '\u1eb9'
            | '\u1ebb'
            | '\u1ebd'
            | '\u1ebf'
            | '\u1ec1'
            | '\u1ec3'
            | '\u1ec5'
            | '\u1ec7'
            | '\u1ec9'
            | '\u1ecb'
            | '\u1ecd'
            | '\u1ecf'
            | '\u1ed1'
            | '\u1ed3'
            | '\u1ed5'
            | '\u1ed7'
            | '\u1ed9'
            | '\u1edb'
            | '\u1edd'
            | '\u1edf'
            | '\u1ee1'
            | '\u1ee3'
            | '\u1ee5'
            | '\u1ee7'
            | '\u1ee9'
            | '\u1eeb'
            | '\u1eed'
            | '\u1eef'
            | '\u1ef1'
            | '\u1ef3'
            | '\u1ef5'
            | '\u1ef7'
            | '\u1ef9'
            | '\u1efb'
            | '\u1efd'
            | '\u1eff' to '\u1f07'
            | '\u1f10' to '\u1f15'
            | '\u1f20' to '\u1f27'
            | '\u1f30' to '\u1f37'
            | '\u1f40' to '\u1f45'
            | '\u1f50' to '\u1f57'
            | '\u1f60' to '\u1f67'
            | '\u1f70' to '\u1f87'
            | '\u1f90' to '\u1f97'
            | '\u1fa0' to '\u1fa7'
            | '\u1fb0' to '\u1fb7'
            | '\u1fbe'
            | '\u1fc2' to '\u1fc7'
            | '\u1fd0' to '\u1fd7'
            | '\u1fe0' to '\u1fe7'
            | '\u1ff2' to '\u1ff7'
            | '\u210a'
            | '\u210e' to '\u210f'
            | '\u2113'
            | '\u212f'
            | '\u2134'
            | '\u2139'
            | '\u213c' to '\u213d'
            | '\u2146' to '\u2149'
            | '\u214e'
            | '\u2184'
            | '\u2c30' to '\u2c5e'
            | '\u2c61'
            | '\u2c65' to '\u2c66'
            | '\u2c68'
            | '\u2c6a'
            | '\u2c6c'
            | '\u2c71'
            | '\u2c73' to '\u2c74'
            | '\u2c76' to '\u2c7c'
            | '\u2c81'
            | '\u2c83'
            | '\u2c85'
            | '\u2c87'
            | '\u2c89'
            | '\u2c8b'
            | '\u2c8d'
            | '\u2c8f'
            | '\u2c91'
            | '\u2c93'
            | '\u2c95'
            | '\u2c97'
            | '\u2c99'
            | '\u2c9b'
            | '\u2c9d'
            | '\u2c9f'
            | '\u2ca1'
            | '\u2ca3'
            | '\u2ca5'
            | '\u2ca7'
            | '\u2ca9'
            | '\u2cab'
            | '\u2cad'
            | '\u2caf'
            | '\u2cb1'
            | '\u2cb3'
            | '\u2cb5'
            | '\u2cb7'
            | '\u2cb9'
            | '\u2cbb'
            | '\u2cbd'
            | '\u2cbf'
            | '\u2cc1'
            | '\u2cc3'
            | '\u2cc5'
            | '\u2cc7'
            | '\u2cc9'
            | '\u2ccb'
            | '\u2ccd'
            | '\u2ccf'
            | '\u2cd1'
            | '\u2cd3'
            | '\u2cd5'
            | '\u2cd7'
            | '\u2cd9'
            | '\u2cdb'
            | '\u2cdd'
            | '\u2cdf'
            | '\u2ce1'
            | '\u2ce3' to '\u2ce4'
            | '\u2cec'
            | '\u2cee'
            | '\u2d00' to '\u2d25'
            | '\ua641'
            | '\ua643'
            | '\ua645'
            | '\ua647'
            | '\ua649'
            | '\ua64b'
            | '\ua64d'
            | '\ua64f'
            | '\ua651'
            | '\ua653'
            | '\ua655'
            | '\ua657'
            | '\ua659'
            | '\ua65b'
            | '\ua65d'
            | '\ua65f'
            | '\ua661'
            | '\ua663'
            | '\ua665'
            | '\ua667'
            | '\ua669'
            | '\ua66b'
            | '\ua66d'
            | '\ua681'
            | '\ua683'
            | '\ua685'
            | '\ua687'
            | '\ua689'
            | '\ua68b'
            | '\ua68d'
            | '\ua68f'
            | '\ua691'
            | '\ua693'
            | '\ua695'
            | '\ua697'
            | '\ua723'
            | '\ua725'
            | '\ua727'
            | '\ua729'
            | '\ua72b'
            | '\ua72d'
            | '\ua72f' to '\ua731'
            | '\ua733'
            | '\ua735'
            | '\ua737'
            | '\ua739'
            | '\ua73b'
            | '\ua73d'
            | '\ua73f'
            | '\ua741'
            | '\ua743'
            | '\ua745'
            | '\ua747'
            | '\ua749'
            | '\ua74b'
            | '\ua74d'
            | '\ua74f'
            | '\ua751'
            | '\ua753'
            | '\ua755'
            | '\ua757'
            | '\ua759'
            | '\ua75b'
            | '\ua75d'
            | '\ua75f'
            | '\ua761'
            | '\ua763'
            | '\ua765'
            | '\ua767'
            | '\ua769'
            | '\ua76b'
            | '\ua76d'
            | '\ua76f'
            | '\ua771' to '\ua778'
            | '\ua77a'
            | '\ua77c'
            | '\ua77f'
            | '\ua781'
            | '\ua783'
            | '\ua785'
            | '\ua787'
            | '\ua78c'
            | '\ua78e'
            | '\ua791'
            | '\ua7a1'
            | '\ua7a3'
            | '\ua7a5'
            | '\ua7a7'
            | '\ua7a9' to '\ua7fa'
            | '\ufb00' to '\ufb17'
            | '\uff41' to '\uff5a'
            | '\U00010428' to '\U0001044f'
            | '\U0001d41a' to '\U0001d433'
            | '\U0001d44e' to '\U0001d467'
            | '\U0001d482' to '\U0001d49b'
            | '\U0001d4b6' to '\U0001d4cf'
            | '\U0001d4ea' to '\U0001d503'
            | '\U0001d51e' to '\U0001d537'
            | '\U0001d552' to '\U0001d56b'
            | '\U0001d586' to '\U0001d59f'
            | '\U0001d5ba' to '\U0001d5d3'
            | '\U0001d5ee' to '\U0001d607'
            | '\U0001d622' to '\U0001d63b'
            | '\U0001d656' to '\U0001d66f'
            | '\U0001d68a' to '\U0001d6a5'
            | '\U0001d6c2' to '\U0001d6da'
            | '\U0001d6dc' to '\U0001d6e1'
            | '\U0001d6fc' to '\U0001d714'
            | '\U0001d716' to '\U0001d71b'
            | '\U0001d736' to '\U0001d74e'
            | '\U0001d750' to '\U0001d755'
            | '\U0001d770' to '\U0001d788'
            | '\U0001d78a' to '\U0001d78f'
            | '\U0001d7aa' to '\U0001d7c2'
            | '\U0001d7c4' to '\U0001d7c9'
            | '\U0001d7cb'
              { true }
            _ { false }
        };
    }

    pure fn Lm(c: char) -> bool {
        ret alt c {
              '\u02b0' to '\u02c1'
            | '\u02c6' to '\u02d1'
            | '\u02e0' to '\u02e4'
            | '\u02ec'
            | '\u02ee'
            | '\u0374'
            | '\u037a'
            | '\u0559'
            | '\u0640'
            | '\u06e5' to '\u06e6'
            | '\u07f4' to '\u07f5'
            | '\u07fa'
            | '\u081a'
            | '\u0824'
            | '\u0828'
            | '\u0971'
            | '\u0e46'
            | '\u0ec6'
            | '\u10fc'
            | '\u17d7'
            | '\u1843'
            | '\u1aa7'
            | '\u1c78' to '\u1c7d'
            | '\u1d2c' to '\u1d61'
            | '\u1d78'
            | '\u1d9b' to '\u1dbf'
            | '\u2071'
            | '\u207f'
            | '\u2090' to '\u209c'
            | '\u2c7d'
            | '\u2d6f'
            | '\u2e2f'
            | '\u3005'
            | '\u3031' to '\u3035'
            | '\u303b'
            | '\u309d' to '\u309e'
            | '\u30fc' to '\u30fe'
            | '\ua015'
            | '\ua4f8' to '\ua4fd'
            | '\ua60c'
            | '\ua67f'
            | '\ua717' to '\ua71f'
            | '\ua770'
            | '\ua788'
            | '\ua9cf'
            | '\uaa70'
            | '\uaadd'
            | '\uff70'
            | '\uff9e' to '\uff9f'
              { true }
            _ { false }
        };
    }

    pure fn Lo(c: char) -> bool {
        ret alt c {
              '\u01bb'
            | '\u01c0' to '\u01c3'
            | '\u0294'
            | '\u05d0' to '\u05f2'
            | '\u0620' to '\u063f'
            | '\u0641' to '\u064a'
            | '\u066e' to '\u066f'
            | '\u0671' to '\u06d3'
            | '\u06d5'
            | '\u06ee' to '\u06ef'
            | '\u06fa' to '\u06fc'
            | '\u06ff'
            | '\u0710'
            | '\u0712' to '\u072f'
            | '\u074d' to '\u07a5'
            | '\u07b1'
            | '\u07ca' to '\u07ea'
            | '\u0800' to '\u0815'
            | '\u0840' to '\u0858'
            | '\u0904' to '\u0939'
            | '\u093d'
            | '\u0950'
            | '\u0958' to '\u0961'
            | '\u0972' to '\u097f'
            | '\u0985' to '\u09b9'
            | '\u09bd'
            | '\u09ce'
            | '\u09dc' to '\u09e1'
            | '\u09f0' to '\u09f1'
            | '\u0a05' to '\u0a39'
            | '\u0a59' to '\u0a5e'
            | '\u0a72' to '\u0a74'
            | '\u0a85' to '\u0ab9'
            | '\u0abd'
            | '\u0ad0' to '\u0ae1'
            | '\u0b05' to '\u0b39'
            | '\u0b3d'
            | '\u0b5c' to '\u0b61'
            | '\u0b71'
            | '\u0b83' to '\u0bb9'
            | '\u0bd0'
            | '\u0c05' to '\u0c3d'
            | '\u0c58' to '\u0c61'
            | '\u0c85' to '\u0cb9'
            | '\u0cbd'
            | '\u0cde' to '\u0ce1'
            | '\u0cf1' to '\u0cf2'
            | '\u0d05' to '\u0d3d'
            | '\u0d4e'
            | '\u0d60' to '\u0d61'
            | '\u0d7a' to '\u0d7f'
            | '\u0d85' to '\u0dc6'
            | '\u0e01' to '\u0e30'
            | '\u0e32' to '\u0e33'
            | '\u0e40' to '\u0e45'
            | '\u0e81' to '\u0eb0'
            | '\u0eb2' to '\u0eb3'
            | '\u0ebd' to '\u0ec4'
            | '\u0edc' to '\u0f00'
            | '\u0f40' to '\u0f6c'
            | '\u0f88' to '\u0f8c'
            | '\u1000' to '\u102a'
            | '\u103f'
            | '\u1050' to '\u1055'
            | '\u105a' to '\u105d'
            | '\u1061'
            | '\u1065' to '\u1066'
            | '\u106e' to '\u1070'
            | '\u1075' to '\u1081'
            | '\u108e'
            | '\u10d0' to '\u10fa'
            | '\u1100' to '\u135a'
            | '\u1380' to '\u138f'
            | '\u13a0' to '\u13f4'
            | '\u1401' to '\u166c'
            | '\u166f' to '\u167f'
            | '\u1681' to '\u169a'
            | '\u16a0' to '\u16ea'
            | '\u1700' to '\u1711'
            | '\u1720' to '\u1731'
            | '\u1740' to '\u1751'
            | '\u1760' to '\u1770'
            | '\u1780' to '\u17b3'
            | '\u17dc'
            | '\u1820' to '\u1842'
            | '\u1844' to '\u18a8'
            | '\u18aa' to '\u191c'
            | '\u1950' to '\u19ab'
            | '\u19c1' to '\u19c7'
            | '\u1a00' to '\u1a16'
            | '\u1a20' to '\u1a54'
            | '\u1b05' to '\u1b33'
            | '\u1b45' to '\u1b4b'
            | '\u1b83' to '\u1ba0'
            | '\u1bae' to '\u1baf'
            | '\u1bc0' to '\u1be5'
            | '\u1c00' to '\u1c23'
            | '\u1c4d' to '\u1c4f'
            | '\u1c5a' to '\u1c77'
            | '\u1ce9' to '\u1cec'
            | '\u1cee' to '\u1cf1'
            | '\u2135' to '\u2138'
            | '\u2d30' to '\u2d65'
            | '\u2d80' to '\u2dde'
            | '\u3006'
            | '\u303c'
            | '\u3041' to '\u3096'
            | '\u309f'
            | '\u30a1' to '\u30fa'
            | '\u30ff' to '\u318e'
            | '\u31a0' to '\u31ba'
            | '\u31f0' to '\u31ff'
            | '\u3400' to '\u4db5'
            | '\u4e00' to '\ua014'
            | '\ua016' to '\ua48c'
            | '\ua4d0' to '\ua4f7'
            | '\ua500' to '\ua60b'
            | '\ua610' to '\ua61f'
            | '\ua62a' to '\ua62b'
            | '\ua66e'
            | '\ua6a0' to '\ua6e5'
            | '\ua7fb' to '\ua801'
            | '\ua803' to '\ua805'
            | '\ua807' to '\ua80a'
            | '\ua80c' to '\ua822'
            | '\ua840' to '\ua873'
            | '\ua882' to '\ua8b3'
            | '\ua8f2' to '\ua8f7'
            | '\ua8fb'
            | '\ua90a' to '\ua925'
            | '\ua930' to '\ua946'
            | '\ua960' to '\ua97c'
            | '\ua984' to '\ua9b2'
            | '\uaa00' to '\uaa28'
            | '\uaa40' to '\uaa42'
            | '\uaa44' to '\uaa4b'
            | '\uaa60' to '\uaa6f'
            | '\uaa71' to '\uaa76'
            | '\uaa7a'
            | '\uaa80' to '\uaaaf'
            | '\uaab1'
            | '\uaab5' to '\uaab6'
            | '\uaab9' to '\uaabd'
            | '\uaac0'
            | '\uaac2' to '\uaadc'
            | '\uab01' to '\uabe2'
            | '\uac00' to '\ud7fb'
            | '\uf900' to '\ufad9'
            | '\ufb1d'
            | '\ufb1f' to '\ufb28'
            | '\ufb2a' to '\ufbb1'
            | '\ufbd3' to '\ufd3d'
            | '\ufd50' to '\ufdfb'
            | '\ufe70' to '\ufefc'
            | '\uff66' to '\uff6f'
            | '\uff71' to '\uff9d'
            | '\uffa0' to '\uffdc'
            | '\U00010000' to '\U000100fa'
            | '\U00010280' to '\U0001031e'
            | '\U00010330' to '\U00010340'
            | '\U00010342' to '\U00010349'
            | '\U00010380' to '\U0001039d'
            | '\U000103a0' to '\U000103cf'
            | '\U00010450' to '\U0001049d'
            | '\U00010800' to '\U00010855'
            | '\U00010900' to '\U00010915'
            | '\U00010920' to '\U00010939'
            | '\U00010a00'
            | '\U00010a10' to '\U00010a33'
            | '\U00010a60' to '\U00010a7c'
            | '\U00010b00' to '\U00010b35'
            | '\U00010b40' to '\U00010b55'
            | '\U00010b60' to '\U00010b72'
            | '\U00010c00' to '\U00010c48'
            | '\U00011003' to '\U00011037'
            | '\U00011083' to '\U000110af'
            | '\U00012000' to '\U0001236e'
            | '\U00013000' to '\U0001b001'
            | '\U00020000' to '\U0002fa1d'
              { true }
            _ { false }
        };
    }

    pure fn Lt(c: char) -> bool {
        ret alt c {
              '\u01c5'
            | '\u01c8'
            | '\u01cb'
            | '\u01f2'
            | '\u1f88' to '\u1f8f'
            | '\u1f98' to '\u1f9f'
            | '\u1fa8' to '\u1faf'
            | '\u1fbc'
            | '\u1fcc'
            | '\u1ffc'
              { true }
            _ { false }
        };
    }

    pure fn Lu(c: char) -> bool {
        ret alt c {
              '\x41' to '\x5a'
            | '\xc0' to '\xd6'
            | '\xd8' to '\xde'
            | '\u0100'
            | '\u0102'
            | '\u0104'
            | '\u0106'
            | '\u0108'
            | '\u010a'
            | '\u010c'
            | '\u010e'
            | '\u0110'
            | '\u0112'
            | '\u0114'
            | '\u0116'
            | '\u0118'
            | '\u011a'
            | '\u011c'
            | '\u011e'
            | '\u0120'
            | '\u0122'
            | '\u0124'
            | '\u0126'
            | '\u0128'
            | '\u012a'
            | '\u012c'
            | '\u012e'
            | '\u0130'
            | '\u0132'
            | '\u0134'
            | '\u0136'
            | '\u0139'
            | '\u013b'
            | '\u013d'
            | '\u013f'
            | '\u0141'
            | '\u0143'
            | '\u0145'
            | '\u0147'
            | '\u014a'
            | '\u014c'
            | '\u014e'
            | '\u0150'
            | '\u0152'
            | '\u0154'
            | '\u0156'
            | '\u0158'
            | '\u015a'
            | '\u015c'
            | '\u015e'
            | '\u0160'
            | '\u0162'
            | '\u0164'
            | '\u0166'
            | '\u0168'
            | '\u016a'
            | '\u016c'
            | '\u016e'
            | '\u0170'
            | '\u0172'
            | '\u0174'
            | '\u0176'
            | '\u0178' to '\u0179'
            | '\u017b'
            | '\u017d'
            | '\u0181' to '\u0182'
            | '\u0184'
            | '\u0186' to '\u0187'
            | '\u0189' to '\u018b'
            | '\u018e' to '\u0191'
            | '\u0193' to '\u0194'
            | '\u0196' to '\u0198'
            | '\u019c' to '\u019d'
            | '\u019f' to '\u01a0'
            | '\u01a2'
            | '\u01a4'
            | '\u01a6' to '\u01a7'
            | '\u01a9'
            | '\u01ac'
            | '\u01ae' to '\u01af'
            | '\u01b1' to '\u01b3'
            | '\u01b5'
            | '\u01b7' to '\u01b8'
            | '\u01bc'
            | '\u01c4'
            | '\u01c7'
            | '\u01ca'
            | '\u01cd'
            | '\u01cf'
            | '\u01d1'
            | '\u01d3'
            | '\u01d5'
            | '\u01d7'
            | '\u01d9'
            | '\u01db'
            | '\u01de'
            | '\u01e0'
            | '\u01e2'
            | '\u01e4'
            | '\u01e6'
            | '\u01e8'
            | '\u01ea'
            | '\u01ec'
            | '\u01ee'
            | '\u01f1'
            | '\u01f4'
            | '\u01f6' to '\u01f8'
            | '\u01fa'
            | '\u01fc'
            | '\u01fe'
            | '\u0200'
            | '\u0202'
            | '\u0204'
            | '\u0206'
            | '\u0208'
            | '\u020a'
            | '\u020c'
            | '\u020e'
            | '\u0210'
            | '\u0212'
            | '\u0214'
            | '\u0216'
            | '\u0218'
            | '\u021a'
            | '\u021c'
            | '\u021e'
            | '\u0220'
            | '\u0222'
            | '\u0224'
            | '\u0226'
            | '\u0228'
            | '\u022a'
            | '\u022c'
            | '\u022e'
            | '\u0230'
            | '\u0232'
            | '\u023a' to '\u023b'
            | '\u023d' to '\u023e'
            | '\u0241'
            | '\u0243' to '\u0246'
            | '\u0248'
            | '\u024a'
            | '\u024c'
            | '\u024e'
            | '\u0370'
            | '\u0372'
            | '\u0376'
            | '\u0386'
            | '\u0388' to '\u038f'
            | '\u0391' to '\u03ab'
            | '\u03cf'
            | '\u03d2' to '\u03d4'
            | '\u03d8'
            | '\u03da'
            | '\u03dc'
            | '\u03de'
            | '\u03e0'
            | '\u03e2'
            | '\u03e4'
            | '\u03e6'
            | '\u03e8'
            | '\u03ea'
            | '\u03ec'
            | '\u03ee'
            | '\u03f4'
            | '\u03f7'
            | '\u03f9' to '\u03fa'
            | '\u03fd' to '\u042f'
            | '\u0460'
            | '\u0462'
            | '\u0464'
            | '\u0466'
            | '\u0468'
            | '\u046a'
            | '\u046c'
            | '\u046e'
            | '\u0470'
            | '\u0472'
            | '\u0474'
            | '\u0476'
            | '\u0478'
            | '\u047a'
            | '\u047c'
            | '\u047e'
            | '\u0480'
            | '\u048a'
            | '\u048c'
            | '\u048e'
            | '\u0490'
            | '\u0492'
            | '\u0494'
            | '\u0496'
            | '\u0498'
            | '\u049a'
            | '\u049c'
            | '\u049e'
            | '\u04a0'
            | '\u04a2'
            | '\u04a4'
            | '\u04a6'
            | '\u04a8'
            | '\u04aa'
            | '\u04ac'
            | '\u04ae'
            | '\u04b0'
            | '\u04b2'
            | '\u04b4'
            | '\u04b6'
            | '\u04b8'
            | '\u04ba'
            | '\u04bc'
            | '\u04be'
            | '\u04c0' to '\u04c1'
            | '\u04c3'
            | '\u04c5'
            | '\u04c7'
            | '\u04c9'
            | '\u04cb'
            | '\u04cd'
            | '\u04d0'
            | '\u04d2'
            | '\u04d4'
            | '\u04d6'
            | '\u04d8'
            | '\u04da'
            | '\u04dc'
            | '\u04de'
            | '\u04e0'
            | '\u04e2'
            | '\u04e4'
            | '\u04e6'
            | '\u04e8'
            | '\u04ea'
            | '\u04ec'
            | '\u04ee'
            | '\u04f0'
            | '\u04f2'
            | '\u04f4'
            | '\u04f6'
            | '\u04f8'
            | '\u04fa'
            | '\u04fc'
            | '\u04fe'
            | '\u0500'
            | '\u0502'
            | '\u0504'
            | '\u0506'
            | '\u0508'
            | '\u050a'
            | '\u050c'
            | '\u050e'
            | '\u0510'
            | '\u0512'
            | '\u0514'
            | '\u0516'
            | '\u0518'
            | '\u051a'
            | '\u051c'
            | '\u051e'
            | '\u0520'
            | '\u0522'
            | '\u0524'
            | '\u0526'
            | '\u0531' to '\u0556'
            | '\u10a0' to '\u10c5'
            | '\u1e00'
            | '\u1e02'
            | '\u1e04'
            | '\u1e06'
            | '\u1e08'
            | '\u1e0a'
            | '\u1e0c'
            | '\u1e0e'
            | '\u1e10'
            | '\u1e12'
            | '\u1e14'
            | '\u1e16'
            | '\u1e18'
            | '\u1e1a'
            | '\u1e1c'
            | '\u1e1e'
            | '\u1e20'
            | '\u1e22'
            | '\u1e24'
            | '\u1e26'
            | '\u1e28'
            | '\u1e2a'
            | '\u1e2c'
            | '\u1e2e'
            | '\u1e30'
            | '\u1e32'
            | '\u1e34'
            | '\u1e36'
            | '\u1e38'
            | '\u1e3a'
            | '\u1e3c'
            | '\u1e3e'
            | '\u1e40'
            | '\u1e42'
            | '\u1e44'
            | '\u1e46'
            | '\u1e48'
            | '\u1e4a'
            | '\u1e4c'
            | '\u1e4e'
            | '\u1e50'
            | '\u1e52'
            | '\u1e54'
            | '\u1e56'
            | '\u1e58'
            | '\u1e5a'
            | '\u1e5c'
            | '\u1e5e'
            | '\u1e60'
            | '\u1e62'
            | '\u1e64'
            | '\u1e66'
            | '\u1e68'
            | '\u1e6a'
            | '\u1e6c'
            | '\u1e6e'
            | '\u1e70'
            | '\u1e72'
            | '\u1e74'
            | '\u1e76'
            | '\u1e78'
            | '\u1e7a'
            | '\u1e7c'
            | '\u1e7e'
            | '\u1e80'
            | '\u1e82'
            | '\u1e84'
            | '\u1e86'
            | '\u1e88'
            | '\u1e8a'
            | '\u1e8c'
            | '\u1e8e'
            | '\u1e90'
            | '\u1e92'
            | '\u1e94'
            | '\u1e9e'
            | '\u1ea0'
            | '\u1ea2'
            | '\u1ea4'
            | '\u1ea6'
            | '\u1ea8'
            | '\u1eaa'
            | '\u1eac'
            | '\u1eae'
            | '\u1eb0'
            | '\u1eb2'
            | '\u1eb4'
            | '\u1eb6'
            | '\u1eb8'
            | '\u1eba'
            | '\u1ebc'
            | '\u1ebe'
            | '\u1ec0'
            | '\u1ec2'
            | '\u1ec4'
            | '\u1ec6'
            | '\u1ec8'
            | '\u1eca'
            | '\u1ecc'
            | '\u1ece'
            | '\u1ed0'
            | '\u1ed2'
            | '\u1ed4'
            | '\u1ed6'
            | '\u1ed8'
            | '\u1eda'
            | '\u1edc'
            | '\u1ede'
            | '\u1ee0'
            | '\u1ee2'
            | '\u1ee4'
            | '\u1ee6'
            | '\u1ee8'
            | '\u1eea'
            | '\u1eec'
            | '\u1eee'
            | '\u1ef0'
            | '\u1ef2'
            | '\u1ef4'
            | '\u1ef6'
            | '\u1ef8'
            | '\u1efa'
            | '\u1efc'
            | '\u1efe'
            | '\u1f08' to '\u1f0f'
            | '\u1f18' to '\u1f1d'
            | '\u1f28' to '\u1f2f'
            | '\u1f38' to '\u1f3f'
            | '\u1f48' to '\u1f4d'
            | '\u1f59' to '\u1f5f'
            | '\u1f68' to '\u1f6f'
            | '\u1fb8' to '\u1fbb'
            | '\u1fc8' to '\u1fcb'
            | '\u1fd8' to '\u1fdb'
            | '\u1fe8' to '\u1fec'
            | '\u1ff8' to '\u1ffb'
            | '\u2102'
            | '\u2107'
            | '\u210b' to '\u210d'
            | '\u2110' to '\u2112'
            | '\u2115'
            | '\u2119' to '\u211d'
            | '\u2124'
            | '\u2126'
            | '\u2128'
            | '\u212a' to '\u212d'
            | '\u2130' to '\u2133'
            | '\u213e' to '\u213f'
            | '\u2145'
            | '\u2183'
            | '\u2c00' to '\u2c2e'
            | '\u2c60'
            | '\u2c62' to '\u2c64'
            | '\u2c67'
            | '\u2c69'
            | '\u2c6b'
            | '\u2c6d' to '\u2c70'
            | '\u2c72'
            | '\u2c75'
            | '\u2c7e' to '\u2c80'
            | '\u2c82'
            | '\u2c84'
            | '\u2c86'
            | '\u2c88'
            | '\u2c8a'
            | '\u2c8c'
            | '\u2c8e'
            | '\u2c90'
            | '\u2c92'
            | '\u2c94'
            | '\u2c96'
            | '\u2c98'
            | '\u2c9a'
            | '\u2c9c'
            | '\u2c9e'
            | '\u2ca0'
            | '\u2ca2'
            | '\u2ca4'
            | '\u2ca6'
            | '\u2ca8'
            | '\u2caa'
            | '\u2cac'
            | '\u2cae'
            | '\u2cb0'
            | '\u2cb2'
            | '\u2cb4'
            | '\u2cb6'
            | '\u2cb8'
            | '\u2cba'
            | '\u2cbc'
            | '\u2cbe'
            | '\u2cc0'
            | '\u2cc2'
            | '\u2cc4'
            | '\u2cc6'
            | '\u2cc8'
            | '\u2cca'
            | '\u2ccc'
            | '\u2cce'
            | '\u2cd0'
            | '\u2cd2'
            | '\u2cd4'
            | '\u2cd6'
            | '\u2cd8'
            | '\u2cda'
            | '\u2cdc'
            | '\u2cde'
            | '\u2ce0'
            | '\u2ce2'
            | '\u2ceb'
            | '\u2ced'
            | '\ua640'
            | '\ua642'
            | '\ua644'
            | '\ua646'
            | '\ua648'
            | '\ua64a'
            | '\ua64c'
            | '\ua64e'
            | '\ua650'
            | '\ua652'
            | '\ua654'
            | '\ua656'
            | '\ua658'
            | '\ua65a'
            | '\ua65c'
            | '\ua65e'
            | '\ua660'
            | '\ua662'
            | '\ua664'
            | '\ua666'
            | '\ua668'
            | '\ua66a'
            | '\ua66c'
            | '\ua680'
            | '\ua682'
            | '\ua684'
            | '\ua686'
            | '\ua688'
            | '\ua68a'
            | '\ua68c'
            | '\ua68e'
            | '\ua690'
            | '\ua692'
            | '\ua694'
            | '\ua696'
            | '\ua722'
            | '\ua724'
            | '\ua726'
            | '\ua728'
            | '\ua72a'
            | '\ua72c'
            | '\ua72e'
            | '\ua732'
            | '\ua734'
            | '\ua736'
            | '\ua738'
            | '\ua73a'
            | '\ua73c'
            | '\ua73e'
            | '\ua740'
            | '\ua742'
            | '\ua744'
            | '\ua746'
            | '\ua748'
            | '\ua74a'
            | '\ua74c'
            | '\ua74e'
            | '\ua750'
            | '\ua752'
            | '\ua754'
            | '\ua756'
            | '\ua758'
            | '\ua75a'
            | '\ua75c'
            | '\ua75e'
            | '\ua760'
            | '\ua762'
            | '\ua764'
            | '\ua766'
            | '\ua768'
            | '\ua76a'
            | '\ua76c'
            | '\ua76e'
            | '\ua779'
            | '\ua77b'
            | '\ua77d' to '\ua77e'
            | '\ua780'
            | '\ua782'
            | '\ua784'
            | '\ua786'
            | '\ua78b'
            | '\ua78d'
            | '\ua790'
            | '\ua7a0'
            | '\ua7a2'
            | '\ua7a4'
            | '\ua7a6'
            | '\ua7a8'
            | '\uff21' to '\uff3a'
            | '\U00010400' to '\U00010427'
            | '\U0001d400' to '\U0001d419'
            | '\U0001d434' to '\U0001d44d'
            | '\U0001d468' to '\U0001d481'
            | '\U0001d49c' to '\U0001d4b5'
            | '\U0001d4d0' to '\U0001d4e9'
            | '\U0001d504' to '\U0001d51c'
            | '\U0001d538' to '\U0001d550'
            | '\U0001d56c' to '\U0001d585'
            | '\U0001d5a0' to '\U0001d5b9'
            | '\U0001d5d4' to '\U0001d5ed'
            | '\U0001d608' to '\U0001d621'
            | '\U0001d63c' to '\U0001d655'
            | '\U0001d670' to '\U0001d689'
            | '\U0001d6a8' to '\U0001d6c0'
            | '\U0001d6e2' to '\U0001d6fa'
            | '\U0001d71c' to '\U0001d734'
            | '\U0001d756' to '\U0001d76e'
            | '\U0001d790' to '\U0001d7a8'
            | '\U0001d7ca'
              { true }
            _ { false }
        };
    }

    pure fn Mc(c: char) -> bool {
        ret alt c {
              '\u0903'
            | '\u093b'
            | '\u093e' to '\u0940'
            | '\u0949' to '\u094c'
            | '\u094e' to '\u094f'
            | '\u0982' to '\u0983'
            | '\u09be' to '\u09c0'
            | '\u09c7' to '\u09cc'
            | '\u09d7'
            | '\u0a03'
            | '\u0a3e' to '\u0a40'
            | '\u0a83'
            | '\u0abe' to '\u0ac0'
            | '\u0ac9' to '\u0acc'
            | '\u0b02' to '\u0b03'
            | '\u0b3e'
            | '\u0b40'
            | '\u0b47' to '\u0b4c'
            | '\u0b57'
            | '\u0bbe' to '\u0bbf'
            | '\u0bc1' to '\u0bcc'
            | '\u0bd7'
            | '\u0c01' to '\u0c03'
            | '\u0c41' to '\u0c44'
            | '\u0c82' to '\u0c83'
            | '\u0cbe'
            | '\u0cc0' to '\u0cc4'
            | '\u0cc7' to '\u0ccb'
            | '\u0cd5' to '\u0cd6'
            | '\u0d02' to '\u0d03'
            | '\u0d3e' to '\u0d40'
            | '\u0d46' to '\u0d4c'
            | '\u0d57'
            | '\u0d82' to '\u0d83'
            | '\u0dcf' to '\u0dd1'
            | '\u0dd8' to '\u0df3'
            | '\u0f3e' to '\u0f3f'
            | '\u0f7f'
            | '\u102b' to '\u102c'
            | '\u1031'
            | '\u1038'
            | '\u103b' to '\u103c'
            | '\u1056' to '\u1057'
            | '\u1062' to '\u1064'
            | '\u1067' to '\u106d'
            | '\u1083' to '\u1084'
            | '\u1087' to '\u108c'
            | '\u108f'
            | '\u109a' to '\u109c'
            | '\u17b6'
            | '\u17be' to '\u17c5'
            | '\u17c7' to '\u17c8'
            | '\u1923' to '\u1926'
            | '\u1929' to '\u1931'
            | '\u1933' to '\u1938'
            | '\u19b0' to '\u19c0'
            | '\u19c8' to '\u19c9'
            | '\u1a19' to '\u1a1b'
            | '\u1a55'
            | '\u1a57'
            | '\u1a61'
            | '\u1a63' to '\u1a64'
            | '\u1a6d' to '\u1a72'
            | '\u1b04'
            | '\u1b35'
            | '\u1b3b'
            | '\u1b3d' to '\u1b41'
            | '\u1b43' to '\u1b44'
            | '\u1b82'
            | '\u1ba1'
            | '\u1ba6' to '\u1ba7'
            | '\u1baa'
            | '\u1be7'
            | '\u1bea' to '\u1bec'
            | '\u1bee'
            | '\u1bf2' to '\u1bf3'
            | '\u1c24' to '\u1c2b'
            | '\u1c34' to '\u1c35'
            | '\u1ce1'
            | '\u1cf2'
            | '\ua823' to '\ua824'
            | '\ua827'
            | '\ua880' to '\ua881'
            | '\ua8b4' to '\ua8c3'
            | '\ua952' to '\ua953'
            | '\ua983'
            | '\ua9b4' to '\ua9b5'
            | '\ua9ba' to '\ua9bb'
            | '\ua9bd' to '\ua9c0'
            | '\uaa2f' to '\uaa30'
            | '\uaa33' to '\uaa34'
            | '\uaa4d'
            | '\uaa7b'
            | '\uabe3' to '\uabe4'
            | '\uabe6' to '\uabe7'
            | '\uabe9' to '\uabea'
            | '\uabec'
            | '\U00011000'
            | '\U00011002'
            | '\U00011082'
            | '\U000110b0' to '\U000110b2'
            | '\U000110b7' to '\U000110b8'
            | '\U0001d165' to '\U0001d166'
            | '\U0001d16d' to '\U0001d172'
              { true }
            _ { false }
        };
    }

    pure fn Me(c: char) -> bool {
        ret alt c {
              '\u0488' to '\u0489'
            | '\u20dd' to '\u20e0'
            | '\u20e2' to '\u20e4'
            | '\ua670' to '\ua672'
              { true }
            _ { false }
        };
    }

    pure fn Mn(c: char) -> bool {
        ret alt c {
              '\u0300' to '\u036f'
            | '\u0483' to '\u0487'
            | '\u0591' to '\u05bd'
            | '\u05bf'
            | '\u05c1' to '\u05c2'
            | '\u05c4' to '\u05c5'
            | '\u05c7'
            | '\u0610' to '\u061a'
            | '\u064b' to '\u065f'
            | '\u0670'
            | '\u06d6' to '\u06dc'
            | '\u06df' to '\u06e4'
            | '\u06e7' to '\u06e8'
            | '\u06ea' to '\u06ed'
            | '\u0711'
            | '\u0730' to '\u074a'
            | '\u07a6' to '\u07b0'
            | '\u07eb' to '\u07f3'
            | '\u0816' to '\u0819'
            | '\u081b' to '\u0823'
            | '\u0825' to '\u0827'
            | '\u0829' to '\u082d'
            | '\u0859' to '\u085b'
            | '\u0900' to '\u0902'
            | '\u093a'
            | '\u093c'
            | '\u0941' to '\u0948'
            | '\u094d'
            | '\u0951' to '\u0957'
            | '\u0962' to '\u0963'
            | '\u0981'
            | '\u09bc'
            | '\u09c1' to '\u09c4'
            | '\u09cd'
            | '\u09e2' to '\u09e3'
            | '\u0a01' to '\u0a02'
            | '\u0a3c'
            | '\u0a41' to '\u0a51'
            | '\u0a70' to '\u0a71'
            | '\u0a75' to '\u0a82'
            | '\u0abc'
            | '\u0ac1' to '\u0ac8'
            | '\u0acd'
            | '\u0ae2' to '\u0ae3'
            | '\u0b01'
            | '\u0b3c'
            | '\u0b3f'
            | '\u0b41' to '\u0b44'
            | '\u0b4d' to '\u0b56'
            | '\u0b62' to '\u0b63'
            | '\u0b82'
            | '\u0bc0'
            | '\u0bcd'
            | '\u0c3e' to '\u0c40'
            | '\u0c46' to '\u0c56'
            | '\u0c62' to '\u0c63'
            | '\u0cbc'
            | '\u0cbf'
            | '\u0cc6'
            | '\u0ccc' to '\u0ccd'
            | '\u0ce2' to '\u0ce3'
            | '\u0d41' to '\u0d44'
            | '\u0d4d'
            | '\u0d62' to '\u0d63'
            | '\u0dca'
            | '\u0dd2' to '\u0dd6'
            | '\u0e31'
            | '\u0e34' to '\u0e3a'
            | '\u0e47' to '\u0e4e'
            | '\u0eb1'
            | '\u0eb4' to '\u0ebc'
            | '\u0ec8' to '\u0ecd'
            | '\u0f18' to '\u0f19'
            | '\u0f35'
            | '\u0f37'
            | '\u0f39'
            | '\u0f71' to '\u0f7e'
            | '\u0f80' to '\u0f84'
            | '\u0f86' to '\u0f87'
            | '\u0f8d' to '\u0fbc'
            | '\u0fc6'
            | '\u102d' to '\u1030'
            | '\u1032' to '\u1037'
            | '\u1039' to '\u103a'
            | '\u103d' to '\u103e'
            | '\u1058' to '\u1059'
            | '\u105e' to '\u1060'
            | '\u1071' to '\u1074'
            | '\u1082'
            | '\u1085' to '\u1086'
            | '\u108d'
            | '\u109d'
            | '\u135d' to '\u135f'
            | '\u1712' to '\u1714'
            | '\u1732' to '\u1734'
            | '\u1752' to '\u1753'
            | '\u1772' to '\u1773'
            | '\u17b7' to '\u17bd'
            | '\u17c6'
            | '\u17c9' to '\u17d3'
            | '\u17dd'
            | '\u180b' to '\u180d'
            | '\u18a9'
            | '\u1920' to '\u1922'
            | '\u1927' to '\u1928'
            | '\u1932'
            | '\u1939' to '\u193b'
            | '\u1a17' to '\u1a18'
            | '\u1a56'
            | '\u1a58' to '\u1a60'
            | '\u1a62'
            | '\u1a65' to '\u1a6c'
            | '\u1a73' to '\u1a7f'
            | '\u1b00' to '\u1b03'
            | '\u1b34'
            | '\u1b36' to '\u1b3a'
            | '\u1b3c'
            | '\u1b42'
            | '\u1b6b' to '\u1b73'
            | '\u1b80' to '\u1b81'
            | '\u1ba2' to '\u1ba5'
            | '\u1ba8' to '\u1ba9'
            | '\u1be6'
            | '\u1be8' to '\u1be9'
            | '\u1bed'
            | '\u1bef' to '\u1bf1'
            | '\u1c2c' to '\u1c33'
            | '\u1c36' to '\u1c37'
            | '\u1cd0' to '\u1cd2'
            | '\u1cd4' to '\u1ce0'
            | '\u1ce2' to '\u1ce8'
            | '\u1ced'
            | '\u1dc0' to '\u1dff'
            | '\u20d0' to '\u20dc'
            | '\u20e1'
            | '\u20e5' to '\u20f0'
            | '\u2cef' to '\u2cf1'
            | '\u2d7f'
            | '\u2de0' to '\u2dff'
            | '\u302a' to '\u302f'
            | '\u3099' to '\u309a'
            | '\ua66f'
            | '\ua67c' to '\ua67d'
            | '\ua6f0' to '\ua6f1'
            | '\ua802'
            | '\ua806'
            | '\ua80b'
            | '\ua825' to '\ua826'
            | '\ua8c4'
            | '\ua8e0' to '\ua8f1'
            | '\ua926' to '\ua92d'
            | '\ua947' to '\ua951'
            | '\ua980' to '\ua982'
            | '\ua9b3'
            | '\ua9b6' to '\ua9b9'
            | '\ua9bc'
            | '\uaa29' to '\uaa2e'
            | '\uaa31' to '\uaa32'
            | '\uaa35' to '\uaa36'
            | '\uaa43'
            | '\uaa4c'
            | '\uaab0'
            | '\uaab2' to '\uaab4'
            | '\uaab7' to '\uaab8'
            | '\uaabe' to '\uaabf'
            | '\uaac1'
            | '\uabe5'
            | '\uabe8'
            | '\uabed'
            | '\ufb1e'
            | '\ufe00' to '\ufe0f'
            | '\ufe20' to '\ufe26'
            | '\U000101fd'
            | '\U00010a01' to '\U00010a0f'
            | '\U00010a38' to '\U00010a3f'
            | '\U00011001'
            | '\U00011038' to '\U00011046'
            | '\U00011080' to '\U00011081'
            | '\U000110b3' to '\U000110b6'
            | '\U000110b9' to '\U000110ba'
            | '\U0001d167' to '\U0001d169'
            | '\U0001d17b' to '\U0001d182'
            | '\U0001d185' to '\U0001d18b'
            | '\U0001d1aa' to '\U0001d1ad'
            | '\U0001d242' to '\U0001d244'
            | '\U000e0100' to '\U000e01ef'
              { true }
            _ { false }
        };
    }

    pure fn Nd(c: char) -> bool {
        ret alt c {
              '\x30' to '\x39'
            | '\u0660' to '\u0669'
            | '\u06f0' to '\u06f9'
            | '\u07c0' to '\u07c9'
            | '\u0966' to '\u096f'
            | '\u09e6' to '\u09ef'
            | '\u0a66' to '\u0a6f'
            | '\u0ae6' to '\u0aef'
            | '\u0b66' to '\u0b6f'
            | '\u0be6' to '\u0bef'
            | '\u0c66' to '\u0c6f'
            | '\u0ce6' to '\u0cef'
            | '\u0d66' to '\u0d6f'
            | '\u0e50' to '\u0e59'
            | '\u0ed0' to '\u0ed9'
            | '\u0f20' to '\u0f29'
            | '\u1040' to '\u1049'
            | '\u1090' to '\u1099'
            | '\u17e0' to '\u17e9'
            | '\u1810' to '\u1819'
            | '\u1946' to '\u194f'
            | '\u19d0' to '\u19d9'
            | '\u1a80' to '\u1a99'
            | '\u1b50' to '\u1b59'
            | '\u1bb0' to '\u1bb9'
            | '\u1c40' to '\u1c49'
            | '\u1c50' to '\u1c59'
            | '\ua620' to '\ua629'
            | '\ua8d0' to '\ua8d9'
            | '\ua900' to '\ua909'
            | '\ua9d0' to '\ua9d9'
            | '\uaa50' to '\uaa59'
            | '\uabf0' to '\uabf9'
            | '\uff10' to '\uff19'
            | '\U000104a0' to '\U000104a9'
            | '\U00011066' to '\U0001106f'
            | '\U0001d7ce' to '\U0001d7ff'
              { true }
            _ { false }
        };
    }

    pure fn Nl(c: char) -> bool {
        ret alt c {
              '\u16ee' to '\u16f0'
            | '\u2160' to '\u2182'
            | '\u2185' to '\u2188'
            | '\u3007'
            | '\u3021' to '\u3029'
            | '\u3038' to '\u303a'
            | '\ua6e6' to '\ua6ef'
            | '\U00010140' to '\U00010174'
            | '\U00010341'
            | '\U0001034a'
            | '\U000103d1' to '\U000103d5'
            | '\U00012400' to '\U00012462'
              { true }
            _ { false }
        };
    }

    pure fn No(c: char) -> bool {
        ret alt c {
              '\xb2' to '\xb3'
            | '\xb9'
            | '\xbc' to '\xbe'
            | '\u09f4' to '\u09f9'
            | '\u0b72' to '\u0b77'
            | '\u0bf0' to '\u0bf2'
            | '\u0c78' to '\u0c7e'
            | '\u0d70' to '\u0d75'
            | '\u0f2a' to '\u0f33'
            | '\u1369' to '\u137c'
            | '\u17f0' to '\u17f9'
            | '\u19da'
            | '\u2070'
            | '\u2074' to '\u2079'
            | '\u2080' to '\u2089'
            | '\u2150' to '\u215f'
            | '\u2189'
            | '\u2460' to '\u249b'
            | '\u24ea' to '\u24ff'
            | '\u2776' to '\u2793'
            | '\u2cfd'
            | '\u3192' to '\u3195'
            | '\u3220' to '\u3229'
            | '\u3251' to '\u325f'
            | '\u3280' to '\u3289'
            | '\u32b1' to '\u32bf'
            | '\ua830' to '\ua835'
            | '\U00010107' to '\U00010133'
            | '\U00010175' to '\U00010178'
            | '\U0001018a'
            | '\U00010320' to '\U00010323'
            | '\U00010858' to '\U0001085f'
            | '\U00010916' to '\U0001091b'
            | '\U00010a40' to '\U00010a47'
            | '\U00010a7d' to '\U00010a7e'
            | '\U00010b58' to '\U00010b5f'
            | '\U00010b78' to '\U00010b7f'
            | '\U00010e60' to '\U00010e7e'
            | '\U00011052' to '\U00011065'
            | '\U0001d360' to '\U0001d371'
            | '\U0001f100' to '\U0001f10a'
              { true }
            _ { false }
        };
    }

    pure fn Pc(c: char) -> bool {
        ret alt c {
              '\x5f'
            | '\u203f' to '\u2040'
            | '\u2054'
            | '\ufe33' to '\ufe34'
            | '\ufe4d' to '\ufe4f'
            | '\uff3f'
              { true }
            _ { false }
        };
    }

    pure fn Pd(c: char) -> bool {
        ret alt c {
              '\x2d'
            | '\u058a'
            | '\u05be'
            | '\u1400'
            | '\u1806'
            | '\u2010' to '\u2015'
            | '\u2e17'
            | '\u2e1a'
            | '\u301c'
            | '\u3030'
            | '\u30a0'
            | '\ufe31' to '\ufe32'
            | '\ufe58'
            | '\ufe63'
            | '\uff0d'
              { true }
            _ { false }
        };
    }

    pure fn Pe(c: char) -> bool {
        ret alt c {
              '\x29'
            | '\x5d'
            | '\x7d'
            | '\u0f3b'
            | '\u0f3d'
            | '\u169c'
            | '\u2046'
            | '\u207e'
            | '\u208e'
            | '\u232a'
            | '\u2769'
            | '\u276b'
            | '\u276d'
            | '\u276f'
            | '\u2771'
            | '\u2773'
            | '\u2775'
            | '\u27c6'
            | '\u27e7'
            | '\u27e9'
            | '\u27eb'
            | '\u27ed'
            | '\u27ef'
            | '\u2984'
            | '\u2986'
            | '\u2988'
            | '\u298a'
            | '\u298c'
            | '\u298e'
            | '\u2990'
            | '\u2992'
            | '\u2994'
            | '\u2996'
            | '\u2998'
            | '\u29d9'
            | '\u29db'
            | '\u29fd'
            | '\u2e23'
            | '\u2e25'
            | '\u2e27'
            | '\u2e29'
            | '\u3009'
            | '\u300b'
            | '\u300d'
            | '\u300f'
            | '\u3011'
            | '\u3015'
            | '\u3017'
            | '\u3019'
            | '\u301b'
            | '\u301e' to '\u301f'
            | '\ufd3f'
            | '\ufe18'
            | '\ufe36'
            | '\ufe38'
            | '\ufe3a'
            | '\ufe3c'
            | '\ufe3e'
            | '\ufe40'
            | '\ufe42'
            | '\ufe44'
            | '\ufe48'
            | '\ufe5a'
            | '\ufe5c'
            | '\ufe5e'
            | '\uff09'
            | '\uff3d'
            | '\uff5d'
            | '\uff60'
            | '\uff63'
              { true }
            _ { false }
        };
    }

    pure fn Pf(c: char) -> bool {
        ret alt c {
              '\xbb'
            | '\u2019'
            | '\u201d'
            | '\u203a'
            | '\u2e03'
            | '\u2e05'
            | '\u2e0a'
            | '\u2e0d'
            | '\u2e1d'
            | '\u2e21'
              { true }
            _ { false }
        };
    }

    pure fn Pi(c: char) -> bool {
        ret alt c {
              '\xab'
            | '\u2018'
            | '\u201b' to '\u201c'
            | '\u201f'
            | '\u2039'
            | '\u2e02'
            | '\u2e04'
            | '\u2e09'
            | '\u2e0c'
            | '\u2e1c'
            | '\u2e20'
              { true }
            _ { false }
        };
    }

    pure fn Po(c: char) -> bool {
        ret alt c {
              '\x21' to '\x23'
            | '\x25' to '\x27'
            | '\x2a'
            | '\x2c'
            | '\x2e' to '\x2f'
            | '\x3a' to '\x3b'
            | '\x3f' to '\x40'
            | '\x5c'
            | '\xa1'
            | '\xb7'
            | '\xbf'
            | '\u037e'
            | '\u0387'
            | '\u055a' to '\u055f'
            | '\u0589'
            | '\u05c0'
            | '\u05c3'
            | '\u05c6'
            | '\u05f3' to '\u05f4'
            | '\u0609' to '\u060a'
            | '\u060c' to '\u060d'
            | '\u061b' to '\u061f'
            | '\u066a' to '\u066d'
            | '\u06d4'
            | '\u0700' to '\u070d'
            | '\u07f7' to '\u07f9'
            | '\u0830' to '\u083e'
            | '\u085e'
            | '\u0964' to '\u0965'
            | '\u0970'
            | '\u0df4'
            | '\u0e4f'
            | '\u0e5a' to '\u0e5b'
            | '\u0f04' to '\u0f12'
            | '\u0f85'
            | '\u0fd0' to '\u0fd4'
            | '\u0fd9' to '\u0fda'
            | '\u104a' to '\u104f'
            | '\u10fb'
            | '\u1361' to '\u1368'
            | '\u166d' to '\u166e'
            | '\u16eb' to '\u16ed'
            | '\u1735' to '\u1736'
            | '\u17d4' to '\u17d6'
            | '\u17d8' to '\u17da'
            | '\u1800' to '\u1805'
            | '\u1807' to '\u180a'
            | '\u1944' to '\u1945'
            | '\u1a1e' to '\u1a1f'
            | '\u1aa0' to '\u1aa6'
            | '\u1aa8' to '\u1aad'
            | '\u1b5a' to '\u1b60'
            | '\u1bfc' to '\u1bff'
            | '\u1c3b' to '\u1c3f'
            | '\u1c7e' to '\u1c7f'
            | '\u1cd3'
            | '\u2016' to '\u2017'
            | '\u2020' to '\u2027'
            | '\u2030' to '\u2038'
            | '\u203b' to '\u203e'
            | '\u2041' to '\u2043'
            | '\u2047' to '\u2051'
            | '\u2053'
            | '\u2055' to '\u205e'
            | '\u2cf9' to '\u2cfc'
            | '\u2cfe' to '\u2cff'
            | '\u2d70'
            | '\u2e00' to '\u2e01'
            | '\u2e06' to '\u2e08'
            | '\u2e0b'
            | '\u2e0e' to '\u2e16'
            | '\u2e18' to '\u2e19'
            | '\u2e1b'
            | '\u2e1e' to '\u2e1f'
            | '\u2e2a' to '\u2e2e'
            | '\u2e30' to '\u2e31'
            | '\u3001' to '\u3003'
            | '\u303d'
            | '\u30fb'
            | '\ua4fe' to '\ua4ff'
            | '\ua60d' to '\ua60f'
            | '\ua673'
            | '\ua67e'
            | '\ua6f2' to '\ua6f7'
            | '\ua874' to '\ua877'
            | '\ua8ce' to '\ua8cf'
            | '\ua8f8' to '\ua8fa'
            | '\ua92e' to '\ua92f'
            | '\ua95f'
            | '\ua9c1' to '\ua9cd'
            | '\ua9de' to '\ua9df'
            | '\uaa5c' to '\uaa5f'
            | '\uaade' to '\uaadf'
            | '\uabeb'
            | '\ufe10' to '\ufe16'
            | '\ufe19'
            | '\ufe30'
            | '\ufe45' to '\ufe46'
            | '\ufe49' to '\ufe4c'
            | '\ufe50' to '\ufe57'
            | '\ufe5f' to '\ufe61'
            | '\ufe68'
            | '\ufe6a' to '\ufe6b'
            | '\uff01' to '\uff03'
            | '\uff05' to '\uff07'
            | '\uff0a'
            | '\uff0c'
            | '\uff0e' to '\uff0f'
            | '\uff1a' to '\uff1b'
            | '\uff1f' to '\uff20'
            | '\uff3c'
            | '\uff61'
            | '\uff64' to '\uff65'
            | '\U00010100' to '\U00010101'
            | '\U0001039f'
            | '\U000103d0'
            | '\U00010857'
            | '\U0001091f'
            | '\U0001093f'
            | '\U00010a50' to '\U00010a58'
            | '\U00010a7f'
            | '\U00010b39' to '\U00010b3f'
            | '\U00011047' to '\U0001104d'
            | '\U000110bb' to '\U000110bc'
            | '\U000110be' to '\U000110c1'
            | '\U00012470' to '\U00012473'
              { true }
            _ { false }
        };
    }

    pure fn Ps(c: char) -> bool {
        ret alt c {
              '\x28'
            | '\x5b'
            | '\x7b'
            | '\u0f3a'
            | '\u0f3c'
            | '\u169b'
            | '\u201a'
            | '\u201e'
            | '\u2045'
            | '\u207d'
            | '\u208d'
            | '\u2329'
            | '\u2768'
            | '\u276a'
            | '\u276c'
            | '\u276e'
            | '\u2770'
            | '\u2772'
            | '\u2774'
            | '\u27c5'
            | '\u27e6'
            | '\u27e8'
            | '\u27ea'
            | '\u27ec'
            | '\u27ee'
            | '\u2983'
            | '\u2985'
            | '\u2987'
            | '\u2989'
            | '\u298b'
            | '\u298d'
            | '\u298f'
            | '\u2991'
            | '\u2993'
            | '\u2995'
            | '\u2997'
            | '\u29d8'
            | '\u29da'
            | '\u29fc'
            | '\u2e22'
            | '\u2e24'
            | '\u2e26'
            | '\u2e28'
            | '\u3008'
            | '\u300a'
            | '\u300c'
            | '\u300e'
            | '\u3010'
            | '\u3014'
            | '\u3016'
            | '\u3018'
            | '\u301a'
            | '\u301d'
            | '\ufd3e'
            | '\ufe17'
            | '\ufe35'
            | '\ufe37'
            | '\ufe39'
            | '\ufe3b'
            | '\ufe3d'
            | '\ufe3f'
            | '\ufe41'
            | '\ufe43'
            | '\ufe47'
            | '\ufe59'
            | '\ufe5b'
            | '\ufe5d'
            | '\uff08'
            | '\uff3b'
            | '\uff5b'
            | '\uff5f'
            | '\uff62'
              { true }
            _ { false }
        };
    }

    pure fn Sc(c: char) -> bool {
        ret alt c {
              '\x24'
            | '\xa2' to '\xa5'
            | '\u060b'
            | '\u09f2' to '\u09f3'
            | '\u09fb'
            | '\u0af1'
            | '\u0bf9'
            | '\u0e3f'
            | '\u17db'
            | '\u20a0' to '\u20b9'
            | '\ua838'
            | '\ufdfc'
            | '\ufe69'
            | '\uff04'
            | '\uffe0' to '\uffe1'
            | '\uffe5' to '\uffe6'
              { true }
            _ { false }
        };
    }

    pure fn Sk(c: char) -> bool {
        ret alt c {
              '\x5e'
            | '\x60'
            | '\xa8'
            | '\xaf'
            | '\xb4'
            | '\xb8'
            | '\u02c2' to '\u02c5'
            | '\u02d2' to '\u02df'
            | '\u02e5' to '\u02eb'
            | '\u02ed'
            | '\u02ef' to '\u02ff'
            | '\u0375'
            | '\u0384' to '\u0385'
            | '\u1fbd'
            | '\u1fbf' to '\u1fc1'
            | '\u1fcd' to '\u1fcf'
            | '\u1fdd' to '\u1fdf'
            | '\u1fed' to '\u1fef'
            | '\u1ffd' to '\u1ffe'
            | '\u309b' to '\u309c'
            | '\ua700' to '\ua716'
            | '\ua720' to '\ua721'
            | '\ua789' to '\ua78a'
            | '\ufbb2' to '\ufbc1'
            | '\uff3e'
            | '\uff40'
            | '\uffe3'
              { true }
            _ { false }
        };
    }

    pure fn Sm(c: char) -> bool {
        ret alt c {
              '\x2b'
            | '\x3c' to '\x3e'
            | '\x7c'
            | '\x7e'
            | '\xac'
            | '\xb1'
            | '\xd7'
            | '\xf7'
            | '\u03f6'
            | '\u0606' to '\u0608'
            | '\u2044'
            | '\u2052'
            | '\u207a' to '\u207c'
            | '\u208a' to '\u208c'
            | '\u2118'
            | '\u2140' to '\u2144'
            | '\u214b'
            | '\u2190' to '\u2194'
            | '\u219a' to '\u219b'
            | '\u21a0'
            | '\u21a3'
            | '\u21a6'
            | '\u21ae'
            | '\u21ce' to '\u21cf'
            | '\u21d2'
            | '\u21d4'
            | '\u21f4' to '\u22ff'
            | '\u2308' to '\u230b'
            | '\u2320' to '\u2321'
            | '\u237c'
            | '\u239b' to '\u23b3'
            | '\u23dc' to '\u23e1'
            | '\u25b7'
            | '\u25c1'
            | '\u25f8' to '\u25ff'
            | '\u266f'
            | '\u27c0' to '\u27c4'
            | '\u27c7' to '\u27e5'
            | '\u27f0' to '\u27ff'
            | '\u2900' to '\u2982'
            | '\u2999' to '\u29d7'
            | '\u29dc' to '\u29fb'
            | '\u29fe' to '\u2aff'
            | '\u2b30' to '\u2b44'
            | '\u2b47' to '\u2b4c'
            | '\ufb29'
            | '\ufe62'
            | '\ufe64' to '\ufe66'
            | '\uff0b'
            | '\uff1c' to '\uff1e'
            | '\uff5c'
            | '\uff5e'
            | '\uffe2'
            | '\uffe9' to '\uffec'
            | '\U0001d6c1'
            | '\U0001d6db'
            | '\U0001d6fb'
            | '\U0001d715'
            | '\U0001d735'
            | '\U0001d74f'
            | '\U0001d76f'
            | '\U0001d789'
            | '\U0001d7a9'
            | '\U0001d7c3'
              { true }
            _ { false }
        };
    }

    pure fn So(c: char) -> bool {
        ret alt c {
              '\xa6' to '\xa7'
            | '\xa9'
            | '\xae'
            | '\xb0'
            | '\xb6'
            | '\u0482'
            | '\u060e' to '\u060f'
            | '\u06de'
            | '\u06e9'
            | '\u06fd' to '\u06fe'
            | '\u07f6'
            | '\u09fa'
            | '\u0b70'
            | '\u0bf3' to '\u0bf8'
            | '\u0bfa'
            | '\u0c7f'
            | '\u0d79'
            | '\u0f01' to '\u0f03'
            | '\u0f13' to '\u0f17'
            | '\u0f1a' to '\u0f1f'
            | '\u0f34'
            | '\u0f36'
            | '\u0f38'
            | '\u0fbe' to '\u0fc5'
            | '\u0fc7' to '\u0fcf'
            | '\u0fd5' to '\u0fd8'
            | '\u109e' to '\u109f'
            | '\u1360'
            | '\u1390' to '\u1399'
            | '\u1940'
            | '\u19de' to '\u19ff'
            | '\u1b61' to '\u1b6a'
            | '\u1b74' to '\u1b7c'
            | '\u2100' to '\u2101'
            | '\u2103' to '\u2106'
            | '\u2108' to '\u2109'
            | '\u2114'
            | '\u2116' to '\u2117'
            | '\u211e' to '\u2123'
            | '\u2125'
            | '\u2127'
            | '\u2129'
            | '\u212e'
            | '\u213a' to '\u213b'
            | '\u214a'
            | '\u214c' to '\u214d'
            | '\u214f'
            | '\u2195' to '\u2199'
            | '\u219c' to '\u219f'
            | '\u21a1' to '\u21a2'
            | '\u21a4' to '\u21a5'
            | '\u21a7' to '\u21ad'
            | '\u21af' to '\u21cd'
            | '\u21d0' to '\u21d1'
            | '\u21d3'
            | '\u21d5' to '\u21f3'
            | '\u2300' to '\u2307'
            | '\u230c' to '\u231f'
            | '\u2322' to '\u2328'
            | '\u232b' to '\u237b'
            | '\u237d' to '\u239a'
            | '\u23b4' to '\u23db'
            | '\u23e2' to '\u244a'
            | '\u249c' to '\u24e9'
            | '\u2500' to '\u25b6'
            | '\u25b8' to '\u25c0'
            | '\u25c2' to '\u25f7'
            | '\u2600' to '\u266e'
            | '\u2670' to '\u2767'
            | '\u2794' to '\u27bf'
            | '\u2800' to '\u28ff'
            | '\u2b00' to '\u2b2f'
            | '\u2b45' to '\u2b46'
            | '\u2b50' to '\u2b59'
            | '\u2ce5' to '\u2cea'
            | '\u2e80' to '\u2ffb'
            | '\u3004'
            | '\u3012' to '\u3013'
            | '\u3020'
            | '\u3036' to '\u3037'
            | '\u303e' to '\u303f'
            | '\u3190' to '\u3191'
            | '\u3196' to '\u319f'
            | '\u31c0' to '\u31e3'
            | '\u3200' to '\u321e'
            | '\u322a' to '\u3250'
            | '\u3260' to '\u327f'
            | '\u328a' to '\u32b0'
            | '\u32c0' to '\u33ff'
            | '\u4dc0' to '\u4dff'
            | '\ua490' to '\ua4c6'
            | '\ua828' to '\ua82b'
            | '\ua836' to '\ua837'
            | '\ua839'
            | '\uaa77' to '\uaa79'
            | '\ufdfd'
            | '\uffe4'
            | '\uffe8'
            | '\uffed' to '\uffee'
            | '\ufffc' to '\ufffd'
            | '\U00010102'
            | '\U00010137' to '\U0001013f'
            | '\U00010179' to '\U00010189'
            | '\U00010190' to '\U000101fc'
            | '\U0001d000' to '\U0001d164'
            | '\U0001d16a' to '\U0001d16c'
            | '\U0001d183' to '\U0001d184'
            | '\U0001d18c' to '\U0001d1a9'
            | '\U0001d1ae' to '\U0001d241'
            | '\U0001d245' to '\U0001d356'
            | '\U0001f000' to '\U0001f0df'
            | '\U0001f110' to '\U0001f773'
              { true }
            _ { false }
        };
    }

    pure fn Zl(c: char) -> bool {
        ret alt c {
              '\u2028'
              { true }
            _ { false }
        };
    }

    pure fn Zp(c: char) -> bool {
        ret alt c {
              '\u2029'
              { true }
            _ { false }
        };
    }

    pure fn Zs(c: char) -> bool {
        ret alt c {
              '\x20'
            | '\xa0'
            | '\u1680'
            | '\u180e'
            | '\u2000' to '\u200a'
            | '\u202f'
            | '\u205f'
            | '\u3000'
              { true }
            _ { false }
        };
    }

}
mod derived_property {
    pure fn Alphabetic(c: char) -> bool {
        ret alt c {
              '\x41' to '\x5a'
            | '\x61' to '\x7a'
            | '\xaa'
            | '\xb5'
            | '\xba'
            | '\xc0' to '\xd6'
            | '\xd8' to '\xf6'
            | '\xf8' to '\u01ba'
            | '\u01bb'
            | '\u01bc' to '\u01bf'
            | '\u01c0' to '\u01c3'
            | '\u01c4' to '\u0293'
            | '\u0294'
            | '\u0295' to '\u02af'
            | '\u02b0' to '\u02c1'
            | '\u02c6' to '\u02d1'
            | '\u02e0' to '\u02e4'
            | '\u02ec'
            | '\u02ee'
            | '\u0345'
            | '\u0370' to '\u0373'
            | '\u0374'
            | '\u0376' to '\u0377'
            | '\u037a'
            | '\u037b' to '\u037d'
            | '\u0386'
            | '\u0388' to '\u038a'
            | '\u038c'
            | '\u038e' to '\u03a1'
            | '\u03a3' to '\u03f5'
            | '\u03f7' to '\u0481'
            | '\u048a' to '\u0527'
            | '\u0531' to '\u0556'
            | '\u0559'
            | '\u0561' to '\u0587'
            | '\u05b0' to '\u05bd'
            | '\u05bf'
            | '\u05c1' to '\u05c2'
            | '\u05c4' to '\u05c5'
            | '\u05c7'
            | '\u05d0' to '\u05ea'
            | '\u05f0' to '\u05f2'
            | '\u0610' to '\u061a'
            | '\u0620' to '\u063f'
            | '\u0640'
            | '\u0641' to '\u064a'
            | '\u064b' to '\u0657'
            | '\u0659' to '\u065f'
            | '\u066e' to '\u066f'
            | '\u0670'
            | '\u0671' to '\u06d3'
            | '\u06d5'
            | '\u06d6' to '\u06dc'
            | '\u06e1' to '\u06e4'
            | '\u06e5' to '\u06e6'
            | '\u06e7' to '\u06e8'
            | '\u06ed'
            | '\u06ee' to '\u06ef'
            | '\u06fa' to '\u06fc'
            | '\u06ff'
            | '\u0710'
            | '\u0711'
            | '\u0712' to '\u072f'
            | '\u0730' to '\u073f'
            | '\u074d' to '\u07a5'
            | '\u07a6' to '\u07b0'
            | '\u07b1'
            | '\u07ca' to '\u07ea'
            | '\u07f4' to '\u07f5'
            | '\u07fa'
            | '\u0800' to '\u0815'
            | '\u0816' to '\u0817'
            | '\u081a'
            | '\u081b' to '\u0823'
            | '\u0824'
            | '\u0825' to '\u0827'
            | '\u0828'
            | '\u0829' to '\u082c'
            | '\u0840' to '\u0858'
            | '\u0900' to '\u0902'
            | '\u0903'
            | '\u0904' to '\u0939'
            | '\u093a'
            | '\u093b'
            | '\u093d'
            | '\u093e' to '\u0940'
            | '\u0941' to '\u0948'
            | '\u0949' to '\u094c'
            | '\u094e' to '\u094f'
            | '\u0950'
            | '\u0955' to '\u0957'
            | '\u0958' to '\u0961'
            | '\u0962' to '\u0963'
            | '\u0971'
            | '\u0972' to '\u0977'
            | '\u0979' to '\u097f'
            | '\u0981'
            | '\u0982' to '\u0983'
            | '\u0985' to '\u098c'
            | '\u098f' to '\u0990'
            | '\u0993' to '\u09a8'
            | '\u09aa' to '\u09b0'
            | '\u09b2'
            | '\u09b6' to '\u09b9'
            | '\u09bd'
            | '\u09be' to '\u09c0'
            | '\u09c1' to '\u09c4'
            | '\u09c7' to '\u09c8'
            | '\u09cb' to '\u09cc'
            | '\u09ce'
            | '\u09d7'
            | '\u09dc' to '\u09dd'
            | '\u09df' to '\u09e1'
            | '\u09e2' to '\u09e3'
            | '\u09f0' to '\u09f1'
            | '\u0a01' to '\u0a02'
            | '\u0a03'
            | '\u0a05' to '\u0a0a'
            | '\u0a0f' to '\u0a10'
            | '\u0a13' to '\u0a28'
            | '\u0a2a' to '\u0a30'
            | '\u0a32' to '\u0a33'
            | '\u0a35' to '\u0a36'
            | '\u0a38' to '\u0a39'
            | '\u0a3e' to '\u0a40'
            | '\u0a41' to '\u0a42'
            | '\u0a47' to '\u0a48'
            | '\u0a4b' to '\u0a4c'
            | '\u0a51'
            | '\u0a59' to '\u0a5c'
            | '\u0a5e'
            | '\u0a70' to '\u0a71'
            | '\u0a72' to '\u0a74'
            | '\u0a75'
            | '\u0a81' to '\u0a82'
            | '\u0a83'
            | '\u0a85' to '\u0a8d'
            | '\u0a8f' to '\u0a91'
            | '\u0a93' to '\u0aa8'
            | '\u0aaa' to '\u0ab0'
            | '\u0ab2' to '\u0ab3'
            | '\u0ab5' to '\u0ab9'
            | '\u0abd'
            | '\u0abe' to '\u0ac0'
            | '\u0ac1' to '\u0ac5'
            | '\u0ac7' to '\u0ac8'
            | '\u0ac9'
            | '\u0acb' to '\u0acc'
            | '\u0ad0'
            | '\u0ae0' to '\u0ae1'
            | '\u0ae2' to '\u0ae3'
            | '\u0b01'
            | '\u0b02' to '\u0b03'
            | '\u0b05' to '\u0b0c'
            | '\u0b0f' to '\u0b10'
            | '\u0b13' to '\u0b28'
            | '\u0b2a' to '\u0b30'
            | '\u0b32' to '\u0b33'
            | '\u0b35' to '\u0b39'
            | '\u0b3d'
            | '\u0b3e'
            | '\u0b3f'
            | '\u0b40'
            | '\u0b41' to '\u0b44'
            | '\u0b47' to '\u0b48'
            | '\u0b4b' to '\u0b4c'
            | '\u0b56'
            | '\u0b57'
            | '\u0b5c' to '\u0b5d'
            | '\u0b5f' to '\u0b61'
            | '\u0b62' to '\u0b63'
            | '\u0b71'
            | '\u0b82'
            | '\u0b83'
            | '\u0b85' to '\u0b8a'
            | '\u0b8e' to '\u0b90'
            | '\u0b92' to '\u0b95'
            | '\u0b99' to '\u0b9a'
            | '\u0b9c'
            | '\u0b9e' to '\u0b9f'
            | '\u0ba3' to '\u0ba4'
            | '\u0ba8' to '\u0baa'
            | '\u0bae' to '\u0bb9'
            | '\u0bbe' to '\u0bbf'
            | '\u0bc0'
            | '\u0bc1' to '\u0bc2'
            | '\u0bc6' to '\u0bc8'
            | '\u0bca' to '\u0bcc'
            | '\u0bd0'
            | '\u0bd7'
            | '\u0c01' to '\u0c03'
            | '\u0c05' to '\u0c0c'
            | '\u0c0e' to '\u0c10'
            | '\u0c12' to '\u0c28'
            | '\u0c2a' to '\u0c33'
            | '\u0c35' to '\u0c39'
            | '\u0c3d'
            | '\u0c3e' to '\u0c40'
            | '\u0c41' to '\u0c44'
            | '\u0c46' to '\u0c48'
            | '\u0c4a' to '\u0c4c'
            | '\u0c55' to '\u0c56'
            | '\u0c58' to '\u0c59'
            | '\u0c60' to '\u0c61'
            | '\u0c62' to '\u0c63'
            | '\u0c82' to '\u0c83'
            | '\u0c85' to '\u0c8c'
            | '\u0c8e' to '\u0c90'
            | '\u0c92' to '\u0ca8'
            | '\u0caa' to '\u0cb3'
            | '\u0cb5' to '\u0cb9'
            | '\u0cbd'
            | '\u0cbe'
            | '\u0cbf'
            | '\u0cc0' to '\u0cc4'
            | '\u0cc6'
            | '\u0cc7' to '\u0cc8'
            | '\u0cca' to '\u0ccb'
            | '\u0ccc'
            | '\u0cd5' to '\u0cd6'
            | '\u0cde'
            | '\u0ce0' to '\u0ce1'
            | '\u0ce2' to '\u0ce3'
            | '\u0cf1' to '\u0cf2'
            | '\u0d02' to '\u0d03'
            | '\u0d05' to '\u0d0c'
            | '\u0d0e' to '\u0d10'
            | '\u0d12' to '\u0d3a'
            | '\u0d3d'
            | '\u0d3e' to '\u0d40'
            | '\u0d41' to '\u0d44'
            | '\u0d46' to '\u0d48'
            | '\u0d4a' to '\u0d4c'
            | '\u0d4e'
            | '\u0d57'
            | '\u0d60' to '\u0d61'
            | '\u0d62' to '\u0d63'
            | '\u0d7a' to '\u0d7f'
            | '\u0d82' to '\u0d83'
            | '\u0d85' to '\u0d96'
            | '\u0d9a' to '\u0db1'
            | '\u0db3' to '\u0dbb'
            | '\u0dbd'
            | '\u0dc0' to '\u0dc6'
            | '\u0dcf' to '\u0dd1'
            | '\u0dd2' to '\u0dd4'
            | '\u0dd6'
            | '\u0dd8' to '\u0ddf'
            | '\u0df2' to '\u0df3'
            | '\u0e01' to '\u0e30'
            | '\u0e31'
            | '\u0e32' to '\u0e33'
            | '\u0e34' to '\u0e3a'
            | '\u0e40' to '\u0e45'
            | '\u0e46'
            | '\u0e4d'
            | '\u0e81' to '\u0e82'
            | '\u0e84'
            | '\u0e87' to '\u0e88'
            | '\u0e8a'
            | '\u0e8d'
            | '\u0e94' to '\u0e97'
            | '\u0e99' to '\u0e9f'
            | '\u0ea1' to '\u0ea3'
            | '\u0ea5'
            | '\u0ea7'
            | '\u0eaa' to '\u0eab'
            | '\u0ead' to '\u0eb0'
            | '\u0eb1'
            | '\u0eb2' to '\u0eb3'
            | '\u0eb4' to '\u0eb9'
            | '\u0ebb' to '\u0ebc'
            | '\u0ebd'
            | '\u0ec0' to '\u0ec4'
            | '\u0ec6'
            | '\u0ecd'
            | '\u0edc' to '\u0edd'
            | '\u0f00'
            | '\u0f40' to '\u0f47'
            | '\u0f49' to '\u0f6c'
            | '\u0f71' to '\u0f7e'
            | '\u0f7f'
            | '\u0f80' to '\u0f81'
            | '\u0f88' to '\u0f8c'
            | '\u0f8d' to '\u0f97'
            | '\u0f99' to '\u0fbc'
            | '\u1000' to '\u102a'
            | '\u102b' to '\u102c'
            | '\u102d' to '\u1030'
            | '\u1031'
            | '\u1032' to '\u1036'
            | '\u1038'
            | '\u103b' to '\u103c'
            | '\u103d' to '\u103e'
            | '\u103f'
            | '\u1050' to '\u1055'
            | '\u1056' to '\u1057'
            | '\u1058' to '\u1059'
            | '\u105a' to '\u105d'
            | '\u105e' to '\u1060'
            | '\u1061'
            | '\u1062'
            | '\u1065' to '\u1066'
            | '\u1067' to '\u1068'
            | '\u106e' to '\u1070'
            | '\u1071' to '\u1074'
            | '\u1075' to '\u1081'
            | '\u1082'
            | '\u1083' to '\u1084'
            | '\u1085' to '\u1086'
            | '\u108e'
            | '\u109c'
            | '\u109d'
            | '\u10a0' to '\u10c5'
            | '\u10d0' to '\u10fa'
            | '\u10fc'
            | '\u1100' to '\u1248'
            | '\u124a' to '\u124d'
            | '\u1250' to '\u1256'
            | '\u1258'
            | '\u125a' to '\u125d'
            | '\u1260' to '\u1288'
            | '\u128a' to '\u128d'
            | '\u1290' to '\u12b0'
            | '\u12b2' to '\u12b5'
            | '\u12b8' to '\u12be'
            | '\u12c0'
            | '\u12c2' to '\u12c5'
            | '\u12c8' to '\u12d6'
            | '\u12d8' to '\u1310'
            | '\u1312' to '\u1315'
            | '\u1318' to '\u135a'
            | '\u135f'
            | '\u1380' to '\u138f'
            | '\u13a0' to '\u13f4'
            | '\u1401' to '\u166c'
            | '\u166f' to '\u167f'
            | '\u1681' to '\u169a'
            | '\u16a0' to '\u16ea'
            | '\u16ee' to '\u16f0'
            | '\u1700' to '\u170c'
            | '\u170e' to '\u1711'
            | '\u1712' to '\u1713'
            | '\u1720' to '\u1731'
            | '\u1732' to '\u1733'
            | '\u1740' to '\u1751'
            | '\u1752' to '\u1753'
            | '\u1760' to '\u176c'
            | '\u176e' to '\u1770'
            | '\u1772' to '\u1773'
            | '\u1780' to '\u17b3'
            | '\u17b6'
            | '\u17b7' to '\u17bd'
            | '\u17be' to '\u17c5'
            | '\u17c6'
            | '\u17c7' to '\u17c8'
            | '\u17d7'
            | '\u17dc'
            | '\u1820' to '\u1842'
            | '\u1843'
            | '\u1844' to '\u1877'
            | '\u1880' to '\u18a8'
            | '\u18a9'
            | '\u18aa'
            | '\u18b0' to '\u18f5'
            | '\u1900' to '\u191c'
            | '\u1920' to '\u1922'
            | '\u1923' to '\u1926'
            | '\u1927' to '\u1928'
            | '\u1929' to '\u192b'
            | '\u1930' to '\u1931'
            | '\u1932'
            | '\u1933' to '\u1938'
            | '\u1950' to '\u196d'
            | '\u1970' to '\u1974'
            | '\u1980' to '\u19ab'
            | '\u19b0' to '\u19c0'
            | '\u19c1' to '\u19c7'
            | '\u19c8' to '\u19c9'
            | '\u1a00' to '\u1a16'
            | '\u1a17' to '\u1a18'
            | '\u1a19' to '\u1a1b'
            | '\u1a20' to '\u1a54'
            | '\u1a55'
            | '\u1a56'
            | '\u1a57'
            | '\u1a58' to '\u1a5e'
            | '\u1a61'
            | '\u1a62'
            | '\u1a63' to '\u1a64'
            | '\u1a65' to '\u1a6c'
            | '\u1a6d' to '\u1a72'
            | '\u1a73' to '\u1a74'
            | '\u1aa7'
            | '\u1b00' to '\u1b03'
            | '\u1b04'
            | '\u1b05' to '\u1b33'
            | '\u1b35'
            | '\u1b36' to '\u1b3a'
            | '\u1b3b'
            | '\u1b3c'
            | '\u1b3d' to '\u1b41'
            | '\u1b42'
            | '\u1b43'
            | '\u1b45' to '\u1b4b'
            | '\u1b80' to '\u1b81'
            | '\u1b82'
            | '\u1b83' to '\u1ba0'
            | '\u1ba1'
            | '\u1ba2' to '\u1ba5'
            | '\u1ba6' to '\u1ba7'
            | '\u1ba8' to '\u1ba9'
            | '\u1bae' to '\u1baf'
            | '\u1bc0' to '\u1be5'
            | '\u1be7'
            | '\u1be8' to '\u1be9'
            | '\u1bea' to '\u1bec'
            | '\u1bed'
            | '\u1bee'
            | '\u1bef' to '\u1bf1'
            | '\u1c00' to '\u1c23'
            | '\u1c24' to '\u1c2b'
            | '\u1c2c' to '\u1c33'
            | '\u1c34' to '\u1c35'
            | '\u1c4d' to '\u1c4f'
            | '\u1c5a' to '\u1c77'
            | '\u1c78' to '\u1c7d'
            | '\u1ce9' to '\u1cec'
            | '\u1cee' to '\u1cf1'
            | '\u1cf2'
            | '\u1d00' to '\u1d2b'
            | '\u1d2c' to '\u1d61'
            | '\u1d62' to '\u1d77'
            | '\u1d78'
            | '\u1d79' to '\u1d9a'
            | '\u1d9b' to '\u1dbf'
            | '\u1e00' to '\u1f15'
            | '\u1f18' to '\u1f1d'
            | '\u1f20' to '\u1f45'
            | '\u1f48' to '\u1f4d'
            | '\u1f50' to '\u1f57'
            | '\u1f59'
            | '\u1f5b'
            | '\u1f5d'
            | '\u1f5f' to '\u1f7d'
            | '\u1f80' to '\u1fb4'
            | '\u1fb6' to '\u1fbc'
            | '\u1fbe'
            | '\u1fc2' to '\u1fc4'
            | '\u1fc6' to '\u1fcc'
            | '\u1fd0' to '\u1fd3'
            | '\u1fd6' to '\u1fdb'
            | '\u1fe0' to '\u1fec'
            | '\u1ff2' to '\u1ff4'
            | '\u1ff6' to '\u1ffc'
            | '\u2071'
            | '\u207f'
            | '\u2090' to '\u209c'
            | '\u2102'
            | '\u2107'
            | '\u210a' to '\u2113'
            | '\u2115'
            | '\u2119' to '\u211d'
            | '\u2124'
            | '\u2126'
            | '\u2128'
            | '\u212a' to '\u212d'
            | '\u212f' to '\u2134'
            | '\u2135' to '\u2138'
            | '\u2139'
            | '\u213c' to '\u213f'
            | '\u2145' to '\u2149'
            | '\u214e'
            | '\u2160' to '\u2182'
            | '\u2183' to '\u2184'
            | '\u2185' to '\u2188'
            | '\u24b6' to '\u24e9'
            | '\u2c00' to '\u2c2e'
            | '\u2c30' to '\u2c5e'
            | '\u2c60' to '\u2c7c'
            | '\u2c7d'
            | '\u2c7e' to '\u2ce4'
            | '\u2ceb' to '\u2cee'
            | '\u2d00' to '\u2d25'
            | '\u2d30' to '\u2d65'
            | '\u2d6f'
            | '\u2d80' to '\u2d96'
            | '\u2da0' to '\u2da6'
            | '\u2da8' to '\u2dae'
            | '\u2db0' to '\u2db6'
            | '\u2db8' to '\u2dbe'
            | '\u2dc0' to '\u2dc6'
            | '\u2dc8' to '\u2dce'
            | '\u2dd0' to '\u2dd6'
            | '\u2dd8' to '\u2dde'
            | '\u2de0' to '\u2dff'
            | '\u2e2f'
            | '\u3005'
            | '\u3006'
            | '\u3007'
            | '\u3021' to '\u3029'
            | '\u3031' to '\u3035'
            | '\u3038' to '\u303a'
            | '\u303b'
            | '\u303c'
            | '\u3041' to '\u3096'
            | '\u309d' to '\u309e'
            | '\u309f'
            | '\u30a1' to '\u30fa'
            | '\u30fc' to '\u30fe'
            | '\u30ff'
            | '\u3105' to '\u312d'
            | '\u3131' to '\u318e'
            | '\u31a0' to '\u31ba'
            | '\u31f0' to '\u31ff'
            | '\u3400' to '\u4db5'
            | '\u4e00' to '\u9fcb'
            | '\ua000' to '\ua014'
            | '\ua015'
            | '\ua016' to '\ua48c'
            | '\ua4d0' to '\ua4f7'
            | '\ua4f8' to '\ua4fd'
            | '\ua500' to '\ua60b'
            | '\ua60c'
            | '\ua610' to '\ua61f'
            | '\ua62a' to '\ua62b'
            | '\ua640' to '\ua66d'
            | '\ua66e'
            | '\ua67f'
            | '\ua680' to '\ua697'
            | '\ua6a0' to '\ua6e5'
            | '\ua6e6' to '\ua6ef'
            | '\ua717' to '\ua71f'
            | '\ua722' to '\ua76f'
            | '\ua770'
            | '\ua771' to '\ua787'
            | '\ua788'
            | '\ua78b' to '\ua78e'
            | '\ua790' to '\ua791'
            | '\ua7a0' to '\ua7a9'
            | '\ua7fa'
            | '\ua7fb' to '\ua801'
            | '\ua803' to '\ua805'
            | '\ua807' to '\ua80a'
            | '\ua80c' to '\ua822'
            | '\ua823' to '\ua824'
            | '\ua825' to '\ua826'
            | '\ua827'
            | '\ua840' to '\ua873'
            | '\ua880' to '\ua881'
            | '\ua882' to '\ua8b3'
            | '\ua8b4' to '\ua8c3'
            | '\ua8f2' to '\ua8f7'
            | '\ua8fb'
            | '\ua90a' to '\ua925'
            | '\ua926' to '\ua92a'
            | '\ua930' to '\ua946'
            | '\ua947' to '\ua951'
            | '\ua952'
            | '\ua960' to '\ua97c'
            | '\ua980' to '\ua982'
            | '\ua983'
            | '\ua984' to '\ua9b2'
            | '\ua9b4' to '\ua9b5'
            | '\ua9b6' to '\ua9b9'
            | '\ua9ba' to '\ua9bb'
            | '\ua9bc'
            | '\ua9bd' to '\ua9bf'
            | '\ua9cf'
            | '\uaa00' to '\uaa28'
            | '\uaa29' to '\uaa2e'
            | '\uaa2f' to '\uaa30'
            | '\uaa31' to '\uaa32'
            | '\uaa33' to '\uaa34'
            | '\uaa35' to '\uaa36'
            | '\uaa40' to '\uaa42'
            | '\uaa43'
            | '\uaa44' to '\uaa4b'
            | '\uaa4c'
            | '\uaa4d'
            | '\uaa60' to '\uaa6f'
            | '\uaa70'
            | '\uaa71' to '\uaa76'
            | '\uaa7a'
            | '\uaa80' to '\uaaaf'
            | '\uaab0'
            | '\uaab1'
            | '\uaab2' to '\uaab4'
            | '\uaab5' to '\uaab6'
            | '\uaab7' to '\uaab8'
            | '\uaab9' to '\uaabd'
            | '\uaabe'
            | '\uaac0'
            | '\uaac2'
            | '\uaadb' to '\uaadc'
            | '\uaadd'
            | '\uab01' to '\uab06'
            | '\uab09' to '\uab0e'
            | '\uab11' to '\uab16'
            | '\uab20' to '\uab26'
            | '\uab28' to '\uab2e'
            | '\uabc0' to '\uabe2'
            | '\uabe3' to '\uabe4'
            | '\uabe5'
            | '\uabe6' to '\uabe7'
            | '\uabe8'
            | '\uabe9' to '\uabea'
            | '\uac00' to '\ud7a3'
            | '\ud7b0' to '\ud7c6'
            | '\ud7cb' to '\ud7fb'
            | '\uf900' to '\ufa2d'
            | '\ufa30' to '\ufa6d'
            | '\ufa70' to '\ufad9'
            | '\ufb00' to '\ufb06'
            | '\ufb13' to '\ufb17'
            | '\ufb1d'
            | '\ufb1e'
            | '\ufb1f' to '\ufb28'
            | '\ufb2a' to '\ufb36'
            | '\ufb38' to '\ufb3c'
            | '\ufb3e'
            | '\ufb40' to '\ufb41'
            | '\ufb43' to '\ufb44'
            | '\ufb46' to '\ufbb1'
            | '\ufbd3' to '\ufd3d'
            | '\ufd50' to '\ufd8f'
            | '\ufd92' to '\ufdc7'
            | '\ufdf0' to '\ufdfb'
            | '\ufe70' to '\ufe74'
            | '\ufe76' to '\ufefc'
            | '\uff21' to '\uff3a'
            | '\uff41' to '\uff5a'
            | '\uff66' to '\uff6f'
            | '\uff70'
            | '\uff71' to '\uff9d'
            | '\uff9e' to '\uff9f'
            | '\uffa0' to '\uffbe'
            | '\uffc2' to '\uffc7'
            | '\uffca' to '\uffcf'
            | '\uffd2' to '\uffd7'
            | '\uffda' to '\uffdc'
            | '\U00010000' to '\U0001000b'
            | '\U0001000d' to '\U00010026'
            | '\U00010028' to '\U0001003a'
            | '\U0001003c' to '\U0001003d'
            | '\U0001003f' to '\U0001004d'
            | '\U00010050' to '\U0001005d'
            | '\U00010080' to '\U000100fa'
            | '\U00010140' to '\U00010174'
            | '\U00010280' to '\U0001029c'
            | '\U000102a0' to '\U000102d0'
            | '\U00010300' to '\U0001031e'
            | '\U00010330' to '\U00010340'
            | '\U00010341'
            | '\U00010342' to '\U00010349'
            | '\U0001034a'
            | '\U00010380' to '\U0001039d'
            | '\U000103a0' to '\U000103c3'
            | '\U000103c8' to '\U000103cf'
            | '\U000103d1' to '\U000103d5'
            | '\U00010400' to '\U0001044f'
            | '\U00010450' to '\U0001049d'
            | '\U00010800' to '\U00010805'
            | '\U00010808'
            | '\U0001080a' to '\U00010835'
            | '\U00010837' to '\U00010838'
            | '\U0001083c'
            | '\U0001083f' to '\U00010855'
            | '\U00010900' to '\U00010915'
            | '\U00010920' to '\U00010939'
            | '\U00010a00'
            | '\U00010a01' to '\U00010a03'
            | '\U00010a05' to '\U00010a06'
            | '\U00010a0c' to '\U00010a0f'
            | '\U00010a10' to '\U00010a13'
            | '\U00010a15' to '\U00010a17'
            | '\U00010a19' to '\U00010a33'
            | '\U00010a60' to '\U00010a7c'
            | '\U00010b00' to '\U00010b35'
            | '\U00010b40' to '\U00010b55'
            | '\U00010b60' to '\U00010b72'
            | '\U00010c00' to '\U00010c48'
            | '\U00011000'
            | '\U00011001'
            | '\U00011002'
            | '\U00011003' to '\U00011037'
            | '\U00011038' to '\U00011045'
            | '\U00011082'
            | '\U00011083' to '\U000110af'
            | '\U000110b0' to '\U000110b2'
            | '\U000110b3' to '\U000110b6'
            | '\U000110b7' to '\U000110b8'
            | '\U00012000' to '\U0001236e'
            | '\U00012400' to '\U00012462'
            | '\U00013000' to '\U0001342e'
            | '\U00016800' to '\U00016a38'
            | '\U0001b000' to '\U0001b001'
            | '\U0001d400' to '\U0001d454'
            | '\U0001d456' to '\U0001d49c'
            | '\U0001d49e' to '\U0001d49f'
            | '\U0001d4a2'
            | '\U0001d4a5' to '\U0001d4a6'
            | '\U0001d4a9' to '\U0001d4ac'
            | '\U0001d4ae' to '\U0001d4b9'
            | '\U0001d4bb'
            | '\U0001d4bd' to '\U0001d4c3'
            | '\U0001d4c5' to '\U0001d505'
            | '\U0001d507' to '\U0001d50a'
            | '\U0001d50d' to '\U0001d514'
            | '\U0001d516' to '\U0001d51c'
            | '\U0001d51e' to '\U0001d539'
            | '\U0001d53b' to '\U0001d53e'
            | '\U0001d540' to '\U0001d544'
            | '\U0001d546'
            | '\U0001d54a' to '\U0001d550'
            | '\U0001d552' to '\U0001d6a5'
            | '\U0001d6a8' to '\U0001d6c0'
            | '\U0001d6c2' to '\U0001d6da'
            | '\U0001d6dc' to '\U0001d6fa'
            | '\U0001d6fc' to '\U0001d714'
            | '\U0001d716' to '\U0001d734'
            | '\U0001d736' to '\U0001d74e'
            | '\U0001d750' to '\U0001d76e'
            | '\U0001d770' to '\U0001d788'
            | '\U0001d78a' to '\U0001d7a8'
            | '\U0001d7aa' to '\U0001d7c2'
            | '\U0001d7c4' to '\U0001d7cb'
            | '\U00020000' to '\U0002a6d6'
            | '\U0002a700' to '\U0002b734'
            | '\U0002b740' to '\U0002b81d'
            | '\U0002f800' to '\U0002fa1d'
              { true }
            _ { false }
        };
    }

    pure fn XID_Continue(c: char) -> bool {
        ret alt c {
              '\x30' to '\x39'
            | '\x41' to '\x5a'
            | '\x5f'
            | '\x61' to '\x7a'
            | '\xaa'
            | '\xb5'
            | '\xb7'
            | '\xba'
            | '\xc0' to '\xd6'
            | '\xd8' to '\xf6'
            | '\xf8' to '\u01ba'
            | '\u01bb'
            | '\u01bc' to '\u01bf'
            | '\u01c0' to '\u01c3'
            | '\u01c4' to '\u0293'
            | '\u0294'
            | '\u0295' to '\u02af'
            | '\u02b0' to '\u02c1'
            | '\u02c6' to '\u02d1'
            | '\u02e0' to '\u02e4'
            | '\u02ec'
            | '\u02ee'
            | '\u0300' to '\u036f'
            | '\u0370' to '\u0373'
            | '\u0374'
            | '\u0376' to '\u0377'
            | '\u037b' to '\u037d'
            | '\u0386'
            | '\u0387'
            | '\u0388' to '\u038a'
            | '\u038c'
            | '\u038e' to '\u03a1'
            | '\u03a3' to '\u03f5'
            | '\u03f7' to '\u0481'
            | '\u0483' to '\u0487'
            | '\u048a' to '\u0527'
            | '\u0531' to '\u0556'
            | '\u0559'
            | '\u0561' to '\u0587'
            | '\u0591' to '\u05bd'
            | '\u05bf'
            | '\u05c1' to '\u05c2'
            | '\u05c4' to '\u05c5'
            | '\u05c7'
            | '\u05d0' to '\u05ea'
            | '\u05f0' to '\u05f2'
            | '\u0610' to '\u061a'
            | '\u0620' to '\u063f'
            | '\u0640'
            | '\u0641' to '\u064a'
            | '\u064b' to '\u065f'
            | '\u0660' to '\u0669'
            | '\u066e' to '\u066f'
            | '\u0670'
            | '\u0671' to '\u06d3'
            | '\u06d5'
            | '\u06d6' to '\u06dc'
            | '\u06df' to '\u06e4'
            | '\u06e5' to '\u06e6'
            | '\u06e7' to '\u06e8'
            | '\u06ea' to '\u06ed'
            | '\u06ee' to '\u06ef'
            | '\u06f0' to '\u06f9'
            | '\u06fa' to '\u06fc'
            | '\u06ff'
            | '\u0710'
            | '\u0711'
            | '\u0712' to '\u072f'
            | '\u0730' to '\u074a'
            | '\u074d' to '\u07a5'
            | '\u07a6' to '\u07b0'
            | '\u07b1'
            | '\u07c0' to '\u07c9'
            | '\u07ca' to '\u07ea'
            | '\u07eb' to '\u07f3'
            | '\u07f4' to '\u07f5'
            | '\u07fa'
            | '\u0800' to '\u0815'
            | '\u0816' to '\u0819'
            | '\u081a'
            | '\u081b' to '\u0823'
            | '\u0824'
            | '\u0825' to '\u0827'
            | '\u0828'
            | '\u0829' to '\u082d'
            | '\u0840' to '\u0858'
            | '\u0859' to '\u085b'
            | '\u0900' to '\u0902'
            | '\u0903'
            | '\u0904' to '\u0939'
            | '\u093a'
            | '\u093b'
            | '\u093c'
            | '\u093d'
            | '\u093e' to '\u0940'
            | '\u0941' to '\u0948'
            | '\u0949' to '\u094c'
            | '\u094d'
            | '\u094e' to '\u094f'
            | '\u0950'
            | '\u0951' to '\u0957'
            | '\u0958' to '\u0961'
            | '\u0962' to '\u0963'
            | '\u0966' to '\u096f'
            | '\u0971'
            | '\u0972' to '\u0977'
            | '\u0979' to '\u097f'
            | '\u0981'
            | '\u0982' to '\u0983'
            | '\u0985' to '\u098c'
            | '\u098f' to '\u0990'
            | '\u0993' to '\u09a8'
            | '\u09aa' to '\u09b0'
            | '\u09b2'
            | '\u09b6' to '\u09b9'
            | '\u09bc'
            | '\u09bd'
            | '\u09be' to '\u09c0'
            | '\u09c1' to '\u09c4'
            | '\u09c7' to '\u09c8'
            | '\u09cb' to '\u09cc'
            | '\u09cd'
            | '\u09ce'
            | '\u09d7'
            | '\u09dc' to '\u09dd'
            | '\u09df' to '\u09e1'
            | '\u09e2' to '\u09e3'
            | '\u09e6' to '\u09ef'
            | '\u09f0' to '\u09f1'
            | '\u0a01' to '\u0a02'
            | '\u0a03'
            | '\u0a05' to '\u0a0a'
            | '\u0a0f' to '\u0a10'
            | '\u0a13' to '\u0a28'
            | '\u0a2a' to '\u0a30'
            | '\u0a32' to '\u0a33'
            | '\u0a35' to '\u0a36'
            | '\u0a38' to '\u0a39'
            | '\u0a3c'
            | '\u0a3e' to '\u0a40'
            | '\u0a41' to '\u0a42'
            | '\u0a47' to '\u0a48'
            | '\u0a4b' to '\u0a4d'
            | '\u0a51'
            | '\u0a59' to '\u0a5c'
            | '\u0a5e'
            | '\u0a66' to '\u0a6f'
            | '\u0a70' to '\u0a71'
            | '\u0a72' to '\u0a74'
            | '\u0a75'
            | '\u0a81' to '\u0a82'
            | '\u0a83'
            | '\u0a85' to '\u0a8d'
            | '\u0a8f' to '\u0a91'
            | '\u0a93' to '\u0aa8'
            | '\u0aaa' to '\u0ab0'
            | '\u0ab2' to '\u0ab3'
            | '\u0ab5' to '\u0ab9'
            | '\u0abc'
            | '\u0abd'
            | '\u0abe' to '\u0ac0'
            | '\u0ac1' to '\u0ac5'
            | '\u0ac7' to '\u0ac8'
            | '\u0ac9'
            | '\u0acb' to '\u0acc'
            | '\u0acd'
            | '\u0ad0'
            | '\u0ae0' to '\u0ae1'
            | '\u0ae2' to '\u0ae3'
            | '\u0ae6' to '\u0aef'
            | '\u0b01'
            | '\u0b02' to '\u0b03'
            | '\u0b05' to '\u0b0c'
            | '\u0b0f' to '\u0b10'
            | '\u0b13' to '\u0b28'
            | '\u0b2a' to '\u0b30'
            | '\u0b32' to '\u0b33'
            | '\u0b35' to '\u0b39'
            | '\u0b3c'
            | '\u0b3d'
            | '\u0b3e'
            | '\u0b3f'
            | '\u0b40'
            | '\u0b41' to '\u0b44'
            | '\u0b47' to '\u0b48'
            | '\u0b4b' to '\u0b4c'
            | '\u0b4d'
            | '\u0b56'
            | '\u0b57'
            | '\u0b5c' to '\u0b5d'
            | '\u0b5f' to '\u0b61'
            | '\u0b62' to '\u0b63'
            | '\u0b66' to '\u0b6f'
            | '\u0b71'
            | '\u0b82'
            | '\u0b83'
            | '\u0b85' to '\u0b8a'
            | '\u0b8e' to '\u0b90'
            | '\u0b92' to '\u0b95'
            | '\u0b99' to '\u0b9a'
            | '\u0b9c'
            | '\u0b9e' to '\u0b9f'
            | '\u0ba3' to '\u0ba4'
            | '\u0ba8' to '\u0baa'
            | '\u0bae' to '\u0bb9'
            | '\u0bbe' to '\u0bbf'
            | '\u0bc0'
            | '\u0bc1' to '\u0bc2'
            | '\u0bc6' to '\u0bc8'
            | '\u0bca' to '\u0bcc'
            | '\u0bcd'
            | '\u0bd0'
            | '\u0bd7'
            | '\u0be6' to '\u0bef'
            | '\u0c01' to '\u0c03'
            | '\u0c05' to '\u0c0c'
            | '\u0c0e' to '\u0c10'
            | '\u0c12' to '\u0c28'
            | '\u0c2a' to '\u0c33'
            | '\u0c35' to '\u0c39'
            | '\u0c3d'
            | '\u0c3e' to '\u0c40'
            | '\u0c41' to '\u0c44'
            | '\u0c46' to '\u0c48'
            | '\u0c4a' to '\u0c4d'
            | '\u0c55' to '\u0c56'
            | '\u0c58' to '\u0c59'
            | '\u0c60' to '\u0c61'
            | '\u0c62' to '\u0c63'
            | '\u0c66' to '\u0c6f'
            | '\u0c82' to '\u0c83'
            | '\u0c85' to '\u0c8c'
            | '\u0c8e' to '\u0c90'
            | '\u0c92' to '\u0ca8'
            | '\u0caa' to '\u0cb3'
            | '\u0cb5' to '\u0cb9'
            | '\u0cbc'
            | '\u0cbd'
            | '\u0cbe'
            | '\u0cbf'
            | '\u0cc0' to '\u0cc4'
            | '\u0cc6'
            | '\u0cc7' to '\u0cc8'
            | '\u0cca' to '\u0ccb'
            | '\u0ccc' to '\u0ccd'
            | '\u0cd5' to '\u0cd6'
            | '\u0cde'
            | '\u0ce0' to '\u0ce1'
            | '\u0ce2' to '\u0ce3'
            | '\u0ce6' to '\u0cef'
            | '\u0cf1' to '\u0cf2'
            | '\u0d02' to '\u0d03'
            | '\u0d05' to '\u0d0c'
            | '\u0d0e' to '\u0d10'
            | '\u0d12' to '\u0d3a'
            | '\u0d3d'
            | '\u0d3e' to '\u0d40'
            | '\u0d41' to '\u0d44'
            | '\u0d46' to '\u0d48'
            | '\u0d4a' to '\u0d4c'
            | '\u0d4d'
            | '\u0d4e'
            | '\u0d57'
            | '\u0d60' to '\u0d61'
            | '\u0d62' to '\u0d63'
            | '\u0d66' to '\u0d6f'
            | '\u0d7a' to '\u0d7f'
            | '\u0d82' to '\u0d83'
            | '\u0d85' to '\u0d96'
            | '\u0d9a' to '\u0db1'
            | '\u0db3' to '\u0dbb'
            | '\u0dbd'
            | '\u0dc0' to '\u0dc6'
            | '\u0dca'
            | '\u0dcf' to '\u0dd1'
            | '\u0dd2' to '\u0dd4'
            | '\u0dd6'
            | '\u0dd8' to '\u0ddf'
            | '\u0df2' to '\u0df3'
            | '\u0e01' to '\u0e30'
            | '\u0e31'
            | '\u0e32' to '\u0e33'
            | '\u0e34' to '\u0e3a'
            | '\u0e40' to '\u0e45'
            | '\u0e46'
            | '\u0e47' to '\u0e4e'
            | '\u0e50' to '\u0e59'
            | '\u0e81' to '\u0e82'
            | '\u0e84'
            | '\u0e87' to '\u0e88'
            | '\u0e8a'
            | '\u0e8d'
            | '\u0e94' to '\u0e97'
            | '\u0e99' to '\u0e9f'
            | '\u0ea1' to '\u0ea3'
            | '\u0ea5'
            | '\u0ea7'
            | '\u0eaa' to '\u0eab'
            | '\u0ead' to '\u0eb0'
            | '\u0eb1'
            | '\u0eb2' to '\u0eb3'
            | '\u0eb4' to '\u0eb9'
            | '\u0ebb' to '\u0ebc'
            | '\u0ebd'
            | '\u0ec0' to '\u0ec4'
            | '\u0ec6'
            | '\u0ec8' to '\u0ecd'
            | '\u0ed0' to '\u0ed9'
            | '\u0edc' to '\u0edd'
            | '\u0f00'
            | '\u0f18' to '\u0f19'
            | '\u0f20' to '\u0f29'
            | '\u0f35'
            | '\u0f37'
            | '\u0f39'
            | '\u0f3e' to '\u0f3f'
            | '\u0f40' to '\u0f47'
            | '\u0f49' to '\u0f6c'
            | '\u0f71' to '\u0f7e'
            | '\u0f7f'
            | '\u0f80' to '\u0f84'
            | '\u0f86' to '\u0f87'
            | '\u0f88' to '\u0f8c'
            | '\u0f8d' to '\u0f97'
            | '\u0f99' to '\u0fbc'
            | '\u0fc6'
            | '\u1000' to '\u102a'
            | '\u102b' to '\u102c'
            | '\u102d' to '\u1030'
            | '\u1031'
            | '\u1032' to '\u1037'
            | '\u1038'
            | '\u1039' to '\u103a'
            | '\u103b' to '\u103c'
            | '\u103d' to '\u103e'
            | '\u103f'
            | '\u1040' to '\u1049'
            | '\u1050' to '\u1055'
            | '\u1056' to '\u1057'
            | '\u1058' to '\u1059'
            | '\u105a' to '\u105d'
            | '\u105e' to '\u1060'
            | '\u1061'
            | '\u1062' to '\u1064'
            | '\u1065' to '\u1066'
            | '\u1067' to '\u106d'
            | '\u106e' to '\u1070'
            | '\u1071' to '\u1074'
            | '\u1075' to '\u1081'
            | '\u1082'
            | '\u1083' to '\u1084'
            | '\u1085' to '\u1086'
            | '\u1087' to '\u108c'
            | '\u108d'
            | '\u108e'
            | '\u108f'
            | '\u1090' to '\u1099'
            | '\u109a' to '\u109c'
            | '\u109d'
            | '\u10a0' to '\u10c5'
            | '\u10d0' to '\u10fa'
            | '\u10fc'
            | '\u1100' to '\u1248'
            | '\u124a' to '\u124d'
            | '\u1250' to '\u1256'
            | '\u1258'
            | '\u125a' to '\u125d'
            | '\u1260' to '\u1288'
            | '\u128a' to '\u128d'
            | '\u1290' to '\u12b0'
            | '\u12b2' to '\u12b5'
            | '\u12b8' to '\u12be'
            | '\u12c0'
            | '\u12c2' to '\u12c5'
            | '\u12c8' to '\u12d6'
            | '\u12d8' to '\u1310'
            | '\u1312' to '\u1315'
            | '\u1318' to '\u135a'
            | '\u135d' to '\u135f'
            | '\u1369' to '\u1371'
            | '\u1380' to '\u138f'
            | '\u13a0' to '\u13f4'
            | '\u1401' to '\u166c'
            | '\u166f' to '\u167f'
            | '\u1681' to '\u169a'
            | '\u16a0' to '\u16ea'
            | '\u16ee' to '\u16f0'
            | '\u1700' to '\u170c'
            | '\u170e' to '\u1711'
            | '\u1712' to '\u1714'
            | '\u1720' to '\u1731'
            | '\u1732' to '\u1734'
            | '\u1740' to '\u1751'
            | '\u1752' to '\u1753'
            | '\u1760' to '\u176c'
            | '\u176e' to '\u1770'
            | '\u1772' to '\u1773'
            | '\u1780' to '\u17b3'
            | '\u17b6'
            | '\u17b7' to '\u17bd'
            | '\u17be' to '\u17c5'
            | '\u17c6'
            | '\u17c7' to '\u17c8'
            | '\u17c9' to '\u17d3'
            | '\u17d7'
            | '\u17dc'
            | '\u17dd'
            | '\u17e0' to '\u17e9'
            | '\u180b' to '\u180d'
            | '\u1810' to '\u1819'
            | '\u1820' to '\u1842'
            | '\u1843'
            | '\u1844' to '\u1877'
            | '\u1880' to '\u18a8'
            | '\u18a9'
            | '\u18aa'
            | '\u18b0' to '\u18f5'
            | '\u1900' to '\u191c'
            | '\u1920' to '\u1922'
            | '\u1923' to '\u1926'
            | '\u1927' to '\u1928'
            | '\u1929' to '\u192b'
            | '\u1930' to '\u1931'
            | '\u1932'
            | '\u1933' to '\u1938'
            | '\u1939' to '\u193b'
            | '\u1946' to '\u194f'
            | '\u1950' to '\u196d'
            | '\u1970' to '\u1974'
            | '\u1980' to '\u19ab'
            | '\u19b0' to '\u19c0'
            | '\u19c1' to '\u19c7'
            | '\u19c8' to '\u19c9'
            | '\u19d0' to '\u19d9'
            | '\u19da'
            | '\u1a00' to '\u1a16'
            | '\u1a17' to '\u1a18'
            | '\u1a19' to '\u1a1b'
            | '\u1a20' to '\u1a54'
            | '\u1a55'
            | '\u1a56'
            | '\u1a57'
            | '\u1a58' to '\u1a5e'
            | '\u1a60'
            | '\u1a61'
            | '\u1a62'
            | '\u1a63' to '\u1a64'
            | '\u1a65' to '\u1a6c'
            | '\u1a6d' to '\u1a72'
            | '\u1a73' to '\u1a7c'
            | '\u1a7f'
            | '\u1a80' to '\u1a89'
            | '\u1a90' to '\u1a99'
            | '\u1aa7'
            | '\u1b00' to '\u1b03'
            | '\u1b04'
            | '\u1b05' to '\u1b33'
            | '\u1b34'
            | '\u1b35'
            | '\u1b36' to '\u1b3a'
            | '\u1b3b'
            | '\u1b3c'
            | '\u1b3d' to '\u1b41'
            | '\u1b42'
            | '\u1b43' to '\u1b44'
            | '\u1b45' to '\u1b4b'
            | '\u1b50' to '\u1b59'
            | '\u1b6b' to '\u1b73'
            | '\u1b80' to '\u1b81'
            | '\u1b82'
            | '\u1b83' to '\u1ba0'
            | '\u1ba1'
            | '\u1ba2' to '\u1ba5'
            | '\u1ba6' to '\u1ba7'
            | '\u1ba8' to '\u1ba9'
            | '\u1baa'
            | '\u1bae' to '\u1baf'
            | '\u1bb0' to '\u1bb9'
            | '\u1bc0' to '\u1be5'
            | '\u1be6'
            | '\u1be7'
            | '\u1be8' to '\u1be9'
            | '\u1bea' to '\u1bec'
            | '\u1bed'
            | '\u1bee'
            | '\u1bef' to '\u1bf1'
            | '\u1bf2' to '\u1bf3'
            | '\u1c00' to '\u1c23'
            | '\u1c24' to '\u1c2b'
            | '\u1c2c' to '\u1c33'
            | '\u1c34' to '\u1c35'
            | '\u1c36' to '\u1c37'
            | '\u1c40' to '\u1c49'
            | '\u1c4d' to '\u1c4f'
            | '\u1c50' to '\u1c59'
            | '\u1c5a' to '\u1c77'
            | '\u1c78' to '\u1c7d'
            | '\u1cd0' to '\u1cd2'
            | '\u1cd4' to '\u1ce0'
            | '\u1ce1'
            | '\u1ce2' to '\u1ce8'
            | '\u1ce9' to '\u1cec'
            | '\u1ced'
            | '\u1cee' to '\u1cf1'
            | '\u1cf2'
            | '\u1d00' to '\u1d2b'
            | '\u1d2c' to '\u1d61'
            | '\u1d62' to '\u1d77'
            | '\u1d78'
            | '\u1d79' to '\u1d9a'
            | '\u1d9b' to '\u1dbf'
            | '\u1dc0' to '\u1de6'
            | '\u1dfc' to '\u1dff'
            | '\u1e00' to '\u1f15'
            | '\u1f18' to '\u1f1d'
            | '\u1f20' to '\u1f45'
            | '\u1f48' to '\u1f4d'
            | '\u1f50' to '\u1f57'
            | '\u1f59'
            | '\u1f5b'
            | '\u1f5d'
            | '\u1f5f' to '\u1f7d'
            | '\u1f80' to '\u1fb4'
            | '\u1fb6' to '\u1fbc'
            | '\u1fbe'
            | '\u1fc2' to '\u1fc4'
            | '\u1fc6' to '\u1fcc'
            | '\u1fd0' to '\u1fd3'
            | '\u1fd6' to '\u1fdb'
            | '\u1fe0' to '\u1fec'
            | '\u1ff2' to '\u1ff4'
            | '\u1ff6' to '\u1ffc'
            | '\u203f' to '\u2040'
            | '\u2054'
            | '\u2071'
            | '\u207f'
            | '\u2090' to '\u209c'
            | '\u20d0' to '\u20dc'
            | '\u20e1'
            | '\u20e5' to '\u20f0'
            | '\u2102'
            | '\u2107'
            | '\u210a' to '\u2113'
            | '\u2115'
            | '\u2118'
            | '\u2119' to '\u211d'
            | '\u2124'
            | '\u2126'
            | '\u2128'
            | '\u212a' to '\u212d'
            | '\u212e'
            | '\u212f' to '\u2134'
            | '\u2135' to '\u2138'
            | '\u2139'
            | '\u213c' to '\u213f'
            | '\u2145' to '\u2149'
            | '\u214e'
            | '\u2160' to '\u2182'
            | '\u2183' to '\u2184'
            | '\u2185' to '\u2188'
            | '\u2c00' to '\u2c2e'
            | '\u2c30' to '\u2c5e'
            | '\u2c60' to '\u2c7c'
            | '\u2c7d'
            | '\u2c7e' to '\u2ce4'
            | '\u2ceb' to '\u2cee'
            | '\u2cef' to '\u2cf1'
            | '\u2d00' to '\u2d25'
            | '\u2d30' to '\u2d65'
            | '\u2d6f'
            | '\u2d7f'
            | '\u2d80' to '\u2d96'
            | '\u2da0' to '\u2da6'
            | '\u2da8' to '\u2dae'
            | '\u2db0' to '\u2db6'
            | '\u2db8' to '\u2dbe'
            | '\u2dc0' to '\u2dc6'
            | '\u2dc8' to '\u2dce'
            | '\u2dd0' to '\u2dd6'
            | '\u2dd8' to '\u2dde'
            | '\u2de0' to '\u2dff'
            | '\u3005'
            | '\u3006'
            | '\u3007'
            | '\u3021' to '\u3029'
            | '\u302a' to '\u302f'
            | '\u3031' to '\u3035'
            | '\u3038' to '\u303a'
            | '\u303b'
            | '\u303c'
            | '\u3041' to '\u3096'
            | '\u3099' to '\u309a'
            | '\u309d' to '\u309e'
            | '\u309f'
            | '\u30a1' to '\u30fa'
            | '\u30fc' to '\u30fe'
            | '\u30ff'
            | '\u3105' to '\u312d'
            | '\u3131' to '\u318e'
            | '\u31a0' to '\u31ba'
            | '\u31f0' to '\u31ff'
            | '\u3400' to '\u4db5'
            | '\u4e00' to '\u9fcb'
            | '\ua000' to '\ua014'
            | '\ua015'
            | '\ua016' to '\ua48c'
            | '\ua4d0' to '\ua4f7'
            | '\ua4f8' to '\ua4fd'
            | '\ua500' to '\ua60b'
            | '\ua60c'
            | '\ua610' to '\ua61f'
            | '\ua620' to '\ua629'
            | '\ua62a' to '\ua62b'
            | '\ua640' to '\ua66d'
            | '\ua66e'
            | '\ua66f'
            | '\ua67c' to '\ua67d'
            | '\ua67f'
            | '\ua680' to '\ua697'
            | '\ua6a0' to '\ua6e5'
            | '\ua6e6' to '\ua6ef'
            | '\ua6f0' to '\ua6f1'
            | '\ua717' to '\ua71f'
            | '\ua722' to '\ua76f'
            | '\ua770'
            | '\ua771' to '\ua787'
            | '\ua788'
            | '\ua78b' to '\ua78e'
            | '\ua790' to '\ua791'
            | '\ua7a0' to '\ua7a9'
            | '\ua7fa'
            | '\ua7fb' to '\ua801'
            | '\ua802'
            | '\ua803' to '\ua805'
            | '\ua806'
            | '\ua807' to '\ua80a'
            | '\ua80b'
            | '\ua80c' to '\ua822'
            | '\ua823' to '\ua824'
            | '\ua825' to '\ua826'
            | '\ua827'
            | '\ua840' to '\ua873'
            | '\ua880' to '\ua881'
            | '\ua882' to '\ua8b3'
            | '\ua8b4' to '\ua8c3'
            | '\ua8c4'
            | '\ua8d0' to '\ua8d9'
            | '\ua8e0' to '\ua8f1'
            | '\ua8f2' to '\ua8f7'
            | '\ua8fb'
            | '\ua900' to '\ua909'
            | '\ua90a' to '\ua925'
            | '\ua926' to '\ua92d'
            | '\ua930' to '\ua946'
            | '\ua947' to '\ua951'
            | '\ua952' to '\ua953'
            | '\ua960' to '\ua97c'
            | '\ua980' to '\ua982'
            | '\ua983'
            | '\ua984' to '\ua9b2'
            | '\ua9b3'
            | '\ua9b4' to '\ua9b5'
            | '\ua9b6' to '\ua9b9'
            | '\ua9ba' to '\ua9bb'
            | '\ua9bc'
            | '\ua9bd' to '\ua9c0'
            | '\ua9cf'
            | '\ua9d0' to '\ua9d9'
            | '\uaa00' to '\uaa28'
            | '\uaa29' to '\uaa2e'
            | '\uaa2f' to '\uaa30'
            | '\uaa31' to '\uaa32'
            | '\uaa33' to '\uaa34'
            | '\uaa35' to '\uaa36'
            | '\uaa40' to '\uaa42'
            | '\uaa43'
            | '\uaa44' to '\uaa4b'
            | '\uaa4c'
            | '\uaa4d'
            | '\uaa50' to '\uaa59'
            | '\uaa60' to '\uaa6f'
            | '\uaa70'
            | '\uaa71' to '\uaa76'
            | '\uaa7a'
            | '\uaa7b'
            | '\uaa80' to '\uaaaf'
            | '\uaab0'
            | '\uaab1'
            | '\uaab2' to '\uaab4'
            | '\uaab5' to '\uaab6'
            | '\uaab7' to '\uaab8'
            | '\uaab9' to '\uaabd'
            | '\uaabe' to '\uaabf'
            | '\uaac0'
            | '\uaac1'
            | '\uaac2'
            | '\uaadb' to '\uaadc'
            | '\uaadd'
            | '\uab01' to '\uab06'
            | '\uab09' to '\uab0e'
            | '\uab11' to '\uab16'
            | '\uab20' to '\uab26'
            | '\uab28' to '\uab2e'
            | '\uabc0' to '\uabe2'
            | '\uabe3' to '\uabe4'
            | '\uabe5'
            | '\uabe6' to '\uabe7'
            | '\uabe8'
            | '\uabe9' to '\uabea'
            | '\uabec'
            | '\uabed'
            | '\uabf0' to '\uabf9'
            | '\uac00' to '\ud7a3'
            | '\ud7b0' to '\ud7c6'
            | '\ud7cb' to '\ud7fb'
            | '\uf900' to '\ufa2d'
            | '\ufa30' to '\ufa6d'
            | '\ufa70' to '\ufad9'
            | '\ufb00' to '\ufb06'
            | '\ufb13' to '\ufb17'
            | '\ufb1d'
            | '\ufb1e'
            | '\ufb1f' to '\ufb28'
            | '\ufb2a' to '\ufb36'
            | '\ufb38' to '\ufb3c'
            | '\ufb3e'
            | '\ufb40' to '\ufb41'
            | '\ufb43' to '\ufb44'
            | '\ufb46' to '\ufbb1'
            | '\ufbd3' to '\ufc5d'
            | '\ufc64' to '\ufd3d'
            | '\ufd50' to '\ufd8f'
            | '\ufd92' to '\ufdc7'
            | '\ufdf0' to '\ufdf9'
            | '\ufe00' to '\ufe0f'
            | '\ufe20' to '\ufe26'
            | '\ufe33' to '\ufe34'
            | '\ufe4d' to '\ufe4f'
            | '\ufe71'
            | '\ufe73'
            | '\ufe77'
            | '\ufe79'
            | '\ufe7b'
            | '\ufe7d'
            | '\ufe7f' to '\ufefc'
            | '\uff10' to '\uff19'
            | '\uff21' to '\uff3a'
            | '\uff3f'
            | '\uff41' to '\uff5a'
            | '\uff66' to '\uff6f'
            | '\uff70'
            | '\uff71' to '\uff9d'
            | '\uff9e' to '\uff9f'
            | '\uffa0' to '\uffbe'
            | '\uffc2' to '\uffc7'
            | '\uffca' to '\uffcf'
            | '\uffd2' to '\uffd7'
            | '\uffda' to '\uffdc'
            | '\U00010000' to '\U0001000b'
            | '\U0001000d' to '\U00010026'
            | '\U00010028' to '\U0001003a'
            | '\U0001003c' to '\U0001003d'
            | '\U0001003f' to '\U0001004d'
            | '\U00010050' to '\U0001005d'
            | '\U00010080' to '\U000100fa'
            | '\U00010140' to '\U00010174'
            | '\U000101fd'
            | '\U00010280' to '\U0001029c'
            | '\U000102a0' to '\U000102d0'
            | '\U00010300' to '\U0001031e'
            | '\U00010330' to '\U00010340'
            | '\U00010341'
            | '\U00010342' to '\U00010349'
            | '\U0001034a'
            | '\U00010380' to '\U0001039d'
            | '\U000103a0' to '\U000103c3'
            | '\U000103c8' to '\U000103cf'
            | '\U000103d1' to '\U000103d5'
            | '\U00010400' to '\U0001044f'
            | '\U00010450' to '\U0001049d'
            | '\U000104a0' to '\U000104a9'
            | '\U00010800' to '\U00010805'
            | '\U00010808'
            | '\U0001080a' to '\U00010835'
            | '\U00010837' to '\U00010838'
            | '\U0001083c'
            | '\U0001083f' to '\U00010855'
            | '\U00010900' to '\U00010915'
            | '\U00010920' to '\U00010939'
            | '\U00010a00'
            | '\U00010a01' to '\U00010a03'
            | '\U00010a05' to '\U00010a06'
            | '\U00010a0c' to '\U00010a0f'
            | '\U00010a10' to '\U00010a13'
            | '\U00010a15' to '\U00010a17'
            | '\U00010a19' to '\U00010a33'
            | '\U00010a38' to '\U00010a3a'
            | '\U00010a3f'
            | '\U00010a60' to '\U00010a7c'
            | '\U00010b00' to '\U00010b35'
            | '\U00010b40' to '\U00010b55'
            | '\U00010b60' to '\U00010b72'
            | '\U00010c00' to '\U00010c48'
            | '\U00011000'
            | '\U00011001'
            | '\U00011002'
            | '\U00011003' to '\U00011037'
            | '\U00011038' to '\U00011046'
            | '\U00011066' to '\U0001106f'
            | '\U00011080' to '\U00011081'
            | '\U00011082'
            | '\U00011083' to '\U000110af'
            | '\U000110b0' to '\U000110b2'
            | '\U000110b3' to '\U000110b6'
            | '\U000110b7' to '\U000110b8'
            | '\U000110b9' to '\U000110ba'
            | '\U00012000' to '\U0001236e'
            | '\U00012400' to '\U00012462'
            | '\U00013000' to '\U0001342e'
            | '\U00016800' to '\U00016a38'
            | '\U0001b000' to '\U0001b001'
            | '\U0001d165' to '\U0001d166'
            | '\U0001d167' to '\U0001d169'
            | '\U0001d16d' to '\U0001d172'
            | '\U0001d17b' to '\U0001d182'
            | '\U0001d185' to '\U0001d18b'
            | '\U0001d1aa' to '\U0001d1ad'
            | '\U0001d242' to '\U0001d244'
            | '\U0001d400' to '\U0001d454'
            | '\U0001d456' to '\U0001d49c'
            | '\U0001d49e' to '\U0001d49f'
            | '\U0001d4a2'
            | '\U0001d4a5' to '\U0001d4a6'
            | '\U0001d4a9' to '\U0001d4ac'
            | '\U0001d4ae' to '\U0001d4b9'
            | '\U0001d4bb'
            | '\U0001d4bd' to '\U0001d4c3'
            | '\U0001d4c5' to '\U0001d505'
            | '\U0001d507' to '\U0001d50a'
            | '\U0001d50d' to '\U0001d514'
            | '\U0001d516' to '\U0001d51c'
            | '\U0001d51e' to '\U0001d539'
            | '\U0001d53b' to '\U0001d53e'
            | '\U0001d540' to '\U0001d544'
            | '\U0001d546'
            | '\U0001d54a' to '\U0001d550'
            | '\U0001d552' to '\U0001d6a5'
            | '\U0001d6a8' to '\U0001d6c0'
            | '\U0001d6c2' to '\U0001d6da'
            | '\U0001d6dc' to '\U0001d6fa'
            | '\U0001d6fc' to '\U0001d714'
            | '\U0001d716' to '\U0001d734'
            | '\U0001d736' to '\U0001d74e'
            | '\U0001d750' to '\U0001d76e'
            | '\U0001d770' to '\U0001d788'
            | '\U0001d78a' to '\U0001d7a8'
            | '\U0001d7aa' to '\U0001d7c2'
            | '\U0001d7c4' to '\U0001d7cb'
            | '\U0001d7ce' to '\U0001d7ff'
            | '\U00020000' to '\U0002a6d6'
            | '\U0002a700' to '\U0002b734'
            | '\U0002b740' to '\U0002b81d'
            | '\U0002f800' to '\U0002fa1d'
            | '\U000e0100' to '\U000e01ef'
              { true }
            _ { false }
        };
    }

    pure fn XID_Start(c: char) -> bool {
        ret alt c {
              '\x41' to '\x5a'
            | '\x61' to '\x7a'
            | '\xaa'
            | '\xb5'
            | '\xba'
            | '\xc0' to '\xd6'
            | '\xd8' to '\xf6'
            | '\xf8' to '\u01ba'
            | '\u01bb'
            | '\u01bc' to '\u01bf'
            | '\u01c0' to '\u01c3'
            | '\u01c4' to '\u0293'
            | '\u0294'
            | '\u0295' to '\u02af'
            | '\u02b0' to '\u02c1'
            | '\u02c6' to '\u02d1'
            | '\u02e0' to '\u02e4'
            | '\u02ec'
            | '\u02ee'
            | '\u0370' to '\u0373'
            | '\u0374'
            | '\u0376' to '\u0377'
            | '\u037b' to '\u037d'
            | '\u0386'
            | '\u0388' to '\u038a'
            | '\u038c'
            | '\u038e' to '\u03a1'
            | '\u03a3' to '\u03f5'
            | '\u03f7' to '\u0481'
            | '\u048a' to '\u0527'
            | '\u0531' to '\u0556'
            | '\u0559'
            | '\u0561' to '\u0587'
            | '\u05d0' to '\u05ea'
            | '\u05f0' to '\u05f2'
            | '\u0620' to '\u063f'
            | '\u0640'
            | '\u0641' to '\u064a'
            | '\u066e' to '\u066f'
            | '\u0671' to '\u06d3'
            | '\u06d5'
            | '\u06e5' to '\u06e6'
            | '\u06ee' to '\u06ef'
            | '\u06fa' to '\u06fc'
            | '\u06ff'
            | '\u0710'
            | '\u0712' to '\u072f'
            | '\u074d' to '\u07a5'
            | '\u07b1'
            | '\u07ca' to '\u07ea'
            | '\u07f4' to '\u07f5'
            | '\u07fa'
            | '\u0800' to '\u0815'
            | '\u081a'
            | '\u0824'
            | '\u0828'
            | '\u0840' to '\u0858'
            | '\u0904' to '\u0939'
            | '\u093d'
            | '\u0950'
            | '\u0958' to '\u0961'
            | '\u0971'
            | '\u0972' to '\u0977'
            | '\u0979' to '\u097f'
            | '\u0985' to '\u098c'
            | '\u098f' to '\u0990'
            | '\u0993' to '\u09a8'
            | '\u09aa' to '\u09b0'
            | '\u09b2'
            | '\u09b6' to '\u09b9'
            | '\u09bd'
            | '\u09ce'
            | '\u09dc' to '\u09dd'
            | '\u09df' to '\u09e1'
            | '\u09f0' to '\u09f1'
            | '\u0a05' to '\u0a0a'
            | '\u0a0f' to '\u0a10'
            | '\u0a13' to '\u0a28'
            | '\u0a2a' to '\u0a30'
            | '\u0a32' to '\u0a33'
            | '\u0a35' to '\u0a36'
            | '\u0a38' to '\u0a39'
            | '\u0a59' to '\u0a5c'
            | '\u0a5e'
            | '\u0a72' to '\u0a74'
            | '\u0a85' to '\u0a8d'
            | '\u0a8f' to '\u0a91'
            | '\u0a93' to '\u0aa8'
            | '\u0aaa' to '\u0ab0'
            | '\u0ab2' to '\u0ab3'
            | '\u0ab5' to '\u0ab9'
            | '\u0abd'
            | '\u0ad0'
            | '\u0ae0' to '\u0ae1'
            | '\u0b05' to '\u0b0c'
            | '\u0b0f' to '\u0b10'
            | '\u0b13' to '\u0b28'
            | '\u0b2a' to '\u0b30'
            | '\u0b32' to '\u0b33'
            | '\u0b35' to '\u0b39'
            | '\u0b3d'
            | '\u0b5c' to '\u0b5d'
            | '\u0b5f' to '\u0b61'
            | '\u0b71'
            | '\u0b83'
            | '\u0b85' to '\u0b8a'
            | '\u0b8e' to '\u0b90'
            | '\u0b92' to '\u0b95'
            | '\u0b99' to '\u0b9a'
            | '\u0b9c'
            | '\u0b9e' to '\u0b9f'
            | '\u0ba3' to '\u0ba4'
            | '\u0ba8' to '\u0baa'
            | '\u0bae' to '\u0bb9'
            | '\u0bd0'
            | '\u0c05' to '\u0c0c'
            | '\u0c0e' to '\u0c10'
            | '\u0c12' to '\u0c28'
            | '\u0c2a' to '\u0c33'
            | '\u0c35' to '\u0c39'
            | '\u0c3d'
            | '\u0c58' to '\u0c59'
            | '\u0c60' to '\u0c61'
            | '\u0c85' to '\u0c8c'
            | '\u0c8e' to '\u0c90'
            | '\u0c92' to '\u0ca8'
            | '\u0caa' to '\u0cb3'
            | '\u0cb5' to '\u0cb9'
            | '\u0cbd'
            | '\u0cde'
            | '\u0ce0' to '\u0ce1'
            | '\u0cf1' to '\u0cf2'
            | '\u0d05' to '\u0d0c'
            | '\u0d0e' to '\u0d10'
            | '\u0d12' to '\u0d3a'
            | '\u0d3d'
            | '\u0d4e'
            | '\u0d60' to '\u0d61'
            | '\u0d7a' to '\u0d7f'
            | '\u0d85' to '\u0d96'
            | '\u0d9a' to '\u0db1'
            | '\u0db3' to '\u0dbb'
            | '\u0dbd'
            | '\u0dc0' to '\u0dc6'
            | '\u0e01' to '\u0e30'
            | '\u0e32'
            | '\u0e40' to '\u0e45'
            | '\u0e46'
            | '\u0e81' to '\u0e82'
            | '\u0e84'
            | '\u0e87' to '\u0e88'
            | '\u0e8a'
            | '\u0e8d'
            | '\u0e94' to '\u0e97'
            | '\u0e99' to '\u0e9f'
            | '\u0ea1' to '\u0ea3'
            | '\u0ea5'
            | '\u0ea7'
            | '\u0eaa' to '\u0eab'
            | '\u0ead' to '\u0eb0'
            | '\u0eb2'
            | '\u0ebd'
            | '\u0ec0' to '\u0ec4'
            | '\u0ec6'
            | '\u0edc' to '\u0edd'
            | '\u0f00'
            | '\u0f40' to '\u0f47'
            | '\u0f49' to '\u0f6c'
            | '\u0f88' to '\u0f8c'
            | '\u1000' to '\u102a'
            | '\u103f'
            | '\u1050' to '\u1055'
            | '\u105a' to '\u105d'
            | '\u1061'
            | '\u1065' to '\u1066'
            | '\u106e' to '\u1070'
            | '\u1075' to '\u1081'
            | '\u108e'
            | '\u10a0' to '\u10c5'
            | '\u10d0' to '\u10fa'
            | '\u10fc'
            | '\u1100' to '\u1248'
            | '\u124a' to '\u124d'
            | '\u1250' to '\u1256'
            | '\u1258'
            | '\u125a' to '\u125d'
            | '\u1260' to '\u1288'
            | '\u128a' to '\u128d'
            | '\u1290' to '\u12b0'
            | '\u12b2' to '\u12b5'
            | '\u12b8' to '\u12be'
            | '\u12c0'
            | '\u12c2' to '\u12c5'
            | '\u12c8' to '\u12d6'
            | '\u12d8' to '\u1310'
            | '\u1312' to '\u1315'
            | '\u1318' to '\u135a'
            | '\u1380' to '\u138f'
            | '\u13a0' to '\u13f4'
            | '\u1401' to '\u166c'
            | '\u166f' to '\u167f'
            | '\u1681' to '\u169a'
            | '\u16a0' to '\u16ea'
            | '\u16ee' to '\u16f0'
            | '\u1700' to '\u170c'
            | '\u170e' to '\u1711'
            | '\u1720' to '\u1731'
            | '\u1740' to '\u1751'
            | '\u1760' to '\u176c'
            | '\u176e' to '\u1770'
            | '\u1780' to '\u17b3'
            | '\u17d7'
            | '\u17dc'
            | '\u1820' to '\u1842'
            | '\u1843'
            | '\u1844' to '\u1877'
            | '\u1880' to '\u18a8'
            | '\u18aa'
            | '\u18b0' to '\u18f5'
            | '\u1900' to '\u191c'
            | '\u1950' to '\u196d'
            | '\u1970' to '\u1974'
            | '\u1980' to '\u19ab'
            | '\u19c1' to '\u19c7'
            | '\u1a00' to '\u1a16'
            | '\u1a20' to '\u1a54'
            | '\u1aa7'
            | '\u1b05' to '\u1b33'
            | '\u1b45' to '\u1b4b'
            | '\u1b83' to '\u1ba0'
            | '\u1bae' to '\u1baf'
            | '\u1bc0' to '\u1be5'
            | '\u1c00' to '\u1c23'
            | '\u1c4d' to '\u1c4f'
            | '\u1c5a' to '\u1c77'
            | '\u1c78' to '\u1c7d'
            | '\u1ce9' to '\u1cec'
            | '\u1cee' to '\u1cf1'
            | '\u1d00' to '\u1d2b'
            | '\u1d2c' to '\u1d61'
            | '\u1d62' to '\u1d77'
            | '\u1d78'
            | '\u1d79' to '\u1d9a'
            | '\u1d9b' to '\u1dbf'
            | '\u1e00' to '\u1f15'
            | '\u1f18' to '\u1f1d'
            | '\u1f20' to '\u1f45'
            | '\u1f48' to '\u1f4d'
            | '\u1f50' to '\u1f57'
            | '\u1f59'
            | '\u1f5b'
            | '\u1f5d'
            | '\u1f5f' to '\u1f7d'
            | '\u1f80' to '\u1fb4'
            | '\u1fb6' to '\u1fbc'
            | '\u1fbe'
            | '\u1fc2' to '\u1fc4'
            | '\u1fc6' to '\u1fcc'
            | '\u1fd0' to '\u1fd3'
            | '\u1fd6' to '\u1fdb'
            | '\u1fe0' to '\u1fec'
            | '\u1ff2' to '\u1ff4'
            | '\u1ff6' to '\u1ffc'
            | '\u2071'
            | '\u207f'
            | '\u2090' to '\u209c'
            | '\u2102'
            | '\u2107'
            | '\u210a' to '\u2113'
            | '\u2115'
            | '\u2118'
            | '\u2119' to '\u211d'
            | '\u2124'
            | '\u2126'
            | '\u2128'
            | '\u212a' to '\u212d'
            | '\u212e'
            | '\u212f' to '\u2134'
            | '\u2135' to '\u2138'
            | '\u2139'
            | '\u213c' to '\u213f'
            | '\u2145' to '\u2149'
            | '\u214e'
            | '\u2160' to '\u2182'
            | '\u2183' to '\u2184'
            | '\u2185' to '\u2188'
            | '\u2c00' to '\u2c2e'
            | '\u2c30' to '\u2c5e'
            | '\u2c60' to '\u2c7c'
            | '\u2c7d'
            | '\u2c7e' to '\u2ce4'
            | '\u2ceb' to '\u2cee'
            | '\u2d00' to '\u2d25'
            | '\u2d30' to '\u2d65'
            | '\u2d6f'
            | '\u2d80' to '\u2d96'
            | '\u2da0' to '\u2da6'
            | '\u2da8' to '\u2dae'
            | '\u2db0' to '\u2db6'
            | '\u2db8' to '\u2dbe'
            | '\u2dc0' to '\u2dc6'
            | '\u2dc8' to '\u2dce'
            | '\u2dd0' to '\u2dd6'
            | '\u2dd8' to '\u2dde'
            | '\u3005'
            | '\u3006'
            | '\u3007'
            | '\u3021' to '\u3029'
            | '\u3031' to '\u3035'
            | '\u3038' to '\u303a'
            | '\u303b'
            | '\u303c'
            | '\u3041' to '\u3096'
            | '\u309d' to '\u309e'
            | '\u309f'
            | '\u30a1' to '\u30fa'
            | '\u30fc' to '\u30fe'
            | '\u30ff'
            | '\u3105' to '\u312d'
            | '\u3131' to '\u318e'
            | '\u31a0' to '\u31ba'
            | '\u31f0' to '\u31ff'
            | '\u3400' to '\u4db5'
            | '\u4e00' to '\u9fcb'
            | '\ua000' to '\ua014'
            | '\ua015'
            | '\ua016' to '\ua48c'
            | '\ua4d0' to '\ua4f7'
            | '\ua4f8' to '\ua4fd'
            | '\ua500' to '\ua60b'
            | '\ua60c'
            | '\ua610' to '\ua61f'
            | '\ua62a' to '\ua62b'
            | '\ua640' to '\ua66d'
            | '\ua66e'
            | '\ua67f'
            | '\ua680' to '\ua697'
            | '\ua6a0' to '\ua6e5'
            | '\ua6e6' to '\ua6ef'
            | '\ua717' to '\ua71f'
            | '\ua722' to '\ua76f'
            | '\ua770'
            | '\ua771' to '\ua787'
            | '\ua788'
            | '\ua78b' to '\ua78e'
            | '\ua790' to '\ua791'
            | '\ua7a0' to '\ua7a9'
            | '\ua7fa'
            | '\ua7fb' to '\ua801'
            | '\ua803' to '\ua805'
            | '\ua807' to '\ua80a'
            | '\ua80c' to '\ua822'
            | '\ua840' to '\ua873'
            | '\ua882' to '\ua8b3'
            | '\ua8f2' to '\ua8f7'
            | '\ua8fb'
            | '\ua90a' to '\ua925'
            | '\ua930' to '\ua946'
            | '\ua960' to '\ua97c'
            | '\ua984' to '\ua9b2'
            | '\ua9cf'
            | '\uaa00' to '\uaa28'
            | '\uaa40' to '\uaa42'
            | '\uaa44' to '\uaa4b'
            | '\uaa60' to '\uaa6f'
            | '\uaa70'
            | '\uaa71' to '\uaa76'
            | '\uaa7a'
            | '\uaa80' to '\uaaaf'
            | '\uaab1'
            | '\uaab5' to '\uaab6'
            | '\uaab9' to '\uaabd'
            | '\uaac0'
            | '\uaac2'
            | '\uaadb' to '\uaadc'
            | '\uaadd'
            | '\uab01' to '\uab06'
            | '\uab09' to '\uab0e'
            | '\uab11' to '\uab16'
            | '\uab20' to '\uab26'
            | '\uab28' to '\uab2e'
            | '\uabc0' to '\uabe2'
            | '\uac00' to '\ud7a3'
            | '\ud7b0' to '\ud7c6'
            | '\ud7cb' to '\ud7fb'
            | '\uf900' to '\ufa2d'
            | '\ufa30' to '\ufa6d'
            | '\ufa70' to '\ufad9'
            | '\ufb00' to '\ufb06'
            | '\ufb13' to '\ufb17'
            | '\ufb1d'
            | '\ufb1f' to '\ufb28'
            | '\ufb2a' to '\ufb36'
            | '\ufb38' to '\ufb3c'
            | '\ufb3e'
            | '\ufb40' to '\ufb41'
            | '\ufb43' to '\ufb44'
            | '\ufb46' to '\ufbb1'
            | '\ufbd3' to '\ufc5d'
            | '\ufc64' to '\ufd3d'
            | '\ufd50' to '\ufd8f'
            | '\ufd92' to '\ufdc7'
            | '\ufdf0' to '\ufdf9'
            | '\ufe71'
            | '\ufe73'
            | '\ufe77'
            | '\ufe79'
            | '\ufe7b'
            | '\ufe7d'
            | '\ufe7f' to '\ufefc'
            | '\uff21' to '\uff3a'
            | '\uff41' to '\uff5a'
            | '\uff66' to '\uff6f'
            | '\uff70'
            | '\uff71' to '\uff9d'
            | '\uffa0' to '\uffbe'
            | '\uffc2' to '\uffc7'
            | '\uffca' to '\uffcf'
            | '\uffd2' to '\uffd7'
            | '\uffda' to '\uffdc'
            | '\U00010000' to '\U0001000b'
            | '\U0001000d' to '\U00010026'
            | '\U00010028' to '\U0001003a'
            | '\U0001003c' to '\U0001003d'
            | '\U0001003f' to '\U0001004d'
            | '\U00010050' to '\U0001005d'
            | '\U00010080' to '\U000100fa'
            | '\U00010140' to '\U00010174'
            | '\U00010280' to '\U0001029c'
            | '\U000102a0' to '\U000102d0'
            | '\U00010300' to '\U0001031e'
            | '\U00010330' to '\U00010340'
            | '\U00010341'
            | '\U00010342' to '\U00010349'
            | '\U0001034a'
            | '\U00010380' to '\U0001039d'
            | '\U000103a0' to '\U000103c3'
            | '\U000103c8' to '\U000103cf'
            | '\U000103d1' to '\U000103d5'
            | '\U00010400' to '\U0001044f'
            | '\U00010450' to '\U0001049d'
            | '\U00010800' to '\U00010805'
            | '\U00010808'
            | '\U0001080a' to '\U00010835'
            | '\U00010837' to '\U00010838'
            | '\U0001083c'
            | '\U0001083f' to '\U00010855'
            | '\U00010900' to '\U00010915'
            | '\U00010920' to '\U00010939'
            | '\U00010a00'
            | '\U00010a10' to '\U00010a13'
            | '\U00010a15' to '\U00010a17'
            | '\U00010a19' to '\U00010a33'
            | '\U00010a60' to '\U00010a7c'
            | '\U00010b00' to '\U00010b35'
            | '\U00010b40' to '\U00010b55'
            | '\U00010b60' to '\U00010b72'
            | '\U00010c00' to '\U00010c48'
            | '\U00011003' to '\U00011037'
            | '\U00011083' to '\U000110af'
            | '\U00012000' to '\U0001236e'
            | '\U00012400' to '\U00012462'
            | '\U00013000' to '\U0001342e'
            | '\U00016800' to '\U00016a38'
            | '\U0001b000' to '\U0001b001'
            | '\U0001d400' to '\U0001d454'
            | '\U0001d456' to '\U0001d49c'
            | '\U0001d49e' to '\U0001d49f'
            | '\U0001d4a2'
            | '\U0001d4a5' to '\U0001d4a6'
            | '\U0001d4a9' to '\U0001d4ac'
            | '\U0001d4ae' to '\U0001d4b9'
            | '\U0001d4bb'
            | '\U0001d4bd' to '\U0001d4c3'
            | '\U0001d4c5' to '\U0001d505'
            | '\U0001d507' to '\U0001d50a'
            | '\U0001d50d' to '\U0001d514'
            | '\U0001d516' to '\U0001d51c'
            | '\U0001d51e' to '\U0001d539'
            | '\U0001d53b' to '\U0001d53e'
            | '\U0001d540' to '\U0001d544'
            | '\U0001d546'
            | '\U0001d54a' to '\U0001d550'
            | '\U0001d552' to '\U0001d6a5'
            | '\U0001d6a8' to '\U0001d6c0'
            | '\U0001d6c2' to '\U0001d6da'
            | '\U0001d6dc' to '\U0001d6fa'
            | '\U0001d6fc' to '\U0001d714'
            | '\U0001d716' to '\U0001d734'
            | '\U0001d736' to '\U0001d74e'
            | '\U0001d750' to '\U0001d76e'
            | '\U0001d770' to '\U0001d788'
            | '\U0001d78a' to '\U0001d7a8'
            | '\U0001d7aa' to '\U0001d7c2'
            | '\U0001d7c4' to '\U0001d7cb'
            | '\U00020000' to '\U0002a6d6'
            | '\U0002a700' to '\U0002b734'
            | '\U0002b740' to '\U0002b81d'
            | '\U0002f800' to '\U0002fa1d'
              { true }
            _ { false }
        };
    }

}
