
kernel void test_fn(local char2 *sSharedStorage, global char2 *srcValues, global uint *offsets, global char2 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (char2)(char)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore2(srcValues[ tid ], lid, ((local char *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local char *sp = (local char *)(sSharedStorage + lid);
  global char *dp = (global char *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
