#pragma OPENCL EXTENSION cl_khr_fp64 : enable

kernel void test_fn(local double16 *sSharedStorage, global double16 *srcValues, global uint *offsets, global double16 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (double16)(double)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore16(srcValues[ tid ], lid, ((local double *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local double *sp = (local double *)(sSharedStorage + lid);
  global double *dp = (global double *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
