#pragma OPENCL EXTENSION cl_khr_fp64 : enable

kernel void test_fn(local double8 *sSharedStorage, global double8 *srcValues, global uint *offsets, global double8 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (double8)(double)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore8(srcValues[ tid ], lid, ((local double *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local double *sp = (local double *)(sSharedStorage + lid);
  global double *dp = (global double *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
