
kernel void test_fn(local float16 *sSharedStorage, global float16 *srcValues, global uint *offsets, global float16 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (float16)(float)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore16(srcValues[ tid ], lid, ((local float *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local float *sp = (local float *)(sSharedStorage + lid);
  global float *dp = (global float *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
