
kernel void test_fn(local int8 *sSharedStorage, global int8 *srcValues, global uint *offsets, global int8 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (int8)(int)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore8(srcValues[ tid ], lid, ((local int *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local int *sp = (local int *)(sSharedStorage + lid);
  global int *dp = (global int *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
