
kernel void test_fn(local short2 *sSharedStorage, global short2 *srcValues, global uint *offsets, global short2 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (short2)(short)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore2(srcValues[ tid ], lid, ((local short *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local short *sp = (local short *)(sSharedStorage + lid);
  global short *dp = (global short *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
