
kernel void test_fn(local uchar4 *sSharedStorage, global uchar4 *srcValues, global uint *offsets, global uchar4 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (uchar4)(uchar)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore4(srcValues[ tid ], lid, ((local uchar *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local uchar *sp = (local uchar *)(sSharedStorage + lid);
  global uchar *dp = (global uchar *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
