
kernel void test_fn(local uint2 *sSharedStorage, global uint2 *srcValues, global uint *offsets, global uint2 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (uint2)(uint)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore2(srcValues[ tid ], lid, ((local uint *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local uint *sp = (local uint *)(sSharedStorage + lid);
  global uint *dp = (global uint *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
