__kernel void test_fn(__global double4 *srcValues, __global double3 *destBuffer) {
  #define SIZE 128
  __private double3 priv[SIZE];
  int tid = get_global_id(0);
  //avoid accessing outside buffer limits
  if (SIZE <= tid*3 )
    return;
  vstore3(srcValues[tid].xyz, tid, (__private double *)priv);
  double3 val = vload3(tid, (__private double *)priv);
  vstore3(val, tid, (__global double *)destBuffer);
}