__kernel void test_fn(__global float4 *srcValues, __global float3 *destBuffer) {
  #define SIZE 128
  __private float3 priv[SIZE];
  int tid = get_global_id(0);
  //avoid accessing outside buffer limits
  if (SIZE <= tid*3 )
    return;
  vstore3(srcValues[tid].xyz, tid, (__private float *)priv);
  float3 val = vload3(tid, (__private float *)priv);
  vstore3(val, tid, (__global float *)destBuffer);
}