__kernel void test_fn(__global int4 *srcValues, __global int3 *destBuffer) {
  #define SIZE 128
  __private int3 priv[SIZE];
  int tid = get_global_id(0);
  //avoid accessing outside buffer limits
  if (SIZE <= tid*3 )
    return;
  vstore3(srcValues[tid].xyz, tid, (__private int *)priv);
  int3 val = vload3(tid, (__private int *)priv);
  vstore3(val, tid, (__global int *)destBuffer);
}