__kernel void test_fn(__global long4 *srcValues, __global long3 *destBuffer) {
  #define SIZE 128
  __private long3 priv[SIZE];
  int tid = get_global_id(0);
  //avoid accessing outside buffer limits
  if (SIZE <= tid*3 )
    return;
  vstore3(srcValues[tid].xyz, tid, (__private long *)priv);
  long3 val = vload3(tid, (__private long *)priv);
  vstore3(val, tid, (__global long *)destBuffer);
}