__kernel void test_fn(__global uint4 *srcValues, __global uint3 *destBuffer) {
  #define SIZE 128
  __private uint3 priv[SIZE];
  int tid = get_global_id(0);
  //avoid accessing outside buffer limits
  if (SIZE <= tid*3 )
    return;
  vstore3(srcValues[tid].xyz, tid, (__private uint *)priv);
  uint3 val = vload3(tid, (__private uint *)priv);
  vstore3(val, tid, (__global uint *)destBuffer);
}