__kernel void test_fn(__global ulong4 *srcValues, __global ulong3 *destBuffer) {
  #define SIZE 128
  __private ulong3 priv[SIZE];
  int tid = get_global_id(0);
  //avoid accessing outside buffer limits
  if (SIZE <= tid*3 )
    return;
  vstore3(srcValues[tid].xyz, tid, (__private ulong *)priv);
  ulong3 val = vload3(tid, (__private ulong *)priv);
  vstore3(val, tid, (__global ulong *)destBuffer);
}