#pragma OPENCL EXTENSION cl_khr_local_int32_base_atomics : enable
kernel void test_atomic_fn(global int *finalDest, global int *srcMemory,
  volatile local int *destMemory) {
  int tid = get_global_id(0), lid = get_local_id(0), gid = get_group_id(0);
  destMemory[lid] = srcMemory[tid];
  barrier(CLK_LOCAL_MEM_FENCE);
  atomic_or(&destMemory[gid], srcMemory[tid]);
  barrier(CLK_LOCAL_MEM_FENCE);
  // Finally, write out the last value. Again, we're synced, so everyone will
  // be writing the same value.
  finalDest[gid] = destMemory[gid];
}
