#pragma OPENCL EXTENSION cl_khr_global_int32_extended_atomics : enable
__kernel void test_atomic_fn(volatile global uint *finalDest)
{
    int tid = get_global_id(0), gid = get_group_id(0);

    size_t numBits = sizeof( finalDest[0] ) * 8;
    int bitIndex = tid & ( numBits - 1 );

    for (int i=0; i<gid; i++)
    {
        atomic_xor( &finalDest[i], 1 << bitIndex );
    }
}

