__kernel void test_convert_char3_sat_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_char3_rte_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_char3( __global char *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_char3( __global char *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_char3( __global char *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_char3( __global char *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_char3( __global char *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_char3( __global char *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_char3( __global char *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_char3( __global char *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_char3( __global char *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_char3( __global char *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_char3( __global char *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}


