constant sampler_t imageSampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
__kernel void sample_kernel( read_only image2d_t input, __global float *xOffsets, __global float *yOffsets, __global float4 *results )
{
   int tidX = get_global_id(0), tidY = get_global_id(1);
   int offset = tidY*get_image_width(input) + tidX;
   float2 coords = (float2)( (float)(tidX * 2 + 1)/(2 * get_image_width(input)), (float)( tidY * 2 + 1)/(2 * get_image_height(input)) );
   results[offset] = read_imagef( input, imageSampler, coords );
}
