typedef read_only image2d_array_t read_only_image2d_array_int;

__kernel void sample_kernel( read_only_image2d_array_int input, sampler_t imageSampler, __global float *xOffsets, __global float *yOffsets, __global float *zOffsets,  __global int4 *results )
{
   int tidX = get_global_id(0), tidY = get_global_id(1), tidZ = get_global_id(2);
   int offset = tidZ*get_image_width(input)*get_image_height(input) + tidY*get_image_width(input) + tidX;
   float4 coords = (float4)( tidX, tidY, tidZ, 0.0f );
   results[offset] = read_imagei( input, imageSampler, coords );
}
