typedef read_only image2d_t read_only_image2d_uint;

__kernel void sample_kernel( read_only_image2d_uint input, sampler_t imageSampler, __global float *xOffsets, __global float *yOffsets, __global uint4 *results )
{
   int tidX = get_global_id(0), tidY = get_global_id(1);
   int offset = tidY*get_image_width(input) + tidX;
   float2 coords = (float2)( (float)( tidX ), (float)( tidY ) );
   results[offset] = read_imageui( input, imageSampler, coords );
}
