from enum import StrEnum


class DeviceCapability(StrEnum):
    ACCELERATION_SENSOR = "AccelerationSensor"
    AIR_QUALITY = "AirQuality"
    ALARM = "Alarm"
    BATTERY = "Battery"
    BULB = "Bulb"
    CARBON_DIOXIDE = "CarbonDioxideMeasurement"
    CARBON_MONOXIDE = "CarbonMonoxideDetector"
    CHANGE_LEVEL = "ChangeLevel"
    CHIME = "Chime"
    COLOR_CONTROL = "ColorControl"
    COLOR_MODE = "ColorMode"
    COLOR_TEMP = "ColorTemperature"
    CONSUMABLE = "consumable"
    CONTACT_SENSOR = "ContactSensor"
    CURRENT_METER = "CurrentMeter"
    DOOR_CONTROL = "DoorControl"
    DOUBLE_TAPABLE_BUTTON = "DoubleTapableButton"
    ENERGY_METER = "EnergyMeter"
    ENERGY_SOURCE = "EnergySource"
    FAN_CONTROL = "FanControl"
    GARAGE_DOOR_CONTROL = "GarageDoorControl"
    GAS_DETECTOR = "GasDetector"
    HOLDABLE_BUTTON = "HoldableButton"
    ILLUMINANCE_MEASUREMENT = "IlluminanceMeasurement"
    INDICATOR = "Indicator"
    LIGHT = "Light"
    LIGHT_EFFECTS = "LightEffects"
    LIQUID_FLOW_RATE = "LiquidFlowRate"
    LOCK = "Lock"
    LOCK_CODES = "LockCodes"
    MOMENTARY = "Momentary"
    MOTION_SENSOR = "MotionSensor"
    MUSIC_PLAYER = "MusicPlayer"
    OUTLET = "Outlet"
    POWER_METER = "PowerMeter"
    POWER_SOURCE = "PowerSource"
    PRESENCE_SENSOR = "PresenceSensor"
    PRESSURE_MEASUREMENT = "PressureMeasurement"
    PUSHABLE_BUTTON = "PushableButton"
    RELATIVE_HUMIDITY_MEASUREMENT = "RelativeHumidityMeasurement"
    RELAY_SWITCH = "RelaySwitch"
    RELEASABLE_BUTTON = "ReleasableButton"
    SECURITY_KEYPAD = "SecurityKeypad"
    SHOCK_SENSOR = "ShockSensor"
    SIGNAL_STRENGTH = "SignalStrength"
    SLEEP_SENSOR = "SleepSensor"
    SMOKE_DETECTOR = "SmokeDetector"
    SOUND_PRESSURE_LEVEL = "SoundPressureLevel"
    SOUND_SENSOR = "SoundSensor"
    SPEECH_SYNTHESIS = "SpeechSynthesis"
    STEP_SENSOR = "StepSensor"
    SWITCH = "Switch"
    SWITCH_LEVEL = "SwitchLevel"
    TAMPER_ALERT = "TamperAlert"
    TEMPERATURE_MEASUREMENT = "TemperatureMeasurement"
    THERMOSTAT = "Thermostat"
    THERMOSTAT_COOLING_SETPOINT = "ThermostatCoolingSetpoint"
    THERMOSTAT_FAN_MODE = "ThermostatFanMode"
    THERMOSTAT_HEATING_SETPOINT = "ThermostatHeatingSetpoint"
    THERMOSTAT_SETPOINT = "ThermostatSetpoint"
    TIMED_SESSION = "TimedSession"
    TOUCH_SENSOR = "TouchSensor"
    UV = "UltravioletIndex"
    VALVE = "Valve"
    VIDEO_CAMERA = "VideoCamera"
    VOLTAGE_MEASUREMENT = "VoltageMeasurement"
    WATER_SENSOR = "WaterSensor"
    WINDOW_BLIND = "WindowBlind"
    WINDOW_SHADE = "WindowShade"


class DeviceAttribute(StrEnum):
    ACCELERATION = "acceleration"
    AIR_QUALITY_INDEX = "airQualityIndex"
    ALARM = "alarm"
    AMPERAGE = "amperage"
    AQI = "aqi"
    BATTERY = "battery"
    CARBON_DIOXIDE = "carbonDioxide"
    CARBON_DIOXIDE_LEVEL = "carbonDioxide-Level"
    CARBON_MONOXIDE = "carbonMonoxide"
    CARBON_MONOXIDE_LEVEL = "carbonMonoxide-Level"
    CLIP = "clip"
    CODE_CHANGED = "codeChanged"
    CODE_LENGTH = "codeLength"
    COLOR_MODE = "colorMode"
    COLOR_NAME = "colorName"
    COLOR_TEMP = "colorTemperature"
    CONSUMABLE_STATUS = "consumableStatus"
    CONTACT = "contact"
    COOLING_SETPOINT = "coolingSetpoint"
    CUMULATIVE_CUBIC_METER = "cumulative_cubic_meter"
    CUMULATIVE_LITER = "cumulative_liter"
    CURRENT = "current"
    DAY_CUBIC_METER = "day_cubic_meter"
    DAY_EURO = "day_euro"
    DAY_LITER = "day_liter"
    DEW_POINT = "DewPoint"
    DIRECTION = "direction"
    DOOR = "door"
    DOUBLE_TAPPED = "doubleTapped"
    EFFECT_NAME = "effectName"
    EFFECT_NUMBER = "effectnumber"
    ENERGY = "energy"
    ENERGY_SOURCE = "energySource"
    ENTRY_DELAY = "entryDelay"
    EXIT_DELAY = "exitDelay"
    FAN_MODE = "thermostatFanMode"
    GOAL = "goal"
    HEATING_SETPOINT = "heatingSetpoint"
    HEAT_ALARM = "heatAlarm"
    HELD = "held"
    HOME_HEALTH = "HomeHealth"
    HSM_STATUS = "hsm_status"
    HUE = "hue"
    HUMIDITY = "humidity"
    ILLUMINANCE = "illuminance"
    INDICATOR_STATUS = "indicatorStatus"
    LAST_CODE_NAME = "lastCodeName"
    LAST_UPDATE = "last_update"
    LEVEL = "level"
    LOCK = "lock"
    LOCK_CODES = "lockCodes"
    LQI = "lqi"
    MAX_CODES = "maxCodes"
    MODE = "mode"
    MOTION = "motion"
    NAME = "name"
    NATURAL_GAS = "naturalGas"
    NEST_MODE = "nestThermostatMode"
    NEST_SUPPORTED_MODES = "supportedNestThermostatModes"
    NETWORK_STATUS = "networkStatus"
    NUM_BUTTONS = "numberOfButtons"
    OPERATING_STATE = "thermostatOperatingState"
    PH = "pH"
    PM1 = "pm1"
    PM10 = "pm10"
    PM25 = "pm25"
    POSITION = "position"
    POWER = "power"
    POWERFACTOR = "powerFactor"
    POWER_SOURCE = "powerSource"
    PRESENCE = "presence"
    PRESSURE = "pressure"
    PUSHED = "pushed"
    RAIN_DAILY = "rainDaily"
    RAIN_RATE = "rainRate"
    RATE = "rate"
    RELEASED = "released"
    RSSI = "rssi"
    SATURATION = "saturation"
    SCHEDULED_SETPOINT = "scheduledSetpoint"
    SECURITY_KEYPAD = "securityKeypad"
    SESSION_STATUS = "sessionStatus"
    SHOCK = "shock"
    SLEEPING = "sleeping"
    SMOKE = "smoke"
    SOUND = "sound"
    SOUNDNUMBER = "soundnumber"
    SOUND_EFFECTS = "soundEffects"
    SOUND_NAME = "soundName"
    SOUND_PRESSURE_LEVEL = "soundPressureLevel"
    SPEED = "speed"
    STATUS = "status"
    STEPS = "steps"
    SUPPORTED_FAN_MODES = "supportedThermostatFanModes"
    SUPPORTED_FAN_SPEEDS = "supportedFanSpeeds"
    SUPPORTED_MODES = "supportedThermostatModes"
    SWITCH = "switch"
    TAMPER = "tamper"
    TEMP = "temperature"
    TEMPERATURE = "temperature"
    TEMP_UNIT = "temperatureUnit"
    THERMOSTAT_FAN_MODE = "thermostatFanMode"
    THERMOSTAT_MODE = "thermostatMode"
    THERMOSTAT_OPERATING_STATE = "thermostatOperatingState"
    THERMOSTAT_SETPOINT = "thermostatSetpoint"
    THERMOSTAT_SETPOINT_MODE = "thermostatSetpointMode"
    TILT = "tilt"
    TIME_REMAINING = "timeRemaining"
    TOUCH = "touch"
    UV = "ultravioletIndex"
    VALVE = "valve"
    VOC = "VOC"
    VOC_LEVEL = "VOC-Level"
    VOLTAGE = "voltage"
    WATER = "water"
    WINDOW_BLIND = "windowBlind"
    WINDOW_SHADE = "windowShade"
    WIND_DIRECTION = "windDirection"
    WIND_GUST = "windGust"
    WIND_SPEED = "windSpeed"


class DeviceCommand(StrEnum):
    ARM_AWAY = "armAway"
    ARM_HOME = "armHome"
    ARM_NIGHT = "armNight"
    AUTO = "auto"
    AWAY = "away"
    BOTH = "both"
    CAPTURE = "capture"
    CLOSE = "close"
    COOL = "cool"
    CYCLE_SPEED = "cycleSpeed"
    DELETE_CODE = "deleteCode"
    DISARM = "disarm"
    ECO = "eco"
    EMERGENCY_HEAT = "emergencyHeat"
    FAN_AUTO = "fanAuto"
    FAN_CIRCULATE = "fanCirculate"
    FAN_ON = "fanOn"
    FLASH = "flash"
    GET_CODES = "getCodes"
    HEAT = "heat"
    INDICATOR_NEVER = "indicatorNever"
    INDICATOR_WHEN_OFF = "indicatorWhenOff"
    INDICATOR_WHEN_ON = "indicatorWhenOn"
    LOCK = "lock"
    MUTE = "mute"
    OFF = "off"
    ON = "on"
    OPEN = "open"
    PHRASE_SPOKEN = "phraseSpoken"
    PLAY_SOUND = "playSound"
    PRESENT = "present"
    PUSH = "push"
    SET_CODE = "setCode"
    SET_CODE_LENGTH = "setCodeLength"
    SET_COLOR = "setColor"
    SET_COLOR_TEMP = "setColorTemperature"
    SET_COOLING_SETPOINT = "setCoolingSetpoint"
    SET_ENTRY_DELAY = "setEntryDelay"
    SET_EXIT_DELAY = "setExitDelay"
    SET_FAN_MODE = "setThermostatFanMode"
    SET_HEATING_SETPOINT = "setHeatingSetpoint"
    SET_HUE = "setHue"
    SET_LEVEL = "setLevel"
    SET_POSITION = "setPosition"
    SET_PRESENCE = "setPresence"
    SET_SAT = "setSaturation"
    SET_SPEED = "setSpeed"
    SET_THERMOSTAT_MODE = "setThermostatMode"
    SIREN = "siren"
    SPEAK = "speak"
    START_LEVEL_CHANGE = "startLevelChange"
    STOP = "stop"
    STOP_LEVEL_CHANGE = "stopLevelChange"
    STROBE = "strobe"
    UNLOCK = "unlock"


# See https://docs.hubitat.com/index.php?title=Hubitat®_Safety_Monitor_Interface
class HsmCommand(StrEnum):
    ARM_ALL = "armAll"
    ARM_AWAY = "armAway"
    ARM_HOME = "armHome"
    ARM_NIGHT = "armNight"
    ARM_RULES = "armRules"
    CANCEL_ALERTS = "cancelAlerts"
    DISARM = "disarm"
    DISARM_ALL = "disarmAll"
    DISARM_RULES = "disarmRules"


class HsmStatus(StrEnum):
    ALL_DISARMED = "allDisarmed"
    ARMED_AWAY = "armedAway"
    ARMED_HOME = "armedHome"
    ARMED_NIGHT = "armedNight"
    ARMING_AWAY = "armingAway"
    ARMING_HOME = "armingHome"
    ARMING_NIGHT = "armingNight"
    DISARMED = "disarmed"


class DeviceState(StrEnum):
    ACTIVE = "active"
    ARMED_AWAY = "armed away"
    ARMED_HOME = "armed home"
    ARMED_NIGHT = "armed night"
    CLEAR = "clear"
    CLOSED = "closed"
    CLOSING = "closing"
    DETECTED = "detected"
    DISARMED = "disarmed"
    INACTIVE = "inactive"
    LOCKED = "locked"
    LOW = "low"
    NOT_DETECTED = "not detected"
    OFF = "off"
    ON = "on"
    OPEN = "open"
    OPENING = "opening"
    PARTIALLY_OPEN = "partially open"
    TESTED = "tested"
    UNKNOWN = "unknown"
    UNLOCKED = "unlocked"
    UNLOCKED_WITH_TIMEOUT = "unlocked with timeout"


class HubitatColorMode(StrEnum):
    RGB = "RGB"
    CT = "CT"


ID_MODE = "hub_mode"
ID_HSM_STATUS = "hub_hsm_status"

DEFAULT_FAN_SPEEDS = [
    "low",
    "medium-low",
    "medium",
    "medium-high",
    "high",
    "on",
    "off",
    "auto",
]
