/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

module.exports = {
  'en-doc1': {
    id: 'en-doc1',
    title: 'Document 1',
    source: 'doc1.md',
    versioned_source: 'doc1.md',
    version: 'next',
    permalink: 'docs/en/next/doc1.html',
    localized_id: 'doc1',
    language: 'en',
    sidebar: 'docs',
    category: 'Test',
    next_id: 'doc2',
    next: 'en-doc2',
    next_title: 'Document 2',
    sort: 1,
  },
  'en-doc2': {
    id: 'en-doc2',
    title: 'Document 2',
    source: 'doc2.md',
    versioned_source: 'doc2.md',
    version: 'next',
    permalink: 'docs/en/next/doc2.html',
    localized_id: 'doc2',
    language: 'en',
    sidebar: 'docs',
    category: 'Test',
    previous_id: 'doc1',
    previous: 'en-doc1',
    previous_title: 'Document 1',
    sort: 2,
  },
  'en-doc3': {
    id: 'en-doc3',
    title: 'Document 3',
    source: 'doc3.md',
    versioned_source: 'doc3.md',
    version: 'next',
    permalink: 'docs/en/next/doc3.html',
    localized_id: 'doc3',
    language: 'en',
    sidebar: 'docs',
    category: 'Test 2',
    previous_id: 'doc2',
    previous: 'en-doc2',
    previous_title: 'Document 2',
    sort: 3,
  },
  'en-reflinks': {
    id: 'en-reflinks',
    title: 'Reference Links',
    source: 'reflinks.md',
    versioned_source: 'reflinks.md',
    version: 'next',
    permalink: 'docs/en/next/reflinks.html',
    localized_id: 'reflinks',
    language: 'en',
    sidebar: 'docs',
    category: 'Test 2',
    previous_id: 'doc3',
    previous: 'en-doc3',
    previous_title: 'Document 3',
    sort: 4,
  },
  'ko-doc1': {
    id: 'ko-doc1',
    title: '문서 1',
    source: 'doc1.md',
    versioned_source: 'doc1.md',
    version: 'next',
    permalink: 'docs/ko/next/doc1.html',
    localized_id: 'doc1',
    language: 'ko',
    sidebar: 'docs',
    category: 'Test',
    next_id: 'doc2',
    next: 'ko-doc2',
    next_title: '문서 2',
  },
  'ko-doc2': {
    id: 'ko-doc2',
    title: '문서 2',
    source: 'doc2.md',
    versioned_source: 'doc2.md',
    version: 'next',
    permalink: 'docs/ko/next/doc2.html',
    localized_id: 'doc2',
    language: 'ko',
    sidebar: 'docs',
    category: 'Test',
    previous_id: 'doc1',
    previous: 'ko-doc1',
    previous_title: '문서 1',
  },
  'en-version-1.0.0-doc1': {
    id: 'en-version-1.0.0-doc1',
    original_id: 'doc1',
    title: 'Document 1',
    source: 'version-1.0.0/doc1.md',
    versioned_source: 'version-1.0.0/doc1.md',
    version: '1.0.0',
    permalink: 'docs/en/doc1.html',
    localized_id: 'version-1.0.0-doc1',
    language: 'en',
    sidebar: 'version-1.0.0-docs',
    category: 'Test',
    next_id: 'doc2',
    next: 'en-version-1.0.0-doc2',
    next_title: 'Document 2',
  },
  'en-version-1.0.0-doc2': {
    id: 'en-version-1.0.0-doc2',
    original_id: 'doc2',
    title: 'Document 2',
    source: 'version-1.0.0/doc2.md',
    versioned_source: 'version-1.0.0/doc2.md',
    version: '1.0.0',
    permalink: 'docs/en/doc2.html',
    localized_id: 'version-1.0.0-doc2',
    language: 'en',
    sidebar: 'version-1.0.0-docs',
    category: 'Test',
    previous_id: 'doc1',
    previous: 'en-version-1.0.0-doc1',
    previous_title: 'Document 1',
  },
  'ko-version-1.0.0-doc1': {
    id: 'ko-version-1.0.0-doc1',
    title: '문서 1',
    source: 'version-1.0.0/doc1.md',
    versioned_source: 'version-1.0.0/doc1.md',
    version: '1.0.0',
    permalink: 'docs/ko/doc1.html',
    localized_id: 'version-1.0.0-doc1',
    language: 'ko',
    sidebar: 'version-1.0.0-docs',
    category: 'Test',
    next_id: 'doc2',
    next: 'ko-version-1.0.0-doc2',
    next_title: '문서 2',
  },
  'ko-version-1.0.0-doc2': {
    id: 'ko-version-1.0.0-doc2',
    title: '문서 2',
    source: 'version-1.0.0/doc2.md',
    versioned_source: 'version-1.0.0/doc2.md',
    version: '1.0.0',
    permalink: 'docs/ko/doc2.html',
    localized_id: 'version-1.0.0-doc2',
    language: 'ko',
    sidebar: 'version-1.0.0-docs',
    category: 'Test',
    previous_id: 'doc1',
    previous: 'ko-version-1.0.0-doc1',
    previous_title: '문서 1',
  },
};
