/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

const users = [
  // Please add your logo in alphabetical order of caption.
  {
    caption: '1Hive',
    image: '/img/users/1hive.png',
    infoLink: 'https://1hive.org',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Accord Project',
    image: '/img/users/accord-project.png',
    infoLink: 'https://docs.accordproject.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Adapt.js',
    image: '/img/users/adaptjs.svg',
    infoLink: 'https://adaptjs.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'All Contributors',
    image: '/img/users/allcontributors.png',
    infoLink: 'https://allcontributors.org/',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'Almin',
    image: '/img/users/almin.png',
    infoLink: 'https://almin.js.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Almond',
    image: '/img/users/almond.svg',
    infoLink: 'https://almond.sh/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Amphora Data',
    image: '/img/users/amphora-data.png',
    infoLink: 'https://amphoradata.github.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Anssr Data Platform',
    image: '/img/users/anssr-data-plataform.svg',
    infoLink: 'https://anssr.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Apify SDK',
    image: '/img/users/apify-skd.svg',
    infoLink: 'https://sdk.apify.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Ara',
    image: '/img/users/ara.png',
    infoLink: 'https://ara-framework.github.io/website/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Ax',
    image: '/img/users/ax.svg',
    infoLink: 'https://ax.dev/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Babel',
    image: '/img/users/babel.svg',
    infoLink: 'https://babeljs.io/',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'Bemuse',
    image: '/img/users/bemuse.png',
    infoLink: 'https://bemuse.ninja/project/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Bitcoin-S',
    image: '/img/users/bitcoin-s.png',
    infoLink: 'https://bitcoin-s.org',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Bottender',
    image: '/img/users/bottender.png',
    infoLink: 'https://bottender.js.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Bowler',
    image: '/img/users/bowler.svg',
    infoLink: 'https://pybowler.io/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'BuckleScript',
    image: '/img/users/bucklescript.svg',
    infoLink: 'https://bucklescript.github.io/',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'CapRover',
    image: '/img/users/caprover.png',
    infoLink: 'https://caprover.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Casbin',
    image: '/img/users/casbin.png',
    infoLink: 'https://casbin.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Channelize.io',
    image: '/img/users/channelize.png',
    infoLink: 'https://docs.channelize.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'CodeceptJS',
    image: '/img/users/codecept.png',
    infoLink: 'https://codecept.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Cohesity',
    image: '/img/users/cohesity.png',
    infoLink: 'https://developer.cohesity.com',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Collective',
    image: '/img/users/collective.png',
    infoLink: 'https://collective.gg/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'ConfigCat',
    image: '/img/users/configcat.svg',
    infoLink: 'https://configcat.com/docs',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Create React App',
    image: '/img/users/react.svg',
    infoLink: 'https://facebook.github.io/create-react-app/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Day.js',
    image: '/img/users/dayjs.png',
    infoLink: 'https://day.js.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Dep',
    image: '/img/users/golang-dep.svg',
    infoLink: 'https://golang.github.io/dep/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'DevSpace',
    image: '/img/users/devspace.svg',
    infoLink: 'https://devspace.cloud/docs/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Dime',
    image: '/img/users/dime.png',
    infoLink: 'https://docs.dimescheduler.com',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Docusaurus',
    image: '/img/users/docusaurus.svg',
    infoLink: 'https://www.docusaurus.io',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Draft.js',
    image: '/img/users/draftjs.png',
    infoLink: 'https://draftjs.org/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Draftail',
    image: '/img/users/draftail.svg',
    infoLink: 'https://www.draftail.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Erxes',
    image: '/img/users/erxes.png',
    infoLink: 'https://docs.erxes.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Express Validator',
    image: '/img/users/express-validator.svg',
    infoLink: 'https://express-validator.github.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'FastText',
    image: '/img/users/fasttext.png',
    infoLink: 'https://fasttext.cc',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'FBT',
    image: '/img/users/fbt_blue.png',
    infoLink: 'https://facebookincubator.github.io/fbt/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Flipper',
    image: '/img/users/flipper.png',
    infoLink: 'https://fbflipper.com',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Formik',
    image: '/img/users/formik.png',
    infoLink: 'https://jaredpalmer.com/formik',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'FuseBox',
    image: '/img/users/fuse-box.svg',
    infoLink: 'https://fuse-box.org',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Global CTO Forum',
    image: '/img/users/global-cto-forum.svg',
    infoLink: 'https://globalctoforum.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Goby',
    image: '/img/users/goby-logo.svg',
    infoLink: 'https://goby-lang.org',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'graphql-compose',
    image: '/img/users/graphql-compose-logo.svg',
    infoLink: 'https://graphql-compose.github.io',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Gulp',
    image: '/img/users/gulp.svg',
    infoLink: 'https://gulpjs.com',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'Haul',
    image: '/img/users/haul.png',
    infoLink: 'https://callstack.github.io/haul/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Hazelcast Jet',
    image: '/img/users/hazelcast-jet.svg',
    infoLink: 'https://jet-start.sh',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Hemera',
    image: '/img/users/hemera.png',
    infoLink: 'https://hemerajs.github.io/hemera/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Home Assistant',
    image: '/img/users/home-assistant.svg',
    infoLink: 'https://developers.home-assistant.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Idb',
    image: '/img/users/idb.svg',
    infoLink: 'https://www.fbidb.io/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Instant Articles Builder',
    image: '/img/users/facebook-instant-articles-rules-editor.svg',
    infoLink: 'https://facebook.github.io/instant-articles-builder/',
    fbOpenSource: true,
    pinned: false,
  },
  {
    caption: 'Jafar',
    image: '/img/users/jafar.svg',
    infoLink: 'https://yahoo.github.io/jafar',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Jest',
    image: '/img/users/jest.png',
    infoLink: 'https://jestjs.io',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'KaTeX',
    image: '/img/users/katex.svg',
    infoLink: 'https://katex.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Libra',
    image: '/img/users/libra.svg',
    infoLink: 'https://developers.libra.org',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'LisanJS',
    image: '/img/users/lisan.svg',
    infoLink: 'https://lisanjs.com',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'MakeItOpen',
    image: '/img/users/makeitopen.png',
    infoLink: 'https://makeitopen.com/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'mailgo',
    image: '/img/users/mailgo.png',
    infoLink: 'https://mailgo.js.org/',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'manylesson',
    image: '/img/users/manylesson.png',
    infoLink: 'http://www.manylesson.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Metro',
    image: '/img/users/metro.svg',
    infoLink: 'https://facebook.github.io/metro/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Microkubes',
    image: '/img/users/microkubes.png',
    infoLink: 'https://www.microkubes.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'minapp',
    image: '/img/users/minapp.svg',
    infoLink: 'https://qiu8310.github.io/minapp/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Mockit',
    image: '/img/users/mockit.png',
    infoLink: 'https://mockit.netlify.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'moleculerjs-boilerplate',
    image: '/img/users/moleculerjs-boilerplate.png',
    infoLink: 'https://pankod.github.io/moleculerjs-boilerplate/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Mojito',
    image: '/img/users/mojito.png',
    infoLink: 'https://mojito.mx/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'next-boilerplate',
    image: '/img/users/next-boilerplate.png',
    infoLink: 'https://pankod.github.io/next-boilerplate/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Netconsd',
    image: '/img/users/netconsd.svg',
    infoLink: 'https://facebookmicrosites.github.io/netconsd/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Node SerialPort',
    image: '/img/users/serialport-logo.svg',
    infoLink: 'https://serialport.io',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Noderize',
    image: '/img/users/noderize.svg',
    infoLink: 'https://noderize.js.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Open Power Quality',
    image: '/img/users/open-power-quality.png',
    infoLink: 'https://openpowerquality.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Overwolf',
    image: '/img/users/overwolf.svg',
    infoLink: 'https://overwolf.github.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Paubox',
    image: '/img/users/paubox.png',
    infoLink: 'https://docs.paubox.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Plus (ThinkSNS+)',
    image: '/img/users/plus.png',
    infoLink: 'https://slimkit.github.io',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Paynow',
    image: '/img/users/paynow.svg',
    infoLink: 'https://developers.paynow.co.zw/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'PayTabs',
    image: '/img/users/paytabs.png',
    infoLink: 'https://dev.paytabs.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'pnpm',
    image: '/img/users/pnpm.svg',
    infoLink: 'https://pnpm.js.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Polymath Network',
    image: '/img/users/polymatch-network.png',
    infoLink: 'https://polymath.network',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Prettier',
    image: '/img/users/prettier.png',
    infoLink: 'https://www.prettier.io',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'Profilo',
    image: '/img/users/profilo.png',
    infoLink: 'https://facebookincubator.github.io/profilo/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Pulsar',
    image: '/img/users/pulsar.svg',
    infoLink: 'https://pulsar.apache.org/',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'Pyre',
    image: '/img/users/pyre.svg',
    infoLink: 'https://pyre-check.org',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Quix',
    image: '/img/users/quix.png',
    infoLink: 'https://wix.github.io/quix/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Quicksi',
    image: '/img/users/quicksi.png',
    infoLink: 'https://quicksi-bot.now.sh/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Radity',
    image: '/img/users/radity.svg',
    infoLink: 'https://radity.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Rawsec Inventory',
    image: '/img/users/rawsec.png',
    infoLink: 'https://inventory.rawsec.ml/docs/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'React 360',
    image: '/img/users/react-360.svg',
    infoLink: 'https://facebook.github.io/react-360',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'React-Leaflet',
    image: '/img/users/react-leaflet.png',
    infoLink: 'https://react-leaflet.js.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'React Native',
    image: '/img/users/react-native.svg',
    infoLink: 'https://facebook.github.io/react-native',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'React Native Elements',
    image: '/img/users/react-native-elements.png',
    infoLink: 'https://react-native-training.github.io/react-native-elements/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'react-native-ios-kit',
    image: '/img/users/react-native-ios-kit.svg',
    infoLink: 'https://callstack.github.io/react-native-ios-kit',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'React Native Sensors',
    image: '/img/users/react-native-sensors.svg',
    infoLink: 'https://react-native-sensors.github.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'React Native Testing Library',
    image: '/img/users/react-native-testing-library.png',
    infoLink: 'https://callstack.github.io/react-native-testing-library/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'React Redux',
    image: '/img/users/react-redux.svg',
    infoLink: 'https://react-redux.js.org',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'react-slate',
    image: '/img/users/react-slate.svg',
    infoLink: 'https://react-slate.surge.sh/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'reaction-commerce',
    image: '/img/users/reaction-commerce.svg',
    infoLink: 'https://docs.reactioncommerce.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Reactive Interaction Gateway',
    image: '/img/users/reactive-interaction-gateway.svg',
    infoLink: 'https://accenture.github.io/reactive-interaction-gateway/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Reason',
    image: '/img/users/reason.svg',
    infoLink: 'https://reasonml.github.io/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'ReasonReact',
    image: '/img/users/reason-react.svg',
    infoLink: 'https://reasonml.github.io/reason-react/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Redex',
    image: '/img/users/redex.png',
    infoLink: 'https://fbredex.com/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Redux',
    image: '/img/users/redux.svg',
    infoLink: 'https://redux.js.org/',
    fbOpenSource: false,
    pinned: true,
  },
  {
    caption: 'Rejoiner',
    image: '/img/users/rejoiner.svg',
    infoLink: 'https://rejoiner.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Relay',
    image: '/img/users/relay.svg',
    infoLink: 'https://facebook.github.io/relay/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'rest-hapi',
    image: '/img/users/rest-hapi.png',
    infoLink: 'https://jkheadley.github.io/rest-hapi/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Saleor',
    image: '/img/users/saleor.png',
    infoLink: 'https://docs.getsaleor.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Scalafmt',
    image: '/img/users/scalameta.png',
    infoLink: 'https://scalameta.org/scalafmt/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'ScanTrust',
    image: '/img/users/st-white-on-black.svg',
    infoLink: 'https://devportal.scantrust.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Shrine',
    image: '/img/users/shrine.png',
    infoLink: 'https://shrinerb.com',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'single-spa',
    image: '/img/users/single-spa.svg',
    infoLink: 'https://single-spa.js.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Skip',
    image: '/img/users/skiplang.png',
    infoLink: 'http://skiplang.com',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'smash.gg',
    image: '/img/users/smash.png',
    infoLink: 'https://developer.smash.gg',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Spectrum',
    image: '/img/users/spectrum.svg',
    infoLink: 'https://libspectrum.io',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'Stackery',
    image: '/img/users/stackery-large-mark-teal-w.png',
    infoLink: 'https://docs.stackery.io',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'StreamPipes',
    image: '/img/users/stream-pipes.png',
    infoLink: 'https://docs.streampipes.org',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Substrate',
    image: '/img/users/substrate.svg',
    infoLink: 'https://substrate.dev',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'T-Regx',
    image: '/img/users/t-regx.png',
    infoLink: 'https://t-regx.com',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Taro',
    image: '/img/users/taro.png',
    infoLink: 'https://nervjs.github.io/taro/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Testing Library',
    image: '/img/users/testing-library.png',
    infoLink: 'https://testing-library.com/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'textlint',
    image: '/img/users/textlint-icon.png',
    infoLink: 'https://textlint.github.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'The Diff Podcast',
    image: '/img/users/the-diff.svg',
    infoLink: 'https://thediffpodcast.com',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'tipsi-stripe',
    image: '/img/users/tipsi-stripe.png',
    infoLink: 'https://tipsi.github.io/tipsi-stripe/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'TorchCraftAI',
    image: '/img/users/torchcraftai.png',
    infoLink: 'https://torchcraft.github.io/TorchCraftAI/',
    fbOpenSource: true,
    pinned: true,
  },
  {
    caption: 'TurtleCoin',
    image: '/img/users/turtlecoin.png',
    infoLink: 'https://docs.turtlecoin.lol',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Twirp',
    image: '/img/users/twirp.png',
    infoLink: 'https://twitchtv.github.io/twirp/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'TypeGraphQL',
    image: '/img/users/type-graphql.png',
    infoLink: 'https://typegraphql.ml/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Type Route',
    image: '/img/users/type-route.svg',
    infoLink: 'https://www.type-route.org',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Verdaccio',
    image: '/img/users/verdaccio-tiny@2x.png',
    infoLink: 'https://www.verdaccio.org/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'Vuls',
    image: '/img/users/vuls.png',
    infoLink: 'https://vuls.io/',
    fbOpenSource: false,
    pinned: false,
  },
  {
    caption: 'WarriorJS',
    image: '/img/users/warriorjs.svg',
    infoLink: 'https://warrior.js.org/',
    fbOpenSource: false,
    pinned: false,
  },

  // Please add your logo in alphabetical order of caption.
];

users.forEach((user) => {
  if (!user.image || !user.image.startsWith('/img/users/')) {
    throw new Error(
      `Bad user site image = ${user.image}. The image should be hosted on Docusaurus site, in /static/img/users/ folder, and not use remote HTTP or HTTPS URLs`,
    );
  }
});

module.exports = users;
