---
id: version-1.14.4-site-config
title: siteConfig.js
original_id: site-config
---

A large part of the site configuration is done by editing the `siteConfig.js` file.

## User Showcase

The `users` array is used to store objects for each project/user that you want to show on your site. Currently, this field is used by example the `pages/en/index.js` and `pages/en/users.js` files provided. Each user object should have `caption`, `image`, `infoLink`, and `pinned` fields. The `caption` is the text showed when someone hovers over the `image` of that user, and the `infoLink` is where clicking the image will bring someone. The `pinned` field determines whether or not it shows up on the `index` page.

Currently, this `users` array is used only by the `index.js` and `users.js` example files. If you do not wish to have a users page or show users on the `index` page, you may remove this section.

## siteConfig Fields

The `siteConfig` object contains the bulk of the configuration settings for your website.

### Mandatory Fields

#### `baseUrl` [string]

baseUrl for your site. This can also be considered the path after the host. For example, `/metro/` is the baseUrl of https://facebook.github.io/metro/. For URLs that have no path, the baseUrl should be set to `/`. This field is related to the [`url` field](#url-string).

#### `colors` [object]

Color configurations for the site.

- `primaryColor` is the color used the header navigation bar and sidebars.
- `secondaryColor` is the color seen in the second row of the header navigation bar when the site window is narrow (including on mobile).
- Custom color configurations can also be added. For example, if user styles are added with colors specified as `$myColor`, then adding a `myColor` field to `colors` will allow you to configure this color.

#### `copyright` [string]

The copyright string at the footer of the site and within the feed

#### `favicon` [string]

URL for site favicon.

#### `headerIcon` [string]

URL for icon used in the header navigation bar.

#### `headerLinks` [array]

Links that will be used in the header navigation bar. The `label` field of each object will be the link text and will also be translated for each language.

Example Usage:

```js
headerLinks: [
  // Links to document with id doc1 for current language/version
  { doc: "doc1", label: "Getting Started" },
  // Link to page found at pages/en/help.js or if that does not exist, pages/help.js, for current language
  { page: "help", label: "Help" },
  // Links to href destination
  { href: "https://github.com/", label: "GitHub" },
  // Links to blog generated by Docusaurus (${baseUrl}blog)
  { blog: true, label: "Blog" },
  // Determines search bar position among links
  { search: true },
  // Determines language drop down position among links
  { languages: true }
],
```

#### `organizationName` [string]

GitHub username of the organization or user hosting this project. This is used by the publishing script to determine where your GitHub pages website will be hosted.

#### `projectName` [string]

Project name. This must match your GitHub repository project name (case-sensitive).

#### `tagline` [string]

The tagline for your website.

#### `title` [string]

Title for your website.

#### `url` [string]

URL for your website. This can also be considered the top-level hostname. For example, `https://facebook.github.io` is the URL of https://facebook.github.io/metro/, and `https://docusaurus.io` is the URL for https://docusaurus.io. This field is related to the [`baseUrl` field](#baseurl-string).

### Optional Fields

#### `algolia` [object]

Information for Algolia search integration. If this field is excluded, the search bar will not appear in the header. You must specify two values for this field, and one (`appId`) is optional.

- `apiKey` - the Algolia provided an API key for your search.
- `indexName` - the Algolia provided index name for your search (usually this is the project name)
- `appId` - Algolia provides a default scraper for your docs. If you provide your own, you will probably get this id from them.

#### `blogSidebarCount` [number]

Control the number of blog posts that show up in the sidebar. See the [adding a blog docs](guides-blog.md#changing-how-many-blog-posts-show-on-sidebar) for more information.

#### `blogSidebarTitle` [string]

Control the title of the blog sidebar. See the [adding a blog docs](guides-blog.md#changing-the-sidebar-title) for more information.

#### `cleanUrl` [boolean]

If `true`, allow URLs with no `HTML` extension. For example, a request to URL https://docusaurus.io/docs/installation will return the same result as https://docusaurus.io/docs/installation.html.

> If users intend for this website to be used exclusively offline, this value must be set to `false`. Otherwise, it will cause the site to route to the parent folder of the linked page.

#### `cname` [string]

The CNAME for your website. It will go into a `CNAME` file when your site is built.

#### `customDocsPath` [string]

By default, Docusaurus expects your documentation to be in a directory called `docs`. This directory is at the same level as the `website` directory (i.e., not inside the `website` directory). You can specify a custom path to your documentation with this field.

```js
customDocsPath: 'docs/site';
```

```js
customDocsPath: 'website-docs';
```

#### `defaultVersionShown` [string]

The default version for the site to be shown. If this is not set, the latest version will be shown.

#### `docsUrl` [string]

The base URL for all docs file. Set this field to `''` to remove the `docs` prefix of the documentation URL. If unset, it is defaulted to `docs`.

#### `disableHeaderTitle` [boolean]

An option to disable showing the title in the header next to the header icon. Exclude this field to keep the header as normal, otherwise set to `true`.

#### `disableTitleTagline` [boolean]

An option to disable showing the tagline in the title of main pages. Exclude this field to keep page titles as `Title • Tagline`. Set to `true` to make page titles just `Title`.

#### `docsSideNavCollapsible` [boolean]

Set this to `true` if you want to be able to expand/collapse the links and subcategories in the sidebar.

#### `editUrl` [string]

URL for editing docs, usage example: `editUrl + 'en/doc1.md'`. If this field is omitted, there will be no "Edit this Doc" button for each document.

#### `enableUpdateBy` [boolean]

An option to enable the docs showing the author who last updated the doc. Set to `true` to show a line at the bottom right corner of each doc page as `Last updated by <Author Name>`.

#### `enableUpdateTime` [boolean]

An option to enable the docs showing last update time. Set to `true` to show a line at the bottom right corner of each doc page as `Last updated on <date>`.

#### `facebookAppId` [string]

If you want Facebook Like/Share buttons in the footer and at the bottom of your blog posts, provide a [Facebook application id](https://www.facebook.com/help/audiencenetwork/804209223039296).

#### `facebookComments` [boolean]

Set this to `true` if you want to enable Facebook comments at the bottom of your blog post. `facebookAppId` has to be also set.

#### `facebookPixelId` [string]

[Facebook Pixel](https://www.facebook.com/business/a/facebook-pixel) ID to track page views.

#### `fonts` [object]

Font-family CSS configuration for the site. If a font family is specified in `siteConfig.js` as `$myFont`, then adding a `myFont` key to an array in `fonts` will allow you to configure the font. Items appearing earlier in the array will take priority of later elements, so ordering of the fonts matter.

In the below example, we have two sets of font configurations, `myFont` and `myOtherFont`. `Times New Roman` is the preferred font in `myFont`. `-apple-system` is the preferred in `myOtherFont`.

```js
fonts: {
  myFont: [
    'Times New Roman',
    'Serif'
  ],
  myOtherFont: [
    '-apple-system',
    'system-ui'
  ]
},
```

The above fonts would be represented in your CSS file(s) as variables `$myFont` and `$myOtherFont`.

```css
h1 {
  font-family: $myFont;
}
```

#### `footerIcon` [string]

URL for a footer icon. Currently used in the `core/Footer.js` file provided as an example, but it can be removed from that file.

#### `gaTrackingId` [string]

Google Analytics tracking ID to track page views.

#### `gaGtag` [boolean]

Set this to `true` if you want to use [global site tags (gtag.js)](https://developers.google.com/gtagjs/) for Google analytics instead of `analytics.js`.

#### `githubHost` [string]

The hostname of your server. Useful if you are using GitHub Enterprise.

#### `highlight`

[Syntax highlighting](api-doc-markdown.md) options:

```js
{
  // ...
  highlight: {
    // The name of the theme used by Highlight.js when highlighting code.
    // You can find the list of supported themes here:
    // https://github.com/isagalaev/highlight.js/tree/master/src/styles
    theme: 'default',

    // The particular version of Highlight.js to be used.
    version: '9.12.0',

    // Escape valve by passing an instance of Highlight.js to the function specified here, allowing additional languages to be registered for syntax highlighting.
    hljs: function(highlightJsInstance) {
      // do something here
    },

    // Default language.
    // It will be used if one is not specified at the top of the code block. You can find the list of supported languages here:
    // https://github.com/isagalaev/highlight.js/tree/master/src/languages

    defaultLang: 'javascript',

    // custom URL of CSS theme file that you want to use with Highlight.js. If this is provided, the `theme` and `version` fields will be ignored.
    themeUrl: 'http://foo.bar/custom.css'
  },
}
```

#### `manifest` [string]

Path to your web app manifest (e.g., `manifest.json`). This will add a `<link>` tag to `<head>` with `rel` as `"manifest"` and `href` as the provided path.

#### `markdownOptions` [object]

Override default [Remarkable options](https://github.com/jonschlinkert/remarkable#options) that will be used to render markdown.

> To manage [syntax extensions](https://github.com/jonschlinkert/remarkable#syntax-extensions), use the `markdownPlugins` field.

#### `markdownPlugins` [array]

An array of plugins to be loaded by Remarkable, the markdown parser and renderer used by Docusaurus. The plugin will receive a reference to the Remarkable instance, allowing custom parsing and rendering rules to be defined.

For example, if you want to [enable superscript and subscript](https://github.com/jonschlinkert/remarkable#syntax-extensions) in your markdown that is rendered by Remarkable to HTML, you would do the following:

```
  markdownPlugins: [
    function foo(md) {
      md.inline.ruler.enable(['sub', 'sup']);
    },
  ],
```

#### `noIndex` [boolean]

Boolean. If true, Docusaurus will politely ask crawlers and search engines to avoid indexing your site. This is done with a header tag and so only applies to docs and pages. Will not attempt to hide static resources. This is a best effort request. Malicious crawlers can and will still index your site.

#### `ogImage` [string]

Local path to an Open Graph image (e.g., `img/myImage.png`). This image will show up when your site is shared on Facebook and other websites/apps where the Open Graph protocol is supported.

#### `onPageNav` [string]

If you want a visible navigation option for representing topics on the current page. Currently, there is one accepted value for this option:

- `separate` - The secondary navigation is a separate pane defaulting on the right side of a document. See http://docusaurus.io/docs/en/translation.html for an example.

#### `scripts` [array]

An array of JavaScript sources to load. The values can be either strings or plain objects of attribute-value maps. Refer to the example below. The script tag will be inserted in the HTML head.

#### `separateCss` [array]

Directories inside which any `CSS` files will not be processed and concatenated to Docusaurus' styles. This is to support static `HTML` pages that may be separate from Docusaurus with completely separate styles.

#### `scrollToTop` [boolean]

Set this to `true` if you want to enable the scroll to top button at the bottom of your site.

#### `scrollToTopOptions` [object]

Optional options configuration for the scroll to top button. You do not need to use this, even if you set `scrollToTop` to `true`; it just provides you more configuration control of the button. You can find more options [here](https://github.com/vfeskov/vanilla-back-to-top/blob/v7.1.14/OPTIONS.md). By default, we set the zIndex option to 100.

#### `stylesheets` [array]

An array of CSS sources to load. The values can be either strings or plain objects of attribute-value maps. The link tag will be inserted in the HTML head.

#### `translationRecruitingLink` [string]

URL for the `Help Translate` tab of language selection when languages besides English are enabled. This can be included you are using translations but does not have to be.

#### `twitter` [boolean]

Set this to `true` if you want a Twitter social button to appear at the bottom of your blog posts.

#### `twitterUsername` [string]

If you want a Twitter follow button at the bottom of your page, provide a Twitter username to follow. For example: `docusaurus`.

#### `twitterImage` [string]

Local path to your Twitter card image (e.g., `img/myImage.png`). This image will show up on the Twitter card when your site is shared on Twitter.

#### `useEnglishUrl` [string]

If you do not have [translations](guides-translation.md) enabled (e.g., by having a `languages.js` file), but still want a link of the form `/docs/en/doc.html` (with the `en`), set this to `true`.

#### `users` [array]

The `users` array mentioned earlier.

#### `usePrism` [array]

An array of languages to use Prism syntax highlighter. Refer to [Using Prism as additional syntax highlighter](api-doc-markdown.md#using-prism-as-additional-syntax-highlighter). Set it to `true` to use Prism on all languages.

#### `wrapPagesHTML` [boolean]

Boolean flag to indicate whether `HTML` files in `/pages` should be wrapped with Docusaurus site styles, header and footer. This feature is experimental and relies on the files being `HTML` fragments instead of complete pages. It inserts the contents of your `HTML` file with no extra processing. Defaults to `false`.

Users can also add their own custom fields if they wish to provide some data across different files.

## Adding Google Fonts

<!-- TODO: Shift this into a dedicated styling section in future -->

Google Fonts offers faster load times by caching fonts without forcing users to sacrifice privacy. For more information on Google Fonts, see the [Google Fonts](https://fonts.google.com/) documentation.

To add Google Fonts to your Docusaurus deployment, add the font path to the `siteConfig.js` under `stylesheets`:

```js
stylesheets: [
  'https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,400i,700',
],
```

## Example siteConfig.js with many available fields

```js
const users = [
  {
    caption: 'User1',
    image: '/test-site/img/docusaurus.svg',
    infoLink: 'https://www.example.com',
    pinned: true,
  },
];

const siteConfig = {
  title: 'Docusaurus',
  tagline: 'Generate websites!',
  url: 'https://docusaurus.io',
  baseUrl: '/',
  // For github.io type URLS, you would combine the URL and baseUrl like:
  // url: 'https://reasonml.github.io',
  // baseUrl: '/reason-react/',
  defaultVersionShown: '1.0.0',
  organizationName: 'facebook',
  projectName: 'docusaurus',
  noIndex: false,
  // For no header links in the top nav bar -> headerLinks: [],
  headerLinks: [
    {doc: 'doc1', label: 'Docs'},
    {page: 'help', label: 'Help'},
    {search: true},
    {blog: true},
  ],
  headerIcon: 'img/docusaurus.svg',
  favicon: 'img/favicon.png',
  colors: {
    primaryColor: '#2E8555',
    secondaryColor: '#205C3B',
  },
  editUrl: 'https://github.com/facebook/docusaurus/edit/master/docs/',
  // Users variable set above
  users,
  disableHeaderTitle: true,
  disableTitleTagline: true,
  separateCss: ['static/css/non-docusaurus', 'static/assets/separate-css'],
  footerIcon: 'img/docusaurus.svg',
  translationRecruitingLink: 'https://crowdin.com/project/docusaurus',
  algolia: {
    apiKey: '0f9f28b9ab9efae89810921a351753b5',
    indexName: 'github',
  },
  gaTrackingId: 'UA-12345678-9',
  highlight: {
    theme: 'default',
  },
  markdownPlugins: [
    function foo(md) {
      md.renderer.rules.fence_custom.foo = function (
        tokens,
        idx,
        options,
        env,
        instance,
      ) {
        return '<div class="foo">bar</div>';
      };
    },
  ],
  scripts: [
    'https://docusaurus.io/slash.js',
    {
      src:
        'https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.0/clipboard.min.js',
      async: true,
    },
  ],
  stylesheets: [
    'https://docusaurus.io/style.css',
    {
      href: 'http://css.link',
      type: 'text/css',
    },
  ],
  facebookAppId: '1615782811974223',
  facebookComments: true,
  facebookPixelId: '352490515235776',
  twitter: 'true',
  twitterUsername: 'docusaurus',
  twitterImage: 'img/docusaurus.png',
  ogImage: 'img/docusaurus.png',
  cleanUrl: true,
  scrollToTop: true,
  scrollToTopOptions: {
    zIndex: 100,
  },
};

module.exports = siteConfig;
```
