---
id: version-1.14.5-translation
title: Translations & Localization
original_id: translation
---

Docusaurus allows for useful translation functionality using [Crowdin](https://crowdin.com/). Documentation files written in English are uploaded to Crowdin for translation by users within a community. Top-level pages written with English strings can be translated by wrapping any strings you want to translate in a `<translate>` tag. Other titles and labels will also be found and properly translated.

## Docusaurus Translation Configurations

To generate example files for translations with Docusaurus, run the `examples` script with the command line argument `translations`:

```bash
npm run examples translations
```

or

```bash
yarn examples translations
```

This will create the following files:

```bash
pages/en/help-with-translations.js
languages.js
../crowdin.yaml
```

- The `pages/en/help-with-translations.js` file includes the same starter help page generated by the `examples` script but now includes translation tags.

> Generally, you will use `help-with-translations.js` as a guide to enable translations in your other pages, but not actually commit the file to your repo (i.e., you can delete it). However, if you want a Help page, and you currently do not have one, you can rename this file to `help.js` and use it as a starting point.

- The `languages.js` file tells Docusaurus what languages you want to enable for your site. By default, we expect English to be enabled.

- The `crowdin.yaml` file is used to configure Crowdin integration and is copied up one level into your Docusaurus project repo. If your Docusaurus project resides in `/project/website`, then `crowdin.yaml` will be copied to `/project/crowdin.yaml`.

## Translating Your Existing Docs

Your documentation files (e.g., the `.md` files that live in your `docs` directory) do not need to be changed or moved to support translations. They will be uploaded to Crowdin to be translated directly.

## Enabling Translations on Pages

Pages allow you to customize the layout and specific content of pages like a custom index page or help page.

Pages with text that you want translated should be placed in `website/pages/en` directory.

Wrap strings that you want translated in a `<translate>` tag, and add the following `require` statement to the top of the file:

```jsx
...
const translate = require('../../server/translate.js').translate;
...
<h2>
  <translate>This header will be translated</translate>
</h2>
...
```

You can also include an optional description attribute to give more context to a translator about how to translate the string:

```jsx
<p>
  <translate desc="flower, not verb">Rose</translate>
<p>
```

> The `<translate>` tag generally works well on pure strings. If you have a string like "Docusaurus currently provides support to help your website use [translations](${siteConfig.baseUrl}${siteConfig.docsUrl}/${this.props.language}/translation.html)", wrapping the `<translation>` tag around that entire string will cause issues because of the markdown linking, etc. Your options are to not translate those strings, or spread a bunch of `<translate>` tags amongst the pure substrings of that string.

## Gathering Strings to Translate

The strings within localized Pages must be extracted and provided to Crowdin.

Add the following script to your `website/package.json` file, if it does not exist already:

```js
{
  ...
  "scripts": {
    "write-translations": "docusaurus-write-translations"
  },
  ...
}
```

Running the script will generate a `website/i18n/en.json` file containing all the strings that will be translated from English into other languages.

The script will include text from the following places:

- `title` and `sidebar_label` strings in document markdown headers
- category names in `sidebars.json`
- tagline in `siteConfig.js`
- header link `label` strings in `siteConfig.js`
- strings wrapped in the `<translate>` tag in any `.js` files inside `pages`

### Custom Translation Strings

If you want to add additional custom translation strings or override any of the strings that get produced by the script that creates the `website/i18n/en.json` file, you can add a `website/data/custom-translation-strings.json` file. The file should have a form of:

```json
{
  "localized-strings": {
    "docs": {
      "id": {
        "title": "string1",
        "sidebar_label": "string2"
      },
      "version-0.0.1-id": {
        "title": "string3",
        "sidebar_label": "string4"
      }
    }
  },
  "pages-strings": {
    "id3": "string3",
    "id4": "string4"
  }
}
```

where `localized-strings` represent strings in your documentation content and `pages-strings` represents metadata in your documentation (e.g., title, links, etc).

Here is an example:

```json
{
  "_comment": "This file is used to provide custom strings for translations, including overriding defaults",
  "localized-strings": {
    "translation": "Translations and Localization"
  },
  "pages-strings": {
    "Help Translate|recruit community translators for your project": "Help Us Translate"
  }
}
```

See the generated `website/i18n/en.json` for an example.

## How Strings Get Translated

Docusaurus itself does not do any translation from one language to another. Instead, it integrates [Crowdin](https://crowdin.com/) to upload translations and then download the appropriately translated files from Crowdin.

## How Docusaurus Uses String Translations

This section provides context about how translations in Docusaurus works.

### Strings

A Docusaurus site has many strings used throughout it that require localization. However, maintaining a list of strings used throughout a site can be laborious. Docusaurus simplifies this by centralizing strings.

The header navigation, for example, can have links to 'Home' or your 'Blog'. This and other strings found in the headers and sidebars of pages are extracted and placed into `i18n/en.json`. When your files are translated, say into Spanish, an `i18n/es-ES.json` file will be downloaded from Crowdin. Then, when the Spanish pages are generated, Docusaurus will replace the English version of corresponding strings with translated strings from the corresponding localized strings file (e.g. In a Spanish enabled site 'Help' will become 'Ayuda').

### Markdown Files

For documentation files themselves, translated versions of these files are downloaded and then rendered through the proper layout template.

### Other Pages

For other pages, Docusaurus will automatically transform all `<translate>` tags it finds into function calls that return the translated strings from the corresponding localized file _`locale.json`_.

## Crowdin

Crowdin is a company that provides translation services. For Open Source projects, Crowdin provides free string translations.

Create your translation project on [Crowdin](https://crowdin.com/). You can use [Crowdin's guides](https://support.crowdin.com/translation-process-overview/) to learn more about the translations workflow. _We suggest that you deselect and do not include "English" as a translatable language to prevent the creation of `en-US` localization files as this can lead to confusion._

> Ensure in your Crowdin settings, in the Translations section, that "Duplicate Strings" are set to ["Hide - all duplicates will share the same translation"](https://support.crowdin.com/api/create-project/). This setting will ensure that identical strings between versions share a single translation.

Your project will need a `crowdin.yaml` file generated. If you ran `yarn examples translations` or `npm run examples translations`, this file was created for you on the same level as your `website` directory.

> You will need to install the `crowdin` command line interface. Please follow the [installation directions](https://support.crowdin.com/cli-tool/).

The example below can be automatically generated by the Docusaurus cli with the `examples` script. It should be placed in the top level of your project directory to configure how and what files are uploaded/downloaded.

Below is an example Crowdin configuration for the respective languages: German, Spanish, French, Japanese, Korean, Bahasa Indonesia, Portuguese Brazilian, Chinese Simplified, and Chinese Traditional.

```yaml
project_identifier_env: CROWDIN_DOCUSAURUS_PROJECT_ID
api_key_env: CROWDIN_DOCUSAURUS_API_KEY
base_path: './'
preserve_hierarchy: true

files:
  - source: '/docs/**/*.md'
    translation: '/website/translated_docs/%locale%/**/%original_file_name%'
    languages_mapping: &anchor
      locale:
        'de': 'de'
        'es-ES': 'es-ES'
        'fr': 'fr'
        'ja': 'ja'
        'ko': 'ko'
        'mr': 'mr-IN'
        'pt-BR': 'pt-BR'
        'zh-CN': 'zh-CN'
        'zh-TW': 'zh-TW'
```

You can go [here](https://support.crowdin.com/configuration-file/) to learn more about customizing your `crowdin.yaml` file.

### Setup the Crowdin Scripts

You will want to manually sync your files to and from Crowdin. The sync process will upload any markdown files in `/docs` as well as translatable strings in `website/i18n/en.json`. (These strings can be generated by running `yarn write-translations`.)

You can add the following to your `package.json` to manually trigger Crowdin.

```js
"scripts": {
  "crowdin-upload": "crowdin --config ../crowdin.yaml upload sources --auto-update -b master",
  "crowdin-download": "crowdin --config ../crowdin.yaml download -b master"
},
```

### Manual File Sync

You will always want to upload your markdown files and translatable strings first and download the translations section. So run the commands in this order:

```bash
CROWDIN_DOCUSAURUS_PROJECT_ID=YOUR_CROWDIN_PROJECT_ID CROWDIN_DOCUSAURUS_API_KEY=YOUR_CROWDIN_API_KEY yarn run crowdin-upload
CROWDIN_DOCUSAURUS_PROJECT_ID=YOUR_CROWDIN_PROJECT_ID CROWDIN_DOCUSAURUS_API_KEY=YOUR_CROWDIN_API_KEY yarn run crowdin-download
```

> `YOUR_CROWDIN_PROJECT_ID` is the name of your Crowdin project. e.g., for https://crowdin.com/project/docusaurus/, that variable would be set to `docusaurus`. `YOUR_CROWDIN_API_KEY` is a unique key that is like a password. You can find it in the `API` tab of your Crowdin project's `Settings`.

> These commands require having an environment variable set with your Crowdin project id and api key (`CROWDIN_PROJECT_ID`, `CROWDIN_API_KEY`). You can preface them inline as done above or add them permanently to your `.bashrc` or `.bash_profile`.

> If you run more than one localized Docusaurus project on your computer, you should change the name of the environment variables to something unique (`CROWDIN_PROJECTNAME_PROJECT_ID`, `CROWDIN_PROJECTNAME_API_KEY`).

> Since the files are generated, you do not need to have any files in your `website/i18n` or `website/translated_docs` directory as part of your repo. So you can can add `website/i18n/*` and `website/translated_docs` to your `.gitignore` file.

### Automated File Sync Using CircleCI

You can automate pulling down and uploading translations for your files using the [CircleCI](https://circleci.com) web continuous integration service.

First, update the `.circleci/config.yml` file in your project directory to include steps to upload English files to be translated and download translated files using the Crowdin CLI. Here is an example `.circleci/config.yml` file:

```yaml
# If you only want circle to run on direct commits to master, you can uncomment this out
# and uncomment the filters: *filter-only-master down below too
#
# aliases:
#  - &filter-only-master
#    branches:
#      only:
#        - master

version: 2
jobs:
  deploy-website:
    docker:
      # specify the version you desire here
      - image: circleci/node:8.11.1

    steps:
      - checkout
      - run:
          name: Deploying to GitHub Pages
          command: |
            git config --global user.email "<GITHUB_USERNAME>@users.noreply.github.com"
            git config --global user.name "<YOUR_NAME>"
            echo "machine github.com login <GITHUB_USERNAME> password $GITHUB_TOKEN" > ~/.netrc
            # install Docusaurus and generate file of English strings
            - cd website && yarn install && yarn run write-translations && cd ..
            # crowdin install
            - sudo apt-get install default-jre
            - wget https://artifacts.crowdin.com/repo/deb/crowdin.deb -O crowdin.deb
            - sudo dpkg -i crowdin.deb
            # translations upload/download
            - crowdin --config crowdin.yaml upload sources --auto-update -b master
            - crowdin --config crowdin.yaml download -b master
            # build and publish website
            cd website && GIT_USER=<GIT_USER> yarn run publish-gh-pages

workflows:
  version: 2
  build_and_deploy:
    jobs:
      - deploy-website:
#         filters: *filter-only-master
```

The `crowdin` command uses the `crowdin.yaml` file generated with the `examples` script. It should be placed in your project directory to configure how and what files are uploaded/downloaded.

Note that in the `crowdin.yaml` file, `CROWDIN_PROJECT_ID` and `CROWDIN_API_KEY` are environment variables set-up in Circle for your Crowdin project. They can be found in your Crowdin project settings.

Now, Circle will help you automatically get translations prior to building your website. The provided `crowdin.yaml` file will copy translated documents into `website/translated_docs/`, and translated versions of the `i18n/en.json` strings file will into `i18n/${language}.json`.

If you wish to use Crowdin on your machine locally, you can install the [Crowdin CLI tool](https://support.crowdin.com/cli-tool/) and run the same commands found in the `circle.yaml` file. The only difference is that you must set `project_identifier` and `api_key` values in the `crowdin.yaml` file since you will not have Circle environment variables set up.

## Versioned Translations

If you wish to have translation and versioning for your documentation, add the following section to the end of your `crowdin.yaml` file:

```yaml
  -
    source: '/website/versioned_docs/**/*.md'
    translation: '/website/translated_docs/%locale%/**/%original_file_name%'
    languages_mapping: *anchor
```

Translated, versioned documents will be copied into `website/translated_docs/${language}/${version}/`.
