/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

const users = [
  // Please add in alphabetical order of title.
  {
    title: 'Algolia Docsearch',
    description:
      'The best search experience for docs, integrates in minutes, for free',
    preview: require('./showcase/algolia.png'),
    website: 'https://docsearch.algolia.com/',
    source: 'https://github.com/algolia/docsearch-website',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Amphora Data',
    description: 'Connecting the world’s real-time information',
    preview: require('./showcase/amphora.png'),
    website: 'https://www.amphoradata.com/',
    source: 'https://github.com/amphoradata/amphoradata.github.io',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Axioms',
    description: 'Axioms Developer Hub and Documentation Portal',
    preview: require('./showcase/axioms.png'),
    website: 'https://developer.axioms.io/',
    source: 'https://github.com/axioms-io/developer',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Benthos',
    description: 'A stream processor for mundane tasks',
    preview: require('./showcase/benthos.png'),
    website: 'https://benthos.dev/',
    source: 'https://github.com/Jeffail/benthos',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Botonic',
    description: 'Build Chatbots and Conversational Apps Using React',
    preview: require('./showcase/botonic.png'),
    website: 'https://botonic.io/',
    source: 'https://github.com/hubtype/botonic',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Build Tracker',
    description:
      'Track performance budgets & prevent unexpected bloat in your app',
    preview: require('./showcase/build-tracker.png'),
    website: 'https://buildtracker.dev',
    source: 'https://github.com/paularmstrong/build-tracker',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Channel.js',
    description: 'The missing constructor for creating safe async iterators',
    preview: require('./showcase/channeljs.png'),
    website: 'https://repeater.js.org/',
    source: 'https://github.com/repeaterjs/repeater',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Clutch',
    description: 'An extensible API and UI platform for infrastructure tooling',
    preview: require('./showcase/clutch.png'),
    website: 'https://clutch.sh/',
    source: 'https://github.com/lyft/clutch',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Component Kit',
    description: 'A declarative UI framework for iOS',
    preview: require('./showcase/componentkit.png'),
    website: 'https://componentkit.org',
    source: 'https://github.com/facebook/componentkit',
    fbOpenSource: true,
    pinned: true,
  },
  {
    title: 'ConfigCat Feature Flags',
    description: 'A feature flag and remote configuration service.',
    preview: require('./showcase/configcat.png'),
    website: 'https://configcat.com/docs/',
    source: 'https://github.com/configcat/docs',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Eta',
    description: 'Faster embedded JS template engine in TypeScript',
    preview: require('./showcase/eta.png'),
    website: 'https://eta.js.org/',
    source: 'https://github.com/eta-dev/eta',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Flux',
    description: 'Application architecture for building user interfaces',
    preview: require('./showcase/flux.png'),
    website: 'https://facebook.github.io/flux/',
    source: 'https://github.com/facebook/flux',
    fbOpenSource: true,
    pinned: true,
  },
  {
    title: 'GraphQL Code Generator',
    description:
      'Generate code from your GraphQL schema and operations with a simple CLI',
    preview: require('./showcase/graphql-codegen.png'),
    website: 'https://graphql-code-generator.com/',
    source: 'https://github.com/dotansimha/graphql-code-generator',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'GraphQL Inspector',
    description: 'An open-source tool to help you work with GraphQL',
    preview: require('./showcase/graphql-inspector.png'),
    website: 'https://graphql-inspector.com',
    source: 'https://github.com/kamilkisiela/graphql-inspector',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'GraphQL Mesh',
    description: 'Query anything, run everywhere',
    preview: require('./showcase/graphql-mesh.png'),
    website: 'https://graphql-mesh.com',
    source: 'https://github.com/urigo/graphql-mesh',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Hermes',
    description: 'JavaScript engine optimized for React Native',
    preview: require('./showcase/hermes.png'),
    website: 'https://hermesengine.dev',
    source: 'https://github.com/facebook/hermes',
    fbOpenSource: true,
    pinned: true,
  },
  {
    title: 'MBT Bundle',
    description: 'An open source model-based testing tool',
    preview: require('./showcase/mbt-bundle.png'),
    website: 'https://mbtbundle.org',
    source: 'https://github.com/tienvx/mbt-bundle',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Motion Layout',
    description:
      'Create beautiful immersive React.js animations using shared components',
    preview: require('./showcase/motion-layout.png'),
    website: 'https://motion-layout.azurewebsites.net',
    source: 'https://github.com/jeffersonlicet/react-motion-layout',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Neutron JS',
    description: 'An open source CLI to work with Redux + Redux Saga',
    preview: require('./showcase/neutronjs.png'),
    website: 'https://www.neutronjs.com/',
    source: 'https://github.com/neutronjs/neutron-cli',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'NextAuth.js',
    description: 'An open source serverless authentication library for next.js',
    preview: require('./showcase/nextauthjs.png'),
    website: 'https://next-auth.js.org/',
    source: 'https://github.com/nextauthjs/next-auth',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Oxidizer',
    description: 'A Rust ORM based on tokio-postgres and refinery',
    preview: require('./showcase/oxidizer.png'),
    website: 'https://oxidizer.rs',
    source: 'https://github.com/oxidizer-rs/website',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'QA-Board',
    description:
      'An open source run-tracker for algorithm and performance engineering with rich visualizations',
    preview: require('./showcase/qa-board.png'),
    website: 'https://samsung.github.io/qaboard/',
    source: 'https://github.com/Samsung/qaboard',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'QuestDB',
    description:
      'An open source SQL database designed to process time series data',
    preview: require('./showcase/questdb.png'),
    website: 'https://questdb.io',
    source: 'https://github.com/questdb/questdb.io',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'React Native',
    description: 'A framework for building native apps using React',
    preview: require('./showcase/reactnative.png'),
    website: 'https://reactnative.dev',
    source: 'https://github.com/facebook/react-native-website',
    fbOpenSource: true,
    pinned: false,
  },
  {
    title: 'Runlet',
    description: 'A cloud-based job manager that integrates your devices',
    preview: require('./showcase/runlet.png'),
    website: 'https://runlet.app',
    source: 'https://github.com/runletapp/website',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'SpotifyAPI-NET',
    description: 'A Client for the Spotify Web API, written in C#/.NET',
    preview: require('./showcase/spotifyapi-net.png'),
    website: 'https://johnnycrazy.github.io/SpotifyAPI-NET/',
    source: 'https://github.com/JohnnyCrazy/SpotifyAPI-NET',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Supabase',
    description: 'Open Source Realtime and RESTful APIs for Postgres',
    preview: require('./showcase/supabase.png'),
    website: 'https://www.supabase.io/',
    source: 'https://github.com/supabase/monorepo',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'T-Regx',
    description: 'Programmer-oriented Regular Expressions library for PHP',
    preview: require('./showcase/t-regx.png'),
    website: 'https://t-regx.com/',
    source: 'https://github.com/T-Regx/T-Regx',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Taro',
    description: 'An open cross-end and cross-frame solution',
    preview: require('./showcase/docs-taro-zone.png'),
    website: 'https://docs.taro.zone/',
    source: 'https://github.com/NervJS/taro',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Tasit',
    description:
      'A JavaScript SDK for building native mobile Ethereum dapps with React Native',
    preview: require('./showcase/tasit.png'),
    website: 'https://docs.tasit.io/',
    source: 'https://github.com/tasitlabs/tasit-sdk',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Tourmaline',
    description:
      'Fast and performant Telegram bot framework for the Crystal programming language',
    preview: require('./showcase/tourmaline.png'),
    website: 'https://tourmaline.dev',
    source: 'https://github.com/protoncr/tourmaline',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'uniforms',
    description: 'A set of React libraries for building forms',
    preview: require('./showcase/uniforms.png'),
    website: 'https://uniforms.tools/',
    source: 'https://github.com/vazco/uniforms',
    fbOpenSource: false,
    pinned: false,
  },
  {
    title: 'Vector',
    description: 'A High-Performance, Logs, Metrics, & Events Router',
    preview: require('./showcase/vector.png'),
    website: 'https://vector.dev/',
    source: 'https://github.com/timberio/vector',
    fbOpenSource: false,
    pinned: true,
  },
  {
    title: 'Vue NodeGui',
    description: 'A cross-platform native desktop app library',
    preview: require('./showcase/vue-nodegui.png'),
    website: 'https://vue.nodegui.org/',
    source: 'https://github.com/nodegui/vue-nodegui',
    fbOpenSource: false,
    pinned: true,
  },
  {
    title: 'Wisdom',
    description: 'Session replay web analytics with open data SQL/S3 access.',
    preview: require('./showcase/wisdom.png'),
    website: 'https://developers.getwisdom.io/',
    source: 'https://github.com/Wisdom/dev-docs',
    fbOpenSource: false,
    pinned: true,
  },
];

users.forEach((user) => {
  if (
    !user.preview ||
    (user.preview instanceof String &&
      (user.preview.startsWith('http') || user.preview.startsWith('//')))
  ) {
    throw new Error(
      `Bad user site image preview = ${user.preview}. The image should be hosted on Docusaurus site, and not use remote HTTP or HTTPS URLs`,
    );
  }
});

export default users;
