module Oga
  module HTML
    module Entities
      ##
      # Hash mapping HTML entities to their Unicode character replacements.
      #
      # Based on the JSON output as listed at
      # http://www.w3.org/TR/html5/syntax.html#named-character-references
      #
      # @return [Hash]
      #
      DECODE_MAPPING = {
        '&Aacute;'                          => [193].pack('U*'),
        '&aacute;'                          => [225].pack('U*'),
        '&Abreve;'                          => [258].pack('U*'),
        '&abreve;'                          => [259].pack('U*'),
        '&ac;'                              => [8766].pack('U*'),
        '&acd;'                             => [8767].pack('U*'),
        '&acE;'                             => [8766, 819].pack('U*'),
        '&Acirc;'                           => [194].pack('U*'),
        '&acirc;'                           => [226].pack('U*'),
        '&acute;'                           => [180].pack('U*'),
        '&Acy;'                             => [1040].pack('U*'),
        '&acy;'                             => [1072].pack('U*'),
        '&AElig;'                           => [198].pack('U*'),
        '&aelig;'                           => [230].pack('U*'),
        '&af;'                              => [8289].pack('U*'),
        '&Afr;'                             => [120068].pack('U*'),
        '&afr;'                             => [120094].pack('U*'),
        '&Agrave;'                          => [192].pack('U*'),
        '&agrave;'                          => [224].pack('U*'),
        '&alefsym;'                         => [8501].pack('U*'),
        '&aleph;'                           => [8501].pack('U*'),
        '&Alpha;'                           => [913].pack('U*'),
        '&alpha;'                           => [945].pack('U*'),
        '&Amacr;'                           => [256].pack('U*'),
        '&amacr;'                           => [257].pack('U*'),
        '&amalg;'                           => [10815].pack('U*'),
        '&AMP;'                             => [38].pack('U*'),
        '&amp;'                             => [38].pack('U*'),
        '&And;'                             => [10835].pack('U*'),
        '&and;'                             => [8743].pack('U*'),
        '&andand;'                          => [10837].pack('U*'),
        '&andd;'                            => [10844].pack('U*'),
        '&andslope;'                        => [10840].pack('U*'),
        '&andv;'                            => [10842].pack('U*'),
        '&ang;'                             => [8736].pack('U*'),
        '&ange;'                            => [10660].pack('U*'),
        '&angle;'                           => [8736].pack('U*'),
        '&angmsd;'                          => [8737].pack('U*'),
        '&angmsdaa;'                        => [10664].pack('U*'),
        '&angmsdab;'                        => [10665].pack('U*'),
        '&angmsdac;'                        => [10666].pack('U*'),
        '&angmsdad;'                        => [10667].pack('U*'),
        '&angmsdae;'                        => [10668].pack('U*'),
        '&angmsdaf;'                        => [10669].pack('U*'),
        '&angmsdag;'                        => [10670].pack('U*'),
        '&angmsdah;'                        => [10671].pack('U*'),
        '&angrt;'                           => [8735].pack('U*'),
        '&angrtvb;'                         => [8894].pack('U*'),
        '&angrtvbd;'                        => [10653].pack('U*'),
        '&angsph;'                          => [8738].pack('U*'),
        '&angst;'                           => [197].pack('U*'),
        '&angzarr;'                         => [9084].pack('U*'),
        '&Aogon;'                           => [260].pack('U*'),
        '&aogon;'                           => [261].pack('U*'),
        '&Aopf;'                            => [120120].pack('U*'),
        '&aopf;'                            => [120146].pack('U*'),
        '&ap;'                              => [8776].pack('U*'),
        '&apacir;'                          => [10863].pack('U*'),
        '&apE;'                             => [10864].pack('U*'),
        '&ape;'                             => [8778].pack('U*'),
        '&apid;'                            => [8779].pack('U*'),
        '&apos;'                            => [39].pack('U*'),
        '&ApplyFunction;'                   => [8289].pack('U*'),
        '&approx;'                          => [8776].pack('U*'),
        '&approxeq;'                        => [8778].pack('U*'),
        '&Aring;'                           => [197].pack('U*'),
        '&aring;'                           => [229].pack('U*'),
        '&Ascr;'                            => [119964].pack('U*'),
        '&ascr;'                            => [119990].pack('U*'),
        '&Assign;'                          => [8788].pack('U*'),
        '&ast;'                             => [42].pack('U*'),
        '&asymp;'                           => [8776].pack('U*'),
        '&asympeq;'                         => [8781].pack('U*'),
        '&Atilde;'                          => [195].pack('U*'),
        '&atilde;'                          => [227].pack('U*'),
        '&Auml;'                            => [196].pack('U*'),
        '&auml;'                            => [228].pack('U*'),
        '&awconint;'                        => [8755].pack('U*'),
        '&awint;'                           => [10769].pack('U*'),
        '&backcong;'                        => [8780].pack('U*'),
        '&backepsilon;'                     => [1014].pack('U*'),
        '&backprime;'                       => [8245].pack('U*'),
        '&backsim;'                         => [8765].pack('U*'),
        '&backsimeq;'                       => [8909].pack('U*'),
        '&Backslash;'                       => [8726].pack('U*'),
        '&Barv;'                            => [10983].pack('U*'),
        '&barvee;'                          => [8893].pack('U*'),
        '&Barwed;'                          => [8966].pack('U*'),
        '&barwed;'                          => [8965].pack('U*'),
        '&barwedge;'                        => [8965].pack('U*'),
        '&bbrk;'                            => [9141].pack('U*'),
        '&bbrktbrk;'                        => [9142].pack('U*'),
        '&bcong;'                           => [8780].pack('U*'),
        '&Bcy;'                             => [1041].pack('U*'),
        '&bcy;'                             => [1073].pack('U*'),
        '&bdquo;'                           => [8222].pack('U*'),
        '&becaus;'                          => [8757].pack('U*'),
        '&Because;'                         => [8757].pack('U*'),
        '&because;'                         => [8757].pack('U*'),
        '&bemptyv;'                         => [10672].pack('U*'),
        '&bepsi;'                           => [1014].pack('U*'),
        '&bernou;'                          => [8492].pack('U*'),
        '&Bernoullis;'                      => [8492].pack('U*'),
        '&Beta;'                            => [914].pack('U*'),
        '&beta;'                            => [946].pack('U*'),
        '&beth;'                            => [8502].pack('U*'),
        '&between;'                         => [8812].pack('U*'),
        '&Bfr;'                             => [120069].pack('U*'),
        '&bfr;'                             => [120095].pack('U*'),
        '&bigcap;'                          => [8898].pack('U*'),
        '&bigcirc;'                         => [9711].pack('U*'),
        '&bigcup;'                          => [8899].pack('U*'),
        '&bigodot;'                         => [10752].pack('U*'),
        '&bigoplus;'                        => [10753].pack('U*'),
        '&bigotimes;'                       => [10754].pack('U*'),
        '&bigsqcup;'                        => [10758].pack('U*'),
        '&bigstar;'                         => [9733].pack('U*'),
        '&bigtriangledown;'                 => [9661].pack('U*'),
        '&bigtriangleup;'                   => [9651].pack('U*'),
        '&biguplus;'                        => [10756].pack('U*'),
        '&bigvee;'                          => [8897].pack('U*'),
        '&bigwedge;'                        => [8896].pack('U*'),
        '&bkarow;'                          => [10509].pack('U*'),
        '&blacklozenge;'                    => [10731].pack('U*'),
        '&blacksquare;'                     => [9642].pack('U*'),
        '&blacktriangle;'                   => [9652].pack('U*'),
        '&blacktriangledown;'               => [9662].pack('U*'),
        '&blacktriangleleft;'               => [9666].pack('U*'),
        '&blacktriangleright;'              => [9656].pack('U*'),
        '&blank;'                           => [9251].pack('U*'),
        '&blk12;'                           => [9618].pack('U*'),
        '&blk14;'                           => [9617].pack('U*'),
        '&blk34;'                           => [9619].pack('U*'),
        '&block;'                           => [9608].pack('U*'),
        '&bne;'                             => [61, 8421].pack('U*'),
        '&bnequiv;'                         => [8801, 8421].pack('U*'),
        '&bNot;'                            => [10989].pack('U*'),
        '&bnot;'                            => [8976].pack('U*'),
        '&Bopf;'                            => [120121].pack('U*'),
        '&bopf;'                            => [120147].pack('U*'),
        '&bot;'                             => [8869].pack('U*'),
        '&bottom;'                          => [8869].pack('U*'),
        '&bowtie;'                          => [8904].pack('U*'),
        '&boxbox;'                          => [10697].pack('U*'),
        '&boxDL;'                           => [9559].pack('U*'),
        '&boxDl;'                           => [9558].pack('U*'),
        '&boxdL;'                           => [9557].pack('U*'),
        '&boxdl;'                           => [9488].pack('U*'),
        '&boxDR;'                           => [9556].pack('U*'),
        '&boxDr;'                           => [9555].pack('U*'),
        '&boxdR;'                           => [9554].pack('U*'),
        '&boxdr;'                           => [9484].pack('U*'),
        '&boxH;'                            => [9552].pack('U*'),
        '&boxh;'                            => [9472].pack('U*'),
        '&boxHD;'                           => [9574].pack('U*'),
        '&boxHd;'                           => [9572].pack('U*'),
        '&boxhD;'                           => [9573].pack('U*'),
        '&boxhd;'                           => [9516].pack('U*'),
        '&boxHU;'                           => [9577].pack('U*'),
        '&boxHu;'                           => [9575].pack('U*'),
        '&boxhU;'                           => [9576].pack('U*'),
        '&boxhu;'                           => [9524].pack('U*'),
        '&boxminus;'                        => [8863].pack('U*'),
        '&boxplus;'                         => [8862].pack('U*'),
        '&boxtimes;'                        => [8864].pack('U*'),
        '&boxUL;'                           => [9565].pack('U*'),
        '&boxUl;'                           => [9564].pack('U*'),
        '&boxuL;'                           => [9563].pack('U*'),
        '&boxul;'                           => [9496].pack('U*'),
        '&boxUR;'                           => [9562].pack('U*'),
        '&boxUr;'                           => [9561].pack('U*'),
        '&boxuR;'                           => [9560].pack('U*'),
        '&boxur;'                           => [9492].pack('U*'),
        '&boxV;'                            => [9553].pack('U*'),
        '&boxv;'                            => [9474].pack('U*'),
        '&boxVH;'                           => [9580].pack('U*'),
        '&boxVh;'                           => [9579].pack('U*'),
        '&boxvH;'                           => [9578].pack('U*'),
        '&boxvh;'                           => [9532].pack('U*'),
        '&boxVL;'                           => [9571].pack('U*'),
        '&boxVl;'                           => [9570].pack('U*'),
        '&boxvL;'                           => [9569].pack('U*'),
        '&boxvl;'                           => [9508].pack('U*'),
        '&boxVR;'                           => [9568].pack('U*'),
        '&boxVr;'                           => [9567].pack('U*'),
        '&boxvR;'                           => [9566].pack('U*'),
        '&boxvr;'                           => [9500].pack('U*'),
        '&bprime;'                          => [8245].pack('U*'),
        '&Breve;'                           => [728].pack('U*'),
        '&breve;'                           => [728].pack('U*'),
        '&brvbar;'                          => [166].pack('U*'),
        '&Bscr;'                            => [8492].pack('U*'),
        '&bscr;'                            => [119991].pack('U*'),
        '&bsemi;'                           => [8271].pack('U*'),
        '&bsim;'                            => [8765].pack('U*'),
        '&bsime;'                           => [8909].pack('U*'),
        '&bsol;'                            => [92].pack('U*'),
        '&bsolb;'                           => [10693].pack('U*'),
        '&bsolhsub;'                        => [10184].pack('U*'),
        '&bull;'                            => [8226].pack('U*'),
        '&bullet;'                          => [8226].pack('U*'),
        '&bump;'                            => [8782].pack('U*'),
        '&bumpE;'                           => [10926].pack('U*'),
        '&bumpe;'                           => [8783].pack('U*'),
        '&Bumpeq;'                          => [8782].pack('U*'),
        '&bumpeq;'                          => [8783].pack('U*'),
        '&Cacute;'                          => [262].pack('U*'),
        '&cacute;'                          => [263].pack('U*'),
        '&Cap;'                             => [8914].pack('U*'),
        '&cap;'                             => [8745].pack('U*'),
        '&capand;'                          => [10820].pack('U*'),
        '&capbrcup;'                        => [10825].pack('U*'),
        '&capcap;'                          => [10827].pack('U*'),
        '&capcup;'                          => [10823].pack('U*'),
        '&capdot;'                          => [10816].pack('U*'),
        '&CapitalDifferentialD;'            => [8517].pack('U*'),
        '&caps;'                            => [8745, 65024].pack('U*'),
        '&caret;'                           => [8257].pack('U*'),
        '&caron;'                           => [711].pack('U*'),
        '&Cayleys;'                         => [8493].pack('U*'),
        '&ccaps;'                           => [10829].pack('U*'),
        '&Ccaron;'                          => [268].pack('U*'),
        '&ccaron;'                          => [269].pack('U*'),
        '&Ccedil;'                          => [199].pack('U*'),
        '&ccedil;'                          => [231].pack('U*'),
        '&Ccirc;'                           => [264].pack('U*'),
        '&ccirc;'                           => [265].pack('U*'),
        '&Cconint;'                         => [8752].pack('U*'),
        '&ccups;'                           => [10828].pack('U*'),
        '&ccupssm;'                         => [10832].pack('U*'),
        '&Cdot;'                            => [266].pack('U*'),
        '&cdot;'                            => [267].pack('U*'),
        '&cedil;'                           => [184].pack('U*'),
        '&Cedilla;'                         => [184].pack('U*'),
        '&cemptyv;'                         => [10674].pack('U*'),
        '&cent;'                            => [162].pack('U*'),
        '&CenterDot;'                       => [183].pack('U*'),
        '&centerdot;'                       => [183].pack('U*'),
        '&Cfr;'                             => [8493].pack('U*'),
        '&cfr;'                             => [120096].pack('U*'),
        '&CHcy;'                            => [1063].pack('U*'),
        '&chcy;'                            => [1095].pack('U*'),
        '&check;'                           => [10003].pack('U*'),
        '&checkmark;'                       => [10003].pack('U*'),
        '&Chi;'                             => [935].pack('U*'),
        '&chi;'                             => [967].pack('U*'),
        '&cir;'                             => [9675].pack('U*'),
        '&circ;'                            => [710].pack('U*'),
        '&circeq;'                          => [8791].pack('U*'),
        '&circlearrowleft;'                 => [8634].pack('U*'),
        '&circlearrowright;'                => [8635].pack('U*'),
        '&circledast;'                      => [8859].pack('U*'),
        '&circledcirc;'                     => [8858].pack('U*'),
        '&circleddash;'                     => [8861].pack('U*'),
        '&CircleDot;'                       => [8857].pack('U*'),
        '&circledR;'                        => [174].pack('U*'),
        '&circledS;'                        => [9416].pack('U*'),
        '&CircleMinus;'                     => [8854].pack('U*'),
        '&CirclePlus;'                      => [8853].pack('U*'),
        '&CircleTimes;'                     => [8855].pack('U*'),
        '&cirE;'                            => [10691].pack('U*'),
        '&cire;'                            => [8791].pack('U*'),
        '&cirfnint;'                        => [10768].pack('U*'),
        '&cirmid;'                          => [10991].pack('U*'),
        '&cirscir;'                         => [10690].pack('U*'),
        '&ClockwiseContourIntegral;'        => [8754].pack('U*'),
        '&CloseCurlyDoubleQuote;'           => [8221].pack('U*'),
        '&CloseCurlyQuote;'                 => [8217].pack('U*'),
        '&clubs;'                           => [9827].pack('U*'),
        '&clubsuit;'                        => [9827].pack('U*'),
        '&Colon;'                           => [8759].pack('U*'),
        '&colon;'                           => [58].pack('U*'),
        '&Colone;'                          => [10868].pack('U*'),
        '&colone;'                          => [8788].pack('U*'),
        '&coloneq;'                         => [8788].pack('U*'),
        '&comma;'                           => [44].pack('U*'),
        '&commat;'                          => [64].pack('U*'),
        '&comp;'                            => [8705].pack('U*'),
        '&compfn;'                          => [8728].pack('U*'),
        '&complement;'                      => [8705].pack('U*'),
        '&complexes;'                       => [8450].pack('U*'),
        '&cong;'                            => [8773].pack('U*'),
        '&congdot;'                         => [10861].pack('U*'),
        '&Congruent;'                       => [8801].pack('U*'),
        '&Conint;'                          => [8751].pack('U*'),
        '&conint;'                          => [8750].pack('U*'),
        '&ContourIntegral;'                 => [8750].pack('U*'),
        '&Copf;'                            => [8450].pack('U*'),
        '&copf;'                            => [120148].pack('U*'),
        '&coprod;'                          => [8720].pack('U*'),
        '&Coproduct;'                       => [8720].pack('U*'),
        '&COPY;'                            => [169].pack('U*'),
        '&copy;'                            => [169].pack('U*'),
        '&copysr;'                          => [8471].pack('U*'),
        '&CounterClockwiseContourIntegral;' => [8755].pack('U*'),
        '&crarr;'                           => [8629].pack('U*'),
        '&Cross;'                           => [10799].pack('U*'),
        '&cross;'                           => [10007].pack('U*'),
        '&Cscr;'                            => [119966].pack('U*'),
        '&cscr;'                            => [119992].pack('U*'),
        '&csub;'                            => [10959].pack('U*'),
        '&csube;'                           => [10961].pack('U*'),
        '&csup;'                            => [10960].pack('U*'),
        '&csupe;'                           => [10962].pack('U*'),
        '&ctdot;'                           => [8943].pack('U*'),
        '&cudarrl;'                         => [10552].pack('U*'),
        '&cudarrr;'                         => [10549].pack('U*'),
        '&cuepr;'                           => [8926].pack('U*'),
        '&cuesc;'                           => [8927].pack('U*'),
        '&cularr;'                          => [8630].pack('U*'),
        '&cularrp;'                         => [10557].pack('U*'),
        '&Cup;'                             => [8915].pack('U*'),
        '&cup;'                             => [8746].pack('U*'),
        '&cupbrcap;'                        => [10824].pack('U*'),
        '&CupCap;'                          => [8781].pack('U*'),
        '&cupcap;'                          => [10822].pack('U*'),
        '&cupcup;'                          => [10826].pack('U*'),
        '&cupdot;'                          => [8845].pack('U*'),
        '&cupor;'                           => [10821].pack('U*'),
        '&cups;'                            => [8746, 65024].pack('U*'),
        '&curarr;'                          => [8631].pack('U*'),
        '&curarrm;'                         => [10556].pack('U*'),
        '&curlyeqprec;'                     => [8926].pack('U*'),
        '&curlyeqsucc;'                     => [8927].pack('U*'),
        '&curlyvee;'                        => [8910].pack('U*'),
        '&curlywedge;'                      => [8911].pack('U*'),
        '&curren;'                          => [164].pack('U*'),
        '&curvearrowleft;'                  => [8630].pack('U*'),
        '&curvearrowright;'                 => [8631].pack('U*'),
        '&cuvee;'                           => [8910].pack('U*'),
        '&cuwed;'                           => [8911].pack('U*'),
        '&cwconint;'                        => [8754].pack('U*'),
        '&cwint;'                           => [8753].pack('U*'),
        '&cylcty;'                          => [9005].pack('U*'),
        '&Dagger;'                          => [8225].pack('U*'),
        '&dagger;'                          => [8224].pack('U*'),
        '&daleth;'                          => [8504].pack('U*'),
        '&Darr;'                            => [8609].pack('U*'),
        '&dArr;'                            => [8659].pack('U*'),
        '&darr;'                            => [8595].pack('U*'),
        '&dash;'                            => [8208].pack('U*'),
        '&Dashv;'                           => [10980].pack('U*'),
        '&dashv;'                           => [8867].pack('U*'),
        '&dbkarow;'                         => [10511].pack('U*'),
        '&dblac;'                           => [733].pack('U*'),
        '&Dcaron;'                          => [270].pack('U*'),
        '&dcaron;'                          => [271].pack('U*'),
        '&Dcy;'                             => [1044].pack('U*'),
        '&dcy;'                             => [1076].pack('U*'),
        '&DD;'                              => [8517].pack('U*'),
        '&dd;'                              => [8518].pack('U*'),
        '&ddagger;'                         => [8225].pack('U*'),
        '&ddarr;'                           => [8650].pack('U*'),
        '&DDotrahd;'                        => [10513].pack('U*'),
        '&ddotseq;'                         => [10871].pack('U*'),
        '&deg;'                             => [176].pack('U*'),
        '&Del;'                             => [8711].pack('U*'),
        '&Delta;'                           => [916].pack('U*'),
        '&delta;'                           => [948].pack('U*'),
        '&demptyv;'                         => [10673].pack('U*'),
        '&dfisht;'                          => [10623].pack('U*'),
        '&Dfr;'                             => [120071].pack('U*'),
        '&dfr;'                             => [120097].pack('U*'),
        '&dHar;'                            => [10597].pack('U*'),
        '&dharl;'                           => [8643].pack('U*'),
        '&dharr;'                           => [8642].pack('U*'),
        '&DiacriticalAcute;'                => [180].pack('U*'),
        '&DiacriticalDot;'                  => [729].pack('U*'),
        '&DiacriticalDoubleAcute;'          => [733].pack('U*'),
        '&DiacriticalGrave;'                => [96].pack('U*'),
        '&DiacriticalTilde;'                => [732].pack('U*'),
        '&diam;'                            => [8900].pack('U*'),
        '&Diamond;'                         => [8900].pack('U*'),
        '&diamond;'                         => [8900].pack('U*'),
        '&diamondsuit;'                     => [9830].pack('U*'),
        '&diams;'                           => [9830].pack('U*'),
        '&die;'                             => [168].pack('U*'),
        '&DifferentialD;'                   => [8518].pack('U*'),
        '&digamma;'                         => [989].pack('U*'),
        '&disin;'                           => [8946].pack('U*'),
        '&div;'                             => [247].pack('U*'),
        '&divide;'                          => [247].pack('U*'),
        '&divideontimes;'                   => [8903].pack('U*'),
        '&divonx;'                          => [8903].pack('U*'),
        '&DJcy;'                            => [1026].pack('U*'),
        '&djcy;'                            => [1106].pack('U*'),
        '&dlcorn;'                          => [8990].pack('U*'),
        '&dlcrop;'                          => [8973].pack('U*'),
        '&dollar;'                          => [36].pack('U*'),
        '&Dopf;'                            => [120123].pack('U*'),
        '&dopf;'                            => [120149].pack('U*'),
        '&Dot;'                             => [168].pack('U*'),
        '&dot;'                             => [729].pack('U*'),
        '&DotDot;'                          => [8412].pack('U*'),
        '&doteq;'                           => [8784].pack('U*'),
        '&doteqdot;'                        => [8785].pack('U*'),
        '&DotEqual;'                        => [8784].pack('U*'),
        '&dotminus;'                        => [8760].pack('U*'),
        '&dotplus;'                         => [8724].pack('U*'),
        '&dotsquare;'                       => [8865].pack('U*'),
        '&doublebarwedge;'                  => [8966].pack('U*'),
        '&DoubleContourIntegral;'           => [8751].pack('U*'),
        '&DoubleDot;'                       => [168].pack('U*'),
        '&DoubleDownArrow;'                 => [8659].pack('U*'),
        '&DoubleLeftArrow;'                 => [8656].pack('U*'),
        '&DoubleLeftRightArrow;'            => [8660].pack('U*'),
        '&DoubleLeftTee;'                   => [10980].pack('U*'),
        '&DoubleLongLeftArrow;'             => [10232].pack('U*'),
        '&DoubleLongLeftRightArrow;'        => [10234].pack('U*'),
        '&DoubleLongRightArrow;'            => [10233].pack('U*'),
        '&DoubleRightArrow;'                => [8658].pack('U*'),
        '&DoubleRightTee;'                  => [8872].pack('U*'),
        '&DoubleUpArrow;'                   => [8657].pack('U*'),
        '&DoubleUpDownArrow;'               => [8661].pack('U*'),
        '&DoubleVerticalBar;'               => [8741].pack('U*'),
        '&DownArrow;'                       => [8595].pack('U*'),
        '&Downarrow;'                       => [8659].pack('U*'),
        '&downarrow;'                       => [8595].pack('U*'),
        '&DownArrowBar;'                    => [10515].pack('U*'),
        '&DownArrowUpArrow;'                => [8693].pack('U*'),
        '&DownBreve;'                       => [785].pack('U*'),
        '&downdownarrows;'                  => [8650].pack('U*'),
        '&downharpoonleft;'                 => [8643].pack('U*'),
        '&downharpoonright;'                => [8642].pack('U*'),
        '&DownLeftRightVector;'             => [10576].pack('U*'),
        '&DownLeftTeeVector;'               => [10590].pack('U*'),
        '&DownLeftVector;'                  => [8637].pack('U*'),
        '&DownLeftVectorBar;'               => [10582].pack('U*'),
        '&DownRightTeeVector;'              => [10591].pack('U*'),
        '&DownRightVector;'                 => [8641].pack('U*'),
        '&DownRightVectorBar;'              => [10583].pack('U*'),
        '&DownTee;'                         => [8868].pack('U*'),
        '&DownTeeArrow;'                    => [8615].pack('U*'),
        '&drbkarow;'                        => [10512].pack('U*'),
        '&drcorn;'                          => [8991].pack('U*'),
        '&drcrop;'                          => [8972].pack('U*'),
        '&Dscr;'                            => [119967].pack('U*'),
        '&dscr;'                            => [119993].pack('U*'),
        '&DScy;'                            => [1029].pack('U*'),
        '&dscy;'                            => [1109].pack('U*'),
        '&dsol;'                            => [10742].pack('U*'),
        '&Dstrok;'                          => [272].pack('U*'),
        '&dstrok;'                          => [273].pack('U*'),
        '&dtdot;'                           => [8945].pack('U*'),
        '&dtri;'                            => [9663].pack('U*'),
        '&dtrif;'                           => [9662].pack('U*'),
        '&duarr;'                           => [8693].pack('U*'),
        '&duhar;'                           => [10607].pack('U*'),
        '&dwangle;'                         => [10662].pack('U*'),
        '&DZcy;'                            => [1039].pack('U*'),
        '&dzcy;'                            => [1119].pack('U*'),
        '&dzigrarr;'                        => [10239].pack('U*'),
        '&Eacute;'                          => [201].pack('U*'),
        '&eacute;'                          => [233].pack('U*'),
        '&easter;'                          => [10862].pack('U*'),
        '&Ecaron;'                          => [282].pack('U*'),
        '&ecaron;'                          => [283].pack('U*'),
        '&ecir;'                            => [8790].pack('U*'),
        '&Ecirc;'                           => [202].pack('U*'),
        '&ecirc;'                           => [234].pack('U*'),
        '&ecolon;'                          => [8789].pack('U*'),
        '&Ecy;'                             => [1069].pack('U*'),
        '&ecy;'                             => [1101].pack('U*'),
        '&eDDot;'                           => [10871].pack('U*'),
        '&Edot;'                            => [278].pack('U*'),
        '&eDot;'                            => [8785].pack('U*'),
        '&edot;'                            => [279].pack('U*'),
        '&ee;'                              => [8519].pack('U*'),
        '&efDot;'                           => [8786].pack('U*'),
        '&Efr;'                             => [120072].pack('U*'),
        '&efr;'                             => [120098].pack('U*'),
        '&eg;'                              => [10906].pack('U*'),
        '&Egrave;'                          => [200].pack('U*'),
        '&egrave;'                          => [232].pack('U*'),
        '&egs;'                             => [10902].pack('U*'),
        '&egsdot;'                          => [10904].pack('U*'),
        '&el;'                              => [10905].pack('U*'),
        '&Element;'                         => [8712].pack('U*'),
        '&elinters;'                        => [9191].pack('U*'),
        '&ell;'                             => [8467].pack('U*'),
        '&els;'                             => [10901].pack('U*'),
        '&elsdot;'                          => [10903].pack('U*'),
        '&Emacr;'                           => [274].pack('U*'),
        '&emacr;'                           => [275].pack('U*'),
        '&empty;'                           => [8709].pack('U*'),
        '&emptyset;'                        => [8709].pack('U*'),
        '&EmptySmallSquare;'                => [9723].pack('U*'),
        '&emptyv;'                          => [8709].pack('U*'),
        '&EmptyVerySmallSquare;'            => [9643].pack('U*'),
        '&emsp;'                            => [8195].pack('U*'),
        '&emsp13;'                          => [8196].pack('U*'),
        '&emsp14;'                          => [8197].pack('U*'),
        '&ENG;'                             => [330].pack('U*'),
        '&eng;'                             => [331].pack('U*'),
        '&ensp;'                            => [8194].pack('U*'),
        '&Eogon;'                           => [280].pack('U*'),
        '&eogon;'                           => [281].pack('U*'),
        '&Eopf;'                            => [120124].pack('U*'),
        '&eopf;'                            => [120150].pack('U*'),
        '&epar;'                            => [8917].pack('U*'),
        '&eparsl;'                          => [10723].pack('U*'),
        '&eplus;'                           => [10865].pack('U*'),
        '&epsi;'                            => [949].pack('U*'),
        '&Epsilon;'                         => [917].pack('U*'),
        '&epsilon;'                         => [949].pack('U*'),
        '&epsiv;'                           => [1013].pack('U*'),
        '&eqcirc;'                          => [8790].pack('U*'),
        '&eqcolon;'                         => [8789].pack('U*'),
        '&eqsim;'                           => [8770].pack('U*'),
        '&eqslantgtr;'                      => [10902].pack('U*'),
        '&eqslantless;'                     => [10901].pack('U*'),
        '&Equal;'                           => [10869].pack('U*'),
        '&equals;'                          => [61].pack('U*'),
        '&EqualTilde;'                      => [8770].pack('U*'),
        '&equest;'                          => [8799].pack('U*'),
        '&Equilibrium;'                     => [8652].pack('U*'),
        '&equiv;'                           => [8801].pack('U*'),
        '&equivDD;'                         => [10872].pack('U*'),
        '&eqvparsl;'                        => [10725].pack('U*'),
        '&erarr;'                           => [10609].pack('U*'),
        '&erDot;'                           => [8787].pack('U*'),
        '&Escr;'                            => [8496].pack('U*'),
        '&escr;'                            => [8495].pack('U*'),
        '&esdot;'                           => [8784].pack('U*'),
        '&Esim;'                            => [10867].pack('U*'),
        '&esim;'                            => [8770].pack('U*'),
        '&Eta;'                             => [919].pack('U*'),
        '&eta;'                             => [951].pack('U*'),
        '&ETH;'                             => [208].pack('U*'),
        '&eth;'                             => [240].pack('U*'),
        '&Euml;'                            => [203].pack('U*'),
        '&euml;'                            => [235].pack('U*'),
        '&euro;'                            => [8364].pack('U*'),
        '&excl;'                            => [33].pack('U*'),
        '&exist;'                           => [8707].pack('U*'),
        '&Exists;'                          => [8707].pack('U*'),
        '&expectation;'                     => [8496].pack('U*'),
        '&ExponentialE;'                    => [8519].pack('U*'),
        '&exponentiale;'                    => [8519].pack('U*'),
        '&fallingdotseq;'                   => [8786].pack('U*'),
        '&Fcy;'                             => [1060].pack('U*'),
        '&fcy;'                             => [1092].pack('U*'),
        '&female;'                          => [9792].pack('U*'),
        '&ffilig;'                          => [64259].pack('U*'),
        '&fflig;'                           => [64256].pack('U*'),
        '&ffllig;'                          => [64260].pack('U*'),
        '&Ffr;'                             => [120073].pack('U*'),
        '&ffr;'                             => [120099].pack('U*'),
        '&filig;'                           => [64257].pack('U*'),
        '&FilledSmallSquare;'               => [9724].pack('U*'),
        '&FilledVerySmallSquare;'           => [9642].pack('U*'),
        '&fjlig;'                           => [102, 106].pack('U*'),
        '&flat;'                            => [9837].pack('U*'),
        '&fllig;'                           => [64258].pack('U*'),
        '&fltns;'                           => [9649].pack('U*'),
        '&fnof;'                            => [402].pack('U*'),
        '&Fopf;'                            => [120125].pack('U*'),
        '&fopf;'                            => [120151].pack('U*'),
        '&ForAll;'                          => [8704].pack('U*'),
        '&forall;'                          => [8704].pack('U*'),
        '&fork;'                            => [8916].pack('U*'),
        '&forkv;'                           => [10969].pack('U*'),
        '&Fouriertrf;'                      => [8497].pack('U*'),
        '&fpartint;'                        => [10765].pack('U*'),
        '&frac12;'                          => [189].pack('U*'),
        '&frac13;'                          => [8531].pack('U*'),
        '&frac14;'                          => [188].pack('U*'),
        '&frac15;'                          => [8533].pack('U*'),
        '&frac16;'                          => [8537].pack('U*'),
        '&frac18;'                          => [8539].pack('U*'),
        '&frac23;'                          => [8532].pack('U*'),
        '&frac25;'                          => [8534].pack('U*'),
        '&frac34;'                          => [190].pack('U*'),
        '&frac35;'                          => [8535].pack('U*'),
        '&frac38;'                          => [8540].pack('U*'),
        '&frac45;'                          => [8536].pack('U*'),
        '&frac56;'                          => [8538].pack('U*'),
        '&frac58;'                          => [8541].pack('U*'),
        '&frac78;'                          => [8542].pack('U*'),
        '&frasl;'                           => [8260].pack('U*'),
        '&frown;'                           => [8994].pack('U*'),
        '&Fscr;'                            => [8497].pack('U*'),
        '&fscr;'                            => [119995].pack('U*'),
        '&gacute;'                          => [501].pack('U*'),
        '&Gamma;'                           => [915].pack('U*'),
        '&gamma;'                           => [947].pack('U*'),
        '&Gammad;'                          => [988].pack('U*'),
        '&gammad;'                          => [989].pack('U*'),
        '&gap;'                             => [10886].pack('U*'),
        '&Gbreve;'                          => [286].pack('U*'),
        '&gbreve;'                          => [287].pack('U*'),
        '&Gcedil;'                          => [290].pack('U*'),
        '&Gcirc;'                           => [284].pack('U*'),
        '&gcirc;'                           => [285].pack('U*'),
        '&Gcy;'                             => [1043].pack('U*'),
        '&gcy;'                             => [1075].pack('U*'),
        '&Gdot;'                            => [288].pack('U*'),
        '&gdot;'                            => [289].pack('U*'),
        '&gE;'                              => [8807].pack('U*'),
        '&ge;'                              => [8805].pack('U*'),
        '&gEl;'                             => [10892].pack('U*'),
        '&gel;'                             => [8923].pack('U*'),
        '&geq;'                             => [8805].pack('U*'),
        '&geqq;'                            => [8807].pack('U*'),
        '&geqslant;'                        => [10878].pack('U*'),
        '&ges;'                             => [10878].pack('U*'),
        '&gescc;'                           => [10921].pack('U*'),
        '&gesdot;'                          => [10880].pack('U*'),
        '&gesdoto;'                         => [10882].pack('U*'),
        '&gesdotol;'                        => [10884].pack('U*'),
        '&gesl;'                            => [8923, 65024].pack('U*'),
        '&gesles;'                          => [10900].pack('U*'),
        '&Gfr;'                             => [120074].pack('U*'),
        '&gfr;'                             => [120100].pack('U*'),
        '&Gg;'                              => [8921].pack('U*'),
        '&gg;'                              => [8811].pack('U*'),
        '&ggg;'                             => [8921].pack('U*'),
        '&gimel;'                           => [8503].pack('U*'),
        '&GJcy;'                            => [1027].pack('U*'),
        '&gjcy;'                            => [1107].pack('U*'),
        '&gl;'                              => [8823].pack('U*'),
        '&gla;'                             => [10917].pack('U*'),
        '&glE;'                             => [10898].pack('U*'),
        '&glj;'                             => [10916].pack('U*'),
        '&gnap;'                            => [10890].pack('U*'),
        '&gnapprox;'                        => [10890].pack('U*'),
        '&gnE;'                             => [8809].pack('U*'),
        '&gne;'                             => [10888].pack('U*'),
        '&gneq;'                            => [10888].pack('U*'),
        '&gneqq;'                           => [8809].pack('U*'),
        '&gnsim;'                           => [8935].pack('U*'),
        '&Gopf;'                            => [120126].pack('U*'),
        '&gopf;'                            => [120152].pack('U*'),
        '&grave;'                           => [96].pack('U*'),
        '&GreaterEqual;'                    => [8805].pack('U*'),
        '&GreaterEqualLess;'                => [8923].pack('U*'),
        '&GreaterFullEqual;'                => [8807].pack('U*'),
        '&GreaterGreater;'                  => [10914].pack('U*'),
        '&GreaterLess;'                     => [8823].pack('U*'),
        '&GreaterSlantEqual;'               => [10878].pack('U*'),
        '&GreaterTilde;'                    => [8819].pack('U*'),
        '&Gscr;'                            => [119970].pack('U*'),
        '&gscr;'                            => [8458].pack('U*'),
        '&gsim;'                            => [8819].pack('U*'),
        '&gsime;'                           => [10894].pack('U*'),
        '&gsiml;'                           => [10896].pack('U*'),
        '&GT;'                              => [62].pack('U*'),
        '&Gt;'                              => [8811].pack('U*'),
        '&gt;'                              => [62].pack('U*'),
        '&gtcc;'                            => [10919].pack('U*'),
        '&gtcir;'                           => [10874].pack('U*'),
        '&gtdot;'                           => [8919].pack('U*'),
        '&gtlPar;'                          => [10645].pack('U*'),
        '&gtquest;'                         => [10876].pack('U*'),
        '&gtrapprox;'                       => [10886].pack('U*'),
        '&gtrarr;'                          => [10616].pack('U*'),
        '&gtrdot;'                          => [8919].pack('U*'),
        '&gtreqless;'                       => [8923].pack('U*'),
        '&gtreqqless;'                      => [10892].pack('U*'),
        '&gtrless;'                         => [8823].pack('U*'),
        '&gtrsim;'                          => [8819].pack('U*'),
        '&gvertneqq;'                       => [8809, 65024].pack('U*'),
        '&gvnE;'                            => [8809, 65024].pack('U*'),
        '&Hacek;'                           => [711].pack('U*'),
        '&hairsp;'                          => [8202].pack('U*'),
        '&half;'                            => [189].pack('U*'),
        '&hamilt;'                          => [8459].pack('U*'),
        '&HARDcy;'                          => [1066].pack('U*'),
        '&hardcy;'                          => [1098].pack('U*'),
        '&hArr;'                            => [8660].pack('U*'),
        '&harr;'                            => [8596].pack('U*'),
        '&harrcir;'                         => [10568].pack('U*'),
        '&harrw;'                           => [8621].pack('U*'),
        '&Hat;'                             => [94].pack('U*'),
        '&hbar;'                            => [8463].pack('U*'),
        '&Hcirc;'                           => [292].pack('U*'),
        '&hcirc;'                           => [293].pack('U*'),
        '&hearts;'                          => [9829].pack('U*'),
        '&heartsuit;'                       => [9829].pack('U*'),
        '&hellip;'                          => [8230].pack('U*'),
        '&hercon;'                          => [8889].pack('U*'),
        '&Hfr;'                             => [8460].pack('U*'),
        '&hfr;'                             => [120101].pack('U*'),
        '&HilbertSpace;'                    => [8459].pack('U*'),
        '&hksearow;'                        => [10533].pack('U*'),
        '&hkswarow;'                        => [10534].pack('U*'),
        '&hoarr;'                           => [8703].pack('U*'),
        '&homtht;'                          => [8763].pack('U*'),
        '&hookleftarrow;'                   => [8617].pack('U*'),
        '&hookrightarrow;'                  => [8618].pack('U*'),
        '&Hopf;'                            => [8461].pack('U*'),
        '&hopf;'                            => [120153].pack('U*'),
        '&horbar;'                          => [8213].pack('U*'),
        '&HorizontalLine;'                  => [9472].pack('U*'),
        '&Hscr;'                            => [8459].pack('U*'),
        '&hscr;'                            => [119997].pack('U*'),
        '&hslash;'                          => [8463].pack('U*'),
        '&Hstrok;'                          => [294].pack('U*'),
        '&hstrok;'                          => [295].pack('U*'),
        '&HumpDownHump;'                    => [8782].pack('U*'),
        '&HumpEqual;'                       => [8783].pack('U*'),
        '&hybull;'                          => [8259].pack('U*'),
        '&hyphen;'                          => [8208].pack('U*'),
        '&Iacute;'                          => [205].pack('U*'),
        '&iacute;'                          => [237].pack('U*'),
        '&ic;'                              => [8291].pack('U*'),
        '&Icirc;'                           => [206].pack('U*'),
        '&icirc;'                           => [238].pack('U*'),
        '&Icy;'                             => [1048].pack('U*'),
        '&icy;'                             => [1080].pack('U*'),
        '&Idot;'                            => [304].pack('U*'),
        '&IEcy;'                            => [1045].pack('U*'),
        '&iecy;'                            => [1077].pack('U*'),
        '&iexcl;'                           => [161].pack('U*'),
        '&iff;'                             => [8660].pack('U*'),
        '&Ifr;'                             => [8465].pack('U*'),
        '&ifr;'                             => [120102].pack('U*'),
        '&Igrave;'                          => [204].pack('U*'),
        '&igrave;'                          => [236].pack('U*'),
        '&ii;'                              => [8520].pack('U*'),
        '&iiiint;'                          => [10764].pack('U*'),
        '&iiint;'                           => [8749].pack('U*'),
        '&iinfin;'                          => [10716].pack('U*'),
        '&iiota;'                           => [8489].pack('U*'),
        '&IJlig;'                           => [306].pack('U*'),
        '&ijlig;'                           => [307].pack('U*'),
        '&Im;'                              => [8465].pack('U*'),
        '&Imacr;'                           => [298].pack('U*'),
        '&imacr;'                           => [299].pack('U*'),
        '&image;'                           => [8465].pack('U*'),
        '&ImaginaryI;'                      => [8520].pack('U*'),
        '&imagline;'                        => [8464].pack('U*'),
        '&imagpart;'                        => [8465].pack('U*'),
        '&imath;'                           => [305].pack('U*'),
        '&imof;'                            => [8887].pack('U*'),
        '&imped;'                           => [437].pack('U*'),
        '&Implies;'                         => [8658].pack('U*'),
        '&in;'                              => [8712].pack('U*'),
        '&incare;'                          => [8453].pack('U*'),
        '&infin;'                           => [8734].pack('U*'),
        '&infintie;'                        => [10717].pack('U*'),
        '&inodot;'                          => [305].pack('U*'),
        '&Int;'                             => [8748].pack('U*'),
        '&int;'                             => [8747].pack('U*'),
        '&intcal;'                          => [8890].pack('U*'),
        '&integers;'                        => [8484].pack('U*'),
        '&Integral;'                        => [8747].pack('U*'),
        '&intercal;'                        => [8890].pack('U*'),
        '&Intersection;'                    => [8898].pack('U*'),
        '&intlarhk;'                        => [10775].pack('U*'),
        '&intprod;'                         => [10812].pack('U*'),
        '&InvisibleComma;'                  => [8291].pack('U*'),
        '&InvisibleTimes;'                  => [8290].pack('U*'),
        '&IOcy;'                            => [1025].pack('U*'),
        '&iocy;'                            => [1105].pack('U*'),
        '&Iogon;'                           => [302].pack('U*'),
        '&iogon;'                           => [303].pack('U*'),
        '&Iopf;'                            => [120128].pack('U*'),
        '&iopf;'                            => [120154].pack('U*'),
        '&Iota;'                            => [921].pack('U*'),
        '&iota;'                            => [953].pack('U*'),
        '&iprod;'                           => [10812].pack('U*'),
        '&iquest;'                          => [191].pack('U*'),
        '&Iscr;'                            => [8464].pack('U*'),
        '&iscr;'                            => [119998].pack('U*'),
        '&isin;'                            => [8712].pack('U*'),
        '&isindot;'                         => [8949].pack('U*'),
        '&isinE;'                           => [8953].pack('U*'),
        '&isins;'                           => [8948].pack('U*'),
        '&isinsv;'                          => [8947].pack('U*'),
        '&isinv;'                           => [8712].pack('U*'),
        '&it;'                              => [8290].pack('U*'),
        '&Itilde;'                          => [296].pack('U*'),
        '&itilde;'                          => [297].pack('U*'),
        '&Iukcy;'                           => [1030].pack('U*'),
        '&iukcy;'                           => [1110].pack('U*'),
        '&Iuml;'                            => [207].pack('U*'),
        '&iuml;'                            => [239].pack('U*'),
        '&Jcirc;'                           => [308].pack('U*'),
        '&jcirc;'                           => [309].pack('U*'),
        '&Jcy;'                             => [1049].pack('U*'),
        '&jcy;'                             => [1081].pack('U*'),
        '&Jfr;'                             => [120077].pack('U*'),
        '&jfr;'                             => [120103].pack('U*'),
        '&jmath;'                           => [567].pack('U*'),
        '&Jopf;'                            => [120129].pack('U*'),
        '&jopf;'                            => [120155].pack('U*'),
        '&Jscr;'                            => [119973].pack('U*'),
        '&jscr;'                            => [119999].pack('U*'),
        '&Jsercy;'                          => [1032].pack('U*'),
        '&jsercy;'                          => [1112].pack('U*'),
        '&Jukcy;'                           => [1028].pack('U*'),
        '&jukcy;'                           => [1108].pack('U*'),
        '&Kappa;'                           => [922].pack('U*'),
        '&kappa;'                           => [954].pack('U*'),
        '&kappav;'                          => [1008].pack('U*'),
        '&Kcedil;'                          => [310].pack('U*'),
        '&kcedil;'                          => [311].pack('U*'),
        '&Kcy;'                             => [1050].pack('U*'),
        '&kcy;'                             => [1082].pack('U*'),
        '&Kfr;'                             => [120078].pack('U*'),
        '&kfr;'                             => [120104].pack('U*'),
        '&kgreen;'                          => [312].pack('U*'),
        '&KHcy;'                            => [1061].pack('U*'),
        '&khcy;'                            => [1093].pack('U*'),
        '&KJcy;'                            => [1036].pack('U*'),
        '&kjcy;'                            => [1116].pack('U*'),
        '&Kopf;'                            => [120130].pack('U*'),
        '&kopf;'                            => [120156].pack('U*'),
        '&Kscr;'                            => [119974].pack('U*'),
        '&kscr;'                            => [120000].pack('U*'),
        '&lAarr;'                           => [8666].pack('U*'),
        '&Lacute;'                          => [313].pack('U*'),
        '&lacute;'                          => [314].pack('U*'),
        '&laemptyv;'                        => [10676].pack('U*'),
        '&lagran;'                          => [8466].pack('U*'),
        '&Lambda;'                          => [923].pack('U*'),
        '&lambda;'                          => [955].pack('U*'),
        '&Lang;'                            => [10218].pack('U*'),
        '&lang;'                            => [10216].pack('U*'),
        '&langd;'                           => [10641].pack('U*'),
        '&langle;'                          => [10216].pack('U*'),
        '&lap;'                             => [10885].pack('U*'),
        '&Laplacetrf;'                      => [8466].pack('U*'),
        '&laquo;'                           => [171].pack('U*'),
        '&Larr;'                            => [8606].pack('U*'),
        '&lArr;'                            => [8656].pack('U*'),
        '&larr;'                            => [8592].pack('U*'),
        '&larrb;'                           => [8676].pack('U*'),
        '&larrbfs;'                         => [10527].pack('U*'),
        '&larrfs;'                          => [10525].pack('U*'),
        '&larrhk;'                          => [8617].pack('U*'),
        '&larrlp;'                          => [8619].pack('U*'),
        '&larrpl;'                          => [10553].pack('U*'),
        '&larrsim;'                         => [10611].pack('U*'),
        '&larrtl;'                          => [8610].pack('U*'),
        '&lat;'                             => [10923].pack('U*'),
        '&lAtail;'                          => [10523].pack('U*'),
        '&latail;'                          => [10521].pack('U*'),
        '&late;'                            => [10925].pack('U*'),
        '&lates;'                           => [10925, 65024].pack('U*'),
        '&lBarr;'                           => [10510].pack('U*'),
        '&lbarr;'                           => [10508].pack('U*'),
        '&lbbrk;'                           => [10098].pack('U*'),
        '&lbrace;'                          => [123].pack('U*'),
        '&lbrack;'                          => [91].pack('U*'),
        '&lbrke;'                           => [10635].pack('U*'),
        '&lbrksld;'                         => [10639].pack('U*'),
        '&lbrkslu;'                         => [10637].pack('U*'),
        '&Lcaron;'                          => [317].pack('U*'),
        '&lcaron;'                          => [318].pack('U*'),
        '&Lcedil;'                          => [315].pack('U*'),
        '&lcedil;'                          => [316].pack('U*'),
        '&lceil;'                           => [8968].pack('U*'),
        '&lcub;'                            => [123].pack('U*'),
        '&Lcy;'                             => [1051].pack('U*'),
        '&lcy;'                             => [1083].pack('U*'),
        '&ldca;'                            => [10550].pack('U*'),
        '&ldquo;'                           => [8220].pack('U*'),
        '&ldquor;'                          => [8222].pack('U*'),
        '&ldrdhar;'                         => [10599].pack('U*'),
        '&ldrushar;'                        => [10571].pack('U*'),
        '&ldsh;'                            => [8626].pack('U*'),
        '&lE;'                              => [8806].pack('U*'),
        '&le;'                              => [8804].pack('U*'),
        '&LeftAngleBracket;'                => [10216].pack('U*'),
        '&LeftArrow;'                       => [8592].pack('U*'),
        '&Leftarrow;'                       => [8656].pack('U*'),
        '&leftarrow;'                       => [8592].pack('U*'),
        '&LeftArrowBar;'                    => [8676].pack('U*'),
        '&LeftArrowRightArrow;'             => [8646].pack('U*'),
        '&leftarrowtail;'                   => [8610].pack('U*'),
        '&LeftCeiling;'                     => [8968].pack('U*'),
        '&LeftDoubleBracket;'               => [10214].pack('U*'),
        '&LeftDownTeeVector;'               => [10593].pack('U*'),
        '&LeftDownVector;'                  => [8643].pack('U*'),
        '&LeftDownVectorBar;'               => [10585].pack('U*'),
        '&LeftFloor;'                       => [8970].pack('U*'),
        '&leftharpoondown;'                 => [8637].pack('U*'),
        '&leftharpoonup;'                   => [8636].pack('U*'),
        '&leftleftarrows;'                  => [8647].pack('U*'),
        '&LeftRightArrow;'                  => [8596].pack('U*'),
        '&Leftrightarrow;'                  => [8660].pack('U*'),
        '&leftrightarrow;'                  => [8596].pack('U*'),
        '&leftrightarrows;'                 => [8646].pack('U*'),
        '&leftrightharpoons;'               => [8651].pack('U*'),
        '&leftrightsquigarrow;'             => [8621].pack('U*'),
        '&LeftRightVector;'                 => [10574].pack('U*'),
        '&LeftTee;'                         => [8867].pack('U*'),
        '&LeftTeeArrow;'                    => [8612].pack('U*'),
        '&LeftTeeVector;'                   => [10586].pack('U*'),
        '&leftthreetimes;'                  => [8907].pack('U*'),
        '&LeftTriangle;'                    => [8882].pack('U*'),
        '&LeftTriangleBar;'                 => [10703].pack('U*'),
        '&LeftTriangleEqual;'               => [8884].pack('U*'),
        '&LeftUpDownVector;'                => [10577].pack('U*'),
        '&LeftUpTeeVector;'                 => [10592].pack('U*'),
        '&LeftUpVector;'                    => [8639].pack('U*'),
        '&LeftUpVectorBar;'                 => [10584].pack('U*'),
        '&LeftVector;'                      => [8636].pack('U*'),
        '&LeftVectorBar;'                   => [10578].pack('U*'),
        '&lEg;'                             => [10891].pack('U*'),
        '&leg;'                             => [8922].pack('U*'),
        '&leq;'                             => [8804].pack('U*'),
        '&leqq;'                            => [8806].pack('U*'),
        '&leqslant;'                        => [10877].pack('U*'),
        '&les;'                             => [10877].pack('U*'),
        '&lescc;'                           => [10920].pack('U*'),
        '&lesdot;'                          => [10879].pack('U*'),
        '&lesdoto;'                         => [10881].pack('U*'),
        '&lesdotor;'                        => [10883].pack('U*'),
        '&lesg;'                            => [8922, 65024].pack('U*'),
        '&lesges;'                          => [10899].pack('U*'),
        '&lessapprox;'                      => [10885].pack('U*'),
        '&lessdot;'                         => [8918].pack('U*'),
        '&lesseqgtr;'                       => [8922].pack('U*'),
        '&lesseqqgtr;'                      => [10891].pack('U*'),
        '&LessEqualGreater;'                => [8922].pack('U*'),
        '&LessFullEqual;'                   => [8806].pack('U*'),
        '&LessGreater;'                     => [8822].pack('U*'),
        '&lessgtr;'                         => [8822].pack('U*'),
        '&LessLess;'                        => [10913].pack('U*'),
        '&lesssim;'                         => [8818].pack('U*'),
        '&LessSlantEqual;'                  => [10877].pack('U*'),
        '&LessTilde;'                       => [8818].pack('U*'),
        '&lfisht;'                          => [10620].pack('U*'),
        '&lfloor;'                          => [8970].pack('U*'),
        '&Lfr;'                             => [120079].pack('U*'),
        '&lfr;'                             => [120105].pack('U*'),
        '&lg;'                              => [8822].pack('U*'),
        '&lgE;'                             => [10897].pack('U*'),
        '&lHar;'                            => [10594].pack('U*'),
        '&lhard;'                           => [8637].pack('U*'),
        '&lharu;'                           => [8636].pack('U*'),
        '&lharul;'                          => [10602].pack('U*'),
        '&lhblk;'                           => [9604].pack('U*'),
        '&LJcy;'                            => [1033].pack('U*'),
        '&ljcy;'                            => [1113].pack('U*'),
        '&Ll;'                              => [8920].pack('U*'),
        '&ll;'                              => [8810].pack('U*'),
        '&llarr;'                           => [8647].pack('U*'),
        '&llcorner;'                        => [8990].pack('U*'),
        '&Lleftarrow;'                      => [8666].pack('U*'),
        '&llhard;'                          => [10603].pack('U*'),
        '&lltri;'                           => [9722].pack('U*'),
        '&Lmidot;'                          => [319].pack('U*'),
        '&lmidot;'                          => [320].pack('U*'),
        '&lmoust;'                          => [9136].pack('U*'),
        '&lmoustache;'                      => [9136].pack('U*'),
        '&lnap;'                            => [10889].pack('U*'),
        '&lnapprox;'                        => [10889].pack('U*'),
        '&lnE;'                             => [8808].pack('U*'),
        '&lne;'                             => [10887].pack('U*'),
        '&lneq;'                            => [10887].pack('U*'),
        '&lneqq;'                           => [8808].pack('U*'),
        '&lnsim;'                           => [8934].pack('U*'),
        '&loang;'                           => [10220].pack('U*'),
        '&loarr;'                           => [8701].pack('U*'),
        '&lobrk;'                           => [10214].pack('U*'),
        '&LongLeftArrow;'                   => [10229].pack('U*'),
        '&Longleftarrow;'                   => [10232].pack('U*'),
        '&longleftarrow;'                   => [10229].pack('U*'),
        '&LongLeftRightArrow;'              => [10231].pack('U*'),
        '&Longleftrightarrow;'              => [10234].pack('U*'),
        '&longleftrightarrow;'              => [10231].pack('U*'),
        '&longmapsto;'                      => [10236].pack('U*'),
        '&LongRightArrow;'                  => [10230].pack('U*'),
        '&Longrightarrow;'                  => [10233].pack('U*'),
        '&longrightarrow;'                  => [10230].pack('U*'),
        '&looparrowleft;'                   => [8619].pack('U*'),
        '&looparrowright;'                  => [8620].pack('U*'),
        '&lopar;'                           => [10629].pack('U*'),
        '&Lopf;'                            => [120131].pack('U*'),
        '&lopf;'                            => [120157].pack('U*'),
        '&loplus;'                          => [10797].pack('U*'),
        '&lotimes;'                         => [10804].pack('U*'),
        '&lowast;'                          => [8727].pack('U*'),
        '&lowbar;'                          => [95].pack('U*'),
        '&LowerLeftArrow;'                  => [8601].pack('U*'),
        '&LowerRightArrow;'                 => [8600].pack('U*'),
        '&loz;'                             => [9674].pack('U*'),
        '&lozenge;'                         => [9674].pack('U*'),
        '&lozf;'                            => [10731].pack('U*'),
        '&lpar;'                            => [40].pack('U*'),
        '&lparlt;'                          => [10643].pack('U*'),
        '&lrarr;'                           => [8646].pack('U*'),
        '&lrcorner;'                        => [8991].pack('U*'),
        '&lrhar;'                           => [8651].pack('U*'),
        '&lrhard;'                          => [10605].pack('U*'),
        '&lrm;'                             => [8206].pack('U*'),
        '&lrtri;'                           => [8895].pack('U*'),
        '&lsaquo;'                          => [8249].pack('U*'),
        '&Lscr;'                            => [8466].pack('U*'),
        '&lscr;'                            => [120001].pack('U*'),
        '&Lsh;'                             => [8624].pack('U*'),
        '&lsh;'                             => [8624].pack('U*'),
        '&lsim;'                            => [8818].pack('U*'),
        '&lsime;'                           => [10893].pack('U*'),
        '&lsimg;'                           => [10895].pack('U*'),
        '&lsqb;'                            => [91].pack('U*'),
        '&lsquo;'                           => [8216].pack('U*'),
        '&lsquor;'                          => [8218].pack('U*'),
        '&Lstrok;'                          => [321].pack('U*'),
        '&lstrok;'                          => [322].pack('U*'),
        '&LT;'                              => [60].pack('U*'),
        '&Lt;'                              => [8810].pack('U*'),
        '&lt;'                              => [60].pack('U*'),
        '&ltcc;'                            => [10918].pack('U*'),
        '&ltcir;'                           => [10873].pack('U*'),
        '&ltdot;'                           => [8918].pack('U*'),
        '&lthree;'                          => [8907].pack('U*'),
        '&ltimes;'                          => [8905].pack('U*'),
        '&ltlarr;'                          => [10614].pack('U*'),
        '&ltquest;'                         => [10875].pack('U*'),
        '&ltri;'                            => [9667].pack('U*'),
        '&ltrie;'                           => [8884].pack('U*'),
        '&ltrif;'                           => [9666].pack('U*'),
        '&ltrPar;'                          => [10646].pack('U*'),
        '&lurdshar;'                        => [10570].pack('U*'),
        '&luruhar;'                         => [10598].pack('U*'),
        '&lvertneqq;'                       => [8808, 65024].pack('U*'),
        '&lvnE;'                            => [8808, 65024].pack('U*'),
        '&macr;'                            => [175].pack('U*'),
        '&male;'                            => [9794].pack('U*'),
        '&malt;'                            => [10016].pack('U*'),
        '&maltese;'                         => [10016].pack('U*'),
        '&Map;'                             => [10501].pack('U*'),
        '&map;'                             => [8614].pack('U*'),
        '&mapsto;'                          => [8614].pack('U*'),
        '&mapstodown;'                      => [8615].pack('U*'),
        '&mapstoleft;'                      => [8612].pack('U*'),
        '&mapstoup;'                        => [8613].pack('U*'),
        '&marker;'                          => [9646].pack('U*'),
        '&mcomma;'                          => [10793].pack('U*'),
        '&Mcy;'                             => [1052].pack('U*'),
        '&mcy;'                             => [1084].pack('U*'),
        '&mdash;'                           => [8212].pack('U*'),
        '&mDDot;'                           => [8762].pack('U*'),
        '&measuredangle;'                   => [8737].pack('U*'),
        '&MediumSpace;'                     => [8287].pack('U*'),
        '&Mellintrf;'                       => [8499].pack('U*'),
        '&Mfr;'                             => [120080].pack('U*'),
        '&mfr;'                             => [120106].pack('U*'),
        '&mho;'                             => [8487].pack('U*'),
        '&micro;'                           => [181].pack('U*'),
        '&mid;'                             => [8739].pack('U*'),
        '&midast;'                          => [42].pack('U*'),
        '&midcir;'                          => [10992].pack('U*'),
        '&middot;'                          => [183].pack('U*'),
        '&minus;'                           => [8722].pack('U*'),
        '&minusb;'                          => [8863].pack('U*'),
        '&minusd;'                          => [8760].pack('U*'),
        '&minusdu;'                         => [10794].pack('U*'),
        '&MinusPlus;'                       => [8723].pack('U*'),
        '&mlcp;'                            => [10971].pack('U*'),
        '&mldr;'                            => [8230].pack('U*'),
        '&mnplus;'                          => [8723].pack('U*'),
        '&models;'                          => [8871].pack('U*'),
        '&Mopf;'                            => [120132].pack('U*'),
        '&mopf;'                            => [120158].pack('U*'),
        '&mp;'                              => [8723].pack('U*'),
        '&Mscr;'                            => [8499].pack('U*'),
        '&mscr;'                            => [120002].pack('U*'),
        '&mstpos;'                          => [8766].pack('U*'),
        '&Mu;'                              => [924].pack('U*'),
        '&mu;'                              => [956].pack('U*'),
        '&multimap;'                        => [8888].pack('U*'),
        '&mumap;'                           => [8888].pack('U*'),
        '&nabla;'                           => [8711].pack('U*'),
        '&Nacute;'                          => [323].pack('U*'),
        '&nacute;'                          => [324].pack('U*'),
        '&nang;'                            => [8736, 8402].pack('U*'),
        '&nap;'                             => [8777].pack('U*'),
        '&napE;'                            => [10864, 824].pack('U*'),
        '&napid;'                           => [8779, 824].pack('U*'),
        '&napos;'                           => [329].pack('U*'),
        '&napprox;'                         => [8777].pack('U*'),
        '&natur;'                           => [9838].pack('U*'),
        '&natural;'                         => [9838].pack('U*'),
        '&naturals;'                        => [8469].pack('U*'),
        '&nbsp;'                            => [160].pack('U*'),
        '&nbump;'                           => [8782, 824].pack('U*'),
        '&nbumpe;'                          => [8783, 824].pack('U*'),
        '&ncap;'                            => [10819].pack('U*'),
        '&Ncaron;'                          => [327].pack('U*'),
        '&ncaron;'                          => [328].pack('U*'),
        '&Ncedil;'                          => [325].pack('U*'),
        '&ncedil;'                          => [326].pack('U*'),
        '&ncong;'                           => [8775].pack('U*'),
        '&ncongdot;'                        => [10861, 824].pack('U*'),
        '&ncup;'                            => [10818].pack('U*'),
        '&Ncy;'                             => [1053].pack('U*'),
        '&ncy;'                             => [1085].pack('U*'),
        '&ndash;'                           => [8211].pack('U*'),
        '&ne;'                              => [8800].pack('U*'),
        '&nearhk;'                          => [10532].pack('U*'),
        '&neArr;'                           => [8663].pack('U*'),
        '&nearr;'                           => [8599].pack('U*'),
        '&nearrow;'                         => [8599].pack('U*'),
        '&nedot;'                           => [8784, 824].pack('U*'),
        '&NegativeMediumSpace;'             => [8203].pack('U*'),
        '&NegativeThickSpace;'              => [8203].pack('U*'),
        '&NegativeThinSpace;'               => [8203].pack('U*'),
        '&NegativeVeryThinSpace;'           => [8203].pack('U*'),
        '&nequiv;'                          => [8802].pack('U*'),
        '&nesear;'                          => [10536].pack('U*'),
        '&nesim;'                           => [8770, 824].pack('U*'),
        '&NestedGreaterGreater;'            => [8811].pack('U*'),
        '&NestedLessLess;'                  => [8810].pack('U*'),
        '&NewLine;'                         => [10].pack('U*'),
        '&nexist;'                          => [8708].pack('U*'),
        '&nexists;'                         => [8708].pack('U*'),
        '&Nfr;'                             => [120081].pack('U*'),
        '&nfr;'                             => [120107].pack('U*'),
        '&ngE;'                             => [8807, 824].pack('U*'),
        '&nge;'                             => [8817].pack('U*'),
        '&ngeq;'                            => [8817].pack('U*'),
        '&ngeqq;'                           => [8807, 824].pack('U*'),
        '&ngeqslant;'                       => [10878, 824].pack('U*'),
        '&nges;'                            => [10878, 824].pack('U*'),
        '&nGg;'                             => [8921, 824].pack('U*'),
        '&ngsim;'                           => [8821].pack('U*'),
        '&nGt;'                             => [8811, 8402].pack('U*'),
        '&ngt;'                             => [8815].pack('U*'),
        '&ngtr;'                            => [8815].pack('U*'),
        '&nGtv;'                            => [8811, 824].pack('U*'),
        '&nhArr;'                           => [8654].pack('U*'),
        '&nharr;'                           => [8622].pack('U*'),
        '&nhpar;'                           => [10994].pack('U*'),
        '&ni;'                              => [8715].pack('U*'),
        '&nis;'                             => [8956].pack('U*'),
        '&nisd;'                            => [8954].pack('U*'),
        '&niv;'                             => [8715].pack('U*'),
        '&NJcy;'                            => [1034].pack('U*'),
        '&njcy;'                            => [1114].pack('U*'),
        '&nlArr;'                           => [8653].pack('U*'),
        '&nlarr;'                           => [8602].pack('U*'),
        '&nldr;'                            => [8229].pack('U*'),
        '&nlE;'                             => [8806, 824].pack('U*'),
        '&nle;'                             => [8816].pack('U*'),
        '&nLeftarrow;'                      => [8653].pack('U*'),
        '&nleftarrow;'                      => [8602].pack('U*'),
        '&nLeftrightarrow;'                 => [8654].pack('U*'),
        '&nleftrightarrow;'                 => [8622].pack('U*'),
        '&nleq;'                            => [8816].pack('U*'),
        '&nleqq;'                           => [8806, 824].pack('U*'),
        '&nleqslant;'                       => [10877, 824].pack('U*'),
        '&nles;'                            => [10877, 824].pack('U*'),
        '&nless;'                           => [8814].pack('U*'),
        '&nLl;'                             => [8920, 824].pack('U*'),
        '&nlsim;'                           => [8820].pack('U*'),
        '&nLt;'                             => [8810, 8402].pack('U*'),
        '&nlt;'                             => [8814].pack('U*'),
        '&nltri;'                           => [8938].pack('U*'),
        '&nltrie;'                          => [8940].pack('U*'),
        '&nLtv;'                            => [8810, 824].pack('U*'),
        '&nmid;'                            => [8740].pack('U*'),
        '&NoBreak;'                         => [8288].pack('U*'),
        '&NonBreakingSpace;'                => [160].pack('U*'),
        '&Nopf;'                            => [8469].pack('U*'),
        '&nopf;'                            => [120159].pack('U*'),
        '&Not;'                             => [10988].pack('U*'),
        '&not;'                             => [172].pack('U*'),
        '&NotCongruent;'                    => [8802].pack('U*'),
        '&NotCupCap;'                       => [8813].pack('U*'),
        '&NotDoubleVerticalBar;'            => [8742].pack('U*'),
        '&NotElement;'                      => [8713].pack('U*'),
        '&NotEqual;'                        => [8800].pack('U*'),
        '&NotEqualTilde;'                   => [8770, 824].pack('U*'),
        '&NotExists;'                       => [8708].pack('U*'),
        '&NotGreater;'                      => [8815].pack('U*'),
        '&NotGreaterEqual;'                 => [8817].pack('U*'),
        '&NotGreaterFullEqual;'             => [8807, 824].pack('U*'),
        '&NotGreaterGreater;'               => [8811, 824].pack('U*'),
        '&NotGreaterLess;'                  => [8825].pack('U*'),
        '&NotGreaterSlantEqual;'            => [10878, 824].pack('U*'),
        '&NotGreaterTilde;'                 => [8821].pack('U*'),
        '&NotHumpDownHump;'                 => [8782, 824].pack('U*'),
        '&NotHumpEqual;'                    => [8783, 824].pack('U*'),
        '&notin;'                           => [8713].pack('U*'),
        '&notindot;'                        => [8949, 824].pack('U*'),
        '&notinE;'                          => [8953, 824].pack('U*'),
        '&notinva;'                         => [8713].pack('U*'),
        '&notinvb;'                         => [8951].pack('U*'),
        '&notinvc;'                         => [8950].pack('U*'),
        '&NotLeftTriangle;'                 => [8938].pack('U*'),
        '&NotLeftTriangleBar;'              => [10703, 824].pack('U*'),
        '&NotLeftTriangleEqual;'            => [8940].pack('U*'),
        '&NotLess;'                         => [8814].pack('U*'),
        '&NotLessEqual;'                    => [8816].pack('U*'),
        '&NotLessGreater;'                  => [8824].pack('U*'),
        '&NotLessLess;'                     => [8810, 824].pack('U*'),
        '&NotLessSlantEqual;'               => [10877, 824].pack('U*'),
        '&NotLessTilde;'                    => [8820].pack('U*'),
        '&NotNestedGreaterGreater;'         => [10914, 824].pack('U*'),
        '&NotNestedLessLess;'               => [10913, 824].pack('U*'),
        '&notni;'                           => [8716].pack('U*'),
        '&notniva;'                         => [8716].pack('U*'),
        '&notnivb;'                         => [8958].pack('U*'),
        '&notnivc;'                         => [8957].pack('U*'),
        '&NotPrecedes;'                     => [8832].pack('U*'),
        '&NotPrecedesEqual;'                => [10927, 824].pack('U*'),
        '&NotPrecedesSlantEqual;'           => [8928].pack('U*'),
        '&NotReverseElement;'               => [8716].pack('U*'),
        '&NotRightTriangle;'                => [8939].pack('U*'),
        '&NotRightTriangleBar;'             => [10704, 824].pack('U*'),
        '&NotRightTriangleEqual;'           => [8941].pack('U*'),
        '&NotSquareSubset;'                 => [8847, 824].pack('U*'),
        '&NotSquareSubsetEqual;'            => [8930].pack('U*'),
        '&NotSquareSuperset;'               => [8848, 824].pack('U*'),
        '&NotSquareSupersetEqual;'          => [8931].pack('U*'),
        '&NotSubset;'                       => [8834, 8402].pack('U*'),
        '&NotSubsetEqual;'                  => [8840].pack('U*'),
        '&NotSucceeds;'                     => [8833].pack('U*'),
        '&NotSucceedsEqual;'                => [10928, 824].pack('U*'),
        '&NotSucceedsSlantEqual;'           => [8929].pack('U*'),
        '&NotSucceedsTilde;'                => [8831, 824].pack('U*'),
        '&NotSuperset;'                     => [8835, 8402].pack('U*'),
        '&NotSupersetEqual;'                => [8841].pack('U*'),
        '&NotTilde;'                        => [8769].pack('U*'),
        '&NotTildeEqual;'                   => [8772].pack('U*'),
        '&NotTildeFullEqual;'               => [8775].pack('U*'),
        '&NotTildeTilde;'                   => [8777].pack('U*'),
        '&NotVerticalBar;'                  => [8740].pack('U*'),
        '&npar;'                            => [8742].pack('U*'),
        '&nparallel;'                       => [8742].pack('U*'),
        '&nparsl;'                          => [11005, 8421].pack('U*'),
        '&npart;'                           => [8706, 824].pack('U*'),
        '&npolint;'                         => [10772].pack('U*'),
        '&npr;'                             => [8832].pack('U*'),
        '&nprcue;'                          => [8928].pack('U*'),
        '&npre;'                            => [10927, 824].pack('U*'),
        '&nprec;'                           => [8832].pack('U*'),
        '&npreceq;'                         => [10927, 824].pack('U*'),
        '&nrArr;'                           => [8655].pack('U*'),
        '&nrarr;'                           => [8603].pack('U*'),
        '&nrarrc;'                          => [10547, 824].pack('U*'),
        '&nrarrw;'                          => [8605, 824].pack('U*'),
        '&nRightarrow;'                     => [8655].pack('U*'),
        '&nrightarrow;'                     => [8603].pack('U*'),
        '&nrtri;'                           => [8939].pack('U*'),
        '&nrtrie;'                          => [8941].pack('U*'),
        '&nsc;'                             => [8833].pack('U*'),
        '&nsccue;'                          => [8929].pack('U*'),
        '&nsce;'                            => [10928, 824].pack('U*'),
        '&Nscr;'                            => [119977].pack('U*'),
        '&nscr;'                            => [120003].pack('U*'),
        '&nshortmid;'                       => [8740].pack('U*'),
        '&nshortparallel;'                  => [8742].pack('U*'),
        '&nsim;'                            => [8769].pack('U*'),
        '&nsime;'                           => [8772].pack('U*'),
        '&nsimeq;'                          => [8772].pack('U*'),
        '&nsmid;'                           => [8740].pack('U*'),
        '&nspar;'                           => [8742].pack('U*'),
        '&nsqsube;'                         => [8930].pack('U*'),
        '&nsqsupe;'                         => [8931].pack('U*'),
        '&nsub;'                            => [8836].pack('U*'),
        '&nsubE;'                           => [10949, 824].pack('U*'),
        '&nsube;'                           => [8840].pack('U*'),
        '&nsubset;'                         => [8834, 8402].pack('U*'),
        '&nsubseteq;'                       => [8840].pack('U*'),
        '&nsubseteqq;'                      => [10949, 824].pack('U*'),
        '&nsucc;'                           => [8833].pack('U*'),
        '&nsucceq;'                         => [10928, 824].pack('U*'),
        '&nsup;'                            => [8837].pack('U*'),
        '&nsupE;'                           => [10950, 824].pack('U*'),
        '&nsupe;'                           => [8841].pack('U*'),
        '&nsupset;'                         => [8835, 8402].pack('U*'),
        '&nsupseteq;'                       => [8841].pack('U*'),
        '&nsupseteqq;'                      => [10950, 824].pack('U*'),
        '&ntgl;'                            => [8825].pack('U*'),
        '&Ntilde;'                          => [209].pack('U*'),
        '&ntilde;'                          => [241].pack('U*'),
        '&ntlg;'                            => [8824].pack('U*'),
        '&ntriangleleft;'                   => [8938].pack('U*'),
        '&ntrianglelefteq;'                 => [8940].pack('U*'),
        '&ntriangleright;'                  => [8939].pack('U*'),
        '&ntrianglerighteq;'                => [8941].pack('U*'),
        '&Nu;'                              => [925].pack('U*'),
        '&nu;'                              => [957].pack('U*'),
        '&num;'                             => [35].pack('U*'),
        '&numero;'                          => [8470].pack('U*'),
        '&numsp;'                           => [8199].pack('U*'),
        '&nvap;'                            => [8781, 8402].pack('U*'),
        '&nVDash;'                          => [8879].pack('U*'),
        '&nVdash;'                          => [8878].pack('U*'),
        '&nvDash;'                          => [8877].pack('U*'),
        '&nvdash;'                          => [8876].pack('U*'),
        '&nvge;'                            => [8805, 8402].pack('U*'),
        '&nvgt;'                            => [62, 8402].pack('U*'),
        '&nvHarr;'                          => [10500].pack('U*'),
        '&nvinfin;'                         => [10718].pack('U*'),
        '&nvlArr;'                          => [10498].pack('U*'),
        '&nvle;'                            => [8804, 8402].pack('U*'),
        '&nvlt;'                            => [60, 8402].pack('U*'),
        '&nvltrie;'                         => [8884, 8402].pack('U*'),
        '&nvrArr;'                          => [10499].pack('U*'),
        '&nvrtrie;'                         => [8885, 8402].pack('U*'),
        '&nvsim;'                           => [8764, 8402].pack('U*'),
        '&nwarhk;'                          => [10531].pack('U*'),
        '&nwArr;'                           => [8662].pack('U*'),
        '&nwarr;'                           => [8598].pack('U*'),
        '&nwarrow;'                         => [8598].pack('U*'),
        '&nwnear;'                          => [10535].pack('U*'),
        '&Oacute;'                          => [211].pack('U*'),
        '&oacute;'                          => [243].pack('U*'),
        '&oast;'                            => [8859].pack('U*'),
        '&ocir;'                            => [8858].pack('U*'),
        '&Ocirc;'                           => [212].pack('U*'),
        '&ocirc;'                           => [244].pack('U*'),
        '&Ocy;'                             => [1054].pack('U*'),
        '&ocy;'                             => [1086].pack('U*'),
        '&odash;'                           => [8861].pack('U*'),
        '&Odblac;'                          => [336].pack('U*'),
        '&odblac;'                          => [337].pack('U*'),
        '&odiv;'                            => [10808].pack('U*'),
        '&odot;'                            => [8857].pack('U*'),
        '&odsold;'                          => [10684].pack('U*'),
        '&OElig;'                           => [338].pack('U*'),
        '&oelig;'                           => [339].pack('U*'),
        '&ofcir;'                           => [10687].pack('U*'),
        '&Ofr;'                             => [120082].pack('U*'),
        '&ofr;'                             => [120108].pack('U*'),
        '&ogon;'                            => [731].pack('U*'),
        '&Ograve;'                          => [210].pack('U*'),
        '&ograve;'                          => [242].pack('U*'),
        '&ogt;'                             => [10689].pack('U*'),
        '&ohbar;'                           => [10677].pack('U*'),
        '&ohm;'                             => [937].pack('U*'),
        '&oint;'                            => [8750].pack('U*'),
        '&olarr;'                           => [8634].pack('U*'),
        '&olcir;'                           => [10686].pack('U*'),
        '&olcross;'                         => [10683].pack('U*'),
        '&oline;'                           => [8254].pack('U*'),
        '&olt;'                             => [10688].pack('U*'),
        '&Omacr;'                           => [332].pack('U*'),
        '&omacr;'                           => [333].pack('U*'),
        '&Omega;'                           => [937].pack('U*'),
        '&omega;'                           => [969].pack('U*'),
        '&Omicron;'                         => [927].pack('U*'),
        '&omicron;'                         => [959].pack('U*'),
        '&omid;'                            => [10678].pack('U*'),
        '&ominus;'                          => [8854].pack('U*'),
        '&Oopf;'                            => [120134].pack('U*'),
        '&oopf;'                            => [120160].pack('U*'),
        '&opar;'                            => [10679].pack('U*'),
        '&OpenCurlyDoubleQuote;'            => [8220].pack('U*'),
        '&OpenCurlyQuote;'                  => [8216].pack('U*'),
        '&operp;'                           => [10681].pack('U*'),
        '&oplus;'                           => [8853].pack('U*'),
        '&Or;'                              => [10836].pack('U*'),
        '&or;'                              => [8744].pack('U*'),
        '&orarr;'                           => [8635].pack('U*'),
        '&ord;'                             => [10845].pack('U*'),
        '&order;'                           => [8500].pack('U*'),
        '&orderof;'                         => [8500].pack('U*'),
        '&ordf;'                            => [170].pack('U*'),
        '&ordm;'                            => [186].pack('U*'),
        '&origof;'                          => [8886].pack('U*'),
        '&oror;'                            => [10838].pack('U*'),
        '&orslope;'                         => [10839].pack('U*'),
        '&orv;'                             => [10843].pack('U*'),
        '&oS;'                              => [9416].pack('U*'),
        '&Oscr;'                            => [119978].pack('U*'),
        '&oscr;'                            => [8500].pack('U*'),
        '&Oslash;'                          => [216].pack('U*'),
        '&oslash;'                          => [248].pack('U*'),
        '&osol;'                            => [8856].pack('U*'),
        '&Otilde;'                          => [213].pack('U*'),
        '&otilde;'                          => [245].pack('U*'),
        '&Otimes;'                          => [10807].pack('U*'),
        '&otimes;'                          => [8855].pack('U*'),
        '&otimesas;'                        => [10806].pack('U*'),
        '&Ouml;'                            => [214].pack('U*'),
        '&ouml;'                            => [246].pack('U*'),
        '&ovbar;'                           => [9021].pack('U*'),
        '&OverBar;'                         => [8254].pack('U*'),
        '&OverBrace;'                       => [9182].pack('U*'),
        '&OverBracket;'                     => [9140].pack('U*'),
        '&OverParenthesis;'                 => [9180].pack('U*'),
        '&par;'                             => [8741].pack('U*'),
        '&para;'                            => [182].pack('U*'),
        '&parallel;'                        => [8741].pack('U*'),
        '&parsim;'                          => [10995].pack('U*'),
        '&parsl;'                           => [11005].pack('U*'),
        '&part;'                            => [8706].pack('U*'),
        '&PartialD;'                        => [8706].pack('U*'),
        '&Pcy;'                             => [1055].pack('U*'),
        '&pcy;'                             => [1087].pack('U*'),
        '&percnt;'                          => [37].pack('U*'),
        '&period;'                          => [46].pack('U*'),
        '&permil;'                          => [8240].pack('U*'),
        '&perp;'                            => [8869].pack('U*'),
        '&pertenk;'                         => [8241].pack('U*'),
        '&Pfr;'                             => [120083].pack('U*'),
        '&pfr;'                             => [120109].pack('U*'),
        '&Phi;'                             => [934].pack('U*'),
        '&phi;'                             => [966].pack('U*'),
        '&phiv;'                            => [981].pack('U*'),
        '&phmmat;'                          => [8499].pack('U*'),
        '&phone;'                           => [9742].pack('U*'),
        '&Pi;'                              => [928].pack('U*'),
        '&pi;'                              => [960].pack('U*'),
        '&pitchfork;'                       => [8916].pack('U*'),
        '&piv;'                             => [982].pack('U*'),
        '&planck;'                          => [8463].pack('U*'),
        '&planckh;'                         => [8462].pack('U*'),
        '&plankv;'                          => [8463].pack('U*'),
        '&plus;'                            => [43].pack('U*'),
        '&plusacir;'                        => [10787].pack('U*'),
        '&plusb;'                           => [8862].pack('U*'),
        '&pluscir;'                         => [10786].pack('U*'),
        '&plusdo;'                          => [8724].pack('U*'),
        '&plusdu;'                          => [10789].pack('U*'),
        '&pluse;'                           => [10866].pack('U*'),
        '&PlusMinus;'                       => [177].pack('U*'),
        '&plusmn;'                          => [177].pack('U*'),
        '&plussim;'                         => [10790].pack('U*'),
        '&plustwo;'                         => [10791].pack('U*'),
        '&pm;'                              => [177].pack('U*'),
        '&Poincareplane;'                   => [8460].pack('U*'),
        '&pointint;'                        => [10773].pack('U*'),
        '&Popf;'                            => [8473].pack('U*'),
        '&popf;'                            => [120161].pack('U*'),
        '&pound;'                           => [163].pack('U*'),
        '&Pr;'                              => [10939].pack('U*'),
        '&pr;'                              => [8826].pack('U*'),
        '&prap;'                            => [10935].pack('U*'),
        '&prcue;'                           => [8828].pack('U*'),
        '&prE;'                             => [10931].pack('U*'),
        '&pre;'                             => [10927].pack('U*'),
        '&prec;'                            => [8826].pack('U*'),
        '&precapprox;'                      => [10935].pack('U*'),
        '&preccurlyeq;'                     => [8828].pack('U*'),
        '&Precedes;'                        => [8826].pack('U*'),
        '&PrecedesEqual;'                   => [10927].pack('U*'),
        '&PrecedesSlantEqual;'              => [8828].pack('U*'),
        '&PrecedesTilde;'                   => [8830].pack('U*'),
        '&preceq;'                          => [10927].pack('U*'),
        '&precnapprox;'                     => [10937].pack('U*'),
        '&precneqq;'                        => [10933].pack('U*'),
        '&precnsim;'                        => [8936].pack('U*'),
        '&precsim;'                         => [8830].pack('U*'),
        '&Prime;'                           => [8243].pack('U*'),
        '&prime;'                           => [8242].pack('U*'),
        '&primes;'                          => [8473].pack('U*'),
        '&prnap;'                           => [10937].pack('U*'),
        '&prnE;'                            => [10933].pack('U*'),
        '&prnsim;'                          => [8936].pack('U*'),
        '&prod;'                            => [8719].pack('U*'),
        '&Product;'                         => [8719].pack('U*'),
        '&profalar;'                        => [9006].pack('U*'),
        '&profline;'                        => [8978].pack('U*'),
        '&profsurf;'                        => [8979].pack('U*'),
        '&prop;'                            => [8733].pack('U*'),
        '&Proportion;'                      => [8759].pack('U*'),
        '&Proportional;'                    => [8733].pack('U*'),
        '&propto;'                          => [8733].pack('U*'),
        '&prsim;'                           => [8830].pack('U*'),
        '&prurel;'                          => [8880].pack('U*'),
        '&Pscr;'                            => [119979].pack('U*'),
        '&pscr;'                            => [120005].pack('U*'),
        '&Psi;'                             => [936].pack('U*'),
        '&psi;'                             => [968].pack('U*'),
        '&puncsp;'                          => [8200].pack('U*'),
        '&Qfr;'                             => [120084].pack('U*'),
        '&qfr;'                             => [120110].pack('U*'),
        '&qint;'                            => [10764].pack('U*'),
        '&Qopf;'                            => [8474].pack('U*'),
        '&qopf;'                            => [120162].pack('U*'),
        '&qprime;'                          => [8279].pack('U*'),
        '&Qscr;'                            => [119980].pack('U*'),
        '&qscr;'                            => [120006].pack('U*'),
        '&quaternions;'                     => [8461].pack('U*'),
        '&quatint;'                         => [10774].pack('U*'),
        '&quest;'                           => [63].pack('U*'),
        '&questeq;'                         => [8799].pack('U*'),
        '&QUOT;'                            => [34].pack('U*'),
        '&quot;'                            => [34].pack('U*'),
        '&rAarr;'                           => [8667].pack('U*'),
        '&race;'                            => [8765, 817].pack('U*'),
        '&Racute;'                          => [340].pack('U*'),
        '&racute;'                          => [341].pack('U*'),
        '&radic;'                           => [8730].pack('U*'),
        '&raemptyv;'                        => [10675].pack('U*'),
        '&Rang;'                            => [10219].pack('U*'),
        '&rang;'                            => [10217].pack('U*'),
        '&rangd;'                           => [10642].pack('U*'),
        '&range;'                           => [10661].pack('U*'),
        '&rangle;'                          => [10217].pack('U*'),
        '&raquo;'                           => [187].pack('U*'),
        '&Rarr;'                            => [8608].pack('U*'),
        '&rArr;'                            => [8658].pack('U*'),
        '&rarr;'                            => [8594].pack('U*'),
        '&rarrap;'                          => [10613].pack('U*'),
        '&rarrb;'                           => [8677].pack('U*'),
        '&rarrbfs;'                         => [10528].pack('U*'),
        '&rarrc;'                           => [10547].pack('U*'),
        '&rarrfs;'                          => [10526].pack('U*'),
        '&rarrhk;'                          => [8618].pack('U*'),
        '&rarrlp;'                          => [8620].pack('U*'),
        '&rarrpl;'                          => [10565].pack('U*'),
        '&rarrsim;'                         => [10612].pack('U*'),
        '&Rarrtl;'                          => [10518].pack('U*'),
        '&rarrtl;'                          => [8611].pack('U*'),
        '&rarrw;'                           => [8605].pack('U*'),
        '&rAtail;'                          => [10524].pack('U*'),
        '&ratail;'                          => [10522].pack('U*'),
        '&ratio;'                           => [8758].pack('U*'),
        '&rationals;'                       => [8474].pack('U*'),
        '&RBarr;'                           => [10512].pack('U*'),
        '&rBarr;'                           => [10511].pack('U*'),
        '&rbarr;'                           => [10509].pack('U*'),
        '&rbbrk;'                           => [10099].pack('U*'),
        '&rbrace;'                          => [125].pack('U*'),
        '&rbrack;'                          => [93].pack('U*'),
        '&rbrke;'                           => [10636].pack('U*'),
        '&rbrksld;'                         => [10638].pack('U*'),
        '&rbrkslu;'                         => [10640].pack('U*'),
        '&Rcaron;'                          => [344].pack('U*'),
        '&rcaron;'                          => [345].pack('U*'),
        '&Rcedil;'                          => [342].pack('U*'),
        '&rcedil;'                          => [343].pack('U*'),
        '&rceil;'                           => [8969].pack('U*'),
        '&rcub;'                            => [125].pack('U*'),
        '&Rcy;'                             => [1056].pack('U*'),
        '&rcy;'                             => [1088].pack('U*'),
        '&rdca;'                            => [10551].pack('U*'),
        '&rdldhar;'                         => [10601].pack('U*'),
        '&rdquo;'                           => [8221].pack('U*'),
        '&rdquor;'                          => [8221].pack('U*'),
        '&rdsh;'                            => [8627].pack('U*'),
        '&Re;'                              => [8476].pack('U*'),
        '&real;'                            => [8476].pack('U*'),
        '&realine;'                         => [8475].pack('U*'),
        '&realpart;'                        => [8476].pack('U*'),
        '&reals;'                           => [8477].pack('U*'),
        '&rect;'                            => [9645].pack('U*'),
        '&REG;'                             => [174].pack('U*'),
        '&reg;'                             => [174].pack('U*'),
        '&ReverseElement;'                  => [8715].pack('U*'),
        '&ReverseEquilibrium;'              => [8651].pack('U*'),
        '&ReverseUpEquilibrium;'            => [10607].pack('U*'),
        '&rfisht;'                          => [10621].pack('U*'),
        '&rfloor;'                          => [8971].pack('U*'),
        '&Rfr;'                             => [8476].pack('U*'),
        '&rfr;'                             => [120111].pack('U*'),
        '&rHar;'                            => [10596].pack('U*'),
        '&rhard;'                           => [8641].pack('U*'),
        '&rharu;'                           => [8640].pack('U*'),
        '&rharul;'                          => [10604].pack('U*'),
        '&Rho;'                             => [929].pack('U*'),
        '&rho;'                             => [961].pack('U*'),
        '&rhov;'                            => [1009].pack('U*'),
        '&RightAngleBracket;'               => [10217].pack('U*'),
        '&RightArrow;'                      => [8594].pack('U*'),
        '&Rightarrow;'                      => [8658].pack('U*'),
        '&rightarrow;'                      => [8594].pack('U*'),
        '&RightArrowBar;'                   => [8677].pack('U*'),
        '&RightArrowLeftArrow;'             => [8644].pack('U*'),
        '&rightarrowtail;'                  => [8611].pack('U*'),
        '&RightCeiling;'                    => [8969].pack('U*'),
        '&RightDoubleBracket;'              => [10215].pack('U*'),
        '&RightDownTeeVector;'              => [10589].pack('U*'),
        '&RightDownVector;'                 => [8642].pack('U*'),
        '&RightDownVectorBar;'              => [10581].pack('U*'),
        '&RightFloor;'                      => [8971].pack('U*'),
        '&rightharpoondown;'                => [8641].pack('U*'),
        '&rightharpoonup;'                  => [8640].pack('U*'),
        '&rightleftarrows;'                 => [8644].pack('U*'),
        '&rightleftharpoons;'               => [8652].pack('U*'),
        '&rightrightarrows;'                => [8649].pack('U*'),
        '&rightsquigarrow;'                 => [8605].pack('U*'),
        '&RightTee;'                        => [8866].pack('U*'),
        '&RightTeeArrow;'                   => [8614].pack('U*'),
        '&RightTeeVector;'                  => [10587].pack('U*'),
        '&rightthreetimes;'                 => [8908].pack('U*'),
        '&RightTriangle;'                   => [8883].pack('U*'),
        '&RightTriangleBar;'                => [10704].pack('U*'),
        '&RightTriangleEqual;'              => [8885].pack('U*'),
        '&RightUpDownVector;'               => [10575].pack('U*'),
        '&RightUpTeeVector;'                => [10588].pack('U*'),
        '&RightUpVector;'                   => [8638].pack('U*'),
        '&RightUpVectorBar;'                => [10580].pack('U*'),
        '&RightVector;'                     => [8640].pack('U*'),
        '&RightVectorBar;'                  => [10579].pack('U*'),
        '&ring;'                            => [730].pack('U*'),
        '&risingdotseq;'                    => [8787].pack('U*'),
        '&rlarr;'                           => [8644].pack('U*'),
        '&rlhar;'                           => [8652].pack('U*'),
        '&rlm;'                             => [8207].pack('U*'),
        '&rmoust;'                          => [9137].pack('U*'),
        '&rmoustache;'                      => [9137].pack('U*'),
        '&rnmid;'                           => [10990].pack('U*'),
        '&roang;'                           => [10221].pack('U*'),
        '&roarr;'                           => [8702].pack('U*'),
        '&robrk;'                           => [10215].pack('U*'),
        '&ropar;'                           => [10630].pack('U*'),
        '&Ropf;'                            => [8477].pack('U*'),
        '&ropf;'                            => [120163].pack('U*'),
        '&roplus;'                          => [10798].pack('U*'),
        '&rotimes;'                         => [10805].pack('U*'),
        '&RoundImplies;'                    => [10608].pack('U*'),
        '&rpar;'                            => [41].pack('U*'),
        '&rpargt;'                          => [10644].pack('U*'),
        '&rppolint;'                        => [10770].pack('U*'),
        '&rrarr;'                           => [8649].pack('U*'),
        '&Rrightarrow;'                     => [8667].pack('U*'),
        '&rsaquo;'                          => [8250].pack('U*'),
        '&Rscr;'                            => [8475].pack('U*'),
        '&rscr;'                            => [120007].pack('U*'),
        '&Rsh;'                             => [8625].pack('U*'),
        '&rsh;'                             => [8625].pack('U*'),
        '&rsqb;'                            => [93].pack('U*'),
        '&rsquo;'                           => [8217].pack('U*'),
        '&rsquor;'                          => [8217].pack('U*'),
        '&rthree;'                          => [8908].pack('U*'),
        '&rtimes;'                          => [8906].pack('U*'),
        '&rtri;'                            => [9657].pack('U*'),
        '&rtrie;'                           => [8885].pack('U*'),
        '&rtrif;'                           => [9656].pack('U*'),
        '&rtriltri;'                        => [10702].pack('U*'),
        '&RuleDelayed;'                     => [10740].pack('U*'),
        '&ruluhar;'                         => [10600].pack('U*'),
        '&rx;'                              => [8478].pack('U*'),
        '&Sacute;'                          => [346].pack('U*'),
        '&sacute;'                          => [347].pack('U*'),
        '&sbquo;'                           => [8218].pack('U*'),
        '&Sc;'                              => [10940].pack('U*'),
        '&sc;'                              => [8827].pack('U*'),
        '&scap;'                            => [10936].pack('U*'),
        '&Scaron;'                          => [352].pack('U*'),
        '&scaron;'                          => [353].pack('U*'),
        '&sccue;'                           => [8829].pack('U*'),
        '&scE;'                             => [10932].pack('U*'),
        '&sce;'                             => [10928].pack('U*'),
        '&Scedil;'                          => [350].pack('U*'),
        '&scedil;'                          => [351].pack('U*'),
        '&Scirc;'                           => [348].pack('U*'),
        '&scirc;'                           => [349].pack('U*'),
        '&scnap;'                           => [10938].pack('U*'),
        '&scnE;'                            => [10934].pack('U*'),
        '&scnsim;'                          => [8937].pack('U*'),
        '&scpolint;'                        => [10771].pack('U*'),
        '&scsim;'                           => [8831].pack('U*'),
        '&Scy;'                             => [1057].pack('U*'),
        '&scy;'                             => [1089].pack('U*'),
        '&sdot;'                            => [8901].pack('U*'),
        '&sdotb;'                           => [8865].pack('U*'),
        '&sdote;'                           => [10854].pack('U*'),
        '&searhk;'                          => [10533].pack('U*'),
        '&seArr;'                           => [8664].pack('U*'),
        '&searr;'                           => [8600].pack('U*'),
        '&searrow;'                         => [8600].pack('U*'),
        '&sect;'                            => [167].pack('U*'),
        '&semi;'                            => [59].pack('U*'),
        '&seswar;'                          => [10537].pack('U*'),
        '&setminus;'                        => [8726].pack('U*'),
        '&setmn;'                           => [8726].pack('U*'),
        '&sext;'                            => [10038].pack('U*'),
        '&Sfr;'                             => [120086].pack('U*'),
        '&sfr;'                             => [120112].pack('U*'),
        '&sfrown;'                          => [8994].pack('U*'),
        '&sharp;'                           => [9839].pack('U*'),
        '&SHCHcy;'                          => [1065].pack('U*'),
        '&shchcy;'                          => [1097].pack('U*'),
        '&SHcy;'                            => [1064].pack('U*'),
        '&shcy;'                            => [1096].pack('U*'),
        '&ShortDownArrow;'                  => [8595].pack('U*'),
        '&ShortLeftArrow;'                  => [8592].pack('U*'),
        '&shortmid;'                        => [8739].pack('U*'),
        '&shortparallel;'                   => [8741].pack('U*'),
        '&ShortRightArrow;'                 => [8594].pack('U*'),
        '&ShortUpArrow;'                    => [8593].pack('U*'),
        '&shy;'                             => [173].pack('U*'),
        '&Sigma;'                           => [931].pack('U*'),
        '&sigma;'                           => [963].pack('U*'),
        '&sigmaf;'                          => [962].pack('U*'),
        '&sigmav;'                          => [962].pack('U*'),
        '&sim;'                             => [8764].pack('U*'),
        '&simdot;'                          => [10858].pack('U*'),
        '&sime;'                            => [8771].pack('U*'),
        '&simeq;'                           => [8771].pack('U*'),
        '&simg;'                            => [10910].pack('U*'),
        '&simgE;'                           => [10912].pack('U*'),
        '&siml;'                            => [10909].pack('U*'),
        '&simlE;'                           => [10911].pack('U*'),
        '&simne;'                           => [8774].pack('U*'),
        '&simplus;'                         => [10788].pack('U*'),
        '&simrarr;'                         => [10610].pack('U*'),
        '&slarr;'                           => [8592].pack('U*'),
        '&SmallCircle;'                     => [8728].pack('U*'),
        '&smallsetminus;'                   => [8726].pack('U*'),
        '&smashp;'                          => [10803].pack('U*'),
        '&smeparsl;'                        => [10724].pack('U*'),
        '&smid;'                            => [8739].pack('U*'),
        '&smile;'                           => [8995].pack('U*'),
        '&smt;'                             => [10922].pack('U*'),
        '&smte;'                            => [10924].pack('U*'),
        '&smtes;'                           => [10924, 65024].pack('U*'),
        '&SOFTcy;'                          => [1068].pack('U*'),
        '&softcy;'                          => [1100].pack('U*'),
        '&sol;'                             => [47].pack('U*'),
        '&solb;'                            => [10692].pack('U*'),
        '&solbar;'                          => [9023].pack('U*'),
        '&Sopf;'                            => [120138].pack('U*'),
        '&sopf;'                            => [120164].pack('U*'),
        '&spades;'                          => [9824].pack('U*'),
        '&spadesuit;'                       => [9824].pack('U*'),
        '&spar;'                            => [8741].pack('U*'),
        '&sqcap;'                           => [8851].pack('U*'),
        '&sqcaps;'                          => [8851, 65024].pack('U*'),
        '&sqcup;'                           => [8852].pack('U*'),
        '&sqcups;'                          => [8852, 65024].pack('U*'),
        '&Sqrt;'                            => [8730].pack('U*'),
        '&sqsub;'                           => [8847].pack('U*'),
        '&sqsube;'                          => [8849].pack('U*'),
        '&sqsubset;'                        => [8847].pack('U*'),
        '&sqsubseteq;'                      => [8849].pack('U*'),
        '&sqsup;'                           => [8848].pack('U*'),
        '&sqsupe;'                          => [8850].pack('U*'),
        '&sqsupset;'                        => [8848].pack('U*'),
        '&sqsupseteq;'                      => [8850].pack('U*'),
        '&squ;'                             => [9633].pack('U*'),
        '&Square;'                          => [9633].pack('U*'),
        '&square;'                          => [9633].pack('U*'),
        '&SquareIntersection;'              => [8851].pack('U*'),
        '&SquareSubset;'                    => [8847].pack('U*'),
        '&SquareSubsetEqual;'               => [8849].pack('U*'),
        '&SquareSuperset;'                  => [8848].pack('U*'),
        '&SquareSupersetEqual;'             => [8850].pack('U*'),
        '&SquareUnion;'                     => [8852].pack('U*'),
        '&squarf;'                          => [9642].pack('U*'),
        '&squf;'                            => [9642].pack('U*'),
        '&srarr;'                           => [8594].pack('U*'),
        '&Sscr;'                            => [119982].pack('U*'),
        '&sscr;'                            => [120008].pack('U*'),
        '&ssetmn;'                          => [8726].pack('U*'),
        '&ssmile;'                          => [8995].pack('U*'),
        '&sstarf;'                          => [8902].pack('U*'),
        '&Star;'                            => [8902].pack('U*'),
        '&star;'                            => [9734].pack('U*'),
        '&starf;'                           => [9733].pack('U*'),
        '&straightepsilon;'                 => [1013].pack('U*'),
        '&straightphi;'                     => [981].pack('U*'),
        '&strns;'                           => [175].pack('U*'),
        '&Sub;'                             => [8912].pack('U*'),
        '&sub;'                             => [8834].pack('U*'),
        '&subdot;'                          => [10941].pack('U*'),
        '&subE;'                            => [10949].pack('U*'),
        '&sube;'                            => [8838].pack('U*'),
        '&subedot;'                         => [10947].pack('U*'),
        '&submult;'                         => [10945].pack('U*'),
        '&subnE;'                           => [10955].pack('U*'),
        '&subne;'                           => [8842].pack('U*'),
        '&subplus;'                         => [10943].pack('U*'),
        '&subrarr;'                         => [10617].pack('U*'),
        '&Subset;'                          => [8912].pack('U*'),
        '&subset;'                          => [8834].pack('U*'),
        '&subseteq;'                        => [8838].pack('U*'),
        '&subseteqq;'                       => [10949].pack('U*'),
        '&SubsetEqual;'                     => [8838].pack('U*'),
        '&subsetneq;'                       => [8842].pack('U*'),
        '&subsetneqq;'                      => [10955].pack('U*'),
        '&subsim;'                          => [10951].pack('U*'),
        '&subsub;'                          => [10965].pack('U*'),
        '&subsup;'                          => [10963].pack('U*'),
        '&succ;'                            => [8827].pack('U*'),
        '&succapprox;'                      => [10936].pack('U*'),
        '&succcurlyeq;'                     => [8829].pack('U*'),
        '&Succeeds;'                        => [8827].pack('U*'),
        '&SucceedsEqual;'                   => [10928].pack('U*'),
        '&SucceedsSlantEqual;'              => [8829].pack('U*'),
        '&SucceedsTilde;'                   => [8831].pack('U*'),
        '&succeq;'                          => [10928].pack('U*'),
        '&succnapprox;'                     => [10938].pack('U*'),
        '&succneqq;'                        => [10934].pack('U*'),
        '&succnsim;'                        => [8937].pack('U*'),
        '&succsim;'                         => [8831].pack('U*'),
        '&SuchThat;'                        => [8715].pack('U*'),
        '&Sum;'                             => [8721].pack('U*'),
        '&sum;'                             => [8721].pack('U*'),
        '&sung;'                            => [9834].pack('U*'),
        '&Sup;'                             => [8913].pack('U*'),
        '&sup;'                             => [8835].pack('U*'),
        '&sup1;'                            => [185].pack('U*'),
        '&sup2;'                            => [178].pack('U*'),
        '&sup3;'                            => [179].pack('U*'),
        '&supdot;'                          => [10942].pack('U*'),
        '&supdsub;'                         => [10968].pack('U*'),
        '&supE;'                            => [10950].pack('U*'),
        '&supe;'                            => [8839].pack('U*'),
        '&supedot;'                         => [10948].pack('U*'),
        '&Superset;'                        => [8835].pack('U*'),
        '&SupersetEqual;'                   => [8839].pack('U*'),
        '&suphsol;'                         => [10185].pack('U*'),
        '&suphsub;'                         => [10967].pack('U*'),
        '&suplarr;'                         => [10619].pack('U*'),
        '&supmult;'                         => [10946].pack('U*'),
        '&supnE;'                           => [10956].pack('U*'),
        '&supne;'                           => [8843].pack('U*'),
        '&supplus;'                         => [10944].pack('U*'),
        '&Supset;'                          => [8913].pack('U*'),
        '&supset;'                          => [8835].pack('U*'),
        '&supseteq;'                        => [8839].pack('U*'),
        '&supseteqq;'                       => [10950].pack('U*'),
        '&supsetneq;'                       => [8843].pack('U*'),
        '&supsetneqq;'                      => [10956].pack('U*'),
        '&supsim;'                          => [10952].pack('U*'),
        '&supsub;'                          => [10964].pack('U*'),
        '&supsup;'                          => [10966].pack('U*'),
        '&swarhk;'                          => [10534].pack('U*'),
        '&swArr;'                           => [8665].pack('U*'),
        '&swarr;'                           => [8601].pack('U*'),
        '&swarrow;'                         => [8601].pack('U*'),
        '&swnwar;'                          => [10538].pack('U*'),
        '&szlig;'                           => [223].pack('U*'),
        '&Tab;'                             => [9].pack('U*'),
        '&target;'                          => [8982].pack('U*'),
        '&Tau;'                             => [932].pack('U*'),
        '&tau;'                             => [964].pack('U*'),
        '&tbrk;'                            => [9140].pack('U*'),
        '&Tcaron;'                          => [356].pack('U*'),
        '&tcaron;'                          => [357].pack('U*'),
        '&Tcedil;'                          => [354].pack('U*'),
        '&tcedil;'                          => [355].pack('U*'),
        '&Tcy;'                             => [1058].pack('U*'),
        '&tcy;'                             => [1090].pack('U*'),
        '&tdot;'                            => [8411].pack('U*'),
        '&telrec;'                          => [8981].pack('U*'),
        '&Tfr;'                             => [120087].pack('U*'),
        '&tfr;'                             => [120113].pack('U*'),
        '&there4;'                          => [8756].pack('U*'),
        '&Therefore;'                       => [8756].pack('U*'),
        '&therefore;'                       => [8756].pack('U*'),
        '&Theta;'                           => [920].pack('U*'),
        '&theta;'                           => [952].pack('U*'),
        '&thetasym;'                        => [977].pack('U*'),
        '&thetav;'                          => [977].pack('U*'),
        '&thickapprox;'                     => [8776].pack('U*'),
        '&thicksim;'                        => [8764].pack('U*'),
        '&ThickSpace;'                      => [8287, 8202].pack('U*'),
        '&thinsp;'                          => [8201].pack('U*'),
        '&ThinSpace;'                       => [8201].pack('U*'),
        '&thkap;'                           => [8776].pack('U*'),
        '&thksim;'                          => [8764].pack('U*'),
        '&THORN;'                           => [222].pack('U*'),
        '&thorn;'                           => [254].pack('U*'),
        '&Tilde;'                           => [8764].pack('U*'),
        '&tilde;'                           => [732].pack('U*'),
        '&TildeEqual;'                      => [8771].pack('U*'),
        '&TildeFullEqual;'                  => [8773].pack('U*'),
        '&TildeTilde;'                      => [8776].pack('U*'),
        '&times;'                           => [215].pack('U*'),
        '&timesb;'                          => [8864].pack('U*'),
        '&timesbar;'                        => [10801].pack('U*'),
        '&timesd;'                          => [10800].pack('U*'),
        '&tint;'                            => [8749].pack('U*'),
        '&toea;'                            => [10536].pack('U*'),
        '&top;'                             => [8868].pack('U*'),
        '&topbot;'                          => [9014].pack('U*'),
        '&topcir;'                          => [10993].pack('U*'),
        '&Topf;'                            => [120139].pack('U*'),
        '&topf;'                            => [120165].pack('U*'),
        '&topfork;'                         => [10970].pack('U*'),
        '&tosa;'                            => [10537].pack('U*'),
        '&tprime;'                          => [8244].pack('U*'),
        '&TRADE;'                           => [8482].pack('U*'),
        '&trade;'                           => [8482].pack('U*'),
        '&triangle;'                        => [9653].pack('U*'),
        '&triangledown;'                    => [9663].pack('U*'),
        '&triangleleft;'                    => [9667].pack('U*'),
        '&trianglelefteq;'                  => [8884].pack('U*'),
        '&triangleq;'                       => [8796].pack('U*'),
        '&triangleright;'                   => [9657].pack('U*'),
        '&trianglerighteq;'                 => [8885].pack('U*'),
        '&tridot;'                          => [9708].pack('U*'),
        '&trie;'                            => [8796].pack('U*'),
        '&triminus;'                        => [10810].pack('U*'),
        '&TripleDot;'                       => [8411].pack('U*'),
        '&triplus;'                         => [10809].pack('U*'),
        '&trisb;'                           => [10701].pack('U*'),
        '&tritime;'                         => [10811].pack('U*'),
        '&trpezium;'                        => [9186].pack('U*'),
        '&Tscr;'                            => [119983].pack('U*'),
        '&tscr;'                            => [120009].pack('U*'),
        '&TScy;'                            => [1062].pack('U*'),
        '&tscy;'                            => [1094].pack('U*'),
        '&TSHcy;'                           => [1035].pack('U*'),
        '&tshcy;'                           => [1115].pack('U*'),
        '&Tstrok;'                          => [358].pack('U*'),
        '&tstrok;'                          => [359].pack('U*'),
        '&twixt;'                           => [8812].pack('U*'),
        '&twoheadleftarrow;'                => [8606].pack('U*'),
        '&twoheadrightarrow;'               => [8608].pack('U*'),
        '&Uacute;'                          => [218].pack('U*'),
        '&uacute;'                          => [250].pack('U*'),
        '&Uarr;'                            => [8607].pack('U*'),
        '&uArr;'                            => [8657].pack('U*'),
        '&uarr;'                            => [8593].pack('U*'),
        '&Uarrocir;'                        => [10569].pack('U*'),
        '&Ubrcy;'                           => [1038].pack('U*'),
        '&ubrcy;'                           => [1118].pack('U*'),
        '&Ubreve;'                          => [364].pack('U*'),
        '&ubreve;'                          => [365].pack('U*'),
        '&Ucirc;'                           => [219].pack('U*'),
        '&ucirc;'                           => [251].pack('U*'),
        '&Ucy;'                             => [1059].pack('U*'),
        '&ucy;'                             => [1091].pack('U*'),
        '&udarr;'                           => [8645].pack('U*'),
        '&Udblac;'                          => [368].pack('U*'),
        '&udblac;'                          => [369].pack('U*'),
        '&udhar;'                           => [10606].pack('U*'),
        '&ufisht;'                          => [10622].pack('U*'),
        '&Ufr;'                             => [120088].pack('U*'),
        '&ufr;'                             => [120114].pack('U*'),
        '&Ugrave;'                          => [217].pack('U*'),
        '&ugrave;'                          => [249].pack('U*'),
        '&uHar;'                            => [10595].pack('U*'),
        '&uharl;'                           => [8639].pack('U*'),
        '&uharr;'                           => [8638].pack('U*'),
        '&uhblk;'                           => [9600].pack('U*'),
        '&ulcorn;'                          => [8988].pack('U*'),
        '&ulcorner;'                        => [8988].pack('U*'),
        '&ulcrop;'                          => [8975].pack('U*'),
        '&ultri;'                           => [9720].pack('U*'),
        '&Umacr;'                           => [362].pack('U*'),
        '&umacr;'                           => [363].pack('U*'),
        '&uml;'                             => [168].pack('U*'),
        '&UnderBar;'                        => [95].pack('U*'),
        '&UnderBrace;'                      => [9183].pack('U*'),
        '&UnderBracket;'                    => [9141].pack('U*'),
        '&UnderParenthesis;'                => [9181].pack('U*'),
        '&Union;'                           => [8899].pack('U*'),
        '&UnionPlus;'                       => [8846].pack('U*'),
        '&Uogon;'                           => [370].pack('U*'),
        '&uogon;'                           => [371].pack('U*'),
        '&Uopf;'                            => [120140].pack('U*'),
        '&uopf;'                            => [120166].pack('U*'),
        '&UpArrow;'                         => [8593].pack('U*'),
        '&Uparrow;'                         => [8657].pack('U*'),
        '&uparrow;'                         => [8593].pack('U*'),
        '&UpArrowBar;'                      => [10514].pack('U*'),
        '&UpArrowDownArrow;'                => [8645].pack('U*'),
        '&UpDownArrow;'                     => [8597].pack('U*'),
        '&Updownarrow;'                     => [8661].pack('U*'),
        '&updownarrow;'                     => [8597].pack('U*'),
        '&UpEquilibrium;'                   => [10606].pack('U*'),
        '&upharpoonleft;'                   => [8639].pack('U*'),
        '&upharpoonright;'                  => [8638].pack('U*'),
        '&uplus;'                           => [8846].pack('U*'),
        '&UpperLeftArrow;'                  => [8598].pack('U*'),
        '&UpperRightArrow;'                 => [8599].pack('U*'),
        '&Upsi;'                            => [978].pack('U*'),
        '&upsi;'                            => [965].pack('U*'),
        '&upsih;'                           => [978].pack('U*'),
        '&Upsilon;'                         => [933].pack('U*'),
        '&upsilon;'                         => [965].pack('U*'),
        '&UpTee;'                           => [8869].pack('U*'),
        '&UpTeeArrow;'                      => [8613].pack('U*'),
        '&upuparrows;'                      => [8648].pack('U*'),
        '&urcorn;'                          => [8989].pack('U*'),
        '&urcorner;'                        => [8989].pack('U*'),
        '&urcrop;'                          => [8974].pack('U*'),
        '&Uring;'                           => [366].pack('U*'),
        '&uring;'                           => [367].pack('U*'),
        '&urtri;'                           => [9721].pack('U*'),
        '&Uscr;'                            => [119984].pack('U*'),
        '&uscr;'                            => [120010].pack('U*'),
        '&utdot;'                           => [8944].pack('U*'),
        '&Utilde;'                          => [360].pack('U*'),
        '&utilde;'                          => [361].pack('U*'),
        '&utri;'                            => [9653].pack('U*'),
        '&utrif;'                           => [9652].pack('U*'),
        '&uuarr;'                           => [8648].pack('U*'),
        '&Uuml;'                            => [220].pack('U*'),
        '&uuml;'                            => [252].pack('U*'),
        '&uwangle;'                         => [10663].pack('U*'),
        '&vangrt;'                          => [10652].pack('U*'),
        '&varepsilon;'                      => [1013].pack('U*'),
        '&varkappa;'                        => [1008].pack('U*'),
        '&varnothing;'                      => [8709].pack('U*'),
        '&varphi;'                          => [981].pack('U*'),
        '&varpi;'                           => [982].pack('U*'),
        '&varpropto;'                       => [8733].pack('U*'),
        '&vArr;'                            => [8661].pack('U*'),
        '&varr;'                            => [8597].pack('U*'),
        '&varrho;'                          => [1009].pack('U*'),
        '&varsigma;'                        => [962].pack('U*'),
        '&varsubsetneq;'                    => [8842, 65024].pack('U*'),
        '&varsubsetneqq;'                   => [10955, 65024].pack('U*'),
        '&varsupsetneq;'                    => [8843, 65024].pack('U*'),
        '&varsupsetneqq;'                   => [10956, 65024].pack('U*'),
        '&vartheta;'                        => [977].pack('U*'),
        '&vartriangleleft;'                 => [8882].pack('U*'),
        '&vartriangleright;'                => [8883].pack('U*'),
        '&Vbar;'                            => [10987].pack('U*'),
        '&vBar;'                            => [10984].pack('U*'),
        '&vBarv;'                           => [10985].pack('U*'),
        '&Vcy;'                             => [1042].pack('U*'),
        '&vcy;'                             => [1074].pack('U*'),
        '&VDash;'                           => [8875].pack('U*'),
        '&Vdash;'                           => [8873].pack('U*'),
        '&vDash;'                           => [8872].pack('U*'),
        '&vdash;'                           => [8866].pack('U*'),
        '&Vdashl;'                          => [10982].pack('U*'),
        '&Vee;'                             => [8897].pack('U*'),
        '&vee;'                             => [8744].pack('U*'),
        '&veebar;'                          => [8891].pack('U*'),
        '&veeeq;'                           => [8794].pack('U*'),
        '&vellip;'                          => [8942].pack('U*'),
        '&Verbar;'                          => [8214].pack('U*'),
        '&verbar;'                          => [124].pack('U*'),
        '&Vert;'                            => [8214].pack('U*'),
        '&vert;'                            => [124].pack('U*'),
        '&VerticalBar;'                     => [8739].pack('U*'),
        '&VerticalLine;'                    => [124].pack('U*'),
        '&VerticalSeparator;'               => [10072].pack('U*'),
        '&VerticalTilde;'                   => [8768].pack('U*'),
        '&VeryThinSpace;'                   => [8202].pack('U*'),
        '&Vfr;'                             => [120089].pack('U*'),
        '&vfr;'                             => [120115].pack('U*'),
        '&vltri;'                           => [8882].pack('U*'),
        '&vnsub;'                           => [8834, 8402].pack('U*'),
        '&vnsup;'                           => [8835, 8402].pack('U*'),
        '&Vopf;'                            => [120141].pack('U*'),
        '&vopf;'                            => [120167].pack('U*'),
        '&vprop;'                           => [8733].pack('U*'),
        '&vrtri;'                           => [8883].pack('U*'),
        '&Vscr;'                            => [119985].pack('U*'),
        '&vscr;'                            => [120011].pack('U*'),
        '&vsubnE;'                          => [10955, 65024].pack('U*'),
        '&vsubne;'                          => [8842, 65024].pack('U*'),
        '&vsupnE;'                          => [10956, 65024].pack('U*'),
        '&vsupne;'                          => [8843, 65024].pack('U*'),
        '&Vvdash;'                          => [8874].pack('U*'),
        '&vzigzag;'                         => [10650].pack('U*'),
        '&Wcirc;'                           => [372].pack('U*'),
        '&wcirc;'                           => [373].pack('U*'),
        '&wedbar;'                          => [10847].pack('U*'),
        '&Wedge;'                           => [8896].pack('U*'),
        '&wedge;'                           => [8743].pack('U*'),
        '&wedgeq;'                          => [8793].pack('U*'),
        '&weierp;'                          => [8472].pack('U*'),
        '&Wfr;'                             => [120090].pack('U*'),
        '&wfr;'                             => [120116].pack('U*'),
        '&Wopf;'                            => [120142].pack('U*'),
        '&wopf;'                            => [120168].pack('U*'),
        '&wp;'                              => [8472].pack('U*'),
        '&wr;'                              => [8768].pack('U*'),
        '&wreath;'                          => [8768].pack('U*'),
        '&Wscr;'                            => [119986].pack('U*'),
        '&wscr;'                            => [120012].pack('U*'),
        '&xcap;'                            => [8898].pack('U*'),
        '&xcirc;'                           => [9711].pack('U*'),
        '&xcup;'                            => [8899].pack('U*'),
        '&xdtri;'                           => [9661].pack('U*'),
        '&Xfr;'                             => [120091].pack('U*'),
        '&xfr;'                             => [120117].pack('U*'),
        '&xhArr;'                           => [10234].pack('U*'),
        '&xharr;'                           => [10231].pack('U*'),
        '&Xi;'                              => [926].pack('U*'),
        '&xi;'                              => [958].pack('U*'),
        '&xlArr;'                           => [10232].pack('U*'),
        '&xlarr;'                           => [10229].pack('U*'),
        '&xmap;'                            => [10236].pack('U*'),
        '&xnis;'                            => [8955].pack('U*'),
        '&xodot;'                           => [10752].pack('U*'),
        '&Xopf;'                            => [120143].pack('U*'),
        '&xopf;'                            => [120169].pack('U*'),
        '&xoplus;'                          => [10753].pack('U*'),
        '&xotime;'                          => [10754].pack('U*'),
        '&xrArr;'                           => [10233].pack('U*'),
        '&xrarr;'                           => [10230].pack('U*'),
        '&Xscr;'                            => [119987].pack('U*'),
        '&xscr;'                            => [120013].pack('U*'),
        '&xsqcup;'                          => [10758].pack('U*'),
        '&xuplus;'                          => [10756].pack('U*'),
        '&xutri;'                           => [9651].pack('U*'),
        '&xvee;'                            => [8897].pack('U*'),
        '&xwedge;'                          => [8896].pack('U*'),
        '&Yacute;'                          => [221].pack('U*'),
        '&yacute;'                          => [253].pack('U*'),
        '&YAcy;'                            => [1071].pack('U*'),
        '&yacy;'                            => [1103].pack('U*'),
        '&Ycirc;'                           => [374].pack('U*'),
        '&ycirc;'                           => [375].pack('U*'),
        '&Ycy;'                             => [1067].pack('U*'),
        '&ycy;'                             => [1099].pack('U*'),
        '&yen;'                             => [165].pack('U*'),
        '&Yfr;'                             => [120092].pack('U*'),
        '&yfr;'                             => [120118].pack('U*'),
        '&YIcy;'                            => [1031].pack('U*'),
        '&yicy;'                            => [1111].pack('U*'),
        '&Yopf;'                            => [120144].pack('U*'),
        '&yopf;'                            => [120170].pack('U*'),
        '&Yscr;'                            => [119988].pack('U*'),
        '&yscr;'                            => [120014].pack('U*'),
        '&YUcy;'                            => [1070].pack('U*'),
        '&yucy;'                            => [1102].pack('U*'),
        '&Yuml;'                            => [376].pack('U*'),
        '&yuml;'                            => [255].pack('U*'),
        '&Zacute;'                          => [377].pack('U*'),
        '&zacute;'                          => [378].pack('U*'),
        '&Zcaron;'                          => [381].pack('U*'),
        '&zcaron;'                          => [382].pack('U*'),
        '&Zcy;'                             => [1047].pack('U*'),
        '&zcy;'                             => [1079].pack('U*'),
        '&Zdot;'                            => [379].pack('U*'),
        '&zdot;'                            => [380].pack('U*'),
        '&zeetrf;'                          => [8488].pack('U*'),
        '&ZeroWidthSpace;'                  => [8203].pack('U*'),
        '&Zeta;'                            => [918].pack('U*'),
        '&zeta;'                            => [950].pack('U*'),
        '&Zfr;'                             => [8488].pack('U*'),
        '&zfr;'                             => [120119].pack('U*'),
        '&ZHcy;'                            => [1046].pack('U*'),
        '&zhcy;'                            => [1078].pack('U*'),
        '&zigrarr;'                         => [8669].pack('U*'),
        '&Zopf;'                            => [8484].pack('U*'),
        '&zopf;'                            => [120171].pack('U*'),
        '&Zscr;'                            => [119989].pack('U*'),
        '&zscr;'                            => [120015].pack('U*'),
        '&zwj;'                             => [8205].pack('U*'),
        '&zwnj;'                            => [8204].pack('U*'),
      }

      ##
      # Decodes HTML entities.
      #
      # @see [decode]
      #
      def self.decode(input)
        return XML::Entities.decode(input, DECODE_MAPPING)
      end
    end # Entities
  end # HTML
end # Oga
