/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public abstract class DialogDisplayer {
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public static DialogDisplayer getDefault() {
        DialogDisplayer dd = (DialogDisplayer)Lookup.getDefault().lookup(DialogDisplayer.class);
        if (dd == null) {
            dd = new Trivial();
        }
        return dd;
    }

    protected DialogDisplayer() {
    }

    public abstract Object notify(NotifyDescriptor var1);

    public abstract Dialog createDialog(DialogDescriptor var1);

    private static final class Trivial
    extends DialogDisplayer {
        private Trivial() {
        }

        public Object notify(NotifyDescriptor nd) {
            StandardDialog dialog = new StandardDialog(nd.getTitle(), true, nd, null, null);
            dialog.show();
            return nd.getValue() != null ? nd.getValue() : NotifyDescriptor.CLOSED_OPTION;
        }

        public Dialog createDialog(final DialogDescriptor dd) {
            final StandardDialog dialog = new StandardDialog(dd.getTitle(), dd.isModal(), dd, dd.getClosingOptions(), dd.getButtonListener());
            dd.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    String pname = ev.getPropertyName();
                    if ("title".equals(pname)) {
                        dialog.setTitle(dd.getTitle());
                    } else if ("message".equals(pname)) {
                        dialog.updateMessage();
                        dialog.validate();
                        dialog.repaint();
                    } else if ("options".equals(pname) || "optionType".equals(pname)) {
                        dialog.updateOptions();
                        dialog.validate();
                        dialog.repaint();
                    }
                }
            });
            return dialog;
        }

        private static Component message2Component(Object message) {
            if (message instanceof Component) {
                return (Component)message;
            }
            if (message instanceof Object[]) {
                Object[] sub = (Object[])message;
                JPanel panel = new JPanel();
                panel.setLayout(new FlowLayout());
                for (int i = 0; i < sub.length; ++i) {
                    panel.add(Trivial.message2Component(sub[i]));
                }
                return panel;
            }
            if (message instanceof Icon) {
                return new JLabel((Icon)message);
            }
            String text = message.toString();
            JTextArea area = new JTextArea(text);
            Color c = UIManager.getColor("Label.background");
            if (c != null) {
                area.setBackground(c);
            }
            area.setLineWrap(true);
            area.setWrapStyleWord(true);
            area.setEditable(false);
            area.setTabSize(4);
            area.setColumns(40);
            if (text.indexOf(10) != -1) {
                return new JScrollPane(area);
            }
            return area;
        }

        private static Component option2Button(Object option, NotifyDescriptor nd, ActionListener l, JRootPane rp) {
            boolean defcap;
            String text;
            if (option instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)option;
                b.addActionListener(l);
                return b;
            }
            if (option instanceof Component) {
                return (Component)option;
            }
            if (option instanceof Icon) {
                return new JLabel((Icon)option);
            }
            if (option == NotifyDescriptor.OK_OPTION) {
                text = "OK";
                defcap = true;
            } else if (option == NotifyDescriptor.CANCEL_OPTION) {
                text = "Cancel";
                defcap = false;
            } else if (option == NotifyDescriptor.YES_OPTION) {
                text = "Yes";
                defcap = true;
            } else if (option == NotifyDescriptor.NO_OPTION) {
                text = "No";
                defcap = false;
            } else {
                if (option == NotifyDescriptor.CLOSED_OPTION) {
                    throw new IllegalArgumentException();
                }
                text = option.toString();
                defcap = false;
            }
            JButton b = new JButton(text);
            if (defcap && rp.getDefaultButton() == null) {
                rp.setDefaultButton(b);
            }
            b.getAccessibleContext().setAccessibleName(text);
            b.addActionListener(l);
            return b;
        }

        private static final class StandardDialog
        extends JDialog {
            private final NotifyDescriptor nd;
            private Component messageComponent;
            private final JPanel buttonPanel;
            private final Object[] closingOptions;
            private final ActionListener buttonListener;
            private boolean haveFinalValue = false;

            public StandardDialog(String title, boolean modal, NotifyDescriptor nd, Object[] closingOptions, ActionListener buttonListener) {
                super((Frame)null, title, modal);
                this.nd = nd;
                this.closingOptions = closingOptions;
                this.buttonListener = buttonListener;
                this.getContentPane().setLayout(new BorderLayout());
                this.setDefaultCloseOperation(2);
                this.updateMessage();
                this.buttonPanel = new JPanel();
                this.buttonPanel.setLayout(new FlowLayout(2));
                this.updateOptions();
                this.getContentPane().add(this.buttonPanel, "South", 1);
                KeyStroke k = KeyStroke.getKeyStroke(27, 0);
                String actionKey = "cancel";
                this.getRootPane().getInputMap(1).put(k, actionKey);
                AbstractAction cancelAction = new AbstractAction(this){
                    private final /* synthetic */ StandardDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        StandardDialog.access$100(this.this$0);
                    }
                };
                this.getRootPane().getActionMap().put(actionKey, cancelAction);
                this.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ StandardDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void windowClosing(WindowEvent ev) {
                        if (!StandardDialog.access$200(this.this$0)) {
                            StandardDialog.access$300(this.this$0).setValue(NotifyDescriptor.CLOSED_OPTION);
                        }
                    }
                });
                this.pack();
                Rectangle r = Utilities.getUsableScreenBounds();
                int maxW = r.width * 9 / 10;
                int maxH = r.height * 9 / 10;
                Dimension d = this.getPreferredSize();
                d.width = Math.min(d.width, maxW);
                d.height = Math.min(d.height, maxH);
                this.setBounds(Utilities.findCenterBounds(d));
            }

            private void cancel() {
                this.nd.setValue(NotifyDescriptor.CANCEL_OPTION);
                this.haveFinalValue = true;
                this.dispose();
            }

            public void updateMessage() {
                if (this.messageComponent != null) {
                    this.getContentPane().remove(this.messageComponent);
                }
                this.messageComponent = Trivial.message2Component(this.nd.getMessage());
                this.getContentPane().add(this.messageComponent, "Center");
            }

            public void updateOptions() {
                int i;
                HashSet<Object> addedOptions = new HashSet<Object>(5);
                Object[] options = this.nd.getOptions();
                if (options == null) {
                    switch (this.nd.getOptionType()) {
                        case -1: 
                        case 2: {
                            options = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
                            break;
                        }
                        case 0: {
                            options = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION};
                            break;
                        }
                        case 1: {
                            options = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, NotifyDescriptor.CANCEL_OPTION};
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                this.buttonPanel.removeAll();
                JRootPane rp = this.getRootPane();
                for (i = 0; i < options.length; ++i) {
                    addedOptions.add(options[i]);
                    this.buttonPanel.add(Trivial.option2Button(options[i], this.nd, this.makeListener(options[i]), rp));
                }
                options = this.nd.getAdditionalOptions();
                if (options != null) {
                    for (i = 0; i < options.length; ++i) {
                        addedOptions.add(options[i]);
                        this.buttonPanel.add(Trivial.option2Button(options[i], this.nd, this.makeListener(options[i]), rp));
                    }
                }
                if (this.closingOptions != null) {
                    for (i = 0; i < this.closingOptions.length; ++i) {
                        if (!addedOptions.add(this.closingOptions[i])) continue;
                        ActionListener l = this.makeListener(this.closingOptions[i]);
                        this.attachActionListener(this.closingOptions[i], l);
                    }
                }
            }

            private void attachActionListener(Object comp, ActionListener l) {
                if (comp instanceof JButton) {
                    JButton b = (JButton)comp;
                    b.addActionListener(l);
                    return;
                }
                Method m = null;
                try {
                    m = comp.getClass().getMethod("addActionListener", class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = DialogDisplayer.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
                    try {
                        m.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        m = null;
                    }
                }
                catch (NoSuchMethodException e) {
                    m = null;
                }
                catch (SecurityException e2) {
                    m = null;
                }
                if (m != null) {
                    try {
                        m.invoke(comp, l);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }

            private ActionListener makeListener(Object option) {
                return new ActionListener(this, option){
                    private final /* synthetic */ Object val$option;
                    private final /* synthetic */ StandardDialog this$0;
                    {
                        this.this$0 = this$0;
                        this.val$option = val$option;
                    }

                    public void actionPerformed(ActionEvent e) {
                        StandardDialog.access$300(this.this$0).setValue(this.val$option);
                        if (StandardDialog.access$600(this.this$0) != null) {
                            ActionEvent e2 = new ActionEvent(this.val$option, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
                            StandardDialog.access$600(this.this$0).actionPerformed(e2);
                        }
                        if (StandardDialog.access$700(this.this$0) == null || Arrays.asList(StandardDialog.access$700(this.this$0)).contains(this.val$option)) {
                            StandardDialog.access$202(this.this$0, true);
                            this.this$0.setVisible(false);
                        }
                    }
                };
            }

            static /* synthetic */ void access$100(StandardDialog x0) {
                x0.cancel();
            }

            static /* synthetic */ boolean access$200(StandardDialog x0) {
                return x0.haveFinalValue;
            }

            static /* synthetic */ NotifyDescriptor access$300(StandardDialog x0) {
                return x0.nd;
            }

            static /* synthetic */ ActionListener access$600(StandardDialog x0) {
                return x0.buttonListener;
            }

            static /* synthetic */ Object[] access$700(StandardDialog x0) {
                return x0.closingOptions;
            }

            static /* synthetic */ boolean access$202(StandardDialog x0, boolean x1) {
                x0.haveFinalValue = x1;
                return x0.haveFinalValue;
            }
        }
    }
}

