/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

final class ExplorerActionsImpl {
    private final CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private final CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private final DeleteActionPerformer deleteActionPerformerConfirm = new DeleteActionPerformer(true);
    private final DeleteActionPerformer deleteActionPerformerNoConfirm = new DeleteActionPerformer(false);
    private final OwnPaste pasteActionPerformer = new OwnPaste();
    private ActionStateUpdater actionStateUpdater;
    private ExplorerManager manager;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerActionsImpl;

    ExplorerActionsImpl() {
    }

    final Action copyAction() {
        return this.copyActionPerformer;
    }

    final Action cutAction() {
        return this.cutActionPerformer;
    }

    final Action deleteAction(boolean confirm) {
        return confirm ? this.deleteActionPerformerConfirm : this.deleteActionPerformerNoConfirm;
    }

    final Action pasteAction() {
        return this.pasteActionPerformer;
    }

    public synchronized void attach(ExplorerManager m) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = m;
        this.actionStateUpdater = new ActionStateUpdater();
        this.manager.addPropertyChangeListener(WeakListeners.propertyChange(this.actionStateUpdater, this.manager));
        Clipboard c = ExplorerActionsImpl.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.addClipboardListener((ClipboardListener)WeakListeners.create(ClipboardListener.class, this.actionStateUpdater, clip));
        }
        this.updateActions();
    }

    public synchronized void detach() {
        if (this.manager == null) {
            return;
        }
        this.actionStateUpdater = null;
        this.stopActions();
        this.manager = null;
    }

    ExplorerManager getAttachedManager() {
        return this.manager;
    }

    private void stopActions() {
        if (this.copyActionPerformer != null) {
            this.copyActionPerformer.setEnabled(false);
            this.cutActionPerformer.setEnabled(false);
            this.deleteActionPerformerConfirm.setEnabled(false);
            this.deleteActionPerformerNoConfirm.setEnabled(false);
            this.pasteActionPerformer.setEnabled(false);
        }
    }

    private void updateActions() {
        int k;
        if (this.manager == null) {
            return;
        }
        Node[] path = this.manager.getSelectedNodes();
        int n = k = path != null ? path.length : 0;
        if (k > 0) {
            int i;
            boolean incest = false;
            if (k > 1) {
                HashMap allNodes = new HashMap(101);
                for (i = 0; i < k; ++i) {
                    if (this.checkParents(path[i], allNodes)) continue;
                    incest = true;
                    break;
                }
            }
            for (i = 0; i < k; ++i) {
                if (!incest && path[i].canCopy()) continue;
                this.copyActionPerformer.setEnabled(false);
                break;
            }
            if (i == k) {
                this.copyActionPerformer.setEnabled(true);
            }
            for (i = 0; i < k; ++i) {
                if (!incest && path[i].canCut()) continue;
                this.cutActionPerformer.setEnabled(false);
                break;
            }
            if (i == k) {
                this.cutActionPerformer.setEnabled(true);
            }
            for (i = 0; i < k; ++i) {
                if (!incest && path[i].canDestroy()) continue;
                this.deleteActionPerformerConfirm.setEnabled(false);
                this.deleteActionPerformerNoConfirm.setEnabled(false);
                break;
            }
            if (i == k) {
                this.deleteActionPerformerConfirm.setEnabled(true);
                this.deleteActionPerformerNoConfirm.setEnabled(true);
            }
        } else {
            this.copyActionPerformer.setEnabled(false);
            this.cutActionPerformer.setEnabled(false);
            this.deleteActionPerformerConfirm.setEnabled(false);
            this.deleteActionPerformerNoConfirm.setEnabled(false);
        }
        this.updatePasteAction(path);
    }

    private boolean checkParents(Node node, HashMap set) {
        if (set.get(node) != null) {
            return false;
        }
        set.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (set.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] path) {
        ExplorerManager man = this.manager;
        if (man == null) {
            this.pasteActionPerformer.setPasteTypes(null);
            return;
        }
        if (path != null && path.length > 1) {
            this.pasteActionPerformer.setPasteTypes(null);
            return;
        }
        Node node = man.getExploredContext();
        Node[] selectedNodes = man.getSelectedNodes();
        if (selectedNodes != null && selectedNodes.length == 1) {
            node = selectedNodes[0];
        }
        if (node != null) {
            Transferable trans = ExplorerActionsImpl.getClipboard().getContents(this);
            this.updatePasteTypes(trans, node);
        }
    }

    private void updatePasteTypes(Transferable trans, Node pan) {
        if (trans != null) {
            PasteType[] pasteTypes;
            PasteType[] pasteTypeArray = pasteTypes = pan == null ? new PasteType[]{} : pan.getPasteTypes(trans);
            if (pasteTypes.length != 0) {
                this.pasteActionPerformer.setPasteTypes(pasteTypes);
                return;
            }
            boolean flavorSupported = false;
            try {
                flavorSupported = trans.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (flavorSupported) {
                try {
                    MultiTransferObject obj = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
                    int count = obj.getCount();
                    boolean ok = true;
                    Transferable[] t = new Transferable[count];
                    PasteType[] p = new PasteType[count];
                    for (int i = 0; i < count; ++i) {
                        t[i] = obj.getTransferableAt(i);
                        PasteType[] pasteTypeArray2 = pasteTypes = pan == null ? new PasteType[]{} : pan.getPasteTypes(t[i]);
                        if (pasteTypes.length == 0) {
                            ok = false;
                            break;
                        }
                        p[i] = pasteTypes[0];
                    }
                    if (ok) {
                        PasteType[] arrOfPaste = new PasteType[]{new MultiPasteType(t, p)};
                        this.pasteActionPerformer.setPasteTypes(arrOfPaste);
                        return;
                    }
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        this.pasteActionPerformer.setPasteTypes(null);
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActionsState() {
        ActionStateUpdater asu;
        ExplorerActionsImpl explorerActionsImpl = this;
        synchronized (explorerActionsImpl) {
            asu = this.actionStateUpdater;
        }
        if (asu != null) {
            asu.update();
        }
    }

    private static class FixIssue29405Timer
    extends Timer {
        private boolean running;

        public FixIssue29405Timer(int delay, ActionListener l) {
            super(delay, l);
        }

        public void restart() {
            super.restart();
            this.running = true;
        }

        public void stop() {
            this.running = false;
            super.stop();
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    private class ActionStateUpdater
    implements PropertyChangeListener,
    ClipboardListener,
    ActionListener,
    Runnable {
        private final Timer timer = new FixIssue29405Timer(150, this);
        private boolean planned;

        ActionStateUpdater() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public synchronized void propertyChange(PropertyChangeEvent e) {
            this.timer.restart();
            this.planned = true;
        }

        public void clipboardChanged(ClipboardEvent ev) {
            if (!ev.isConsumed()) {
                Mutex.EVENT.readAccess(this);
            }
        }

        public void run() {
            ExplorerManager em = ExplorerActionsImpl.this.manager;
            if (em != null) {
                ExplorerActionsImpl.this.updatePasteAction(em.getSelectedNodes());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            ExplorerActionsImpl.this.updateActions();
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                this.timer.stop();
                this.planned = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            boolean update;
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                update = this.planned;
            }
            if (update) {
                this.timer.stop();
                ExplorerActionsImpl.this.updateActions();
            }
        }
    }

    private class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer,
    Runnable {
        private boolean confirmDelete;

        DeleteActionPerformer(boolean confirmDelete) {
            this.confirmDelete = confirmDelete;
        }

        public boolean isEnabled() {
            ExplorerActionsImpl.this.updateActionsState();
            return super.isEnabled();
        }

        public void performAction(SystemAction action) {
            Node[] sel = ExplorerActionsImpl.this.manager.getSelectedNodes();
            if (sel == null || sel.length == 0) {
                return;
            }
            if (!this.confirmDelete || this.doConfirm(sel)) {
                try {
                    if (ExplorerActionsImpl.this.manager != null) {
                        ExplorerActionsImpl.this.manager.setSelectedNodes(new Node[0]);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(sel);
                Mutex.EVENT.readAccess(this);
            }
        }

        public void run() {
            this.setEnabled(false);
        }

        private boolean doConfirm(Node[] sel) {
            String title;
            String message;
            boolean customDelete = true;
            for (int i = 0; i < sel.length; ++i) {
                if (Boolean.TRUE.equals(sel[i].getValue("customDelete"))) continue;
                customDelete = false;
                break;
            }
            if (customDelete) {
                return true;
            }
            if (sel.length == 1) {
                message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActionsImpl == null ? (class$org$openide$explorer$ExplorerActionsImpl = ExplorerActionsImpl.class$("org.openide.explorer.ExplorerActionsImpl")) : class$org$openide$explorer$ExplorerActionsImpl, "MSG_ConfirmDeleteObject", sel[0].getDisplayName());
                title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActionsImpl == null ? (class$org$openide$explorer$ExplorerActionsImpl = ExplorerActionsImpl.class$("org.openide.explorer.ExplorerActionsImpl")) : class$org$openide$explorer$ExplorerActionsImpl, "MSG_ConfirmDeleteObjectTitle");
            } else {
                message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActionsImpl == null ? (class$org$openide$explorer$ExplorerActionsImpl = ExplorerActionsImpl.class$("org.openide.explorer.ExplorerActionsImpl")) : class$org$openide$explorer$ExplorerActionsImpl, "MSG_ConfirmDeleteObjects", new Integer(sel.length));
                title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActionsImpl == null ? (class$org$openide$explorer$ExplorerActionsImpl = ExplorerActionsImpl.class$("org.openide.explorer.ExplorerActionsImpl")) : class$org$openide$explorer$ExplorerActionsImpl, "MSG_ConfirmDeleteObjectsTitle");
            }
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, title, 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify(desc));
        }

        private void doDestroy(Node[] sel) {
            for (int i = 0; i < sel.length; ++i) {
                try {
                    sel[i].destroy();
                    continue;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(e);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }
    }

    private class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        private boolean copyCut;

        public CopyCutActionPerformer(boolean b) {
            this.copyCut = b;
        }

        public boolean isEnabled() {
            ExplorerActionsImpl.this.updateActionsState();
            return super.isEnabled();
        }

        public void performAction(SystemAction action) {
            Transferable trans = null;
            Node[] sel = ExplorerActionsImpl.this.manager.getSelectedNodes();
            if (sel.length != 1) {
                Transferable[] arrayTrans = new Transferable[sel.length];
                for (int i = 0; i < sel.length; ++i) {
                    arrayTrans[i] = this.getTransferableOwner(sel[i]);
                    if (arrayTrans[i] != null) continue;
                    return;
                }
                trans = new ExTransferable.Multi(arrayTrans);
            } else {
                trans = this.getTransferableOwner(sel[0]);
            }
            if (trans != null) {
                Clipboard clipboard = ExplorerActionsImpl.getClipboard();
                clipboard.setContents(trans, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copyCut ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, e);
                return null;
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }
    }

    private class OwnPaste
    extends AbstractAction {
        private PasteType[] pasteTypes;

        OwnPaste() {
        }

        public boolean isEnabled() {
            ExplorerActionsImpl.this.updateActionsState();
            return super.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPasteTypes(PasteType[] arr) {
            OwnPaste ownPaste = this;
            synchronized (ownPaste) {
                this.pasteTypes = arr;
            }
            this.setEnabled(arr != null);
        }

        public void actionPerformed(ActionEvent e) {
            throw new IllegalStateException("Should not be invoked at all. Paste types: " + Arrays.asList(this.pasteTypes));
        }

        public Object getValue(String s) {
            ExplorerActionsImpl.this.updateActionsState();
            if ("delegates".equals(s)) {
                return this.pasteTypes;
            }
            return super.getValue(s);
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] t, PasteType[] p) {
            this.t = t;
            this.p = p;
        }

        public Transferable paste() throws IOException {
            int size = this.p.length;
            Transferable[] arr = new Transferable[size];
            for (int i = 0; i < size; ++i) {
                Transferable newTransferable = this.p[i].paste();
                arr[i] = newTransferable != null ? newTransferable : this.t[i];
            }
            return new ExTransferable.Multi(arr);
        }
    }
}

