/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerActionsImpl;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.io.SafeException;

public final class ExplorerManager
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4330330689803575792L;
    public static final String PROP_ROOT_CONTEXT = "rootContext";
    public static final String PROP_EXPLORED_CONTEXT = "exploredContext";
    public static final String PROP_SELECTED_NODES = "selectedNodes";
    public static final String PROP_NODE_CHANGE = "nodeChange";
    private transient VetoableChangeSupport vetoableSupport;
    private transient PropertyChangeSupport propertySupport;
    private Node rootContext;
    private Node exploredContext;
    private Node[] selectedNodes;
    private transient Listener listener;
    private transient NodeListener weakListener;
    static RequestProcessor selectionProcessor;
    private static final int SELECTION_SYNC_DELAY = 200;
    private RequestProcessor.Task selectionSyncTask;
    private ExplorerActionsImpl actions;
    private static final ObjectStreamField[] serialPersistentFields;

    public ExplorerManager() {
        this.init();
    }

    private void init() {
        this.exploredContext = this.rootContext = Node.EMPTY;
        this.selectedNodes = new Node[0];
        this.listener = new Listener();
        this.weakListener = NodeOp.weakNodeListener(this.listener, null);
    }

    public Object clone() {
        ExplorerManager em = new ExplorerManager();
        em.rootContext = this.rootContext;
        em.exploredContext = this.exploredContext;
        em.selectedNodes = this.selectedNodes;
        return em;
    }

    public Node[] getSelectedNodes() {
        return this.selectedNodes;
    }

    private boolean equalNodes(Node[] arr1, Node[] arr2) {
        int i;
        if (!Arrays.equals(arr1, arr2)) {
            return false;
        }
        if (arr1 == null || arr1.length == 0) {
            return true;
        }
        for (i = 0; i < arr1.length && Arrays.equals(NodeOp.createPath(arr1[i], null), NodeOp.createPath(arr2[i], null)); ++i) {
        }
        return i == arr1.length;
    }

    public final void setSelectedNodes(Node[] value) throws PropertyVetoException {
        class AtomicSetSelectedNodes
        implements Runnable {
            public PropertyVetoException veto;
            private final /* synthetic */ Node[] val$value;

            AtomicSetSelectedNodes(Node[] val$value) {
                this.val$value = val$value;
            }

            private boolean checkArgumentIsValid() {
                if (this.val$value == null) {
                    throw new IllegalArgumentException(ExplorerManager.getString("EXC_NodeCannotBeNull"));
                }
                if (ExplorerManager.this.equalNodes(this.val$value, ExplorerManager.this.selectedNodes)) {
                    return false;
                }
                for (int i = 0; i < this.val$value.length; ++i) {
                    if (this.val$value[i] == null) {
                        throw new IllegalArgumentException(ExplorerManager.getString("EXC_NoElementOfNodeSelectionMayBeNull"));
                    }
                    ExplorerManager.this.checkUnderRoot(this.val$value[i], "EXC_NodeSelectionCannotContainNodes");
                }
                if (this.val$value.length != 0 && ExplorerManager.this.vetoableSupport != null) {
                    try {
                        ExplorerManager.this.vetoableSupport.fireVetoableChange(ExplorerManager.PROP_SELECTED_NODES, ExplorerManager.this.selectedNodes, this.val$value);
                    }
                    catch (PropertyVetoException ex) {
                        this.veto = ex;
                        return false;
                    }
                }
                return true;
            }

            private void updateSelection() {
                Node n;
                Node[] oldValue = ExplorerManager.this.selectedNodes;
                List<Node> currentNodes = Arrays.asList(oldValue);
                List<Node> newSelection = Arrays.asList(this.val$value);
                LinkedList<Node> nodesToAdd = new LinkedList<Node>(newSelection);
                nodesToAdd.removeAll(currentNodes);
                LinkedList<Node> nodesToRemove = new LinkedList<Node>(currentNodes);
                nodesToRemove.removeAll(newSelection);
                ExplorerManager.access$102(ExplorerManager.this, this.val$value);
                Iterator it = nodesToRemove.iterator();
                while (it.hasNext()) {
                    n = (Node)it.next();
                    n.removeNodeListener(ExplorerManager.this.weakListener);
                }
                it = nodesToAdd.iterator();
                while (it.hasNext()) {
                    n = (Node)it.next();
                    n.removeNodeListener(ExplorerManager.this.weakListener);
                    n.addNodeListener(ExplorerManager.this.weakListener);
                }
                ExplorerManager.this.fireInAWT(ExplorerManager.PROP_SELECTED_NODES, oldValue, ExplorerManager.this.selectedNodes);
            }

            public void run() {
                if (this.checkArgumentIsValid()) {
                    this.updateSelection();
                }
            }
        }
        AtomicSetSelectedNodes setNodes = new AtomicSetSelectedNodes(value);
        Children.MUTEX.readAccess(setNodes);
        if (setNodes.veto != null) {
            throw setNodes.veto;
        }
    }

    public final Node getExploredContext() {
        return this.exploredContext;
    }

    public final void setExploredContext(Node value) {
        this.setExploredContext(value, new Node[0]);
    }

    public final void setExploredContext(Node value, Node[] selection) {
        class SetExploredContext
        implements Runnable {
            private final /* synthetic */ Node val$value;
            private final /* synthetic */ Node[] val$selection;

            SetExploredContext(Node val$value, Node[] val$selection) {
                this.val$value = val$value;
                this.val$selection = val$selection;
            }

            public void run() {
                if (Utilities.compareObjects(this.val$value, ExplorerManager.this.exploredContext)) {
                    ExplorerManager.this.setSelectedNodes0(this.val$selection);
                    return;
                }
                ExplorerManager.this.checkUnderRoot(this.val$value, "EXC_ContextMustBeWithinRootContext");
                ExplorerManager.this.setSelectedNodes0(this.val$selection);
                Node oldValue = ExplorerManager.this.exploredContext;
                ExplorerManager.this.exploredContext = this.val$value;
                ExplorerManager.this.fireInAWT(ExplorerManager.PROP_EXPLORED_CONTEXT, oldValue, this.val$value);
            }
        }
        SetExploredContext set = new SetExploredContext(value, selection);
        Children.MUTEX.readAccess(set);
    }

    public final void setExploredContextAndSelection(Node value, Node[] selection) throws PropertyVetoException {
        class SetExploredContextAndSelection
        implements Runnable {
            public PropertyVetoException veto;
            private final /* synthetic */ Node val$value;
            private final /* synthetic */ Node[] val$selection;

            SetExploredContextAndSelection(Node val$value, Node[] val$selection) {
                this.val$value = val$value;
                this.val$selection = val$selection;
            }

            public void run() {
                try {
                    if (Utilities.compareObjects(this.val$value, ExplorerManager.this.exploredContext)) {
                        ExplorerManager.this.setSelectedNodes(this.val$selection);
                        return;
                    }
                    ExplorerManager.this.checkUnderRoot(this.val$value, "EXC_ContextMustBeWithinRootContext");
                    ExplorerManager.this.setSelectedNodes(this.val$selection);
                    Node oldValue = ExplorerManager.this.exploredContext;
                    ExplorerManager.this.exploredContext = this.val$value;
                    ExplorerManager.this.fireInAWT(ExplorerManager.PROP_EXPLORED_CONTEXT, oldValue, ExplorerManager.this.exploredContext);
                }
                catch (PropertyVetoException ex) {
                    this.veto = ex;
                }
            }
        }
        SetExploredContextAndSelection set = new SetExploredContextAndSelection(value, selection);
        Children.MUTEX.readAccess(set);
        if (set.veto != null) {
            throw set.veto;
        }
    }

    final void setSelectedNodes0(Node[] nodes) {
        try {
            this.setSelectedNodes(nodes);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public final Node getRootContext() {
        return this.rootContext;
    }

    public final void setRootContext(Node value) {
        if (value == null) {
            throw new IllegalArgumentException(ExplorerManager.getString("EXC_CannotHaveNullRootContext"));
        }
        if (this.rootContext.equals(value)) {
            return;
        }
        Node oldValue = this.rootContext;
        this.rootContext = value;
        oldValue.removeNodeListener(this.weakListener);
        this.rootContext.addNodeListener(this.weakListener);
        this.fireInAWT(PROP_ROOT_CONTEXT, oldValue, this.rootContext);
        Node[] newselection = this.getSelectedNodes();
        if (!this.areUnderTarget(newselection, this.rootContext)) {
            newselection = new Node[]{};
        }
        this.setExploredContext(this.rootContext, newselection);
    }

    private boolean areUnderTarget(Node[] nodes, Node target) {
        block0: for (int i = 0; i < nodes.length; ++i) {
            for (Node node = nodes[i]; node != null; node = node.getParentNode()) {
                if (node.equals(target)) continue block0;
            }
            return false;
        }
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertySupport != null) {
            this.propertySupport.removePropertyChangeListener(l);
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableSupport == null) {
            this.vetoableSupport = new VetoableChangeSupport(this);
        }
        this.vetoableSupport.addVetoableChangeListener(l);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableSupport != null) {
            this.vetoableSupport.removeVetoableChangeListener(l);
        }
    }

    private boolean isUnderRoot(Node node) {
        while (node != null) {
            if (node.equals(this.rootContext)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private void checkUnderRoot(Node value, String errorKey) {
        if (value != null && !this.isUnderRoot(value)) {
            throw new IllegalArgumentException(NbBundle.getMessage(ExplorerManager.class, errorKey, value.getDisplayName(), this.rootContext.getDisplayName()));
        }
    }

    final void waitFinished() {
        if (this.selectionSyncTask != null) {
            this.selectionSyncTask.waitFinished();
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeObject(this);
        ObjectOutputStream.PutField fields = os.putFields();
        Node.Handle rCH = this.rootContext.getHandle();
        fields.put("root", rCH);
        fields.put("rootName", this.rootContext.getDisplayName());
        if (rCH != null) {
            String[] explored = this.exploredContext == null ? null : (this.isUnderRoot(this.exploredContext) ? NodeOp.createPath(this.exploredContext, this.rootContext) : null);
            fields.put("explored", explored);
            LinkedList<String[]> selected = new LinkedList<String[]>();
            for (int i = 0; i < this.selectedNodes.length; ++i) {
                if (!this.isUnderRoot(this.selectedNodes[i])) continue;
                selected.add(NodeOp.createPath(this.selectedNodes[i], this.rootContext));
            }
            fields.put("selected", selected.toArray());
        }
        os.writeFields();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.init();
        Object firstObject = ois.readObject();
        if (firstObject != this) {
            this.readObjectOld((Node.Handle)firstObject, ois);
            return;
        }
        ObjectInputStream.GetField fields = ois.readFields();
        Node.Handle h = (Node.Handle)fields.get("root", null);
        String rootName = (String)fields.get("rootName", null);
        if (h == null) {
            throw new SafeException(new IOException("Could not restore Explorer window; the root node \"" + rootName + "\" is not persistent; override Node.getHandle to fix"));
        }
        String[] exploredCtx = (String[])fields.get("explored", null);
        Object[] selPaths = (Object[])fields.get("selected", null);
        try {
            Node root = h.getNode();
            if (root == null) {
                throw new IOException("Node.Handle.getNode (for " + rootName + ") should not return null");
            }
            this.restoreSelection(root, exploredCtx, Arrays.asList(selPaths));
        }
        catch (IOException ioe) {
            SafeException safe = new SafeException(ioe);
            if (!Utilities.compareObjects(ioe.getMessage(), ioe.getLocalizedMessage())) {
                ErrorManager.getDefault().annotate((Throwable)safe, NbBundle.getMessage(ExplorerManager.class, "EXC_handle_failed", rootName));
            }
            throw safe;
        }
    }

    private void readObjectOld(Node.Handle h, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String[] path;
        if (h == null) {
            return;
        }
        String[] rootCtx = (String[])ois.readObject();
        String[] exploredCtx = (String[])ois.readObject();
        LinkedList<String[]> ll = new LinkedList<String[]>();
        while ((path = (String[])ois.readObject()) != null) {
            ll.add(path);
        }
        Node root = ExplorerManager.findPath(h.getNode(), rootCtx);
        this.restoreSelection(root, exploredCtx, ll);
    }

    private void restoreSelection(final Node root, final String[] exploredCtx, final List selectedPaths) {
        this.setRootContext(root);
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                ArrayList<Node> selNodes = new ArrayList<Node>(selectedPaths.size());
                Iterator iter = selectedPaths.iterator();
                while (iter.hasNext()) {
                    String[] path = (String[])iter.next();
                    selNodes.add(ExplorerManager.findPath(root, path));
                }
                Node[] newSelection = selNodes.toArray(new Node[selNodes.size()]);
                if (exploredCtx != null) {
                    ExplorerManager.this.setExploredContext(ExplorerManager.findPath(root, exploredCtx), newSelection);
                } else {
                    ExplorerManager.this.setSelectedNodes0(newSelection);
                }
            }
        });
    }

    public static ExplorerManager find(Component comp) {
        do {
            if ((comp = comp.getParent()) != null) continue;
            return new ExplorerManager();
        } while (!(comp instanceof Provider));
        return ((Provider)((Object)comp)).getExplorerManager();
    }

    static Node findPath(Node r, String[] path) {
        try {
            return NodeOp.findPath(r, path);
        }
        catch (NodeNotFoundException ex) {
            return ex.getClosestNode();
        }
    }

    static synchronized RequestProcessor getSelectionProcessor() {
        if (selectionProcessor == null) {
            selectionProcessor = new RequestProcessor("ExplorerManager-selection");
        }
        return selectionProcessor;
    }

    static synchronized ExplorerActionsImpl findExplorerActionsImpl(ExplorerManager em) {
        if (em.actions == null) {
            em.actions = new ExplorerActionsImpl();
            em.actions.attach(em);
        }
        return em.actions;
    }

    private void fireInAWT(final String propName, final Object oldVal, final Object newVal) {
        if (this.propertySupport != null) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    ExplorerManager.this.propertySupport.firePropertyChange(propName, oldVal, newVal);
                }
            });
        }
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ExplorerManager.class, key);
    }

    static /* synthetic */ Node[] access$102(ExplorerManager x0, Node[] x1) {
        x0.selectedNodes = x1;
        return x1;
    }

    static {
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("root", Node.Handle.class), new ObjectStreamField("rootName", String.class), new ObjectStreamField("explored", String;.class), new ObjectStreamField("selected", Object;.class)};
    }

    private class Listener
    extends NodeAdapter
    implements Runnable {
        Collection removeList = new HashSet();

        Listener() {
        }

        public void nodeDestroyed(NodeEvent ev) {
            if (ev.getNode().equals(ExplorerManager.this.getRootContext())) {
                ExplorerManager.this.setRootContext(Node.EMPTY);
            } else {
                this.scheduleRemove(ev.getNode());
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            ExplorerManager.this.fireInAWT(ExplorerManager.PROP_NODE_CHANGE, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleRemove(Node n) {
            Object object = ExplorerManager.this;
            synchronized (object) {
                if (ExplorerManager.this.selectionSyncTask == null) {
                    ExplorerManager.this.selectionSyncTask = ExplorerManager.getSelectionProcessor().create(this);
                } else {
                    ExplorerManager.this.selectionSyncTask.cancel();
                }
            }
            object = this;
            synchronized (object) {
                this.removeList.add(n);
            }
            ExplorerManager.this.selectionSyncTask.schedule(200);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Collection remove;
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.readAccess(this);
                return;
            }
            Listener listener = this;
            synchronized (listener) {
                remove = this.removeList;
                this.removeList = new HashSet();
            }
            LinkedList<Node> newSel = new LinkedList<Node>(Arrays.asList(ExplorerManager.this.getSelectedNodes()));
            Iterator it = remove.iterator();
            while (it.hasNext()) {
                Node n_remove = (Node)it.next();
                if (!newSel.contains(n_remove)) continue;
                Node n_selection = newSel.get(newSel.indexOf(n_remove));
                if (Arrays.equals(NodeOp.createPath(n_remove, null), NodeOp.createPath(n_selection, null))) continue;
                it.remove();
            }
            newSel.removeAll(remove);
            Node[] selNodes = newSel.toArray(new Node[newSel.size()]);
            ExplorerManager.this.setSelectedNodes0(selNodes);
        }
    }

    public static interface Provider {
        public ExplorerManager getExplorerManager();
    }
}

