/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.NbBundle;

final class Boolean3WayEditor
implements ExPropertyEditor,
InplaceEditor.Factory {
    Boolean v = null;
    private transient List propertyChangeListenerList;
    private Boolean3Inplace renderer = null;

    public String getAsText() {
        if (this.v == null) {
            return NbBundle.getMessage(Boolean3WayEditor.class, "CTL_Different_Values");
        }
        if (Boolean.TRUE.equals(this.v)) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    public Component getCustomEditor() {
        return null;
    }

    public String getJavaInitializationString() {
        if (this.v == null) {
            return "null";
        }
        if (Boolean.TRUE.equals(this.v)) {
            return "Boolean.TRUE";
        }
        return "Boolean.FALSE";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.v;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.renderer == null) {
            this.renderer = new Boolean3Inplace();
        }
        this.renderer.setSize(box.width, box.height);
        this.renderer.doLayout();
        Graphics g = gfx.create(box.x, box.y, box.width, box.height);
        this.renderer.setOpaque(false);
        this.renderer.paint(g);
        g.dispose();
    }

    public void setAsText(String text) {
        if (Boolean.TRUE.toString().compareToIgnoreCase(text) == 0) {
            this.setValue(Boolean.TRUE);
        } else {
            this.setValue(Boolean.FALSE);
        }
    }

    public void setValue(Object value) {
        if (this.v != value) {
            this.v = (Boolean)value;
            this.firePropertyChange();
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void attachEnv(PropertyEnv env) {
        env.registerInplaceEditorFactory(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListenerList == null) {
            this.propertyChangeListenerList = new ArrayList();
        }
        this.propertyChangeListenerList.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListenerList != null) {
            this.propertyChangeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange() {
        List list;
        Boolean3WayEditor boolean3WayEditor = this;
        synchronized (boolean3WayEditor) {
            if (this.propertyChangeListenerList == null) {
                return;
            }
            list = (List)((ArrayList)this.propertyChangeListenerList).clone();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < list.size(); ++i) {
            ((PropertyChangeListener)list.get(i)).propertyChange(event);
        }
    }

    public InplaceEditor getInplaceEditor() {
        return new Boolean3Inplace();
    }

    private class ButtonModel3Way
    extends DefaultButtonModel {
        private ButtonModel3Way() {
        }

        public boolean isPressed() {
            return Boolean3WayEditor.this.v == null;
        }

        public boolean isArmed() {
            return true;
        }

        public boolean isSelected() {
            if (Boolean3WayEditor.this.v == null) {
                return true;
            }
            return super.isSelected();
        }
    }

    class Boolean3Inplace
    extends JCheckBox
    implements InplaceEditor {
        private PropertyModel propertyModel = null;

        Boolean3Inplace() {
            this.setModel(new ButtonModel3Way());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        public String getText() {
            return PropUtils.noCheckboxCaption ? "" : NbBundle.getMessage(class$org$openide$explorer$propertysheet$Boolean3WayEditor == null ? (class$org$openide$explorer$propertysheet$Boolean3WayEditor = Boolean3WayEditor.class$("org.openide.explorer.propertysheet.Boolean3WayEditor")) : class$org$openide$explorer$propertysheet$Boolean3WayEditor, "CTL_Different_Values");
        }

        public void clear() {
            this.propertyModel = null;
        }

        public void connect(PropertyEditor pe, PropertyEnv env) {
        }

        public JComponent getComponent() {
            return this;
        }

        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        public PropertyEditor getPropertyEditor() {
            return Boolean3WayEditor.this;
        }

        public Object getValue() {
            return Boolean3WayEditor.this.getValue();
        }

        public void reset() {
        }

        public void setValue(Object o) {
        }

        public boolean supportsTextEntry() {
            return false;
        }

        public void setPropertyModel(PropertyModel pm) {
            this.propertyModel = pm;
        }

        public PropertyModel getPropertyModel() {
            return this.propertyModel;
        }

        public boolean isKnownComponent(Component c) {
            return false;
        }
    }
}

