/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.ListViewDragSupport;
import org.openide.explorer.view.ListViewDropSupport;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class ListView
extends JScrollPane
implements Externalizable {
    static final long serialVersionUID = -7540940974042262975L;
    private transient ExplorerManager manager;
    protected transient JList list;
    protected transient NodeListModel model;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupSupport popupSupport;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = true;
    private ActionListener defaultProcessor;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient ListViewDragSupport dragSupport;
    transient ListViewDropSupport dropSupport;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;
    transient boolean listenerActive;
    static /* synthetic */ Class class$java$awt$event$KeyListener;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeView;

    public ListView() {
        this.initializeList();
        if (DragDropUtilities.dragAndDropEnabled) {
            ExplorerDnDManager.getDefault().addFutureDropTarget(this);
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
    }

    private void initializeList() {
        this.model = this.createModel();
        this.list = this.createList();
        this.list.setModel(this.model);
        this.setViewportView(this.list);
        AbstractAction action = new GoUpAction();
        KeyStroke key = KeyStroke.getKeyStroke(8, 0);
        this.list.registerKeyboardAction(action, key, 0);
        action = new EnterAction();
        key = KeyStroke.getKeyStroke(10, 0);
        this.list.registerKeyboardAction(action, key, 0);
        this.managerListener = new Listener();
        this.popupSupport = new PopupSupport();
        this.list.getSelectionModel().setSelectionMode(2);
        ToolTipManager.sharedInstance().registerComponent(this.list);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.popupAllowed ? Boolean.TRUE : Boolean.FALSE);
        out.writeObject(this.traversalAllowed ? Boolean.TRUE : Boolean.FALSE);
        out.writeObject(new Integer(this.getSelectionMode()));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)in.readObject();
        this.traversalAllowed = (Boolean)in.readObject();
        this.setSelectionMode((Integer)in.readObject());
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean value) {
        this.popupAllowed = value;
    }

    public boolean isTraversalAllowed() {
        return this.traversalAllowed;
    }

    public void setTraversalAllowed(boolean value) {
        this.traversalAllowed = value;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener value) {
        this.defaultProcessor = value;
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean state) {
        if (state == this.dragActive) {
            return;
        }
        this.dragActive = state;
        if (this.dragActive && this.dragSupport == null) {
            this.dragSupport = new ListViewDragSupport(this, this.list);
        }
        this.dragSupport.activate(this.dragActive);
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean state) {
        if (state == this.dropActive) {
            return;
        }
        this.dropActive = state;
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new ListViewDropSupport(this, this.list);
        }
        this.dropSupport.activate(this.dropActive);
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int actions) {
        this.allowedDragActions = actions;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    public void setAllowedDropActions(int actions) {
        this.allowedDropActions = actions;
    }

    protected JList createList() {
        NbList list = new NbList();
        list.setCellRenderer(new NodeRenderer());
        return list;
    }

    protected NodeListModel createModel() {
        return new NodeListModel();
    }

    protected void selectionChanged(Node[] nodes, ExplorerManager em) throws PropertyVetoException {
        em.setSelectedNodes(nodes);
    }

    protected boolean selectionAccept(Node[] nodes) {
        if (nodes.length == 1 && this.manager.getRootContext().equals(nodes[0])) {
            return true;
        }
        for (int i = 0; i < nodes.length; ++i) {
            VisualizerNode v = VisualizerNode.getVisualizer(null, nodes[i]);
            if (this.model.getIndex(v) != -1) continue;
            return false;
        }
        return true;
    }

    protected void showSelection(int[] indexes) {
        this.list.setSelectedIndices(indexes);
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find(this);
        if (em != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = em;
            this.wlvc = WeakListeners.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.model.setNode(this.manager.getExploredContext());
            this.updateSelection();
        } else if (!this.listenerActive && this.manager != null) {
            this.wlvc = WeakListeners.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
            this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            this.model.addListDataListener(this.managerListener);
            this.model.setNode(this.manager.getExploredContext());
            this.list.addFocusListener(this.popupSupport);
            this.list.addMouseListener(this.popupSupport);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.listenerActive = false;
        this.list.getSelectionModel().removeListSelectionListener(this.managerListener);
        if (this.manager != null) {
            this.manager.removeVetoableChangeListener(this.wlvc);
            this.manager.removePropertyChangeListener(this.wlpc);
        }
        this.model.removeListDataListener(this.managerListener);
        this.list.removeFocusListener(this.popupSupport);
        this.list.removeMouseListener(this.popupSupport);
    }

    public void requestFocus() {
        this.list.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.list.requestFocusInWindow();
    }

    final void performObjectAt(int index, int modifiers) {
        if (index < 0 || index >= this.model.getSize()) {
            return;
        }
        VisualizerNode v = (VisualizerNode)this.model.getElementAt(index);
        Node node = v.node;
        if (this.defaultProcessor != null) {
            this.defaultProcessor.actionPerformed(new ActionEvent(node, 0, null, modifiers));
            return;
        }
        Action a = node.getPreferredAction();
        if (a != null && (modifiers & 2) == 0) {
            if (a instanceof ContextAwareAction) {
                a = ((ContextAwareAction)a).createContextAwareInstance(node.getLookup());
            }
            if (a.isEnabled()) {
                a.actionPerformed(new ActionEvent(node, 1001, ""));
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (this.traversalAllowed && !node.isLeaf()) {
            this.manager.setExploredContext(node, this.manager.getSelectedNodes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelection() {
        Node[] sel = this.manager.getSelectedNodes();
        int[] indices = new int[sel.length];
        int firstVisible = this.list.getFirstVisibleIndex();
        int lastVisible = this.list.getLastVisibleIndex();
        boolean ensureVisible = indices.length > 0;
        for (int i = 0; i < sel.length; ++i) {
            VisualizerNode v = VisualizerNode.getVisualizer(null, sel[i]);
            indices[i] = this.model.getIndex(v);
            ensureVisible = ensureVisible && (indices[i] < firstVisible || indices[i] > lastVisible);
        }
        if (this.listenerActive) {
            this.list.getSelectionModel().removeListSelectionListener(this.managerListener);
        }
        try {
            this.showSelection(indices);
            if (ensureVisible) {
                this.list.ensureIndexIsVisible(indices[0]);
            }
            Object var9_8 = null;
            if (this.listenerActive) {
                this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (this.listenerActive) {
                this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            }
            throw throwable;
        }
    }

    void createPopup(int xpos, int ypos, boolean contextMenu) {
        JPopupMenu popup;
        if (this.manager == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        if (contextMenu) {
            popup = Utilities.actionsToPopup((Action[])this.manager.getExploredContext().getContextActions(), this);
        } else {
            Action[] actions = NodeOp.findActions(this.manager.getSelectedNodes());
            popup = Utilities.actionsToPopup(actions, this);
        }
        if (popup != null && popup.getSubElements().length > 0) {
            Point p = this.getViewport().getViewPosition();
            p.x = xpos - p.x;
            p.y = ypos - p.y;
            SwingUtilities.convertPointToScreen(p, this);
            Dimension popupSize = popup.getPreferredSize();
            Rectangle screenBounds = Utilities.getUsableScreenBounds(this.getGraphicsConfiguration());
            if (p.x + popupSize.width > screenBounds.x + screenBounds.width) {
                p.x = screenBounds.x + screenBounds.width - popupSize.width;
            }
            if (p.y + popupSize.height > screenBounds.y + screenBounds.height) {
                p.y = screenBounds.y + screenBounds.height - popupSize.height;
            }
            SwingUtilities.convertPointFromScreen(p, this);
            popup.show(this, p.x, p.y);
        }
    }

    private final class EnterAction
    extends AbstractAction {
        static final long serialVersionUID = -239805141416294016L;

        public EnterAction() {
            super("Enter");
        }

        public void actionPerformed(ActionEvent e) {
            int index = ListView.this.list.getSelectedIndex();
            ListView.this.performObjectAt(index, e.getModifiers());
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class GoUpAction
    extends AbstractAction {
        static final long serialVersionUID = 1599999335583246715L;

        public GoUpAction() {
            super("GoUpAction");
        }

        public void actionPerformed(ActionEvent e) {
            if (ListView.this.traversalAllowed) {
                Node pan = ListView.this.manager.getExploredContext();
                if ((pan = pan.getParentNode()) != null) {
                    ListView.this.manager.setExploredContext(pan, ListView.this.manager.getSelectedNodes());
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class Listener
    implements ListDataListener,
    ListSelectionListener,
    PropertyChangeListener,
    VetoableChangeListener {
        Listener() {
        }

        public void intervalAdded(ListDataEvent evt) {
            ListView.this.updateSelection();
        }

        public void intervalRemoved(ListDataEvent evt) {
            ListView.this.updateSelection();
        }

        public void contentsChanged(ListDataEvent evt) {
            ListView.this.updateSelection();
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] newNodes;
            ListView.this.manager;
            if ("selectedNodes".equals(evt.getPropertyName()) && !ListView.this.selectionAccept(newNodes = (Node[])evt.getNewValue())) {
                throw new PropertyVetoException("", evt);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ListView.this.manager;
            if ("selectedNodes".equals(evt.getPropertyName())) {
                ListView.this.updateSelection();
                return;
            }
            if ("exploredContext".equals(evt.getPropertyName())) {
                ListView.this.model.setNode(ListView.this.manager.getExploredContext());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent e) {
            int curSize = ListView.this.model.getSize();
            int[] indices = ListView.this.list.getSelectedIndices();
            ArrayList<Node> ll = new ArrayList<Node>(indices.length);
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] < curSize) {
                    Node n = Visualizer.findNode(ListView.this.model.getElementAt(indices[i]));
                    if (n != ListView.this.manager.getRootContext() && n.getParentNode() == null) continue;
                    ll.add(n);
                    continue;
                }
                ListView.this.updateSelection();
                return;
            }
            Node[] nodes = ll.toArray(new Node[ll.size()]);
            ListView.this.manager.removePropertyChangeListener(ListView.this.wlpc);
            ListView.this.manager.removeVetoableChangeListener(ListView.this.wlvc);
            try {
                try {
                    ListView.this.selectionChanged(nodes, ListView.this.manager);
                }
                catch (PropertyVetoException ex) {
                    ListView.this.updateSelection();
                    Object var8_10 = null;
                    ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                    ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
                }
                Object var8_9 = null;
                ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
                throw throwable;
            }
        }
    }

    final class PopupSupport
    extends MouseUtils.PopupMouseAdapter
    implements ActionPerformer,
    Runnable,
    FocusListener {
        CallbackSystemAction csa;

        PopupSupport() {
        }

        public void mouseClicked(MouseEvent e) {
            if (MouseUtils.isDoubleClick(e)) {
                int index = ListView.this.list.locationToIndex(e.getPoint());
                ListView.this.performObjectAt(index, e.getModifiers());
            }
        }

        protected void showPopup(MouseEvent e) {
            Rectangle r;
            Point p = new Point(e.getX(), e.getY());
            int i = ListView.this.list.locationToIndex(p);
            if (!ListView.this.list.isSelectedIndex(i)) {
                ListView.this.list.setSelectedIndex(i);
            }
            boolean contextMenu = (r = ListView.this.list.getCellBounds(i, i)) == null || !r.contains(p);
            ListView.this.createPopup(e.getX(), e.getY(), contextMenu);
        }

        public void performAction(SystemAction act) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            int i;
            boolean multisel = ListView.this.list.getSelectionMode() != 0;
            int n = i = multisel ? ListView.this.list.getLeadSelectionIndex() : ListView.this.list.getSelectedIndex();
            if (i < 0) {
                return;
            }
            Point p = ListView.this.list.indexToLocation(i);
            if (p == null) {
                return;
            }
            ListView.this.createPopup(p.x, p.y, false);
        }

        public void focusGained(FocusEvent ev) {
            if (this.csa == null) {
                try {
                    Class<?> popup = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)CallbackSystemAction.get(popup);
                }
                catch (ClassNotFoundException e) {
                    NoClassDefFoundError err = new NoClassDefFoundError();
                    ErrorManager.getDefault().annotate((Throwable)err, e);
                    throw err;
                }
            }
            this.csa.setActionPerformer(this);
        }

        public void focusLost(FocusEvent ev) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupSupport) {
                this.csa.setActionPerformer(null);
            }
        }
    }

    final class NbList
    extends JList
    implements Autoscroll {
        static final long serialVersionUID = -7571829536335024077L;
        AutoscrollSupport support;
        int SEARCH_FIELD_PREFERRED_SIZE = 160;
        int SEARCH_FIELD_SPACE = 3;
        private String maxPrefix;
        private JTextField searchTextField = new JTextField(this){
            private final /* synthetic */ NbList this$1;
            {
                this.this$1 = this$1;
            }

            public boolean isManagingFocus() {
                return true;
            }

            public void processKeyEvent(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    NbList.access$100(this.this$1);
                    this.this$1.requestFocus();
                } else {
                    super.processKeyEvent(ke);
                }
            }
        };
        private final int heightOfTextField;
        private int originalScrollMode;
        private JPanel searchpanel;

        NbList() {
            this.heightOfTextField = this.searchTextField.getPreferredSize().height;
            this.searchpanel = null;
            this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
            this.setupSearch();
        }

        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            this.repaintSelection();
        }

        private void repaintSelection() {
            int[] idx = this.getSelectedIndices();
            if (idx.length == 0) {
                return;
            }
            for (int i = 0; i < idx.length; ++i) {
                Rectangle r = this.getCellBounds(idx[i], idx[i]);
                this.repaint(r.x, r.y, r.width, r.height);
            }
        }

        public String getToolTipText(MouseEvent event) {
            Point p;
            int row;
            if (event != null && (row = this.locationToIndex(p = event.getPoint())) >= 0) {
                VisualizerNode v = (VisualizerNode)ListView.this.model.getElementAt(row);
                String tooltip = v.getShortDescription();
                String displayName = v.getDisplayName();
                if (tooltip != null && !tooltip.equals(displayName)) {
                    return tooltip;
                }
            }
            return null;
        }

        public void autoscroll(Point cursorLoc) {
            this.getSupport().autoscroll(cursorLoc);
        }

        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerList();
            }
            return this.accessibleContext;
        }

        private void setupSearch() {
            KeyListener[] keyListeners = (KeyListener[])this.getListeners(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = ListView.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener);
            for (int i = 0; i < keyListeners.length; ++i) {
                this.removeKeyListener(keyListeners[i]);
            }
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ NbList this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    int modifiers = e.getModifiers();
                    int keyCode = e.getKeyCode();
                    if (modifiers > 0 && modifiers != 1 || e.isActionKey()) {
                        return;
                    }
                    char c = e.getKeyChar();
                    if (!Character.isISOControl(c) && keyCode != 16) {
                        NbList.access$200(this.this$1).setText(String.valueOf(c));
                        NbList.access$300(this.this$1);
                    }
                }
            });
            SearchFieldListener searchFieldListener = new SearchFieldListener();
            this.searchTextField.addKeyListener(searchFieldListener);
            this.searchTextField.addFocusListener(searchFieldListener);
            this.searchTextField.getDocument().addDocumentListener(searchFieldListener);
        }

        private List doSearch(String prefix) {
            ArrayList<Integer> results = new ArrayList<Integer>();
            int startIndex = this.getSelectedIndex() == -1 ? 0 : this.getSelectedIndex();
            int size = this.getModel().getSize();
            while (true) {
                startIndex %= size;
                if ((startIndex = this.getNextMatch(prefix, startIndex, Position.Bias.Forward)) == -1 || results.contains(new Integer(startIndex))) break;
                results.add(new Integer(startIndex));
                String elementName = this.getModel().getElementAt(startIndex).toString();
                if (this.maxPrefix == null) {
                    this.maxPrefix = elementName;
                }
                this.maxPrefix = this.findMaxPrefix(this.maxPrefix, elementName);
                ++startIndex;
            }
            return results;
        }

        private String findMaxPrefix(String str1, String str2) {
            String res = null;
            int i = 0;
            while (str1.regionMatches(true, 0, str2, 0, i)) {
                res = str1.substring(0, i);
                ++i;
            }
            return res;
        }

        private void prepareSearchPanel() {
            if (this.searchpanel == null) {
                this.searchpanel = new JPanel();
                JLabel lbl = new JLabel(NbBundle.getMessage(class$org$openide$explorer$view$TreeView == null ? (class$org$openide$explorer$view$TreeView = ListView.class$("org.openide.explorer.view.TreeView")) : class$org$openide$explorer$view$TreeView, "LBL_QUICKSEARCH"));
                this.searchpanel.setLayout(new BoxLayout(this.searchpanel, 0));
                this.searchpanel.add(lbl);
                this.searchpanel.add(this.searchTextField);
                lbl.setLabelFor(this.searchTextField);
                this.searchpanel.setBorder(BorderFactory.createRaisedBevelBorder());
                lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            }
        }

        private void displaySearchField() {
            if (this.getModel().getSize() > 0 && !this.searchTextField.isDisplayable()) {
                JViewport viewport = ListView.this.getViewport();
                this.originalScrollMode = viewport.getScrollMode();
                viewport.setScrollMode(0);
                this.prepareSearchPanel();
                this.add(this.searchpanel);
                this.revalidate();
                this.repaint();
                System.err.println("Displayed search field");
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ NbList this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        NbList.access$200(this.this$1).requestFocus();
                    }
                });
            } else {
                System.err.println("Not setting up search: " + this.searchTextField.isDisplayable());
            }
        }

        public void doLayout() {
            super.doLayout();
            if (this.searchpanel != null && this.searchpanel.isDisplayable()) {
                Rectangle visibleRect = this.getVisibleRect();
                int width = Math.min(this.getPreferredSize().width - this.SEARCH_FIELD_SPACE * 2, this.SEARCH_FIELD_PREFERRED_SIZE - this.SEARCH_FIELD_SPACE);
                this.searchpanel.setBounds(Math.max(this.SEARCH_FIELD_SPACE, visibleRect.x + visibleRect.width - width), visibleRect.y + this.SEARCH_FIELD_SPACE, Math.min(visibleRect.width, width) - this.SEARCH_FIELD_SPACE, this.heightOfTextField);
                System.err.println("Laid out search field: " + this.searchpanel.getBounds());
            }
        }

        private void removeSearchField() {
            if (this.searchpanel != null && this.searchpanel.isDisplayable()) {
                this.remove(this.searchpanel);
                ListView.this.getViewport().setScrollMode(this.originalScrollMode);
                this.repaint(this.searchpanel.getBounds());
                this.requestFocus();
            }
        }

        static /* synthetic */ void access$300(NbList x0) {
            x0.displaySearchField();
        }

        private class SearchFieldListener
        extends KeyAdapter
        implements DocumentListener,
        FocusListener {
            private List results = new ArrayList();
            private int currentSelectionIndex;

            SearchFieldListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void insertUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void removeUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 27) {
                    NbList.this.removeSearchField();
                    NbList.this.requestFocus();
                } else if (keyCode == 38) {
                    --this.currentSelectionIndex;
                    this.displaySearchResult();
                    e.consume();
                } else if (keyCode == 40) {
                    ++this.currentSelectionIndex;
                    this.displaySearchResult();
                    e.consume();
                } else if (keyCode == 9) {
                    if (NbList.this.maxPrefix != null) {
                        NbList.this.searchTextField.setText(NbList.this.maxPrefix);
                    }
                    e.consume();
                } else if (keyCode == 10) {
                    NbList.this.removeSearchField();
                    NbList.this.requestFocus();
                    NbList.this.dispatchEvent(e);
                }
            }

            private void searchForNode() {
                this.currentSelectionIndex = 0;
                this.results.clear();
                NbList.this.maxPrefix = null;
                String text = NbList.this.searchTextField.getText();
                if (text.length() > 0) {
                    this.results = NbList.this.doSearch(text);
                    this.displaySearchResult();
                }
            }

            private void displaySearchResult() {
                int sz = this.results.size();
                if (sz > 0) {
                    if (this.currentSelectionIndex < 0) {
                        this.currentSelectionIndex = sz - 1;
                    } else if (this.currentSelectionIndex >= sz) {
                        this.currentSelectionIndex = 0;
                    }
                    Integer index = (Integer)this.results.get(this.currentSelectionIndex);
                    ((NbList)NbList.this).ListView.this.list.setSelectedIndex(index);
                    ((NbList)NbList.this).ListView.this.list.ensureIndexIsVisible(index);
                } else {
                    ((NbList)NbList.this).ListView.this.list.clearSelection();
                }
            }

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                NbList.this.removeSearchField();
            }
        }

        private class AccessibleExplorerList
        extends JList.AccessibleJList {
            AccessibleExplorerList() {
                super(NbList.this);
            }

            public String getAccessibleName() {
                return ListView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return ListView.this.getAccessibleContext().getAccessibleDescription();
            }
        }
    }
}

