/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.openide.util.AWTBridge;
import org.openide.ErrorManager;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class CallbackSystemAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet notSurviving = new WeakSet(37);
    private static final WeakSet surviving = new WeakSet(37);
    private static final Object LISTENER = new Object();
    static final long serialVersionUID = -6305817805474624653L;
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.util.actions.CallbackSystemAction");
    private static final boolean errLog = err.isLoggable(1);
    static /* synthetic */ Class class$javax$swing$ActionMap;
    static /* synthetic */ Class class$org$openide$util$LookupListener;
    static /* synthetic */ Class class$org$openide$util$actions$CallableSystemAction;

    protected void initialize() {
        super.initialize();
        this.updateEnabled();
        this.setSurviveFocusChange(false);
    }

    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    public void setActionPerformer(ActionPerformer performer) {
        this.putProperty(PROP_ACTION_PERFORMER, performer);
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEnabled() {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            this.setEnabled(action.isEnabled());
            Object object = LISTENER;
            synchronized (object) {
                ActionDelegateListener l = (ActionDelegateListener)this.getProperty(LISTENER);
                if (l == null || l.get() != this) {
                    l = new ActionDelegateListener(this, action);
                    this.putProperty(LISTENER, l);
                } else {
                    l.attach(action);
                }
            }
        } else {
            if (this.getActionPerformer() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.clearListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListener() {
        Object object = LISTENER;
        synchronized (object) {
            ActionDelegateListener l = (ActionDelegateListener)this.getProperty(LISTENER);
            if (l != null) {
                l.clear();
                this.putProperty(LISTENER, null);
            }
        }
    }

    public void actionPerformed(ActionEvent ev) {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            if (action.isEnabled()) {
                action.actionPerformed(ev);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return;
        }
        final ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            this.doPerformAction(new CallableSystemAction.ActionRunnable(ev){

                public void run() {
                    ap.performAction(CallbackSystemAction.this);
                }
            });
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public void performAction() {
        ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ap.performAction(this);
        }
    }

    public Object getActionMapKey() {
        return this.getClass().getName();
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurviveFocusChange(boolean b) {
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            if (b) {
                notSurviving.remove(this.getClass());
                surviving.add(this.getClass());
            } else {
                notSurviving.add(this.getClass());
                surviving.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList toInstances(Set s) {
        ArrayList<SharedClassObject> actions;
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            actions = new ArrayList<SharedClassObject>(s.size());
            Iterator it = s.iterator();
            while (it.hasNext()) {
                Class c = (Class)it.next();
                SharedClassObject a = SystemAction.findObject(c, false);
                if (a == null) continue;
                actions.add(a);
            }
        }
        return actions;
    }

    private static void clearActionPerformers() {
        CallbackSystemAction a;
        ArrayList actions = CallbackSystemAction.toInstances(notSurviving);
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            a = (CallbackSystemAction)it.next();
            a.setActionPerformer(null);
        }
        actions = CallbackSystemAction.toInstances(surviving);
        it = actions.iterator();
        while (it.hasNext()) {
            a = (CallbackSystemAction)it.next();
            if (errLog) {
                err.log("updateEnabled: " + a);
            }
            a.updateEnabled();
        }
    }

    private static final class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    PropertyChangeListener {
        private CallbackSystemAction delegate;
        private Lookup.Result result;
        private boolean enabled;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private PropertyChangeListener weakL;
        private WeakReference lastRef;

        public DelegateAction(CallbackSystemAction a, Lookup actionContext) {
            this.delegate = a;
            this.weakL = WeakListeners.propertyChange(this, null);
            this.enabled = a.getActionPerformer() != null;
            this.result = actionContext.lookup(new Lookup.Template(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = CallbackSystemAction.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap));
            this.result.addLookupListener((LookupListener)WeakListeners.create(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = CallbackSystemAction.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void actionPerformed(ActionEvent e) {
            Action a = this.findAction();
            if (a != null) {
                CallbackSystemAction callbackSystemAction = this.delegate;
                callbackSystemAction.getClass();
                CallableSystemAction.ActionRunnable run = new CallableSystemAction.ActionRunnable(this, callbackSystemAction, e, a, e){
                    private final /* synthetic */ Action val$a;
                    private final /* synthetic */ ActionEvent val$e;
                    private final /* synthetic */ DelegateAction this$0;
                    {
                        this.this$0 = this$0;
                        this.val$a = val$a;
                        this.val$e = val$e;
                        CallbackSystemAction callbackSystemAction = x0;
                        callbackSystemAction.getClass();
                        super(x1);
                    }

                    public void run() {
                        this.val$a.actionPerformed(this.val$e);
                    }
                };
                this.delegate.doPerformAction(run);
            } else {
                Object value;
                Object source = e.getSource();
                if (source instanceof Component && SwingUtilities.getWindowAncestor((Component)source) instanceof Dialog && !Boolean.TRUE.equals(value = this.delegate.getValue("OpenIDE-Transmodal-Action"))) {
                    return;
                }
                this.delegate.actionPerformed(e);
            }
        }

        public boolean isEnabled() {
            Action last;
            Action a = this.findAction();
            if (a == null) {
                a = this.delegate;
            }
            Action action = last = this.lastRef == null ? null : (Action)this.lastRef.get();
            if (a != last) {
                if (last != null) {
                    last.removePropertyChangeListener(this.weakL);
                }
                this.lastRef = new WeakReference<Action>(a);
                a.addPropertyChangeListener(this.weakL);
            }
            return a.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public void putValue(String key, Object o) {
        }

        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        public void setEnabled(boolean b) {
        }

        public void resultChanged(LookupEvent ev) {
            boolean newEnabled = this.isEnabled();
            if (newEnabled != this.enabled) {
                this.support.firePropertyChange("enabled", this.enabled, newEnabled);
                this.enabled = newEnabled;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.resultChanged(null);
        }

        private Action findAction() {
            List c;
            Collection collection = c = this.result != null ? this.result.allInstances() : Collections.EMPTY_LIST;
            if (!c.isEmpty()) {
                Object key = this.delegate.getActionMapKey();
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    ActionMap map = (ActionMap)it.next();
                    Action action = map.get(key);
                    if (action == null) continue;
                    return action;
                }
            }
            return null;
        }

        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverriden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return AWTBridge.getDefault().createMenuPresenter(this);
        }

        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverriden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return AWTBridge.getDefault().createPopupPresenter(this);
        }

        public Component getToolbarPresenter() {
            if (this.isMethodOverriden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return AWTBridge.getDefault().createToolbarPresenter(this);
        }

        private boolean isMethodOverriden(CallableSystemAction d, String name) {
            try {
                Method m = d.getClass().getMethod(name, new Class[0]);
                return m.getDeclaringClass() != (class$org$openide$util$actions$CallableSystemAction == null ? (class$org$openide$util$actions$CallableSystemAction = CallbackSystemAction.class$("org.openide.util.actions.CallableSystemAction")) : class$org$openide$util$actions$CallableSystemAction);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Error searching for method " + name + " in " + d);
            }
        }
    }

    private static final class ActionDelegateListener
    extends WeakReference
    implements PropertyChangeListener {
        private WeakReference delegate;

        public ActionDelegateListener(CallbackSystemAction c, Action delegate) {
            super(c);
            this.delegate = new WeakReference<Action>(delegate);
            delegate.addPropertyChangeListener(this);
        }

        public void clear() {
            Action a;
            WeakReference d = this.delegate;
            Action action = a = d == null ? null : (Action)d.get();
            if (a == null) {
                return;
            }
            this.delegate = null;
            a.removePropertyChangeListener(this);
        }

        public void attach(Action action) {
            WeakReference d = this.delegate;
            if (d != null && d.get() == action) {
                return;
            }
            Action prev = (Action)d.get();
            if (prev != null) {
                prev.removePropertyChangeListener(this);
            }
            this.delegate = new WeakReference<Action>(action);
            action.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            Object object = LISTENER;
            synchronized (object) {
                WeakReference d = this.delegate;
                if (d == null || d.get() == null) {
                    return;
                }
            }
            CallbackSystemAction c = (CallbackSystemAction)this.get();
            if (c != null) {
                c.updateEnabled();
            }
        }
    }

    private static final class WeakAction
    extends WeakReference
    implements Action {
        public WeakAction(Action delegate) {
            super(delegate);
        }

        public Action getDelegate() {
            return (Action)super.get();
        }

        public Object getValue(String key) {
            throw new UnsupportedOperationException();
        }

        public void putValue(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException();
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        public void setEnabled(boolean b) {
            throw new UnsupportedOperationException();
        }

        public boolean isEnabled() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GlobalManager
    implements LookupListener {
        private static GlobalManager instance;
        private Lookup.Result result;
        private Reference actionMap = new WeakReference<Object>(null);
        private final ActionMap survive = new ActionMap();

        public static synchronized GlobalManager getDefault() {
            if (instance != null) {
                return instance;
            }
            instance = new GlobalManager();
            return instance;
        }

        private GlobalManager() {
            this.result = Utilities.actionsGlobalContext().lookup(new Lookup.Template(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = CallbackSystemAction.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap));
            this.result.addLookupListener(this);
            this.resultChanged(null);
        }

        public Action findGlobalAction(Object key, boolean surviveFocusChange) {
            Action a;
            ActionMap map = (ActionMap)this.actionMap.get();
            Action action = a = map == null ? null : map.get(key);
            if (surviveFocusChange) {
                if (a == null) {
                    a = this.survive.get(key);
                    if (a != null) {
                        a = ((WeakAction)a).getDelegate();
                    }
                    if (errLog) {
                        err.log("No action for key: " + key + " using delegate: " + a);
                    }
                } else {
                    if (errLog) {
                        err.log("New action for key: " + key + " put: " + a);
                    }
                    this.survive.put(key, new WeakAction(a));
                }
            }
            if (errLog) {
                err.log("Action for key: " + key + " is: " + a);
            }
            return a;
        }

        public void resultChanged(LookupEvent ev) {
            ActionMap a = (ActionMap)Utilities.actionsGlobalContext().lookup(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = CallbackSystemAction.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap);
            if (errLog) {
                err.log("changed map : " + a);
                err.log("previous map: " + this.actionMap.get());
            }
            if (a == this.actionMap.get()) {
                return;
            }
            this.actionMap = new WeakReference<ActionMap>(a);
            if (errLog) {
                err.log("clearActionPerformers");
            }
            CallbackSystemAction.clearActionPerformers();
        }
    }
}

