/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XMLUtilImpl {
    private XMLUtilImpl() {
    }

    static void write(Document doc, OutputStream out, String encoding) throws IOException {
        try {
            try {
                XMLUtilImpl.writeXerces(doc, out, encoding);
            }
            catch (ClassNotFoundException e) {
                XMLUtilImpl.writeJaxp(doc, out, encoding);
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw (IOException)new IOException(t.toString()).initCause(t);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Could not find a safe DOM serializer: " + e).initCause(e);
        }
    }

    private static void writeCrimson(Document doc, OutputStream out, String encoding) throws IllegalArgumentException, Exception {
        String name = doc.getClass().getName();
        if (XMLUtilImpl.hasNamespaces(doc)) {
            throw new IllegalArgumentException("No namespace writing support in Crimson!");
        }
        if (!name.equals("com.sun.xml.tree.XmlDocument") && !name.equals("org.apache.crimson.tree.XmlDocument")) {
            throw new IllegalArgumentException("Not a Crimson document");
        }
        Method write = doc.getClass().getDeclaredMethod("write", OutputStream.class);
        write.invoke((Object)doc, out);
    }

    private static void writeXerces(Document doc, OutputStream out, String encoding) throws ClassNotFoundException, Exception {
        ClassLoader cl = doc.getClass().getClassLoader();
        Class<?> serka = null;
        String sername = "XMLSerializer";
        String pkg1 = "org.apache.xml.serialize.";
        String pkg2 = "com.sun.org.apache.xml.internal.serialize.";
        boolean usingPkg2 = false;
        try {
            serka = Class.forName(pkg1 + sername, true, cl);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                serka = Class.forName(pkg2 + sername, true, cl);
                usingPkg2 = true;
            }
            catch (ClassNotFoundException cnfe2) {
                // empty catch block
            }
        }
        if (serka == null) {
            cl = Thread.currentThread().getContextClassLoader();
            try {
                serka = Class.forName(pkg1 + sername, true, cl);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    serka = Class.forName(pkg2 + sername, true, cl);
                    usingPkg2 = true;
                }
                catch (ClassNotFoundException cnfe2) {
                    // empty catch block
                }
            }
        }
        if (serka == null) {
            cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (cl == null) {
                cl = XMLUtilImpl.class.getClassLoader();
            }
            try {
                serka = Class.forName(pkg1 + sername, true, cl);
            }
            catch (ClassNotFoundException cnfe) {
                serka = Class.forName(pkg2 + sername, true, cl);
                usingPkg2 = true;
            }
        }
        Class<?> forka = Class.forName((usingPkg2 ? pkg2 : pkg1) + "OutputFormat", true, cl);
        Object serin = serka.newInstance();
        Object forin = forka.newInstance();
        Method setmet = null;
        setmet = forka.getMethod("setMethod", String.class);
        setmet.invoke(forin, "xml");
        setmet = forka.getMethod("setIndenting", Boolean.TYPE);
        setmet.invoke(forin, Boolean.TRUE);
        setmet = forka.getMethod("setLineWidth", Integer.TYPE);
        setmet.invoke(forin, new Integer(0));
        setmet = forka.getMethod("setLineSeparator", String.class);
        setmet.invoke(forin, (Object[])new String[]{System.getProperty("line.separator")});
        Method init = serka.getMethod("setOutputByteStream", OutputStream.class);
        init.invoke(serin, out);
        Method setenc = forka.getMethod("setEncoding", String.class);
        setenc.invoke(forin, encoding);
        Method setout = serka.getMethod("setOutputFormat", forka);
        setout.invoke(serin, forin);
        Method setnam = serka.getMethod("setNamespaces", Boolean.TYPE);
        setnam.invoke(serin, Boolean.TRUE);
        Method asDOM = serka.getMethod("asDOMSerializer", new Class[0]);
        Object impl = asDOM.invoke(serin, new Object[0]);
        Method serialize = impl.getClass().getMethod("serialize", Document.class);
        serialize.invoke(impl, doc);
    }

    private static void writeJaxp(Document doc, OutputStream out, String encoding) throws IllegalArgumentException, Exception {
        if (XMLUtilImpl.hasNamespaces(doc) && System.getProperty("java.version").startsWith("1.4.")) {
            throw new IllegalArgumentException("Writing namespaces using JAXP does not work reliably on JDK 1.4; make sure Xerces is loaded; cf. http://www.netbeans.org/issues/show_bug.cgi?id=51945");
        }
        Transformer t = TransformerFactory.newInstance().newTransformer();
        DocumentType dt = doc.getDoctype();
        if (dt != null) {
            String pub = dt.getPublicId();
            if (pub != null) {
                t.setOutputProperty("doctype-public", pub);
            }
            t.setOutputProperty("doctype-system", dt.getSystemId());
        }
        t.setOutputProperty("encoding", encoding);
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        t.transform(source, result);
    }

    private static void writeXalan(Document doc, OutputStream out, String encoding) throws Exception {
        Properties format = new Properties();
        format.setProperty("encoding", encoding);
        format.setProperty("indent", "yes");
        format.setProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        format.setProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Object serializer = Class.forName("org.apache.xalan.serialize.SerializerToXML").newInstance();
        Method setOutputFormat = serializer.getClass().getMethod("setOutputFormat", Properties.class);
        setOutputFormat.invoke(serializer, format);
        Method setOutputStream = serializer.getClass().getMethod("setOutputStream", OutputStream.class);
        setOutputStream.invoke(serializer, out);
        Method asDOMSerializer = serializer.getClass().getMethod("asDOMSerializer", null);
        Object domSerializer = asDOMSerializer.invoke(serializer, null);
        Method serialize = domSerializer.getClass().getMethod("serialize", Node.class);
        serialize.invoke(domSerializer, doc);
    }

    private static boolean hasNamespaces(Document doc) {
        NodeList l = doc.getElementsByTagName("*");
        for (int i = 0; i < l.getLength(); ++i) {
            if (((Element)l.item(i)).getNamespaceURI() == null) continue;
            return true;
        }
        return false;
    }
}

