/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Util {
    public static ProgramElementDoc[] excludeDeprecatedMembers(ProgramElementDoc[] programElementDocArray) {
        return Util.toProgramElementDocArray(Util.excludeDeprecatedMembersAsList(programElementDocArray));
    }

    public static List excludeDeprecatedMembersAsList(ProgramElementDoc[] programElementDocArray) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        for (int i = 0; i < programElementDocArray.length; ++i) {
            if (programElementDocArray[i].tags("deprecated").length != 0) continue;
            arrayList.add(programElementDocArray[i]);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static ProgramElementDoc[] toProgramElementDocArray(List list) {
        ProgramElementDoc[] programElementDocArray = new ProgramElementDoc[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            programElementDocArray[i] = (ProgramElementDoc)list.get(i);
        }
        return programElementDocArray;
    }

    public static boolean nonPublicMemberFound(ProgramElementDoc[] programElementDocArray) {
        for (int i = 0; i < programElementDocArray.length; ++i) {
            if (programElementDocArray[i].isPublic()) continue;
            return true;
        }
        return false;
    }

    public static MethodDoc findMethod(ClassDoc classDoc, MethodDoc methodDoc) {
        MethodDoc[] methodDocArray = classDoc.methods();
        for (int i = 0; i < methodDocArray.length; ++i) {
            if (!methodDoc.name().equals(methodDocArray[i].name()) || !methodDoc.signature().equals(methodDocArray[i].signature())) continue;
            return methodDocArray[i];
        }
        return null;
    }

    public static boolean isCoreClass(ClassDoc classDoc) {
        return classDoc.containingClass() == null || classDoc.isStatic();
    }

    public static boolean matches(ProgramElementDoc programElementDoc, ProgramElementDoc programElementDoc2) {
        if (programElementDoc instanceof ExecutableMemberDoc && programElementDoc2 instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)programElementDoc;
            ExecutableMemberDoc executableMemberDoc2 = (ExecutableMemberDoc)programElementDoc2;
            return executableMemberDoc.name().equals(executableMemberDoc2.name()) && executableMemberDoc.signature().equals(executableMemberDoc2.signature());
        }
        return programElementDoc.name().equals(programElementDoc2.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        byte[] byArray = new byte[512];
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static ClassDoc[] getAllInterfaces(ClassDoc classDoc) {
        ClassDoc classDoc2;
        HashSet hashSet = new HashSet();
        Util.buildInterfaces(hashSet, classDoc);
        if (classDoc.isClass()) {
            for (classDoc2 = classDoc.superclass(); classDoc2 != null; classDoc2 = classDoc2.superclass()) {
                Util.buildInterfaces(hashSet, classDoc2);
            }
        }
        classDoc2 = new ClassDoc[hashSet.size()];
        hashSet.toArray((T[])classDoc2);
        Arrays.sort((Object[])classDoc2);
        return classDoc2;
    }

    private static void buildInterfaces(Set set, ClassDoc classDoc) {
        ClassDoc[] classDocArray = classDoc.interfaces();
        for (int i = 0; i < classDocArray.length; ++i) {
            set.add(classDocArray[i]);
            Util.buildInterfaces(set, classDocArray[i]);
        }
    }

    public static List asList(ProgramElementDoc[] programElementDocArray) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        for (int i = 0; i < programElementDocArray.length; ++i) {
            arrayList.add(programElementDocArray[i]);
        }
        return arrayList;
    }
}

