/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.webui.jsf.doclets.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VisibleMemberMap {
    public static final int INNERCLASSES = 0;
    public static final int FIELDS = 1;
    public static final int CONSTRUCTORS = 2;
    public static final int METHODS = 3;
    public static final String STARTLEVEL = "start";
    private final List visibleClasses = new ArrayList();
    private final Map memberNameMap = new HashMap();
    private final Map classMap = new HashMap();
    private final ClassDoc classdoc;
    private final int kind;
    private final boolean nodepr;

    public VisibleMemberMap(ClassDoc classDoc, int n, boolean bl) {
        this.classdoc = classDoc;
        this.nodepr = bl;
        this.kind = n;
        new ClassMembers(classDoc, STARTLEVEL).build();
    }

    public List getVisibleClassesList() {
        this.sort(this.visibleClasses);
        return this.visibleClasses;
    }

    public List getMembersFor(ClassDoc classDoc) {
        ClassMembers classMembers = (ClassMembers)this.classMap.get(classDoc);
        if (classMembers == null) {
            return new ArrayList();
        }
        return classMembers.getMembers();
    }

    private void sort(List list) {
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        ArrayList<ClassDoc> arrayList2 = new ArrayList<ClassDoc>();
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc classDoc = (ClassDoc)list.get(i);
            if (classDoc.isClass()) {
                arrayList.add(classDoc);
                continue;
            }
            arrayList2.add(classDoc);
        }
        list.clear();
        list.addAll(arrayList);
        list.addAll(arrayList2);
    }

    private void fillMemberLevelMap(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            ProgramElementDoc programElementDoc = (ProgramElementDoc)list.get(i);
            String string2 = VisibleMemberMap.getDocName(programElementDoc);
            HashMap<ProgramElementDoc, String> hashMap = (HashMap<ProgramElementDoc, String>)this.memberNameMap.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<ProgramElementDoc, String>();
                this.memberNameMap.put(string2, hashMap);
            }
            hashMap.put(programElementDoc, string);
        }
    }

    protected static String getDocName(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isMethod() || programElementDoc.isConstructor()) {
            return programElementDoc.name() + ((ExecutableMemberDoc)programElementDoc).signature();
        }
        if (programElementDoc.isField()) {
            return programElementDoc.name();
        }
        String string = programElementDoc.name();
        string = string.indexOf(46) != 0 ? string.substring(string.lastIndexOf(46), string.length()) : string;
        return "clint" + string;
    }

    private class ClassMembers {
        private ClassDoc mappingClass;
        private List members = new ArrayList();
        private String level;

        public List getMembers() {
            return this.members;
        }

        private ClassMembers(ClassDoc classDoc, String string) {
            this.mappingClass = classDoc;
            this.level = string;
            if (!VisibleMemberMap.this.classMap.containsKey(classDoc)) {
                VisibleMemberMap.this.classMap.put(classDoc, this);
                VisibleMemberMap.this.visibleClasses.add(classDoc);
            }
        }

        private void build() {
            if (VisibleMemberMap.this.kind == 2) {
                this.addMembers(this.mappingClass);
            } else {
                this.mapClass(this);
            }
        }

        private void mapClass(ClassMembers classMembers) {
            ClassDoc classDoc;
            Object object;
            Object object2;
            if (this.checkAccess(this.mappingClass)) {
                classMembers = this;
            }
            classMembers.addMembers(this.mappingClass);
            ClassDoc[] classDocArray = this.mappingClass.interfaces();
            for (int i = 0; i < classDocArray.length; ++i) {
                object2 = this.level + (i + 1);
                object = new ClassMembers(classDocArray[i], (String)object2);
                ((ClassMembers)object).mapClass(classMembers);
            }
            if (this.mappingClass.isClass() && (classDoc = this.mappingClass.superclass()) != null) {
                object2 = new ClassMembers(classDoc, this.level + "c");
                super.mapClass(classMembers);
                object = classDoc.containingPackage() + "." + classDoc.name();
                String string = "com.sun.webui.jsf.component." + this.mappingClass.name() + "Base";
                if (((String)object).equals(string)) {
                    classMembers.addMembers(classDoc);
                }
            }
        }

        private boolean checkAccess(ClassDoc classDoc) {
            return classDoc.isPublic() || classDoc.isProtected() || classDoc.isPrivate() && classDoc.isPackagePrivate();
        }

        private void addMembers(ClassDoc classDoc) {
            List list = this.getClassMembers(classDoc, true);
            ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)list.get(i);
                if (this.found(this.members, programElementDoc) || !this.isVisible(programElementDoc) || this.isOverridden(programElementDoc, this.level)) continue;
                arrayList.add(programElementDoc);
            }
            this.members.addAll(arrayList);
            VisibleMemberMap.this.fillMemberLevelMap(this.getClassMembers(classDoc, false), this.level);
        }

        private boolean isVisible(ProgramElementDoc programElementDoc) {
            if (programElementDoc.containingClass() == this.mappingClass) {
                return true;
            }
            if (programElementDoc.isPrivate()) {
                return false;
            }
            if (programElementDoc.isPackagePrivate()) {
                return programElementDoc.containingClass().containingPackage() == this.mappingClass.containingPackage();
            }
            return true;
        }

        private List getClassMembers(ClassDoc classDoc, boolean bl) {
            ConstructorDoc[] constructorDocArray = null;
            switch (VisibleMemberMap.this.kind) {
                case 0: {
                    constructorDocArray = classDoc.innerClasses(bl);
                    break;
                }
                case 1: {
                    constructorDocArray = classDoc.fields(bl);
                    break;
                }
                case 2: {
                    constructorDocArray = classDoc.constructors();
                    break;
                }
                case 3: {
                    constructorDocArray = classDoc.methods(bl);
                    break;
                }
                default: {
                    constructorDocArray = new ProgramElementDoc[]{};
                }
            }
            if (VisibleMemberMap.this.nodepr) {
                return Util.excludeDeprecatedMembersAsList((ProgramElementDoc[])constructorDocArray);
            }
            return Util.asList((ProgramElementDoc[])constructorDocArray);
        }

        private boolean found(List list, ProgramElementDoc programElementDoc) {
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc programElementDoc2 = (ProgramElementDoc)list.get(i);
                if (!Util.matches(programElementDoc2, programElementDoc)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridden(ProgramElementDoc programElementDoc, String string) {
            Map map = (Map)VisibleMemberMap.this.memberNameMap.get(VisibleMemberMap.getDocName(programElementDoc));
            if (map == null) {
                return false;
            }
            String string22 = null;
            for (String string22 : map.values()) {
                if (!string22.equals(VisibleMemberMap.STARTLEVEL) && !string.startsWith(string22)) continue;
                return true;
            }
            return false;
        }
    }
}

