/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.webui.jsf.doclets.Configuration;
import com.sun.webui.jsf.doclets.DirectoryManager;
import com.sun.webui.jsf.doclets.DocletAbortException;
import com.sun.webui.jsf.doclets.Util;
import com.sun.webui.jsf.doclets.standard.AbstractPackageWriter;
import com.sun.webui.jsf.doclets.standard.ConfigurationStandard;
import java.io.IOException;
import java.util.Arrays;

public class PackageFrameWriter
extends AbstractPackageWriter {
    public PackageFrameWriter(ConfigurationStandard configurationStandard, String string, String string2, PackageDoc packageDoc) throws IOException {
        super(configurationStandard, string, string2, packageDoc);
    }

    public static void generate(ConfigurationStandard configurationStandard, PackageDoc packageDoc) {
        String string = DirectoryManager.getDirectoryPath(packageDoc);
        String string2 = "package-frame.html";
        try {
            PackageFrameWriter packageFrameWriter = new PackageFrameWriter(configurationStandard, string, string2, packageDoc);
            packageFrameWriter.generatePackageFile();
            packageFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generateClassListing() {
        String string = this.packagedoc.name();
        Configuration configuration = this.configuration();
        if (this.packagedoc.isIncluded()) {
            this.generateClassKindListing(this.packagedoc.interfaces(), this.getText("doclet.Interfaces"));
            this.generateClassKindListing(this.packagedoc.ordinaryClasses(), this.getText("doclet.Classes"));
            this.generateClassKindListing(this.packagedoc.exceptions(), this.getText("doclet.Exceptions"));
            this.generateClassKindListing(this.packagedoc.errors(), this.getText("doclet.Errors"));
        } else {
            this.generateClassKindListing(configuration.classDocCatalog.interfaces(string), this.getText("doclet.Interfaces"));
            this.generateClassKindListing(configuration.classDocCatalog.ordinaryClasses(string), this.getText("doclet.Classes"));
            this.generateClassKindListing(configuration.classDocCatalog.exceptions(string), this.getText("doclet.Exceptions"));
            this.generateClassKindListing(configuration.classDocCatalog.errors(string), this.getText("doclet.Errors"));
        }
    }

    protected void generateClassKindListing(ClassDoc[] classDocArray, String string) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            this.printPackageTableHeader();
            this.fontSizeStyle("+1", "FrameHeadingFont");
            boolean bl = false;
            for (int i = 0; i < classDocArray.length; ++i) {
                ClassDoc classDoc = classDocArray[i];
                if (classDoc.containingPackage().toString().equals("com.sun.webui.jsf.component") && classDoc.name().indexOf("Base") != -1 || this.documentedClasses != null && !this.documentedClasses.contains(classDocArray[i]) || !Util.isCoreClass(classDocArray[i]) || !this.isGeneratedDoc((Doc)classDocArray[i])) continue;
                if (!bl) {
                    this.print(string);
                    this.fontEnd();
                    this.println("&nbsp;");
                    this.fontStyle("FrameItemFont");
                    bl = true;
                }
                this.br();
                this.printTargetClassLink(classDocArray[i], "classFrame");
            }
            this.fontEnd();
            this.printPackageTableFooter();
            this.println();
        }
    }

    protected void printPackageHeader(String string) {
        this.fontSizeStyle("+1", "FrameTitleFont");
        this.printTargetPackageLink(this.packagedoc, "classFrame", string);
        this.fontEnd();
    }

    protected void printPackageTableHeader() {
        this.table();
        this.tr();
        this.tdNowrap();
    }

    protected void printPackageTableFooter() {
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }

    protected void printPackageFooter() {
    }

    protected void printPackageDescription() throws IOException {
    }
}

