/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.webui.jsf.doclets.DirectoryManager;
import com.sun.webui.jsf.doclets.DocletAbortException;
import com.sun.webui.jsf.doclets.standard.ClassUseMapper;
import com.sun.webui.jsf.doclets.standard.ConfigurationStandard;
import com.sun.webui.jsf.doclets.standard.SubWriterHolderWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class PackageUseWriter
extends SubWriterHolderWriter {
    final PackageDoc pkgdoc;
    final SortedMap usingPackageToUsedClasses = new TreeMap();

    public PackageUseWriter(ConfigurationStandard configurationStandard, ClassUseMapper classUseMapper, String string, PackageDoc packageDoc) throws IOException {
        super(configurationStandard, DirectoryManager.getDirectoryPath(packageDoc), string, DirectoryManager.getRelativePath(packageDoc.name()));
        this.pkgdoc = packageDoc;
        ClassDoc[] classDocArray = packageDoc.allClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassDoc classDoc = classDocArray[i];
            Set set = (Set)classUseMapper.classToClass.get(classDoc.qualifiedName());
            if (set == null) continue;
            for (ClassDoc classDoc2 : set) {
                PackageDoc packageDoc2 = classDoc2.containingPackage();
                TreeSet<ClassDoc> treeSet = (TreeSet<ClassDoc>)this.usingPackageToUsedClasses.get(packageDoc2.name());
                if (treeSet == null) {
                    treeSet = new TreeSet<ClassDoc>();
                    this.usingPackageToUsedClasses.put(packageDoc2.name(), treeSet);
                }
                treeSet.add(classDoc);
            }
        }
    }

    public static void generate(ConfigurationStandard configurationStandard, ClassUseMapper classUseMapper, PackageDoc packageDoc) {
        String string = "package-use.html";
        try {
            PackageUseWriter packageUseWriter = new PackageUseWriter(configurationStandard, classUseMapper, string, packageDoc);
            packageUseWriter.generatePackageUseFile();
            packageUseWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageUseFile() throws IOException {
        this.printPackageUseHeader();
        if (this.usingPackageToUsedClasses.isEmpty()) {
            this.printText("doclet.ClassUse_No.usage.of.0", this.pkgdoc.name());
            this.p();
        } else {
            this.generatePackageUse();
        }
        this.printPackageUseFooter();
    }

    protected void generatePackageUse() throws IOException {
        if (this.configuration.packages.length > 1) {
            this.generatePackageList();
        }
        this.generateClassList();
    }

    protected void generatePackageList() throws IOException {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_Packages.that.use.0", this.pkgdoc.name().length() > 0 ? this.getPackageLink(this.pkgdoc) : this.configuration.standardmessage.getText("doclet.Default_Package"));
        this.tableHeaderEnd();
        Iterator iterator = this.usingPackageToUsedClasses.keySet().iterator();
        while (iterator.hasNext()) {
            PackageDoc packageDoc = this.configuration.root.packageNamed((String)iterator.next());
            this.generatePackageUse(packageDoc);
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generateClassList() throws IOException {
        for (String string : this.usingPackageToUsedClasses.keySet()) {
            PackageDoc packageDoc = this.configuration.root.packageNamed(string);
            if (packageDoc != null) {
                this.anchor(packageDoc.name());
            }
            this.tableIndexSummary();
            this.tableHeaderStart("#CCCCFF");
            this.printText("doclet.ClassUse_Classes.in.0.used.by.1", this.getPackageLink(this.pkgdoc), packageDoc != null ? this.getPackageLink(packageDoc) : this.configuration.standardmessage.getText("doclet.Default_Package"));
            Iterator iterator = ((Collection)this.usingPackageToUsedClasses.get(string)).iterator();
            while (iterator.hasNext()) {
                this.printClassRow((ClassDoc)iterator.next(), string);
            }
            this.tableHeaderEnd();
            this.tableEnd();
            this.space();
            this.p();
        }
    }

    protected void printClassRow(ClassDoc classDoc, String string) {
        String string2 = this.pathString(classDoc, "class-use/" + classDoc.name() + ".html");
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.bold();
        this.printHyperLink(string2, string, classDoc.name(), true);
        this.boldEnd();
        this.println();
        this.br();
        this.printNbsps();
        this.printIndexComment((Doc)classDoc);
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void generatePackageUse(PackageDoc packageDoc) throws IOException {
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        if (packageDoc == null) {
            this.print(this.configuration.standardmessage.getText("doclet.Default_Package"));
        } else {
            this.printHyperLink("", packageDoc.name(), packageDoc.name(), true);
        }
        this.summaryRowEnd();
        this.summaryRow(0);
        if (packageDoc != null) {
            this.printSummaryComment((Doc)packageDoc);
        }
        this.space();
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void printPackageUseHeader() {
        String string = this.getText("doclet.Package");
        String string2 = this.pkgdoc.name();
        this.printHeader(this.getText("doclet.Window_ClassUse_Header", string, string2));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.ClassUse_Title", string, string2);
        this.h2End();
        this.centerEnd();
    }

    protected void printPackageUseFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navClassUse");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

