/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.webui.jsf.doclets.ClassTree;
import com.sun.webui.jsf.doclets.DocletAbortException;
import com.sun.webui.jsf.doclets.IndexBuilder;
import com.sun.webui.jsf.doclets.SourceToHTMLConverter;
import com.sun.webui.jsf.doclets.Util;
import com.sun.webui.jsf.doclets.standard.AllClassesFrameWriter;
import com.sun.webui.jsf.doclets.standard.ClassUseMapper;
import com.sun.webui.jsf.doclets.standard.ClassWriter;
import com.sun.webui.jsf.doclets.standard.ConfigurationStandard;
import com.sun.webui.jsf.doclets.standard.ConstantsSummaryWriter;
import com.sun.webui.jsf.doclets.standard.DeprecatedListWriter;
import com.sun.webui.jsf.doclets.standard.FrameOutputWriter;
import com.sun.webui.jsf.doclets.standard.HelpWriter;
import com.sun.webui.jsf.doclets.standard.HtmlStandardWriter;
import com.sun.webui.jsf.doclets.standard.PackageFrameWriter;
import com.sun.webui.jsf.doclets.standard.PackageIndexFrameWriter;
import com.sun.webui.jsf.doclets.standard.PackageIndexWriter;
import com.sun.webui.jsf.doclets.standard.PackageListWriter;
import com.sun.webui.jsf.doclets.standard.PackageTreeWriter;
import com.sun.webui.jsf.doclets.standard.PackageWriter;
import com.sun.webui.jsf.doclets.standard.PackagesFileWriter;
import com.sun.webui.jsf.doclets.standard.SerializedFormWriter;
import com.sun.webui.jsf.doclets.standard.SingleIndexWriter;
import com.sun.webui.jsf.doclets.standard.SplitIndexWriter;
import com.sun.webui.jsf.doclets.standard.StylesheetWriter;
import com.sun.webui.jsf.doclets.standard.TreeWriter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Standard {
    public static final String BUILD_DATE = "1.4.1";
    public ConfigurationStandard configuration = Standard.configuration();

    public static boolean start(RootDoc rootDoc) throws IOException {
        Standard standard;
        try {
            standard = new Standard();
            standard.startGeneration(rootDoc);
        }
        catch (DocletAbortException docletAbortException) {
            return false;
        }
        standard.configuration.tagletManager.printReport();
        return true;
    }

    public static ConfigurationStandard configuration() {
        return new ConfigurationStandard();
    }

    protected void startGeneration(RootDoc rootDoc) {
        StringTokenizer stringTokenizer;
        this.configuration.setOptions(rootDoc);
        if (!this.configuration.quiet) {
            this.configuration.standardmessage.notice("stddoclet.version", BUILD_DATE);
            this.configuration.printedVersion = true;
        }
        if (this.configuration.genSrc) {
            if (this.configuration.destdirname.length() > 0) {
                SourceToHTMLConverter.convertRoot(this.configuration, rootDoc, this.configuration.destdirname + File.separator + ConfigurationStandard.SOURCE_OUTPUT_DIR_NAME);
            } else {
                SourceToHTMLConverter.convertRoot(this.configuration, rootDoc, ConfigurationStandard.SOURCE_OUTPUT_DIR_NAME);
            }
        }
        ConstantsSummaryWriter.generate(this.configuration);
        if (rootDoc.classes().length == 0) {
            this.configuration.standardmessage.error("doclet.No_Public_Classes_To_Document");
            return;
        }
        if (this.configuration.topFile.length() == 0) {
            this.configuration.standardmessage.error("doclet.No_Non_Deprecated_Classes_To_Document");
            return;
        }
        boolean bl = this.configuration.nodeprecated;
        String string = this.configuration.destdirname;
        String string2 = this.configuration.helpfile;
        String string3 = this.configuration.stylesheetfile;
        this.performCopy(string, string2);
        this.performCopy(string, string3);
        ClassTree classTree = new ClassTree(this.configuration, bl);
        if (this.configuration.classuse) {
            ClassUseMapper.generate(this.configuration, classTree);
        }
        IndexBuilder indexBuilder = new IndexBuilder(this.configuration, bl);
        PackageDoc[] packageDocArray = this.configuration.packages;
        if (this.configuration.createtree) {
            TreeWriter.generate(this.configuration, classTree);
        }
        if (this.configuration.createindex) {
            if (this.configuration.splitindex) {
                SplitIndexWriter.generate(this.configuration, indexBuilder);
            } else {
                SingleIndexWriter.generate(this.configuration, indexBuilder);
            }
        }
        if (!this.configuration.nodeprecatedlist && !bl) {
            DeprecatedListWriter.generate(this.configuration);
        }
        AllClassesFrameWriter.generate(this.configuration, new IndexBuilder(this.configuration, bl, true));
        FrameOutputWriter.generate(this.configuration);
        PackagesFileWriter.generate(this.configuration);
        if (this.configuration.createoverview) {
            PackageIndexWriter.generate(this.configuration);
        }
        if (packageDocArray.length > 1) {
            PackageIndexFrameWriter.generate(this.configuration);
        }
        if (packageDocArray.length != 1 || !packageDocArray[0].name().equals("")) {
            stringTokenizer = null;
            for (int i = 0; i < packageDocArray.length; ++i) {
                PackageFrameWriter.generate(this.configuration, packageDocArray[i]);
                if (packageDocArray[i].name().length() == 0) continue;
                PackageDoc packageDoc = i + 1 < packageDocArray.length && packageDocArray[i + 1].name().length() > 0 ? packageDocArray[i + 1] : null;
                packageDoc = i + 2 < packageDocArray.length && packageDoc == null ? packageDocArray[i + 2] : packageDoc;
                PackageWriter.generate(this.configuration, packageDocArray[i], (PackageDoc)stringTokenizer, packageDoc);
                if (this.configuration.createtree) {
                    PackageTreeWriter.generate(this.configuration, packageDocArray[i], (PackageDoc)stringTokenizer, packageDoc, bl);
                }
                stringTokenizer = packageDocArray[i];
            }
        }
        this.generateClassFiles(rootDoc, classTree);
        if (this.configuration.sourcepath != null && this.configuration.sourcepath.length() > 0) {
            stringTokenizer = new StringTokenizer(this.configuration.sourcepath, ":");
            boolean bl2 = true;
            while (stringTokenizer.hasMoreTokens()) {
                HtmlStandardWriter.copyDocFiles(this.configuration, stringTokenizer.nextToken() + File.separator, "doc-files", bl2);
                bl2 = false;
            }
        }
        if (this.generateSerializedFormPage(rootDoc)) {
            SerializedFormWriter.generate(this.configuration);
        }
        PackageListWriter.generate(this.configuration);
        if (this.configuration.helpfile.length() == 0 && !this.configuration.nohelp) {
            HelpWriter.generate(this.configuration);
        }
        if (this.configuration.stylesheetfile.length() == 0) {
            StylesheetWriter.generate(this.configuration);
        }
    }

    protected void generateClassFiles(RootDoc rootDoc, ClassTree classTree) {
        this.generateClassCycle(classTree, true);
        PackageDoc[] packageDocArray = this.configuration.root.specifiedPackages();
        for (int i = 0; i < packageDocArray.length; ++i) {
            PackageDoc packageDoc = packageDocArray[i];
            this.generateClassCycle(packageDoc.interfaces(), classTree, false);
            this.generateClassCycle(packageDoc.ordinaryClasses(), classTree, false);
            this.generateClassCycle(packageDoc.exceptions(), classTree, false);
            this.generateClassCycle(packageDoc.errors(), classTree, false);
        }
    }

    protected String classFileName(ClassDoc classDoc) {
        return classDoc.qualifiedName() + ".html";
    }

    protected void generateClassCycle(ClassTree classTree, boolean bl) {
        String[] stringArray = this.configuration.classDocCatalog.packageNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray = this.configuration.classDocCatalog.allClasses(stringArray[i]);
            Arrays.sort(objectArray);
            this.generateClassCycle((ClassDoc[])objectArray, classTree, bl);
        }
    }

    protected void generateClassCycle(ClassDoc[] classDocArray, ClassTree classTree, boolean bl) {
        Arrays.sort(classDocArray);
        for (int i = 0; i < classDocArray.length; ++i) {
            if (!this.configuration.isGeneratedDoc((Doc)classDocArray[i]) || !classDocArray[i].isIncluded()) continue;
            ClassDoc classDoc = i == 0 ? null : classDocArray[i - 1];
            ClassDoc classDoc2 = classDocArray[i];
            ClassDoc classDoc3 = i + 1 == classDocArray.length ? null : classDocArray[i + 1];
            ClassWriter.generate(this.configuration, classDoc2, classDoc, classDoc3, classTree, bl);
        }
    }

    public static int optionLength(String string) {
        return new ConfigurationStandard().optionLength(string);
    }

    public static boolean validOptions(String[][] stringArray, DocErrorReporter docErrorReporter) throws IOException {
        return new ConfigurationStandard().validOptions(stringArray, docErrorReporter);
    }

    protected void performCopy(String string, String string2) {
        try {
            String string3;
            String string4 = string3 = string.length() > 0 ? string + File.separatorChar : "";
            if (string2.length() > 0) {
                File file = new File(string2);
                String string5 = file.getParent();
                String string6 = string5 == null ? string2 : string2.substring(string5.length() + 1);
                File file2 = new File(string3 + string6);
                if (!file2.getCanonicalPath().equals(file.getCanonicalPath())) {
                    this.configuration.standardmessage.notice((SourcePosition)null, "doclet.Copying_File_0_To_File_1", file.toString(), file2.toString());
                    Util.copyFile(file2, file);
                }
            }
        }
        catch (IOException iOException) {
            this.configuration.standardmessage.error((SourcePosition)null, "doclet.perform_copy_exception_encountered", iOException.toString());
            throw new DocletAbortException();
        }
    }

    public boolean generateSerializedFormPage(RootDoc rootDoc) {
        int n;
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        ClassDoc[] classDocArray = rootDoc.specifiedClasses();
        for (n = 0; n < packageDocArray.length; ++n) {
            PackageDoc packageDoc = packageDocArray[n];
            boolean bl = HtmlStandardWriter.serialInclude((Doc)packageDoc);
            if (!bl) continue;
            ClassDoc[] classDocArray2 = packageDoc.allClasses();
            for (int i = 0; i < classDocArray2.length; ++i) {
                if (!HtmlStandardWriter.serialInclude((Doc)classDocArray2[i])) continue;
                return true;
            }
        }
        for (n = 0; n < classDocArray.length; ++n) {
            if (!HtmlStandardWriter.serialInclude((Doc)classDocArray[n])) continue;
            return true;
        }
        return false;
    }
}

