/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std;

import com.sun.jsfcl.util.ComponentBundle;
import com.sun.rave.designtime.CategoryDescriptor;
import java.util.HashMap;

public class PropCategories {
    private static final ComponentBundle bundle = ComponentBundle.getBundle(PropCategories.class);
    protected static HashMap CategoryHash;
    public static final CategoryDescriptor GENERAL;
    public static final CategoryDescriptor APPEARANCE;
    public static final CategoryDescriptor DATA;
    public static final CategoryDescriptor EVENTS;
    public static final CategoryDescriptor JAVASCRIPT;
    public static final CategoryDescriptor ADVANCED;
    public static final CategoryDescriptor INTERNAL;
    private static CategoryDescriptor[] defaultCategoryDescriptors;

    public static CategoryDescriptor getCategoryDescriptor(String categoryName) {
        if (categoryName == null) {
            return null;
        }
        Object[] pair = (Object[])CategoryHash.get(categoryName.toLowerCase());
        if (pair == null) {
            pair = new Object[]{null, new CategoryDescriptor(categoryName, "")};
            CategoryHash.put(categoryName, pair);
        }
        return (CategoryDescriptor)pair[1];
    }

    public static String getCategoryDescriptorConstantName(String categoryName) {
        if (categoryName == null) {
            return null;
        }
        Object[] pair = (Object[])CategoryHash.get(categoryName.toLowerCase());
        if (pair == null) {
            return null;
        }
        return (String)pair[0];
    }

    public static CategoryDescriptor[] getDefaultCategoryDescriptors() {
        return defaultCategoryDescriptors;
    }

    static {
        GENERAL = new CategoryDescriptor(bundle.getMessage("gen"), bundle.getMessage("genCatDesc"), true);
        APPEARANCE = new CategoryDescriptor(bundle.getMessage("appear"), bundle.getMessage("appearCatDesc"), true);
        DATA = new CategoryDescriptor(bundle.getMessage("data"), bundle.getMessage("dataCatDesc"), true);
        EVENTS = new CategoryDescriptor(bundle.getMessage("ev"), bundle.getMessage("evCatDesc"), true);
        JAVASCRIPT = new CategoryDescriptor(bundle.getMessage("js"), bundle.getMessage("jsCatDesc"), false);
        ADVANCED = new CategoryDescriptor(bundle.getMessage("adv"), bundle.getMessage("advCatDesc"), false);
        INTERNAL = new CategoryDescriptor(bundle.getMessage("intern"), bundle.getMessage("internCatDesc"), false);
        CategoryHash = new HashMap();
        CategoryHash.put(GENERAL.getName().toLowerCase(), new Object[]{"GENERAL", GENERAL});
        CategoryHash.put(APPEARANCE.getName().toLowerCase(), new Object[]{"APPEARANCE", APPEARANCE});
        CategoryHash.put(DATA.getName().toLowerCase(), new Object[]{"DATA", DATA});
        CategoryHash.put(EVENTS.getName().toLowerCase(), new Object[]{"EVENTS", EVENTS});
        CategoryHash.put(JAVASCRIPT.getName().toLowerCase(), new Object[]{"JAVASCRIPT", JAVASCRIPT});
        CategoryHash.put(ADVANCED.getName().toLowerCase(), new Object[]{"ADVANCED", ADVANCED});
        CategoryHash.put(INTERNAL.getName().toLowerCase(), new Object[]{"INTERNAL", INTERNAL});
        defaultCategoryDescriptors = new CategoryDescriptor[]{GENERAL, APPEARANCE, DATA, EVENTS, JAVASCRIPT, ADVANCED, INTERNAL};
    }
}

