/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std;

import com.sun.java.swing.plaf.windows.WindowsFileChooserUI;
import com.sun.jsfcl.std.URLPropertyEditor;
import com.sun.jsfcl.util.ComponentBundle;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.extension.openide.awt.JFileChooser_RAVE;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageProducer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;

public class URLPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
ChangeListener,
EnhancedCustomPropertyEditor,
DocumentListener {
    static String copyString = "Copy";
    static String linkString = "Link";
    protected static WeakHashMap lastDirectoryByProject = new WeakHashMap();
    protected static final String LAST_DIRECTORY_KEY_NO_PROJECT = "DEFAULT";
    private static final ComponentBundle bundle = ComponentBundle.getBundle(URLPanel.class);
    JTabbedPane tabs = new JTabbedPane();
    JFileChooser filePanel;
    HTTPPanel httpPanel;
    JTextField valueTextField = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel valueLabel = new JLabel();
    URLPropertyEditor ure;
    JRadioButton copyButton = new JRadioButton(bundle.getMessage("copy"));
    JRadioButton linkButton = new JRadioButton(bundle.getMessage("link"));
    ButtonGroup group = new ButtonGroup();
    RadioListener myListener = new RadioListener();
    private boolean initialized = false;
    protected DesignProperty liveProperty;
    protected DesignContext liveContext;
    protected Node.Property property;
    private File baseDirectory;
    protected boolean ignoreValueTextFieldChanges;
    JToggleButton shortCutPanelMyProjectButton;
    protected File relativeRootDirectoryCache;
    protected boolean relativeRootDirectoryCacheSet;
    protected File relativeDirectoryCache;
    protected boolean relativeDirectoryCacheSet;
    protected String propertyValue;
    protected File delayedFileToAdd;
    protected File delayedSetLastDirectoryUsed;

    public URLPanel(URLPropertyEditor ure) {
        this();
        this.ure = ure;
    }

    public URLPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Image loadImage(final String resourceName, final Class clazz) {
        try {
            ImageProducer ip = (ImageProducer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL url = clazz.getResource(resourceName);
                    if (url == null) {
                        return null;
                    }
                    try {
                        return url.getContent();
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }
            });
            if (ip == null) {
                return null;
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            return tk.createImage(ip);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void jbInit() throws Exception {
        this.copyButton.setActionCommand(copyString);
        this.linkButton.setActionCommand(linkString);
        this.group.add(this.copyButton);
        this.group.add(this.linkButton);
        this.linkButton.setSelected(true);
        this.copyButton.addActionListener(this.myListener);
        this.linkButton.addActionListener(this.myListener);
        this.setLayout(this.gridBagLayout1);
        this.valueLabel.setText(bundle.getMessage("urlPanelCurrSetting"));
        this.valueTextField.setText("");
        this.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 2, 8), 0, 0));
        this.add((Component)this.valueTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 4, 8), 0, 0));
        this.add((Component)this.tabs, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
        this.add((Component)this.copyButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.linkButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected File getLastDirectoryUsed() {
        String key = this.getDesignProperty() == null ? LAST_DIRECTORY_KEY_NO_PROJECT : this.getDesignProperty().getDesignBean().getDesignContext().getProject();
        File dir = (File)lastDirectoryByProject.get(key);
        if (dir == null) {
            dir = this.getRelativeRootDirectory();
            lastDirectoryByProject.put(key, dir);
        }
        return dir;
    }

    protected void setLastDirectoryUsed(File dir) {
        String key = this.getDesignProperty() == null ? LAST_DIRECTORY_KEY_NO_PROJECT : this.getDesignProperty().getDesignBean().getDesignContext().getProject();
        lastDirectoryByProject.put(key, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.filePanel) {
            File file = this.filePanel.getSelectedFile();
            if (file == null) {
                file = this.filePanel.getCurrentDirectory();
            }
            this.processValueFile(file);
            this.ignoreValueTextFieldChanges = true;
            try {
                this.valueTextField.setText(this.propertyValue);
            }
            finally {
                this.ignoreValueTextFieldChanges = false;
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.shortCutPanelMyProjectButton) {
            this.filePanel.setCurrentDirectory(this.getRelativeRootDirectory());
            return;
        }
    }

    public void stateChanged(ChangeEvent evt) {
    }

    protected DesignProperty getDesignProperty() {
        return this.liveProperty;
    }

    public void setDesignProperty(DesignProperty prop) {
        this.liveProperty = prop;
        if (prop != null) {
            this.liveContext = prop.getDesignBean().getDesignContext();
        }
    }

    public void setProperty(Node.Property prop) {
        this.property = prop;
    }

    public void setDesignContext(DesignContext context) {
        this.liveContext = context;
    }

    public void changedUpdate(DocumentEvent event) {
        if (event.getDocument() == this.httpPanel.textField.getDocument()) {
            this.httpTextFieldChanged();
        }
        if (event.getDocument() == this.valueTextField.getDocument()) {
            this.valueTextFieldChanged();
        }
    }

    public void insertUpdate(DocumentEvent event) {
        if (event.getDocument() == this.httpPanel.textField.getDocument()) {
            this.httpTextFieldChanged();
        }
        if (event.getDocument() == this.valueTextField.getDocument()) {
            this.valueTextFieldChanged();
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (event.getDocument() == this.httpPanel.textField.getDocument()) {
            this.httpTextFieldChanged();
        }
        if (event.getDocument() == this.valueTextField.getDocument()) {
            this.valueTextFieldChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void httpTextFieldChanged() {
        this.processValueUri(this.httpPanel.textField.getText());
        this.ignoreValueTextFieldChanges = true;
        try {
            this.valueTextField.setText(this.propertyValue);
        }
        finally {
            this.ignoreValueTextFieldChanges = false;
        }
    }

    public void valueTextFieldChanged() {
        if (this.ignoreValueTextFieldChanges) {
            return;
        }
        this.processValueString(this.valueTextField.getText());
    }

    public void initialize() {
        if (!this.initialized) {
            this.filePanel = JFileChooser_RAVE.getJFileChooser();
            if (this.filePanel.getUI() instanceof WindowsFileChooserUI) {
                try {
                    this.tweakWindowsFileChooserUI(this.filePanel, (WindowsFileChooserUI)this.filePanel.getUI());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.filePanel.setControlButtonsAreShown(false);
            this.filePanel.setFileSelectionMode(2);
            this.filePanel.addPropertyChangeListener("SelectedFileChangedProperty", this);
            this.tabs.add((Component)this.filePanel, bundle.getMessage("file"));
            this.httpPanel = new HTTPPanel();
            this.tabs.add((Component)this.httpPanel, bundle.getMessage("url"));
            this.tabs.addChangeListener(this);
            String original = null;
            if (this.liveProperty == null) {
                if (this.property != null) {
                    try {
                        original = (String)this.property.getValue();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                original = (String)this.liveProperty.getValue();
            }
            if (original == null || original.trim().length() == 0) {
                this.tabs.setSelectedComponent(this.filePanel);
            } else {
                this.tabs.setSelectedComponent(this.httpPanel);
            }
            this.httpPanel.textField.setText(original);
            this.httpTextFieldChanged();
            this.valueTextField.getDocument().addDocumentListener(this);
            this.httpPanel.textField.getDocument().addDocumentListener(this);
            File dir = this.getLastDirectoryUsed();
            this.filePanel.setCurrentDirectory(dir);
            this.initialized = true;
        }
    }

    protected void tweakWindowsFileChooserUI(JFileChooser fileChooser, WindowsFileChooserUI ui) {
        String folderName;
        int index;
        JToolBar shortCutPanel;
        File projectDirectory = this.getRelativeRootDirectory();
        if (projectDirectory == null) {
            return;
        }
        try {
            Field shortCutPanelField = WindowsFileChooserUI.class.getDeclaredField("shortCutPanel");
            boolean oldAccessibleState = shortCutPanelField.isAccessible();
            shortCutPanelField.setAccessible(true);
            shortCutPanel = (JToolBar)shortCutPanelField.get(ui);
            shortCutPanelField.setAccessible(false);
        }
        catch (Exception e) {
            return;
        }
        if (shortCutPanel == null) {
            return;
        }
        FileSystemView fsv = fileChooser.getFileSystemView();
        if (fsv.isFileSystemRoot(projectDirectory)) {
            projectDirectory = fsv.createFileObject(projectDirectory.getAbsolutePath());
        }
        if ((index = (folderName = fsv.getSystemDisplayName(projectDirectory)).lastIndexOf(File.separatorChar)) >= 0 && index < folderName.length() - 1) {
            folderName = folderName.substring(index + 1);
        }
        boolean xp = false;
        try {
            Class<?> clazz = Class.forName("com.sun.java.swing.plaf.windows.XPStyle");
            Method method = clazz.getDeclaredMethod("getXP", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke(null, new Object[0]);
            method.setAccessible(false);
            xp = object != null;
        }
        catch (Exception e) {
            // empty catch block
        }
        Icon icon = null;
        if (xp) {
            Image image = URLPanel.loadImage("urlpanel_myproject.png", this.getClass());
            icon = new ImageIcon(image, bundle.getMessage("myProject"));
        }
        if (icon == null) {
            icon = fsv.getSystemIcon(projectDirectory);
            folderName = bundle.getMessage("myProject");
        }
        Dimension buttonSize = new Dimension(83, xp ? 69 : 54);
        this.shortCutPanelMyProjectButton = new JToggleButton(folderName, icon);
        if (xp) {
            this.shortCutPanelMyProjectButton.setIconTextGap(2);
            this.shortCutPanelMyProjectButton.setMargin(new Insets(2, 2, 2, 2));
            this.shortCutPanelMyProjectButton.setText("<html><center>" + bundle.getMessage("myProject") + "</center></html>");
        } else {
            Color fgColor = new Color(UIManager.getColor("List.selectionForeground").getRGB());
            this.shortCutPanelMyProjectButton.setBackground(fileChooser.getBackground());
            this.shortCutPanelMyProjectButton.setForeground(fileChooser.getForeground());
        }
        this.shortCutPanelMyProjectButton.setHorizontalTextPosition(0);
        this.shortCutPanelMyProjectButton.setVerticalTextPosition(3);
        this.shortCutPanelMyProjectButton.setAlignmentX(0.5f);
        this.shortCutPanelMyProjectButton.setPreferredSize(buttonSize);
        this.shortCutPanelMyProjectButton.setMaximumSize(buttonSize);
        this.shortCutPanelMyProjectButton.addActionListener(this);
        shortCutPanel.add((Component)this.shortCutPanelMyProjectButton, 0);
        shortCutPanel.add(Box.createRigidArea(new Dimension(1, 1)), 1);
        Component[] components = shortCutPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JToggleButton)) continue;
            JToggleButton button = (JToggleButton)components[i];
            ButtonModel buttonModel = button.getModel();
            try {
                Field field = buttonModel.getClass().getSuperclass().getDeclaredField("group");
                field.setAccessible(true);
                ButtonGroup group = (ButtonGroup)field.get(buttonModel);
                field.setAccessible(false);
                if (group == null) continue;
                group.add(this.shortCutPanelMyProjectButton);
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected File getRelativeRootDirectory() {
        if (!this.relativeRootDirectoryCacheSet) {
            this.relativeRootDirectoryCache = this.getRelativeRootDirectoryImp();
            this.relativeRootDirectoryCacheSet = true;
            if (this.relativeDirectoryCache != null && this.relativeRootDirectoryCache != null && this.relativeDirectoryCache.getPath().equals(this.relativeRootDirectoryCache.getPath())) {
                this.relativeRootDirectoryCache = this.relativeDirectoryCache;
            }
        }
        return this.relativeRootDirectoryCache;
    }

    protected File getRelativeDirectory() {
        if (!this.relativeDirectoryCacheSet) {
            this.relativeDirectoryCache = this.getRelativeDirectoryImp();
            this.relativeDirectoryCacheSet = true;
        }
        return this.relativeDirectoryCache;
    }

    protected File getFileFromUrl(URL url) {
        File result = null;
        if (url != null && "file".equals(url.getProtocol())) {
            result = url.getAuthority() == null ? new File(url.getPath()) : new File(url.getAuthority(), url.getPath());
        }
        if (result != null && result.isFile()) {
            result = result.getParentFile();
        }
        return result;
    }

    protected File getRelativeRootDirectoryImp() {
        File rootFile = this.getRelativeDirectory();
        if (rootFile == null) {
            return null;
        }
        try {
            boolean isProjectRoot;
            while (rootFile != null && !(isProjectRoot = this.isProjectRootFolder(rootFile))) {
                rootFile = rootFile.getParentFile();
            }
            if (rootFile == null) {
                return this.getRelativeDirectory();
            }
            if (this.liveContext == null) {
                rootFile = new File(rootFile, "src/web");
            } else {
                String sourcePath = (String)this.liveContext.getProject().getProjectData("sourceRoot");
                rootFile = new File(rootFile, sourcePath);
                rootFile = new File(rootFile, "web");
            }
            return rootFile;
        }
        catch (Exception e) {
            return this.getRelativeDirectory();
        }
    }

    public boolean isProjectRootFolder(File f) {
        String PROJECT_DATA = "project-data";
        String FILE_EXTENSION = "prj";
        String PROJECT_FILE = "project.prj";
        if (!f.isDirectory()) {
            return false;
        }
        File subF = new File(f, "project-data");
        if (!subF.exists()) {
            return false;
        }
        return (subF = new File(subF, "project.prj")).exists();
    }

    public void setRelativeRootDirectory(File file) {
        this.relativeRootDirectoryCache = file;
        this.relativeRootDirectoryCacheSet = true;
    }

    protected File getRelativeDirectoryImp() {
        if (this.liveContext == null) {
            return null;
        }
        URL url = this.liveContext.resolveResource("");
        File contextFile = this.getFileFromUrl(url);
        try {
            contextFile = contextFile.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
        return contextFile;
    }

    public void setRelativeDirectory(File file) {
        this.relativeDirectoryCache = file;
        if (file != null && file.isFile()) {
            this.relativeDirectoryCache = this.relativeDirectoryCache.getParentFile();
        }
        this.relativeDirectoryCacheSet = true;
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            Object result = this.getPropertyValueImp();
            return result;
        }
        catch (IllegalStateException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), bundle.getMessage("urlPanelErroDialogTitle"), 2);
            throw e;
        }
    }

    protected Object getPropertyValueImp() {
        if (this.delayedFileToAdd != null) {
            if (!this.delayedFileToAdd.exists()) {
                throw new IllegalStateException(bundle.getMessage("fileSpecifiedNotExist"));
            }
            try {
                DesignProject designProject = this.liveContext.getProject();
                URI uri = new URI("web/resources/" + URLPanel.encodeUrl(this.delayedFileToAdd.getName()));
                if (designProject.getResourceFile(uri) == null) {
                    designProject.addResource(this.delayedFileToAdd.toURI().toURL(), uri);
                }
                this.propertyValue = "/resources/" + this.delayedFileToAdd.getName();
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify(1, (Throwable)mue);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
            catch (URISyntaxException use) {
                ErrorManager.getDefault().notify(1, (Throwable)use);
            }
        }
        if (this.delayedSetLastDirectoryUsed != null) {
            this.setLastDirectoryUsed(this.delayedSetLastDirectoryUsed);
        }
        return this.propertyValue;
    }

    private static String encodeUrl(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        StringBuffer buffer = new StringBuffer();
        String anchor = null;
        int index = url.lastIndexOf(35);
        if (index > 0) {
            anchor = url.substring(index + 1);
            url = url.substring(0, index);
        }
        char[] chars = url.toCharArray();
        block13: for (int i = 0; i < chars.length; ++i) {
            if (chars[i] <= ' ') {
                buffer.append('%');
                buffer.append(Integer.toHexString(chars[i]));
                continue;
            }
            switch (chars[i]) {
                case '\t': {
                    buffer.append("%09");
                    continue block13;
                }
                case ' ': {
                    buffer.append("%20");
                    continue block13;
                }
                case '#': {
                    buffer.append("%23");
                    continue block13;
                }
                case '%': {
                    buffer.append("%25");
                    continue block13;
                }
                case '<': {
                    buffer.append("%3C");
                    continue block13;
                }
                case '>': {
                    buffer.append("%3E");
                    continue block13;
                }
                case '[': {
                    buffer.append("%5B");
                    continue block13;
                }
                case ']': {
                    buffer.append("%5D");
                    continue block13;
                }
                case '{': {
                    buffer.append("%7B");
                    continue block13;
                }
                case '}': {
                    buffer.append("%7D");
                    continue block13;
                }
                case '~': {
                    buffer.append("%7E");
                    continue block13;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        if (anchor != null) {
            buffer.append('#');
            buffer.append(anchor);
        }
        if (buffer.length() == url.length()) {
            return url;
        }
        return buffer.toString();
    }

    protected void processValueFile(File file) {
        if (file.isAbsolute()) {
            try {
                file = file.getCanonicalFile();
                String fileAbsolutePath = file.toURI().toString();
                String rootAbsolutePath = this.getRelativeRootDirectory() == null ? null : this.getRelativeRootDirectory().toURI().toString();
                if (rootAbsolutePath != null && fileAbsolutePath.startsWith(rootAbsolutePath)) {
                    this.linkButton.setSelected(true);
                    this.linkButton.setEnabled(true);
                    this.copyButton.setEnabled(false);
                    this.delayedFileToAdd = null;
                    this.delayedSetLastDirectoryUsed = file.getParentFile();
                    this.propertyValue = fileAbsolutePath.substring(rootAbsolutePath.length());
                    if (this.getRelativeRootDirectory() != this.getRelativeDirectory()) {
                        int i;
                        File fileDir = file;
                        if (file.isFile()) {
                            fileDir = file.getParentFile();
                        }
                        ArrayList filePathList = this.getPathList(fileDir, this.getRelativeRootDirectory());
                        ArrayList relativePathList = this.getPathList(this.getRelativeDirectory(), this.getRelativeRootDirectory());
                        for (int index = 0; index < filePathList.size() && index < relativePathList.size() && filePathList.get(index).equals(relativePathList.get(index)); ++index) {
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        for (i = index; i < relativePathList.size(); ++i) {
                            stringBuffer.append("../");
                        }
                        for (i = index; i < filePathList.size(); ++i) {
                            stringBuffer.append(filePathList.get(i));
                            stringBuffer.append("/");
                        }
                        if (file.isFile()) {
                            stringBuffer.append(file.getName());
                        }
                        this.propertyValue = stringBuffer.toString();
                    }
                    return;
                }
                this.copyButton.setSelected(true);
                this.copyButton.setEnabled(true);
                this.linkButton.setEnabled(false);
                this.delayedFileToAdd = file;
                this.delayedSetLastDirectoryUsed = file.getParentFile();
                this.propertyValue = file.getPath();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.processValueUri(file.getPath());
    }

    protected ArrayList getPathList(File from, File to) {
        String toPath = to.getPath();
        ArrayList<String> result = new ArrayList<String>();
        while (!from.getPath().equals(toPath)) {
            File parent = from.getParentFile();
            String subDir = from.getPath().substring(parent.getPath().length() + File.separator.length());
            result.add(subDir);
            from = parent;
        }
        Collections.reverse(result);
        return result;
    }

    protected void processValueString(String valueString) {
        File file = new File(valueString);
        try {
            file.getCanonicalPath();
            this.processValueFile(file);
            return;
        }
        catch (IOException iOException) {
            this.processValueUri(valueString);
            return;
        }
    }

    protected void processValueUri(String uriString) {
        this.delayedFileToAdd = null;
        this.delayedSetLastDirectoryUsed = null;
        this.linkButton.setSelected(true);
        this.linkButton.setEnabled(true);
        this.copyButton.setEnabled(false);
        this.propertyValue = uriString.replace('\\', '/');
    }

    public void customizerApply() {
        this.liveProperty.setValue(this.getPropertyValue());
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class HTTPPanel
    extends JPanel {
        JLabel httpLabel = new JLabel();
        JTextField textField = new JTextField();

        HTTPPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.httpLabel.setText(bundle.getMessage("enterUrlHttp"));
            this.httpLabel.setAlignmentX(0.0f);
            this.add(this.httpLabel);
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
            this.textField.setAlignmentX(0.0f);
            this.add(this.textField);
        }
    }
}

