/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.BackgroundImageUrlDialog;
import com.sun.jsfcl.std.css.ColorSelectionField;
import com.sun.jsfcl.std.css.StyleBuilderDialog;
import com.sun.jsfcl.std.css.StyleEditor;
import com.sun.jsfcl.std.css.model.BackgroundModel;
import com.sun.jsfcl.std.css.model.BackgroundPositionData;
import com.sun.jsfcl.std.css.model.CssStyleData;
import com.sun.jsfcl.std.css.model.PropertyData;
import com.sun.jsfcl.std.css.model.Utils;
import com.sun.rave.designtime.DesignProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

public class BackgroundStyleEditor
extends StyleEditor
implements PropertyChangeListener {
    CssStyleData cssStyleData = null;
    static File currentFile = null;
    BackgroundModel backgroundModel = new BackgroundModel();
    ColorSelectionField colorField = new ColorSelectionField();
    BackgroundPositionData bgPositionData = new BackgroundPositionData();
    DesignProperty designProperty = null;
    private JButton browseButton;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JPanel colorSelectionPanel;
    private JLabel errorLabel;
    private JPanel errorPanel;
    private JComboBox horizontalPosComboBox;
    private JLabel horizontalPosLabel;
    private JComboBox horizontalUnitComboBox;
    private JTextField imageFileField;
    private JLabel imageScrollLabel;
    private JLabel imageTileLabel;
    private JLabel lineHeightLabel;
    private JComboBox repeatComboBox;
    private JComboBox scrollComboBox;
    private JComboBox verticalPosComboBox;
    private JLabel verticalPosLabel;
    private JComboBox verticalUnitComboBox;

    public BackgroundStyleEditor(CssStyleData styleData) {
        this.cssStyleData = styleData;
        this.setName("backgroundStyleEditor");
        this.setDisplayName(NbBundle.getMessage((Class)StyleBuilderDialog.class, (String)"BACKGROUND_EDITOR_DISPNAME"));
        this.initComponents();
        this.colorSelectionPanel.add((Component)this.colorField, "Center");
        this.colorField.addPropertyChangeListener(this);
        this.initialize();
    }

    public void setDesignProperty(DesignProperty liveProperty) {
        this.designProperty = liveProperty;
    }

    private void initialize() {
        String backGroundImage;
        String backGroundColor = this.cssStyleData.getProperty("background-color");
        if (backGroundColor != null) {
            this.colorField.setColorString(backGroundColor);
        }
        if ((backGroundImage = this.cssStyleData.getProperty("background-image")) != null) {
            String imgString = backGroundImage.substring(backGroundImage.indexOf("(") + 1, backGroundImage.indexOf(")"));
            this.imageFileField.setText(imgString);
        } else {
            this.imageFileField.setText(CssStyleData.NOT_SET);
        }
        DefaultComboBoxModel backgroundRepeatList = this.backgroundModel.getBackgroundRepeatList();
        this.repeatComboBox.setModel(backgroundRepeatList);
        String backGroundRepeat = this.cssStyleData.getProperty("background-repeat");
        if (backGroundRepeat != null) {
            this.repeatComboBox.setSelectedItem(backGroundRepeat);
        } else {
            this.repeatComboBox.setSelectedIndex(0);
        }
        DefaultComboBoxModel backgroundScrollList = this.backgroundModel.getBackgroundScrollList();
        this.scrollComboBox.setModel(backgroundScrollList);
        String backGroundScroll = this.cssStyleData.getProperty("background-attachment");
        if (backGroundScroll != null) {
            this.scrollComboBox.setSelectedItem(backGroundScroll);
        } else {
            this.scrollComboBox.setSelectedIndex(0);
        }
        this.horizontalPosComboBox.setModel(this.backgroundModel.getBackgroundPositionList());
        this.verticalPosComboBox.setModel(this.backgroundModel.getBackgroundPositionList());
        this.horizontalUnitComboBox.setModel(this.backgroundModel.getBackgroundPositionUnitList());
        this.verticalUnitComboBox.setModel(this.backgroundModel.getBackgroundPositionUnitList());
        String backgroundPosition = this.cssStyleData.getProperty("background-position");
        if (backgroundPosition != null) {
            this.bgPositionData.setBackgroundPosition(backgroundPosition);
            this.horizontalPosComboBox.setSelectedItem(this.bgPositionData.getHorizontalValue());
            this.horizontalUnitComboBox.setSelectedItem(this.bgPositionData.getHorizontalUnit());
            this.verticalPosComboBox.setSelectedItem(this.bgPositionData.getVerticalValue());
            this.verticalUnitComboBox.setSelectedItem(this.bgPositionData.getVerticalUnit());
        } else {
            this.horizontalPosComboBox.setSelectedIndex(0);
            this.verticalPosComboBox.setSelectedIndex(0);
        }
        this.verticalPosComboBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackgroundStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent evt) {
                BackgroundStyleEditor.this.errorLabel.setText("");
            }
        });
        this.horizontalPosComboBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackgroundStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent evt) {
                BackgroundStyleEditor.this.errorLabel.setText("");
            }
        });
        this.scrollComboBox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackgroundStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent evt) {
                BackgroundStyleEditor.this.errorLabel.setText("");
            }
        });
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setBackgroundColor();
    }

    private void initComponents() {
        this.colorPanel = new JPanel();
        this.colorLabel = new JLabel();
        this.browseButton = new JButton();
        this.imageFileField = new JTextField();
        this.lineHeightLabel = new JLabel();
        this.imageTileLabel = new JLabel();
        this.imageScrollLabel = new JLabel();
        this.scrollComboBox = new JComboBox();
        this.repeatComboBox = new JComboBox();
        this.horizontalPosLabel = new JLabel();
        this.verticalPosLabel = new JLabel();
        this.horizontalPosComboBox = new JComboBox();
        this.verticalPosComboBox = new JComboBox();
        this.horizontalUnitComboBox = new JComboBox();
        this.verticalUnitComboBox = new JComboBox();
        this.colorSelectionPanel = new JPanel();
        this.errorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.colorPanel.setLayout(new GridBagLayout());
        this.colorPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.colorLabel.setLabelFor(this.colorPanel);
        this.colorLabel.setText(NbBundle.getMessage((Class)BackgroundStyleEditor.class, (String)"BACKGROUND_COLOR"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.colorPanel.add((Component)this.colorLabel, gridBagConstraints);
        this.browseButton.setMnemonic(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("BG_IMAGE_CHOOSER_MNEMONIC").charAt(0));
        this.browseButton.setText("...");
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.setPreferredSize(new Dimension(20, 20));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackgroundStyleEditor.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.colorPanel.add((Component)this.browseButton, gridBagConstraints);
        this.imageFileField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackgroundStyleEditor.this.imageFileFieldActionPerformed(evt);
            }
        });
        this.imageFileField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                BackgroundStyleEditor.this.imageFileFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.colorPanel.add((Component)this.imageFileField, gridBagConstraints);
        this.lineHeightLabel.setLabelFor(this.imageFileField);
        this.lineHeightLabel.setText(NbBundle.getMessage((Class)BackgroundStyleEditor.class, (String)"BACKGROUND_IMAGE"));
        this.lineHeightLabel.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.lineHeightLabel, gridBagConstraints);
        this.imageTileLabel.setLabelFor(this.repeatComboBox);
        this.imageTileLabel.setText(NbBundle.getMessage((Class)BackgroundStyleEditor.class, (String)"BACKGROUNDTILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 0, 10);
        this.colorPanel.add((Component)this.imageTileLabel, gridBagConstraints);
        this.imageScrollLabel.setLabelFor(this.scrollComboBox);
        this.imageScrollLabel.setText(NbBundle.getMessage((Class)BackgroundStyleEditor.class, (String)"BACKGROUND_SCROLL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 0, 10);
        this.colorPanel.add((Component)this.imageScrollLabel, gridBagConstraints);
        this.scrollComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.scrollComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.scrollComboBox, gridBagConstraints);
        this.scrollComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("SCROLL_COMBO_ACCESSIBLE_DESC"));
        this.repeatComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.repeatComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.repeatComboBox, gridBagConstraints);
        this.repeatComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("TILE_COMBO_ACCESSIBLE_DESC"));
        this.horizontalPosLabel.setLabelFor(this.horizontalPosComboBox);
        this.horizontalPosLabel.setText(NbBundle.getMessage((Class)BackgroundStyleEditor.class, (String)"BG_HORIZONTAL_POS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 0, 10);
        this.colorPanel.add((Component)this.horizontalPosLabel, gridBagConstraints);
        this.verticalPosLabel.setLabelFor(this.verticalPosComboBox);
        this.verticalPosLabel.setText(NbBundle.getMessage((Class)BackgroundStyleEditor.class, (String)"BG_VERTICAL_POS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 0, 10);
        this.colorPanel.add((Component)this.verticalPosLabel, gridBagConstraints);
        this.horizontalPosComboBox.setEditable(true);
        this.horizontalPosComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackgroundStyleEditor.this.horizontalPosComboBoxActionPerformed(evt);
            }
        });
        this.horizontalPosComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.horizontalPosComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.horizontalPosComboBox, gridBagConstraints);
        this.horizontalPosComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("HORIZPOS_COMBO_ACCESSIBLE_DESC"));
        this.verticalPosComboBox.setEditable(true);
        this.verticalPosComboBox.setEnabled(false);
        this.verticalPosComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackgroundStyleEditor.this.verticalPosComboBoxActionPerformed(evt);
            }
        });
        this.verticalPosComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.verticalPosComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.verticalPosComboBox, gridBagConstraints);
        this.verticalPosComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("VERTPOS_COMBO_ACCESSIBLE_DESC"));
        this.horizontalUnitComboBox.setEnabled(false);
        this.horizontalUnitComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.horizontalUnitComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.colorPanel.add((Component)this.horizontalUnitComboBox, gridBagConstraints);
        this.horizontalUnitComboBox.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("HORIZPOS_UNIT_COMBO_ACCESSIBLE_NAME"));
        this.horizontalUnitComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("HORIZPOS_UNIT_COMBO_ACCESSIBLE_DESC"));
        this.verticalUnitComboBox.setEnabled(false);
        this.verticalUnitComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.verticalUnitComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.colorPanel.add((Component)this.verticalUnitComboBox, gridBagConstraints);
        this.verticalUnitComboBox.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("VERTPOS_UNIT_COMBO_ACCESSIBLE_NAME"));
        this.verticalUnitComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("VERTPOS_UNIT_COMBO_ACCESSIBLE_DESC"));
        this.colorSelectionPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.colorPanel.add((Component)this.colorSelectionPanel, gridBagConstraints);
        this.add((Component)this.colorPanel, "North");
        this.errorPanel.setLayout(new BorderLayout());
        this.errorPanel.setBorder(new EmptyBorder(new Insets(1, 10, 1, 1)));
        this.errorLabel.setForeground(new Color(0, 0, 153));
        this.errorLabel.setMinimumSize(new Dimension(200, 20));
        this.errorLabel.setPreferredSize(new Dimension(200, 20));
        this.errorPanel.add((Component)this.errorLabel, "Center");
        this.add((Component)this.errorPanel, "South");
    }

    private void verticalUnitComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.bgPositionData.setVerticalUnit((String)this.verticalUnitComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void horizontalUnitComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.bgPositionData.setHorizontalUnit((String)this.horizontalUnitComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void verticalPosComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.bgPositionData.setVerticalValue((String)this.verticalPosComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void verticalPosComboBoxActionPerformed(ActionEvent evt) {
        this.bgPositionData.setVerticalValue((String)this.verticalPosComboBox.getSelectedItem());
        this.setBackgroundPosition();
    }

    private void horizontalPosComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.bgPositionData.setHorizontalValue((String)this.horizontalPosComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void horizontalPosComboBoxActionPerformed(ActionEvent evt) {
        this.bgPositionData.setHorizontalValue((String)this.horizontalPosComboBox.getSelectedItem());
        this.setBackgroundPosition();
    }

    private void scrollComboBoxItemStateChanged(ItemEvent evt) {
        this.setBackgroundAttachment();
    }

    private void repeatComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBackgroundRepeat();
        }
    }

    private void imageFileFieldFocusLost(FocusEvent evt) {
        this.setBackgroundImage();
    }

    private void imageFileFieldActionPerformed(ActionEvent evt) {
        this.setBackgroundImage();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        BackgroundImageUrlDialog imageUrlDialog = new BackgroundImageUrlDialog();
        if (this.designProperty != null) {
            imageUrlDialog.setDesignContext(this.designProperty.getDesignBean().getDesignContext());
        }
        imageUrlDialog.initialize();
        imageUrlDialog.showDialog();
        String imgResource = (String)imageUrlDialog.getPropertyValue();
        if (imgResource.startsWith("/")) {
            imgResource = "." + imgResource;
        }
        this.imageFileField.setText(imgResource);
        this.setBackgroundImage();
    }

    private void setBackgroundColor() {
        PropertyData backgroundColorData = new PropertyData();
        backgroundColorData.setValue(this.colorField.getColorString());
        this.cssStyleData.modifyProperty("background-color", backgroundColorData.toString());
    }

    private void setBackgroundImage() {
        PropertyData backgroundImageData = new PropertyData();
        String imgPath = this.imageFileField.getText();
        if (imgPath == null || imgPath.equals("")) {
            imgPath = CssStyleData.NOT_SET;
            this.imageFileField.setText(imgPath);
        }
        backgroundImageData.setValue("url(" + imgPath + ")");
        this.cssStyleData.modifyProperty("background-image", backgroundImageData.toString());
    }

    private void setBackgroundRepeat() {
        PropertyData backgroundRepeatData = new PropertyData();
        backgroundRepeatData.setValue(this.repeatComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("background-repeat", backgroundRepeatData.toString());
    }

    private void setBackgroundAttachment() {
        PropertyData backgroundAttachmentData = new PropertyData();
        backgroundAttachmentData.setValue(this.scrollComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("background-attachment", backgroundAttachmentData.toString());
    }

    private void setBackgroundPosition() {
        String backgroundPosition = this.bgPositionData.toString();
        this.cssStyleData.modifyProperty("background-position", backgroundPosition);
        this.enablePositionCombo();
    }

    private void enablePositionCombo() {
        String horizontalPos = this.bgPositionData.getHorizontalValue();
        if (Utils.isInteger(horizontalPos)) {
            this.horizontalUnitComboBox.setEnabled(true);
        } else {
            this.horizontalUnitComboBox.setEnabled(false);
        }
        if (horizontalPos.equals("") || horizontalPos.startsWith(CssStyleData.NOT_SET) || horizontalPos.startsWith(CssStyleData.VALUE)) {
            this.verticalPosComboBox.setEnabled(false);
            this.verticalUnitComboBox.setEnabled(false);
        } else {
            this.verticalPosComboBox.setEnabled(true);
            this.verticalUnitComboBox.setEnabled(true);
        }
        String verticalPos = this.bgPositionData.getVerticalValue();
        if (Utils.isInteger(verticalPos)) {
            this.verticalUnitComboBox.setEnabled(true);
        } else {
            this.verticalUnitComboBox.setEnabled(false);
        }
    }

    class ImageFileFilter
    extends FileFilter {
        ImageFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                extension = s.substring(i + 1).toLowerCase();
            }
            if (extension != null) {
                return extension.toLowerCase().equals("gif") || extension.toLowerCase().equals("jpg") || extension.toLowerCase().equals("png");
            }
            return false;
        }

        public String getDescription() {
            return NbBundle.getMessage((Class)(class$com$sun$jsfcl$std$css$BackgroundStyleEditor == null ? (class$com$sun$jsfcl$std$css$BackgroundStyleEditor = BackgroundStyleEditor.class$("com.sun.jsfcl.std.css.BackgroundStyleEditor")) : class$com$sun$jsfcl$std$css$BackgroundStyleEditor), (String)"IMAGE_FILE_FILTER");
        }
    }
}

