/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.ColorSelectionField;
import com.sun.jsfcl.std.css.FontFamilyEditorDialog;
import com.sun.jsfcl.std.css.StyleBuilderDialog;
import com.sun.jsfcl.std.css.StyleEditor;
import com.sun.jsfcl.std.css.model.CssStyleData;
import com.sun.jsfcl.std.css.model.FontModel;
import com.sun.jsfcl.std.css.model.PropertyData;
import com.sun.jsfcl.std.css.model.PropertyWithUnitData;
import com.sun.jsfcl.std.css.model.TextDecorationData;
import com.sun.jsfcl.std.css.model.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

public class FontStyleEditor
extends StyleEditor
implements PropertyChangeListener {
    CssStyleData cssStyleData = null;
    ColorSelectionField colorField = new ColorSelectionField();
    TextDecorationData textDecorationData = new TextDecorationData();
    FontModel fontModel = new FontModel();
    DefaultListModel fontFamilies = this.fontModel.getFontFamilySetList();
    private JLabel colorLabel;
    private JPanel colorSelectionPanel;
    private JLabel decorationLabel;
    private JPanel decorationPanel;
    private JLabel errorLabel;
    private JPanel errorPanel;
    private JTextField fontChosenField;
    private JList fontFaceList;
    private JScrollPane fontFaceScroll;
    private JButton fontFamilyButton;
    private JPanel fontFamilyPanel;
    private JLabel fontLabel;
    private JTextField fontSizeField;
    private JList fontSizeList;
    private JPanel fontSizePanel;
    private JScrollPane fontSizeScroll;
    private JComboBox fontSizeUnitCombo;
    private JComboBox fontStyleComboBox;
    private JComboBox fontVariantComboBox;
    private JComboBox fontWeightComboBox;
    private JPanel mainPanel;
    private JCheckBox noDecorationCheckbox;
    private JCheckBox overlineCheckbox;
    private JLabel sizeLabel;
    private JCheckBox strikethroughCheckbox;
    private JLabel styleLabel;
    private JPanel styleMainPanel;
    private JPanel stylePanel;
    private JCheckBox underlineCheckbox;
    private JLabel variantLabel;
    private JLabel weightLabel;

    public FontStyleEditor(CssStyleData styleData) {
        this.cssStyleData = styleData;
        this.setName("fontStyleEditor");
        this.setDisplayName(NbBundle.getMessage((Class)StyleBuilderDialog.class, (String)"FONT_EDITOR_DISPNAME"));
        this.initComponents();
        this.colorSelectionPanel.add((Component)this.colorField, "Center");
        this.colorField.addPropertyChangeListener(this);
        this.initialize();
    }

    private void initialize() {
        String textColor;
        String textDecoration;
        this.fontFamilies = this.fontModel.getFontFamilySetList();
        this.fontFaceList.setModel(this.fontFamilies);
        String fontFamily = this.cssStyleData.getProperty("font-family");
        if (fontFamily != null) {
            String fontSet = "";
            StringTokenizer st = new StringTokenizer(fontFamily.trim(), ",");
            while (st.hasMoreTokens()) {
                String fontName = st.nextToken();
                if (new StringTokenizer(fontName.trim()).countTokens() == 1) {
                    fontName = fontName.replaceAll("'", "");
                }
                fontSet = fontSet + fontName;
                if (!st.hasMoreTokens()) continue;
                fontSet = fontSet + ",";
            }
            if (!this.fontFamilies.contains(fontSet)) {
                this.fontFamilies.add(1, fontSet);
            }
            this.fontFaceList.setSelectedIndex(this.fontFamilies.indexOf(fontSet));
        } else {
            this.fontFaceList.setSelectedIndex(0);
        }
        DefaultListModel fontSizes = this.fontModel.getFontSizeList();
        this.fontSizeList.setModel(fontSizes);
        DefaultComboBoxModel fontSizeUnits = this.fontModel.getFontSizeUnitList();
        this.fontSizeUnitCombo.setModel(fontSizeUnits);
        String fontSizeStr = this.cssStyleData.getProperty("font-size");
        if (fontSizeStr != null) {
            if (fontSizes.contains(fontSizeStr)) {
                this.fontSizeList.setSelectedIndex(fontSizes.indexOf(fontSizeStr));
            } else {
                FontModel.FontSize fontSize = this.fontModel.getFontSize(fontSizeStr);
                if (fontSize.getValue() != null) {
                    if (fontSizes.contains(fontSize.getValue())) {
                        this.fontSizeList.setSelectedIndex(fontSizes.indexOf(fontSize.getValue()));
                    } else {
                        this.fontSizeField.setText(fontSize.getValue());
                    }
                } else {
                    this.fontSizeList.setSelectedIndex(0);
                }
                if (fontSizeUnits.getIndexOf(fontSize.getUnit()) != -1) {
                    this.fontSizeUnitCombo.setSelectedIndex(fontSizeUnits.getIndexOf(fontSize.getUnit()));
                }
            }
        } else {
            this.fontSizeList.setSelectedIndex(0);
        }
        DefaultComboBoxModel fontStyles = this.fontModel.getFontStyleList();
        this.fontStyleComboBox.setModel(fontStyles);
        String fontStyle = this.cssStyleData.getProperty("font-style");
        if (fontStyle != null) {
            if (fontStyles.getIndexOf(fontStyle) != -1) {
                this.fontStyleComboBox.setSelectedIndex(fontStyles.getIndexOf(fontStyle));
            }
        } else {
            this.fontStyleComboBox.setSelectedIndex(0);
        }
        DefaultComboBoxModel fontWeights = this.fontModel.getFontWeightList();
        this.fontWeightComboBox.setModel(fontWeights);
        String fontWeight = this.cssStyleData.getProperty("font-weight");
        if (fontWeight != null) {
            if (fontWeights.getIndexOf(fontWeight) != -1) {
                this.fontWeightComboBox.setSelectedIndex(fontWeights.getIndexOf(fontWeight));
            }
        } else {
            this.fontWeightComboBox.setSelectedIndex(0);
        }
        DefaultComboBoxModel fontVariants = this.fontModel.getFontVariantList();
        this.fontVariantComboBox.setModel(fontVariants);
        String fontVariant = this.cssStyleData.getProperty("font-variant");
        if (fontVariant != null) {
            if (fontVariants.getIndexOf(fontVariant) != -1) {
                this.fontVariantComboBox.setSelectedIndex(fontVariants.getIndexOf(fontVariant));
            }
        } else {
            this.fontVariantComboBox.setSelectedIndex(0);
        }
        if ((textDecoration = this.cssStyleData.getProperty("text-decoration")) != null) {
            this.textDecorationData.setDecoration(textDecoration);
            this.underlineCheckbox.setSelected(this.textDecorationData.underlineEnabled());
            this.overlineCheckbox.setSelected(this.textDecorationData.overlineEnabled());
            this.strikethroughCheckbox.setSelected(this.textDecorationData.lineThroughEnabled());
        }
        if ((textColor = this.cssStyleData.getProperty("color")) != null) {
            this.colorField.setColorString(textColor);
        }
        FontMetrics fontMetrics = this.fontSizeField.getFontMetrics(this.fontSizeField.getFont());
        int width = fontMetrics.stringWidth((String)fontSizes.get(0)) + 10;
        int height = fontMetrics.getHeight() + 10 > 25 ? fontMetrics.getHeight() + 10 : 25;
        this.fontSizeField.setPreferredSize(new Dimension(width, height));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setFontColor();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.fontFamilyPanel = new JPanel();
        this.fontLabel = new JLabel();
        this.fontFaceScroll = new JScrollPane();
        this.fontFaceList = new JList();
        this.fontChosenField = new JTextField();
        this.fontFamilyButton = new JButton();
        this.fontSizePanel = new JPanel();
        this.sizeLabel = new JLabel();
        this.fontSizeField = new JTextField();
        this.fontSizeUnitCombo = new JComboBox();
        this.fontSizeScroll = new JScrollPane();
        this.fontSizeList = new JList();
        this.styleMainPanel = new JPanel();
        this.stylePanel = new JPanel();
        this.styleLabel = new JLabel();
        this.fontStyleComboBox = new JComboBox();
        this.weightLabel = new JLabel();
        this.fontWeightComboBox = new JComboBox();
        this.variantLabel = new JLabel();
        this.fontVariantComboBox = new JComboBox();
        this.colorLabel = new JLabel();
        this.colorSelectionPanel = new JPanel();
        this.decorationPanel = new JPanel();
        this.decorationLabel = new JLabel();
        this.underlineCheckbox = new JCheckBox();
        this.strikethroughCheckbox = new JCheckBox();
        this.overlineCheckbox = new JCheckBox();
        this.noDecorationCheckbox = new JCheckBox();
        this.errorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.fontFamilyPanel.setLayout(new GridBagLayout());
        this.fontFamilyPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fontLabel.setLabelFor(this.fontChosenField);
        this.fontLabel.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"Font_Family"));
        this.fontLabel.setMinimumSize(new Dimension(200, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontFamilyPanel.add((Component)this.fontLabel, gridBagConstraints);
        this.fontFaceList.setSelectionMode(0);
        this.fontFaceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FontStyleEditor.this.fontFaceListValueChanged(evt);
            }
        });
        this.fontFaceScroll.setViewportView(this.fontFaceList);
        this.fontFaceList.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontFamilyList"));
        this.fontFaceList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontFamilyListAccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.fontFamilyPanel.add((Component)this.fontFaceScroll, gridBagConstraints);
        this.fontChosenField.setEditable(false);
        this.fontChosenField.setMargin(new Insets(1, 2, 2, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontFamilyPanel.add((Component)this.fontChosenField, gridBagConstraints);
        this.fontChosenField.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("chosenFontsAccessibleName"));
        this.fontChosenField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("ChosenFontAccessibleDescription"));
        this.fontFamilyButton.setMnemonic(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("EDIT_FONT_FAMILY_MNEMONIC").charAt(0));
        this.fontFamilyButton.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"EDIT"));
        this.fontFamilyButton.setMargin(new Insets(4, 4, 4, 4));
        this.fontFamilyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontStyleEditor.this.fontFamilyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.fontFamilyPanel.add((Component)this.fontFamilyButton, gridBagConstraints);
        this.fontFamilyButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("EditChosenFontsAccessibleDescription"));
        this.mainPanel.add((Component)this.fontFamilyPanel, "Center");
        this.fontSizePanel.setLayout(new GridBagLayout());
        this.fontSizePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.sizeLabel.setLabelFor(this.fontSizeField);
        this.sizeLabel.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_SIZE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontSizePanel.add((Component)this.sizeLabel, gridBagConstraints);
        this.fontSizeField.setHorizontalAlignment(2);
        this.fontSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontStyleEditor.this.fontSizeFieldActionPerformed(evt);
            }
        });
        this.fontSizeField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FontStyleEditor.this.fontSizeFieldFocusLost(evt);
            }
        });
        this.fontSizeField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                FontStyleEditor.this.fontSizeFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontSizePanel.add((Component)this.fontSizeField, gridBagConstraints);
        this.fontSizeField.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("ChosenFontSizeAccessibleName"));
        this.fontSizeField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("ChosenFontSizeAccessibleDescription"));
        this.fontSizeUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FontStyleEditor.this.fontSizeUnitComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.fontSizePanel.add((Component)this.fontSizeUnitCombo, gridBagConstraints);
        this.fontSizeUnitCombo.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontSizeUnitListAccessibleName"));
        this.fontSizeUnitCombo.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontSizeUnitListAccessibleDescription"));
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FontStyleEditor.this.fontSizeListValueChanged(evt);
            }
        });
        this.fontSizeScroll.setViewportView(this.fontSizeList);
        this.fontSizeList.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontSizeListAccessibleName"));
        this.fontSizeList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontSizeListAccessibleDesription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.fontSizePanel.add((Component)this.fontSizeScroll, gridBagConstraints);
        this.mainPanel.add((Component)this.fontSizePanel, "East");
        this.styleMainPanel.setLayout(new BorderLayout(20, 0));
        this.stylePanel.setLayout(new GridBagLayout());
        this.stylePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.styleLabel.setLabelFor(this.fontStyleComboBox);
        this.styleLabel.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_STYLE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.stylePanel.add((Component)this.styleLabel, gridBagConstraints);
        this.fontStyleComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontStyleComboBox.setPreferredSize(new Dimension(150, 20));
        this.fontStyleComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontStyleEditor.this.fontStyleComboBoxActionPerformed(evt);
            }
        });
        this.fontStyleComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FontStyleEditor.this.fontStyleComboBoxFocusLost(evt);
            }
        });
        this.fontStyleComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FontStyleEditor.this.fontStyleComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.stylePanel.add((Component)this.fontStyleComboBox, gridBagConstraints);
        this.fontStyleComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontStyleSelectionAccessibleDescription"));
        this.weightLabel.setLabelFor(this.fontWeightComboBox);
        this.weightLabel.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_WEIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.stylePanel.add((Component)this.weightLabel, gridBagConstraints);
        this.fontWeightComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontWeightComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontStyleEditor.this.fontWeightComboBoxActionPerformed(evt);
            }
        });
        this.fontWeightComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FontStyleEditor.this.fontWeightComboBoxFocusLost(evt);
            }
        });
        this.fontWeightComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FontStyleEditor.this.fontWeightComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.stylePanel.add((Component)this.fontWeightComboBox, gridBagConstraints);
        this.fontWeightComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontWeightSelectionAccessibleDescription"));
        this.variantLabel.setLabelFor(this.fontVariantComboBox);
        this.variantLabel.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_VARIANT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.stylePanel.add((Component)this.variantLabel, gridBagConstraints);
        this.variantLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontVariantSelectionAccessibleDescription"));
        this.fontVariantComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontVariantComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontStyleEditor.this.fontVariantComboBoxActionPerformed(evt);
            }
        });
        this.fontVariantComboBox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FontStyleEditor.this.fontVariantComboBoxFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                FontStyleEditor.this.fontVariantComboBoxFocusLost(evt);
            }
        });
        this.fontVariantComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FontStyleEditor.this.fontVariantComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.stylePanel.add((Component)this.fontVariantComboBox, gridBagConstraints);
        this.fontVariantComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontVariantSelectionAccessibleDescription"));
        this.colorLabel.setLabelFor(this.colorSelectionPanel);
        this.colorLabel.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_COLOR"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.stylePanel.add((Component)this.colorLabel, gridBagConstraints);
        this.colorSelectionPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.stylePanel.add((Component)this.colorSelectionPanel, gridBagConstraints);
        this.styleMainPanel.add((Component)this.stylePanel, "West");
        this.decorationPanel.setLayout(new GridBagLayout());
        this.decorationPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.decorationLabel.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_DECORATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.decorationPanel.add((Component)this.decorationLabel, gridBagConstraints);
        this.underlineCheckbox.setMnemonic(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FONT_DECORATION_UNDERLINE_MNEMONIC").charAt(0));
        this.underlineCheckbox.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_UNDERLINE"));
        this.underlineCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.underlineCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FontStyleEditor.this.underlineCheckboxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.decorationPanel.add((Component)this.underlineCheckbox, gridBagConstraints);
        this.underlineCheckbox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontUnderlineAccessibleDescription"));
        this.strikethroughCheckbox.setMnemonic(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FONT_DECORATION_STRIKETHROUGH_MNEMONIC").charAt(0));
        this.strikethroughCheckbox.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_STRIKETHROUGH"));
        this.strikethroughCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.strikethroughCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FontStyleEditor.this.strikethroughCheckboxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.decorationPanel.add((Component)this.strikethroughCheckbox, gridBagConstraints);
        this.strikethroughCheckbox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontStrikeThroughAccessibleDescription"));
        this.overlineCheckbox.setMnemonic(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FONT_DECORATION_OVERLINE_MNEMONIC").charAt(0));
        this.overlineCheckbox.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"FONT_OVERLINE"));
        this.overlineCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.overlineCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FontStyleEditor.this.overlineCheckboxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.decorationPanel.add((Component)this.overlineCheckbox, gridBagConstraints);
        this.overlineCheckbox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontOverlineAccessibleDescription"));
        this.noDecorationCheckbox.setMnemonic(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FONT_DECORATION_NONE_MNEMONIC").charAt(0));
        this.noDecorationCheckbox.setText(NbBundle.getMessage((Class)FontStyleEditor.class, (String)"NO_DECORATION"));
        this.noDecorationCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FontStyleEditor.this.noDecorationCheckboxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.decorationPanel.add((Component)this.noDecorationCheckbox, gridBagConstraints);
        this.noDecorationCheckbox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/css/Bundle").getString("FontNoDecorationAccessibleDescription"));
        this.styleMainPanel.add((Component)this.decorationPanel, "Center");
        this.mainPanel.add((Component)this.styleMainPanel, "South");
        this.add((Component)this.mainPanel, "North");
        this.errorPanel.setLayout(new BorderLayout());
        this.errorPanel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.errorLabel.setForeground(new Color(0, 0, 153));
        this.errorLabel.setMinimumSize(new Dimension(200, 20));
        this.errorLabel.setPreferredSize(new Dimension(200, 20));
        this.errorPanel.add((Component)this.errorLabel, "Center");
        this.add((Component)this.errorPanel, "Center");
    }

    private void noDecorationCheckboxItemStateChanged(ItemEvent evt) {
        this.textDecorationData.enableNoDecoration(evt.getStateChange() == 1);
        if (evt.getStateChange() == 1) {
            this.strikethroughCheckbox.setSelected(false);
            this.overlineCheckbox.setSelected(false);
            this.underlineCheckbox.setSelected(false);
            this.strikethroughCheckbox.setEnabled(false);
            this.overlineCheckbox.setEnabled(false);
            this.underlineCheckbox.setEnabled(false);
        } else {
            this.strikethroughCheckbox.setEnabled(true);
            this.overlineCheckbox.setEnabled(true);
            this.underlineCheckbox.setEnabled(true);
        }
        this.setTextDecoration();
    }

    private void fontVariantComboBoxFocusGained(FocusEvent evt) {
        this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
    }

    private void strikethroughCheckboxItemStateChanged(ItemEvent evt) {
        this.textDecorationData.enableLineThrough(evt.getStateChange() == 1);
        this.setTextDecoration();
    }

    private void overlineCheckboxItemStateChanged(ItemEvent evt) {
        this.textDecorationData.enableOverline(evt.getStateChange() == 1);
        this.setTextDecoration();
    }

    private void underlineCheckboxItemStateChanged(ItemEvent evt) {
        this.textDecorationData.enableUnderline(evt.getStateChange() == 1);
        this.setTextDecoration();
    }

    private void fontVariantComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setFontVariant();
        }
    }

    private void fontVariantComboBoxFocusLost(FocusEvent evt) {
        this.errorLabel.setText("");
        this.setFontVariant();
    }

    private void fontVariantComboBoxActionPerformed(ActionEvent evt) {
        this.setFontVariant();
    }

    private void fontWeightComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setFontWeight();
        }
    }

    private void fontWeightComboBoxActionPerformed(ActionEvent evt) {
        this.setFontWeight();
    }

    private void fontWeightComboBoxFocusLost(FocusEvent evt) {
        this.setFontWeight();
    }

    private void fontStyleComboBoxActionPerformed(ActionEvent evt) {
        this.setFontStyle();
    }

    private void fontStyleComboBoxFocusLost(FocusEvent evt) {
        this.setFontStyle();
    }

    private void fontStyleComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setFontStyle();
        }
    }

    private void fontSizeUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setFontSize();
        }
    }

    private void fontSizeFieldActionPerformed(ActionEvent evt) {
        this.setFontSize();
    }

    private void fontSizeFieldFocusLost(FocusEvent evt) {
        this.setFontSize();
    }

    private void fontSizeFieldKeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FontStyleEditor.this.enableFontSizeUnitCombo(Utils.isInteger(FontStyleEditor.this.fontSizeField.getText()));
            }
        });
    }

    private void fontSizeListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        String selectedFontSize = (String)this.fontSizeList.getSelectedValue();
        this.fontSizeField.setText(selectedFontSize);
        this.enableFontSizeUnitCombo(Utils.isInteger(selectedFontSize));
        this.setFontSize();
    }

    private void enableFontSizeUnitCombo(final boolean enable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FontStyleEditor.this.fontSizeUnitCombo.setEnabled(enable);
            }
        });
    }

    private void fontFaceListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.fontChosenField.setText(this.fontFaceList.getSelectedValue().toString());
        this.setFontFamily();
    }

    private void fontFamilyButtonActionPerformed(ActionEvent evt) {
        FontFamilyEditorDialog fontFamilyEditor = new FontFamilyEditorDialog(this.fontFamilies, this.fontFaceList.getSelectedIndex());
        fontFamilyEditor.showDialog();
        this.fontFaceList.setSelectedIndex(fontFamilyEditor.getSelectedIndex());
        this.fontChosenField.setText(this.fontFaceList.getSelectedValue().toString());
        this.setFontFamily();
    }

    private void setFontFamily() {
        PropertyData fontFamilyData = new PropertyData();
        fontFamilyData.setValue(this.fontChosenField.getText());
        this.cssStyleData.modifyProperty("font-family", fontFamilyData.toString());
    }

    private void setFontSize() {
        PropertyWithUnitData fontSizeData = new PropertyWithUnitData();
        fontSizeData.setUnit(this.fontSizeUnitCombo.getSelectedItem().toString());
        fontSizeData.setValue(this.fontSizeField.getText());
        this.cssStyleData.modifyProperty("font-size", fontSizeData.toString());
    }

    private void setFontStyle() {
        PropertyData fontStyleData = new PropertyData();
        fontStyleData.setValue(this.fontStyleComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("font-style", fontStyleData.toString());
    }

    private void setFontWeight() {
        PropertyData fontWeightData = new PropertyData();
        fontWeightData.setValue(this.fontWeightComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("font-weight", fontWeightData.toString());
    }

    private void setFontVariant() {
        PropertyData fontVariantData = new PropertyData();
        fontVariantData.setValue(this.fontVariantComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("font-variant", fontVariantData.toString());
    }

    private void setFontColor() {
        PropertyData fontColorData = new PropertyData();
        fontColorData.setValue(this.colorField.getColorString());
        this.cssStyleData.modifyProperty("color", fontColorData.toString());
    }

    private void setTextDecoration() {
        this.cssStyleData.modifyProperty("text-decoration", this.textDecorationData.toString());
    }
}

