/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.model.MarginPaddingModel;
import com.sun.jsfcl.std.css.model.PropertyWithUnitData;
import com.sun.jsfcl.std.css.model.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class PaddingWidthField
extends JPanel {
    PropertyWithUnitData borderPaddingData = new PropertyWithUnitData();
    MarginPaddingModel marginPaddingModel = new MarginPaddingModel();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JComboBox borderPaddingCombo;
    private JComboBox borderPaddingUnitCombo;

    public PaddingWidthField() {
        this.initComponents();
        this.borderPaddingCombo.setModel(this.marginPaddingModel.getPaddingList());
        this.borderPaddingUnitCombo.setModel(this.marginPaddingModel.getPaddingUnitList());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void setPaddingString(String paddingStr) {
        if (paddingStr != null && !paddingStr.equals("")) {
            if (Utils.isInteger(paddingStr)) {
                this.setWidthValue(paddingStr);
            } else {
                String unit = this.getUnit(paddingStr);
                this.setWidthUnit(unit);
                this.setWidthValue(paddingStr.replaceAll(unit, "").trim());
            }
        } else {
            this.setWidthValue(null);
            this.setWidthUnit(null);
        }
    }

    public String getPaddingString() {
        return this.borderPaddingData.toString();
    }

    private String getUnit(String paddingStr) {
        DefaultComboBoxModel unitList = this.marginPaddingModel.getPaddingUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!paddingStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setWidthValue(String value) {
        if (value == null || value.equals("")) {
            this.borderPaddingCombo.setSelectedIndex(0);
        } else {
            this.borderPaddingCombo.setSelectedItem(value);
            this.borderPaddingData.setValue(value);
        }
    }

    public void setWidthUnit(String value) {
        if (value == null || value.equals("")) {
            this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf("px"));
        } else {
            if (this.marginPaddingModel.getMarginUnitList().getIndexOf(value) != -1) {
                this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf(value));
            } else {
                this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf("px"));
            }
            this.borderPaddingData.setUnit(value);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    private void initComponents() {
        this.borderPaddingCombo = new JComboBox();
        this.borderPaddingUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(5, 0));
        this.borderPaddingCombo.setEditable(true);
        this.borderPaddingCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PaddingWidthField.this.borderPaddingComboItemStateChanged(evt);
            }
        });
        this.borderPaddingCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaddingWidthField.this.borderPaddingComboActionPerformed(evt);
            }
        });
        this.borderPaddingCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PaddingWidthField.this.borderPaddingComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderPaddingCombo, "Center");
        this.borderPaddingUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PaddingWidthField.this.borderPaddingUnitComboItemStateChanged(evt);
            }
        });
        this.borderPaddingUnitCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PaddingWidthField.this.borderPaddingUnitComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderPaddingUnitCombo, "East");
    }

    private void borderPaddingUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setborderPadding();
        }
    }

    private void borderPaddingUnitComboFocusLost(FocusEvent evt) {
        this.setborderPadding();
    }

    public void setAccessibleName(String comboName, String unitName) {
        this.borderPaddingCombo.getAccessibleContext().setAccessibleName(comboName);
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleName(unitName);
    }

    public void setAccessibleDescription(String comboDesc, String unitDesc) {
        this.borderPaddingCombo.getAccessibleContext().setAccessibleDescription(comboDesc);
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleDescription(unitDesc);
    }

    private void borderPaddingComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setborderPadding();
        }
    }

    private void borderPaddingComboFocusLost(FocusEvent evt) {
        this.setborderPadding();
    }

    private void borderPaddingComboActionPerformed(ActionEvent evt) {
        this.setborderPadding();
    }

    private void setborderPadding() {
        String oldValue = this.borderPaddingData.toString();
        this.borderPaddingData.setUnit(this.borderPaddingUnitCombo.getSelectedItem().toString());
        this.borderPaddingData.setValue(this.borderPaddingCombo.getSelectedItem().toString());
        this.propertyChangeSupport.firePropertyChange("padding-width", oldValue, this.borderPaddingData.toString());
    }
}

